/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.MBill;
import jpiere.base.plugin.org.adempiere.model.X_JP_BillLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceTax;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MBillLine
extends X_JP_BillLine {
    private MInvoice invoice = null;
    private MBill m_parent = null;

    public MBillLine(Properties ctx, int JP_BillLine_ID, String trxName) {
        super(ctx, JP_BillLine_ID, trxName);
    }

    public MBillLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        if (newRecord || this.is_ValueChanged("C_Invoice_ID")) {
            if (this.getC_Invoice_ID() == 0) {
                this.log.saveError("FillMandatory", Msg.getElement((Properties)this.getCtx(), (String)"C_Invoice_ID"));
                return false;
            }
            this.invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
            if (!this.invoice.getDocStatus().equals("CO") && !this.invoice.getDocStatus().equals("CL")) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_Not_Completed_Document"));
                return false;
            }
            if (this.invoice.getC_Currency_ID() != this.getParent().getC_Currency_ID()) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_DifferentCurrency"));
                return false;
            }
            if (this.getDescription() == null || this.getDescription().isEmpty()) {
                this.setDescription(this.invoice.getDescription());
            }
            this.setC_DocType_ID(this.invoice.getC_DocType_ID());
            this.setDateInvoiced(this.invoice.getDateInvoiced());
            this.setDateAcct(this.invoice.getDateAcct());
            this.setC_BPartner_ID(this.invoice.getC_BPartner_ID());
            this.setC_BPartner_Location_ID(this.invoice.getC_BPartner_Location_ID());
            this.setAD_User_ID(this.invoice.getAD_User_ID());
            this.setM_PriceList_ID(this.invoice.getM_PriceList_ID());
            this.setSalesRep_ID(this.invoice.getSalesRep_ID());
            this.setPaymentRule(this.invoice.getPaymentRule());
            this.setC_PaymentTerm_ID(this.invoice.getC_PaymentTerm_ID());
            this.setC_Currency_ID(this.invoice.getC_Currency_ID());
            this.setTotalLines(this.invoice.getTotalLines());
            this.setGrandTotal(this.invoice.getGrandTotal());
            BigDecimal TaxBaseAmt = Env.ZERO;
            BigDecimal TaxAmt = Env.ZERO;
            MInvoiceTax[] invTaxes = this.invoice.getTaxes(false);
            int i = 0;
            while (i < invTaxes.length) {
                TaxBaseAmt = TaxBaseAmt.add(invTaxes[i].getTaxBaseAmt());
                TaxAmt = TaxAmt.add(invTaxes[i].getTaxAmt());
                ++i;
            }
            this.setTaxBaseAmt(TaxBaseAmt);
            this.setTaxAmt(TaxAmt);
            this.setPayAmt(this.invoice.getGrandTotal().subtract(this.invoice.getOpenAmt()));
            this.setOpenAmt(this.invoice.getOpenAmt());
            if (this.invoice.getC_DocType().getDocBaseType().equals("ARC")) {
                this.setTotalLines(this.getTotalLines().negate());
                this.setGrandTotal(this.getGrandTotal().negate());
                this.setTaxBaseAmt(this.getTaxBaseAmt().negate());
                this.setTaxAmt(this.getTaxAmt().negate());
                this.setPayAmt(this.invoice.getGrandTotal().add(this.invoice.getOpenAmt()));
            }
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord || this.is_ValueChanged("C_Invoice_ID")) {
            Integer JP_Bill_ID;
            MInvoice invoice_old;
            Integer JP_Bill_ID2;
            String sql = "UPDATE JP_Bill b SET (TotalLines ,GrandTotal ,TaxBaseAmt ,TaxAmt ,PayAmt ,OpenAmt ,OverUnderAmt ) = (SELECT COALESCE(SUM(TotalLines),0)  ,COALESCE(SUM(GrandTotal),0)  ,COALESCE(SUM(TaxBaseAmt),0)  ,COALESCE(SUM(TaxAmt),0)  ,COALESCE(SUM(PayAmt),0)  ,COALESCE(SUM(OpenAmt),0)  ,COALESCE(SUM(OverUnderAmt),0) FROM JP_BillLine bl WHERE b.JP_Bill_ID=bl.JP_Bill_ID)  WHERE JP_Bill_ID=" + this.getJP_Bill_ID();
            int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
            if (no != 1) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"SaveErrorNotUnique"));
                return false;
            }
            sql = "UPDATE JP_Bill b SET JPBillAmt =(SELECT COALESCE(OpenAmt,0) + COALESCE(JPCarriedForwardAmt,0) FROM JP_Bill WHERE JP_Bill_ID=" + this.getJP_Bill_ID() + " )" + " WHERE JP_Bill_ID=" + this.getJP_Bill_ID();
            no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
            if (no != 1) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"SaveErrorNotUnique"));
                return false;
            }
            if (this.invoice == null) {
                this.invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
            }
            if (!newRecord && (JP_Bill_ID2 = (Integer)(invoice_old = new MInvoice(this.getCtx(), this.get_ValueOldAsInt("C_Invoice_ID"), this.get_TrxName())).get_Value("JP_Bill_ID")) != null && JP_Bill_ID2.intValue() == this.getJP_Bill_ID()) {
                invoice_old.set_ValueNoCheck("JP_Bill_ID", null);
                invoice_old.save(this.get_TrxName());
            }
            if ((JP_Bill_ID = (Integer)this.invoice.get_Value("JP_Bill_ID")) == null || JP_Bill_ID == 0) {
                this.invoice.set_ValueNoCheck("JP_Bill_ID", (Object)this.getJP_Bill_ID());
                this.invoice.save(this.get_TrxName());
            }
        }
        return true;
    }

    protected boolean afterDelete(boolean success) {
        Integer JP_Bill_ID;
        String sql = "UPDATE JP_Bill b SET (TotalLines ,GrandTotal ,TaxBaseAmt ,TaxAmt ,PayAmt ,OpenAmt ,OverUnderAmt ) = (SELECT COALESCE(SUM(TotalLines),0)  ,COALESCE(SUM(GrandTotal),0)  ,COALESCE(SUM(TaxBaseAmt),0)  ,COALESCE(SUM(TaxAmt),0)  ,COALESCE(SUM(PayAmt),0)  ,COALESCE(SUM(OpenAmt),0)  ,COALESCE(SUM(OverUnderAmt),0) FROM JP_BillLine bl WHERE b.JP_Bill_ID=bl.JP_Bill_ID)  WHERE JP_Bill_ID=" + this.getJP_Bill_ID();
        int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        if (no != 1) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"SaveErrorNotUnique"));
            return false;
        }
        sql = "UPDATE JP_Bill b SET JPBillAmt =(SELECT COALESCE(OpenAmt,0) + COALESCE(JPCarriedForwardAmt,0) FROM JP_Bill WHERE JP_Bill_ID=" + this.getJP_Bill_ID() + " )" + " WHERE JP_Bill_ID=" + this.getJP_Bill_ID();
        no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        if (no != 1) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"SaveErrorNotUnique"));
            return false;
        }
        if (this.invoice == null) {
            this.invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
        }
        if ((JP_Bill_ID = (Integer)this.invoice.get_Value("JP_Bill_ID")) != null && JP_Bill_ID.intValue() == this.getJP_Bill_ID()) {
            this.invoice.set_ValueNoCheck("JP_Bill_ID", null);
            this.invoice.save(this.get_TrxName());
        }
        return true;
    }

    public MBill getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MBill(this.getCtx(), this.getJP_Bill_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }
}

