/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MBillLine;
import jpiere.base.plugin.org.adempiere.model.X_JP_Bill;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MBill
extends X_JP_Bill
implements DocAction,
DocOptions {
    private static final long serialVersionUID = -7588955558162632796L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private MBillLine[] m_lines;

    public MBill(Properties ctx, int JP_Bill_ID, String trxName) {
        super(ctx, JP_Bill_ID, trxName);
    }

    public MBill(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        return String.valueOf(dt.getNameTrl()) + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("unlockIt - " + this.toString());
        }
        return true;
    }

    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("invalidateIt - " + this.toString());
        }
        return true;
    }

    public String prepareIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (!MPeriod.isOpen((Properties)this.getCtx(), (Timestamp)this.getJPDateBilled(), (String)dt.getDocBaseType(), (int)this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MBillLine[] lines = this.getLines(false);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        return "IP";
    }

    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("approveIt - " + this.toString());
        }
        return true;
    }

    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("rejectIt - " + this.toString());
        }
        return true;
    }

    public String completeIt() {
        String valid;
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.approveIt();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9)) != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    public boolean voidIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("voidIt - " + this.toString());
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus()) || "CO".equals(this.getDocStatus())) {
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
            if (this.m_processMsg != null) {
                return false;
            }
            MBillLine[] lines = this.getLines(false);
            MInvoice invoice = null;
            int i = 0;
            while (i < lines.length) {
                MBillLine line = lines[i];
                invoice = new MInvoice(this.getCtx(), line.getC_Invoice_ID(), this.get_TrxName());
                Integer JP_Bill_ID = (Integer)invoice.get_Value("JP_Bill_ID");
                if (JP_Bill_ID != null && JP_Bill_ID.intValue() == this.getJP_Bill_ID()) {
                    invoice.set_ValueNoCheck("JP_Bill_ID", null);
                    invoice.save(this.get_TrxName());
                }
                ++i;
            }
        } else {
            return false;
        }
        this.addDescription(Msg.getMsg((Properties)this.getCtx(), (String)"Voided"));
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("closeIt - " + this.toString());
        }
        this.setDocAction("--");
        return true;
    }

    public boolean reverseCorrectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reverseCorrectIt - " + this.toString());
        }
        return false;
    }

    public boolean reverseAccrualIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reverseAccrualIt - " + this.toString());
        }
        return false;
    }

    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reActivateIt - " + this.toString());
        }
        return this.reverseCorrectIt();
    }

    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDocumentNo());
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    public BigDecimal getApprovalAmt() {
        return this.getGrandTotal();
    }

    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (docStatus.equals("DR")) {
            return index;
        }
        if (docStatus.equals("CO")) {
            options[index++] = "VO";
            return index;
        }
        return index;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (newRecord || this.is_ValueChanged("JP_LastBill_ID")) {
            if (this.getJP_LastBill_ID() == 0) {
                this.setJPLastBillAmt(Env.ZERO);
            } else {
                MBill lastbill = new MBill(this.getCtx(), this.getJP_LastBill_ID(), this.get_TrxName());
                if (!lastbill.getDocStatus().equals("CO") && !lastbill.getDocStatus().equals("CL")) {
                    this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_InvalidDocStatus"));
                    return false;
                }
            }
        }
        if (newRecord || this.is_ValueChanged("C_Payment_ID")) {
            if (this.getC_Payment_ID() == 0) {
                this.setJPLastPayAmt(Env.ZERO);
            } else {
                MPayment lastPayment = new MPayment(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName());
                if (!lastPayment.getDocStatus().equals("CO") && !lastPayment.getDocStatus().equals("CL")) {
                    this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_InvalidDocStatus"));
                    return false;
                }
            }
        }
        this.setJPCarriedForwardAmt(this.getJPLastBillAmt().subtract(this.getJPLastPayAmt()));
        this.setJPBillAmt(this.getJPCarriedForwardAmt().add(this.getOpenAmt()));
        return true;
    }

    private MBillLine[] getLines(String whereClause) {
        String whereClauseFinal = "JP_Bill_ID=? ";
        if (whereClause != null) {
            whereClauseFinal = String.valueOf(whereClauseFinal) + whereClause;
        }
        List list = new Query(this.getCtx(), "JP_BillLine", whereClauseFinal, this.get_TrxName()).setParameters(new Object[]{this.getJP_Bill_ID()}).setOrderBy("Line").list();
        return list.toArray(new MBillLine[list.size()]);
    }

    public MBillLine[] getLines(boolean requery) {
        if (this.m_lines == null || this.m_lines.length == 0 || requery) {
            this.m_lines = this.getLines(null);
        }
        MBill.set_TrxName((PO[])this.m_lines, (String)this.get_TrxName());
        return this.m_lines;
    }

    public MBillLine[] getLines() {
        return this.getLines(false);
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            StringBuilder msgd = new StringBuilder(desc).append(" | ").append(description);
            this.setDescription(msgd.toString());
        }
    }

    public BigDecimal getCurrentOpenAmt() {
        this.getLines(true);
        BigDecimal openAmt = Env.ZERO;
        MInvoice inv = null;
        int i = 0;
        while (i < this.m_lines.length) {
            inv = new MInvoice(this.getCtx(), this.m_lines[i].getC_Invoice_ID(), this.get_TrxName());
            openAmt = openAmt.add(inv.getOpenAmt(true, null));
            ++i;
        }
        return openAmt;
    }
}

