/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.base.IJPiereTaxProvider;
import jpiere.base.plugin.org.adempiere.model.MEstimation;
import jpiere.base.plugin.org.adempiere.model.MEstimationLine;
import jpiere.base.plugin.org.adempiere.model.MEstimationTax;
import jpiere.base.plugin.org.adempiere.model.MRecognition;
import jpiere.base.plugin.org.adempiere.model.MRecognitionLine;
import jpiere.base.plugin.org.adempiere.model.MRecognitionTax;
import org.adempiere.exceptions.DBException;
import org.adempiere.model.ITaxProvider;
import org.compiere.model.I_C_TaxProvider;
import org.compiere.model.MBPartner;
import org.compiere.model.MCharge;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrderTax;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.MRMATax;
import org.compiere.model.MTax;
import org.compiere.model.MTaxProvider;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class JPiereTaxProvider
implements ITaxProvider,
IJPiereTaxProvider {
    protected transient CLogger log = CLogger.getCLogger(this.getClass());
    private static CCache<Integer, MBPartner> s_cache = new CCache("C_BPartner", 40, 5);

    public boolean calculateOrderTaxTotal(MTaxProvider provider, MOrder order) {
        MOrderTax oTax;
        BigDecimal totalLines = Env.ZERO;
        ArrayList<Integer> taxList = new ArrayList<Integer>();
        MOrderLine[] lines = order.getLines();
        int i = 0;
        while (i < lines.length) {
            MTax tax;
            MOrderLine line = lines[i];
            totalLines = totalLines.add(line.getLineNetAmt());
            Integer taxID = new Integer(line.getC_Tax_ID());
            if (!taxList.contains(taxID) && (tax = new MTax(order.getCtx(), taxID.intValue(), order.get_TrxName())).getC_TaxProvider_ID() != 0) {
                MCharge charge;
                oTax = MOrderTax.get((MOrderLine)line, (int)order.getPrecision(), (boolean)false, (String)order.get_TrxName());
                oTax.setIsTaxIncluded(order.isTaxIncluded());
                if (line.getC_Charge_ID() != 0 && !(charge = MCharge.get((Properties)Env.getCtx(), (int)line.getC_Charge_ID())).isSameTax()) {
                    oTax.setIsTaxIncluded(charge.isTaxIncluded());
                }
                if (!this.calculateTaxFromOrderLines(line, oTax)) {
                    return false;
                }
                if (!oTax.save(order.get_TrxName())) {
                    return false;
                }
                taxList.add(taxID);
            }
            ++i;
        }
        BigDecimal grandTotal = totalLines;
        MOrderTax[] taxes = order.getTaxes(true);
        RoundingMode roundingMode = JPiereTaxProvider.getRoundingMode(lines[0].getParent().getC_BPartner_ID(), lines[0].getParent().isSOTrx(), (I_C_TaxProvider)provider);
        int i2 = 0;
        while (i2 < taxes.length) {
            oTax = taxes[i2];
            if (oTax.getC_TaxProvider_ID() == 0) {
                if (!order.isTaxIncluded()) {
                    grandTotal = grandTotal.add(oTax.getTaxAmt());
                }
            } else {
                MTax tax = MTax.get((Properties)oTax.getCtx(), (int)oTax.getC_Tax_ID());
                if (tax.isSummary()) {
                    MTax[] cTaxes = tax.getChildTaxes(false);
                    int j = 0;
                    while (j < cTaxes.length) {
                        MTax cTax = cTaxes[j];
                        BigDecimal taxAmt = this.calculateTax(cTax, oTax.getTaxBaseAmt(), oTax.isTaxIncluded(), order.getPrecision(), roundingMode);
                        MOrderTax newOTax = new MOrderTax(order.getCtx(), 0, order.get_TrxName());
                        newOTax.set_ValueOfColumn("AD_Client_ID", (Object)order.getAD_Client_ID());
                        newOTax.setAD_Org_ID(order.getAD_Org_ID());
                        newOTax.setC_Order_ID(order.getC_Order_ID());
                        newOTax.setC_Tax_ID(cTax.getC_Tax_ID());
                        newOTax.setIsTaxIncluded(oTax.isTaxIncluded());
                        newOTax.setTaxBaseAmt(oTax.getTaxBaseAmt());
                        newOTax.setTaxAmt(taxAmt);
                        if (!newOTax.save(order.get_TrxName())) {
                            return false;
                        }
                        if (!oTax.isTaxIncluded()) {
                            grandTotal = grandTotal.add(taxAmt);
                        }
                        ++j;
                    }
                    if (!oTax.delete(true, order.get_TrxName())) {
                        return false;
                    }
                    if (!oTax.save(order.get_TrxName())) {
                        return false;
                    }
                } else if (!order.isTaxIncluded()) {
                    grandTotal = grandTotal.add(oTax.getTaxAmt());
                }
            }
            ++i2;
        }
        order.setTotalLines(totalLines);
        order.setGrandTotal(grandTotal);
        return true;
    }

    public boolean updateHeaderTax(MTaxProvider provider, MOrderLine line) {
        String sql = "UPDATE C_Order i SET TotalLines=(SELECT COALESCE(SUM(LineNetAmt),0) FROM C_OrderLine il WHERE i.C_Order_ID=il.C_Order_ID) , JP_ScheduledCostTotalLines = (SELECT COALESCE(SUM(JP_ScheduledCostLineAmt),0) FROM C_OrderLine il WHERE i.C_Order_ID=il.C_Order_ID)WHERE C_Order_ID = ?";
        int no = DB.executeUpdate((String)sql, (Object[])new Object[]{new Integer(line.getC_Order_ID())}, (boolean)false, (String)line.get_TrxName(), (int)0);
        if (no != 1) {
            this.log.warning("(1) #" + no);
        }
        sql = "UPDATE C_Order i  SET GrandTotal=TotalLines+(SELECT COALESCE(SUM(TaxAmt),0) FROM C_OrderTax it WHERE i.C_Order_ID=it.C_Order_ID AND it.IsTaxIncluded='N') WHERE C_Order_ID = ?";
        no = DB.executeUpdate((String)sql, (Object[])new Object[]{new Integer(line.getC_Order_ID())}, (boolean)false, (String)line.get_TrxName(), (int)0);
        if (no != 1) {
            this.log.warning("(2) #" + no);
        }
        line.clearParent();
        return no == 1;
    }

    public boolean updateOrderTax(MTaxProvider provider, MOrderLine line) {
        return this.updateOrderTax(line, false);
    }

    public boolean recalculateTax(MTaxProvider provider, MOrderLine line, boolean newRecord) {
        if (!newRecord && line.is_ValueChanged("C_Tax_ID") && !line.getParent().isProcessed() && !this.updateOrderTax(line, true)) {
            return false;
        }
        if (!this.updateOrderTax(line, false)) {
            return false;
        }
        return this.updateHeaderTax(provider, line);
    }

    private boolean updateOrderTax(MOrderLine line, boolean oldTax) {
        MOrderTax tax = MOrderTax.get((MOrderLine)line, (int)line.getPrecision(), (boolean)oldTax, (String)line.get_TrxName());
        if (tax != null) {
            MCharge charge;
            if (line.getC_Charge_ID() != 0 && !(charge = MCharge.get((Properties)Env.getCtx(), (int)line.getC_Charge_ID())).isSameTax()) {
                tax.setIsTaxIncluded(charge.isTaxIncluded());
            }
            if (!this.calculateTaxFromOrderLines(line, tax)) {
                return false;
            }
            if (tax.getTaxAmt().signum() != 0 ? !tax.save(line.get_TrxName()) : !tax.is_new() && !tax.delete(false, line.get_TrxName())) {
                return false;
            }
        }
        return true;
    }

    private boolean calculateTaxFromOrderLines(MOrderLine line, MOrderTax m_oderTax) {
        RoundingMode roundingMode;
        boolean documentLevel;
        MTax tax;
        BigDecimal taxAmt;
        BigDecimal taxBaseAmt;
        block11: {
            taxBaseAmt = Env.ZERO;
            taxAmt = Env.ZERO;
            tax = MTax.get((Properties)m_oderTax.getCtx(), (int)m_oderTax.getC_Tax_ID());
            documentLevel = tax.isDocumentLevel();
            roundingMode = JPiereTaxProvider.getRoundingMode(line.getParent().getC_BPartner_ID(), line.getParent().isSOTrx(), tax.getC_TaxProvider());
            String sql = "SELECT LineNetAmt FROM C_OrderLine WHERE C_Order_ID=? AND C_Tax_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)m_oderTax.get_TrxName());
                    pstmt.setInt(1, m_oderTax.getC_Order_ID());
                    pstmt.setInt(2, m_oderTax.getC_Tax_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        BigDecimal baseAmt = rs.getBigDecimal(1);
                        taxBaseAmt = taxBaseAmt.add(baseAmt);
                        if (documentLevel) continue;
                        taxAmt = taxAmt.add(this.calculateTax(tax, baseAmt, m_oderTax.isTaxIncluded(), line.getPrecision(), roundingMode));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, m_oderTax.get_TrxName(), (Throwable)e);
                    taxBaseAmt = null;
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (taxBaseAmt == null) {
            return false;
        }
        if (documentLevel) {
            taxAmt = this.calculateTax(tax, taxBaseAmt, m_oderTax.isTaxIncluded(), line.getPrecision(), roundingMode);
        }
        m_oderTax.setTaxAmt(taxAmt);
        if (m_oderTax.isTaxIncluded()) {
            m_oderTax.setTaxBaseAmt(taxBaseAmt.subtract(taxAmt));
        } else {
            m_oderTax.setTaxBaseAmt(taxBaseAmt);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.toString());
        }
        return true;
    }

    public boolean calculateInvoiceTaxTotal(MTaxProvider provider, MInvoice invoice) {
        BigDecimal totalLines = Env.ZERO;
        ArrayList<Integer> taxList = new ArrayList<Integer>();
        MInvoiceLine[] lines = invoice.getLines(false);
        int i = 0;
        while (i < lines.length) {
            MInvoiceTax iTax;
            MTax tax;
            MInvoiceLine line = lines[i];
            totalLines = totalLines.add(line.getLineNetAmt());
            if (!taxList.contains(line.getC_Tax_ID()) && (tax = new MTax(invoice.getCtx(), line.getC_Tax_ID(), invoice.get_TrxName())).getC_TaxProvider_ID() != 0 && (iTax = MInvoiceTax.get((MInvoiceLine)line, (int)invoice.getPrecision(), (boolean)false, (String)invoice.get_TrxName())) != null) {
                MCharge charge;
                iTax.setIsTaxIncluded(invoice.isTaxIncluded());
                if (line.getC_Charge_ID() != 0 && !(charge = MCharge.get((Properties)Env.getCtx(), (int)line.getC_Charge_ID())).isSameTax()) {
                    iTax.setIsTaxIncluded(charge.isTaxIncluded());
                }
                if (!this.calculateTaxFromInvoiceLines(line, iTax)) {
                    return false;
                }
                iTax.saveEx();
                taxList.add(line.getC_Tax_ID());
            }
            ++i;
        }
        BigDecimal grandTotal = totalLines;
        MInvoiceTax[] taxes = invoice.getTaxes(true);
        RoundingMode roundingMode = JPiereTaxProvider.getRoundingMode(lines[0].getParent().getC_BPartner_ID(), lines[0].getParent().isSOTrx(), (I_C_TaxProvider)provider);
        int i2 = 0;
        while (i2 < taxes.length) {
            MInvoiceTax iTax = taxes[i2];
            if (iTax.getC_TaxProvider_ID() == 0) {
                if (!iTax.isTaxIncluded()) {
                    grandTotal = grandTotal.add(iTax.getTaxAmt());
                }
            } else {
                MTax tax = MTax.get((Properties)iTax.getCtx(), (int)iTax.getC_Tax_ID());
                if (tax.isSummary()) {
                    MTax[] cTaxes = tax.getChildTaxes(false);
                    int j = 0;
                    while (j < cTaxes.length) {
                        MTax cTax = cTaxes[j];
                        BigDecimal taxAmt = this.calculateTax(cTax, iTax.getTaxBaseAmt(), iTax.isTaxIncluded(), invoice.getPrecision(), roundingMode);
                        MInvoiceTax newITax = new MInvoiceTax(invoice.getCtx(), 0, invoice.get_TrxName());
                        newITax.set_ValueOfColumn("AD_Client_ID", (Object)invoice.getAD_Client_ID());
                        newITax.setAD_Org_ID(invoice.getAD_Org_ID());
                        newITax.setC_Invoice_ID(invoice.getC_Invoice_ID());
                        newITax.setC_Tax_ID(cTax.getC_Tax_ID());
                        newITax.setIsTaxIncluded(iTax.isTaxIncluded());
                        newITax.setTaxBaseAmt(iTax.getTaxBaseAmt());
                        newITax.setTaxAmt(taxAmt);
                        newITax.saveEx(invoice.get_TrxName());
                        if (!iTax.isTaxIncluded()) {
                            grandTotal = grandTotal.add(taxAmt);
                        }
                        ++j;
                    }
                    iTax.deleteEx(true, invoice.get_TrxName());
                } else if (!invoice.isTaxIncluded()) {
                    grandTotal = grandTotal.add(iTax.getTaxAmt());
                }
            }
            ++i2;
        }
        invoice.setTotalLines(totalLines);
        invoice.setGrandTotal(grandTotal);
        return true;
    }

    public boolean updateHeaderTax(MTaxProvider provider, MInvoiceLine line) {
        String sql = "UPDATE C_Invoice i SET TotalLines=(SELECT COALESCE(SUM(LineNetAmt),0) FROM C_InvoiceLine il WHERE i.C_Invoice_ID=il.C_Invoice_ID) WHERE C_Invoice_ID=?";
        int no = DB.executeUpdateEx((String)sql, (Object[])new Object[]{line.getC_Invoice_ID()}, (String)line.get_TrxName());
        if (no != 1) {
            this.log.warning("(1) #" + no);
        }
        sql = "UPDATE C_Invoice i  SET GrandTotal=TotalLines+(SELECT COALESCE(SUM(TaxAmt),0) FROM C_InvoiceTax it WHERE i.C_Invoice_ID=it.C_Invoice_ID AND it.IsTaxIncluded='N') WHERE C_Invoice_ID=?";
        no = DB.executeUpdateEx((String)sql, (Object[])new Object[]{line.getC_Invoice_ID()}, (String)line.get_TrxName());
        if (no != 1) {
            this.log.warning("(2) #" + no);
        }
        line.clearParent();
        return no == 1;
    }

    public boolean updateInvoiceTax(MTaxProvider provider, MInvoiceLine line) {
        return this.updateInvoiceTax(line, false);
    }

    public boolean recalculateTax(MTaxProvider provider, MInvoiceLine line, boolean newRecord) {
        if (!newRecord && line.is_ValueChanged("C_Tax_ID") && !this.updateInvoiceTax(line, true)) {
            return false;
        }
        if (!this.updateInvoiceTax(line, false)) {
            return false;
        }
        return this.updateHeaderTax(provider, line);
    }

    private boolean updateInvoiceTax(MInvoiceLine line, boolean oldTax) {
        MInvoiceTax tax = MInvoiceTax.get((MInvoiceLine)line, (int)line.getPrecision(), (boolean)oldTax, (String)line.get_TrxName());
        if (tax != null) {
            MCharge charge;
            if (line.getC_Charge_ID() != 0 && !(charge = MCharge.get((Properties)Env.getCtx(), (int)line.getC_Charge_ID())).isSameTax()) {
                tax.setIsTaxIncluded(charge.isTaxIncluded());
            }
            if (!this.calculateTaxFromInvoiceLines(line, tax)) {
                return false;
            }
            if (tax.getTaxAmt().signum() != 0 ? !tax.save(tax.get_TrxName()) : !tax.is_new() && !tax.isProcessed() && !tax.delete(false, tax.get_TrxName())) {
                return false;
            }
        }
        return true;
    }

    private boolean calculateTaxFromInvoiceLines(MInvoiceLine line, MInvoiceTax m_invoiceTax) {
        BigDecimal taxBaseAmt = Env.ZERO;
        BigDecimal taxAmt = Env.ZERO;
        MTax tax = MTax.get((Properties)m_invoiceTax.getCtx(), (int)m_invoiceTax.getC_Tax_ID());
        boolean documentLevel = tax.isDocumentLevel();
        RoundingMode roundingMode = JPiereTaxProvider.getRoundingMode(line.getParent().getC_BPartner_ID(), line.getParent().isSOTrx(), tax.getC_TaxProvider());
        String sql = "SELECT il.LineNetAmt, COALESCE(il.JP_TaxAmt,0), i.IsSOTrx FROM C_InvoiceLine il INNER JOIN C_Invoice i ON (il.C_Invoice_ID=i.C_Invoice_ID) WHERE il.C_Invoice_ID=? AND il.C_Tax_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)m_invoiceTax.get_TrxName());
                pstmt.setInt(1, m_invoiceTax.getC_Invoice_ID());
                pstmt.setInt(2, m_invoiceTax.getC_Tax_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    BigDecimal baseAmt = rs.getBigDecimal(1);
                    taxBaseAmt = taxBaseAmt.add(baseAmt);
                    BigDecimal amt = rs.getBigDecimal(2);
                    if (amt == null) {
                        amt = Env.ZERO;
                    }
                    boolean isSOTrx = "Y".equals(rs.getString(3));
                    if (documentLevel || amt.signum() == 0 || isSOTrx) {
                        amt = documentLevel || baseAmt.signum() == 0 ? Env.ZERO : this.calculateTax(tax, baseAmt, m_invoiceTax.isTaxIncluded(), line.getPrecision(), roundingMode);
                    }
                    taxAmt = taxAmt.add(amt);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        if (documentLevel || taxAmt.signum() == 0) {
            taxAmt = this.calculateTax(tax, taxBaseAmt, m_invoiceTax.isTaxIncluded(), line.getPrecision(), roundingMode);
        }
        m_invoiceTax.setTaxAmt(taxAmt);
        if (m_invoiceTax.isTaxIncluded()) {
            m_invoiceTax.setTaxBaseAmt(taxBaseAmt.subtract(taxAmt));
        } else {
            m_invoiceTax.setTaxBaseAmt(taxBaseAmt);
        }
        return true;
    }

    public boolean calculateRMATaxTotal(MTaxProvider provider, MRMA rma) {
        MRMATax oTax;
        BigDecimal totalLines = Env.ZERO;
        ArrayList<Integer> taxList = new ArrayList<Integer>();
        MRMALine[] lines = rma.getLines(false);
        int i = 0;
        while (i < lines.length) {
            MTax tax;
            MRMALine line = lines[i];
            totalLines = totalLines.add(line.getLineNetAmt());
            Integer taxID = new Integer(line.getC_Tax_ID());
            if (!taxList.contains(taxID) && (tax = new MTax(rma.getCtx(), taxID.intValue(), rma.get_TrxName())).getC_TaxProvider_ID() != 0) {
                oTax = MRMATax.get((MRMALine)line, (int)rma.getPrecision(), (boolean)false, (String)rma.get_TrxName());
                oTax.setIsTaxIncluded(rma.isTaxIncluded());
                if (!this.calculateTaxFromRMALines(line, oTax)) {
                    return false;
                }
                if (!oTax.save(rma.get_TrxName())) {
                    return false;
                }
                taxList.add(taxID);
            }
            ++i;
        }
        BigDecimal grandTotal = totalLines;
        MRMATax[] taxes = rma.getTaxes(true);
        RoundingMode roundingMode = JPiereTaxProvider.getRoundingMode(lines[0].getParent().getC_BPartner_ID(), lines[0].getParent().isSOTrx(), (I_C_TaxProvider)provider);
        int i2 = 0;
        while (i2 < taxes.length) {
            oTax = taxes[i2];
            if (oTax.getC_TaxProvider_ID() == 0) {
                if (!rma.isTaxIncluded()) {
                    grandTotal = grandTotal.add(oTax.getTaxAmt());
                }
            } else {
                MTax tax = MTax.get((Properties)oTax.getCtx(), (int)oTax.getC_Tax_ID());
                if (tax.isSummary()) {
                    MTax[] cTaxes = tax.getChildTaxes(false);
                    int j = 0;
                    while (j < cTaxes.length) {
                        MTax cTax = cTaxes[j];
                        BigDecimal taxAmt = this.calculateTax(cTax, oTax.getTaxBaseAmt(), rma.isTaxIncluded(), rma.getPrecision(), roundingMode);
                        MRMATax newOTax = new MRMATax(rma.getCtx(), 0, rma.get_TrxName());
                        newOTax.set_ValueOfColumn("AD_Client_ID", (Object)rma.getAD_Client_ID());
                        newOTax.setAD_Org_ID(rma.getAD_Org_ID());
                        newOTax.setM_RMA_ID(rma.getM_RMA_ID());
                        newOTax.setC_Tax_ID(cTax.getC_Tax_ID());
                        newOTax.setIsTaxIncluded(rma.isTaxIncluded());
                        newOTax.setTaxBaseAmt(oTax.getTaxBaseAmt());
                        newOTax.setTaxAmt(taxAmt);
                        if (!newOTax.save(rma.get_TrxName())) {
                            return false;
                        }
                        if (!rma.isTaxIncluded()) {
                            grandTotal = grandTotal.add(taxAmt);
                        }
                        ++j;
                    }
                    if (!oTax.delete(true, rma.get_TrxName())) {
                        return false;
                    }
                    if (!oTax.save(rma.get_TrxName())) {
                        return false;
                    }
                } else if (!rma.isTaxIncluded()) {
                    grandTotal = grandTotal.add(oTax.getTaxAmt());
                }
            }
            ++i2;
        }
        rma.setAmt(grandTotal);
        return true;
    }

    public boolean updateHeaderTax(MTaxProvider provider, MRMALine line) {
        String sql = "UPDATE M_RMA  SET Amt=(SELECT COALESCE(SUM(LineNetAmt),0) FROM M_RMALine WHERE M_RMA.M_RMA_ID=M_RMALine.M_RMA_ID) WHERE M_RMA_ID=?";
        int no = DB.executeUpdateEx((String)sql, (Object[])new Object[]{line.getM_RMA_ID()}, (String)line.get_TrxName());
        if (no != 1) {
            this.log.warning("(1) #" + no);
        }
        line.clearParent();
        return no == 1;
    }

    public boolean updateRMATax(MTaxProvider provider, MRMALine line) {
        return this.updateRMATax(line, false);
    }

    public boolean recalculateTax(MTaxProvider provider, MRMALine line, boolean newRecord) {
        if (!newRecord && line.is_ValueChanged("C_Tax_ID") && !line.getParent().isProcessed() && !this.updateRMATax(line, true)) {
            return false;
        }
        if (!this.updateRMATax(line, false)) {
            return false;
        }
        return this.updateHeaderTax(provider, line);
    }

    private boolean updateRMATax(MRMALine line, boolean oldTax) {
        MRMATax tax = MRMATax.get((MRMALine)line, (int)line.getPrecision(), (boolean)oldTax, (String)line.get_TrxName());
        if (tax != null) {
            if (!this.calculateTaxFromRMALines(line, tax)) {
                return false;
            }
            if (tax.getTaxAmt().signum() != 0 ? !tax.save(tax.get_TrxName()) : !tax.is_new() && !tax.delete(false, tax.get_TrxName())) {
                return false;
            }
        }
        return true;
    }

    private boolean calculateTaxFromRMALines(MRMALine line, MRMATax m_rmatax) {
        RoundingMode roundingMode;
        boolean documentLevel;
        MTax tax;
        BigDecimal taxAmt;
        BigDecimal taxBaseAmt;
        block11: {
            taxBaseAmt = Env.ZERO;
            taxAmt = Env.ZERO;
            tax = MTax.get((Properties)m_rmatax.getCtx(), (int)m_rmatax.getC_Tax_ID());
            documentLevel = tax.isDocumentLevel();
            roundingMode = JPiereTaxProvider.getRoundingMode(line.getParent().getC_BPartner_ID(), line.getParent().isSOTrx(), tax.getC_TaxProvider());
            String sql = "SELECT LineNetAmt FROM M_RMALine WHERE M_RMA_ID=? AND C_Tax_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)line.get_TrxName());
                    pstmt.setInt(1, m_rmatax.getM_RMA_ID());
                    pstmt.setInt(2, m_rmatax.getC_Tax_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        BigDecimal baseAmt = rs.getBigDecimal(1);
                        taxBaseAmt = taxBaseAmt.add(baseAmt);
                        if (documentLevel) continue;
                        taxAmt = taxAmt.add(this.calculateTax(tax, baseAmt, m_rmatax.isTaxIncluded(), line.getPrecision(), roundingMode));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, line.get_TrxName(), (Throwable)e);
                    taxBaseAmt = null;
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (taxBaseAmt == null) {
            return false;
        }
        if (documentLevel) {
            taxAmt = this.calculateTax(tax, taxBaseAmt, m_rmatax.isTaxIncluded(), line.getPrecision(), roundingMode);
        }
        m_rmatax.setTaxAmt(taxAmt);
        if (m_rmatax.isTaxIncluded()) {
            m_rmatax.setTaxBaseAmt(taxBaseAmt.subtract(taxAmt));
        } else {
            m_rmatax.setTaxBaseAmt(taxBaseAmt);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.toString());
        }
        return true;
    }

    public String validateConnection(MTaxProvider provider, ProcessInfo pi) throws Exception {
        throw new IllegalStateException(Msg.getMsg((Properties)provider.getCtx(), (String)"ActionNotSupported"));
    }

    public static RoundingMode getRoundingMode(int C_BPartner_ID, boolean isSOTrx, I_C_TaxProvider provider) {
        Integer key = new Integer(C_BPartner_ID);
        MBPartner bp = (MBPartner)s_cache.get((Object)key);
        if (bp == null && (bp = MBPartner.get((Properties)Env.getCtx(), (int)C_BPartner_ID)) == null && C_BPartner_ID != 0) {
            String whereClause = "C_BPartner_ID=? AND AD_Client_ID=?";
            bp = (MBPartner)new Query(Env.getCtx(), "C_BPartner", whereClause, null).setParameters(new Object[]{C_BPartner_ID, provider.getAD_Client_ID()}).firstOnly();
        }
        RoundingMode roundingMode = null;
        if (bp != null) {
            s_cache.put((Object)key, (Object)bp);
            if (isSOTrx) {
                Object SO_TaxRounding = bp.get_Value("JP_SOTaxRounding");
                if (SO_TaxRounding != null) {
                    roundingMode = RoundingMode.valueOf(new Integer(SO_TaxRounding.toString()));
                }
            } else {
                Object PO_TaxRounding = bp.get_Value("JP_POTaxRounding");
                if (PO_TaxRounding != null) {
                    roundingMode = RoundingMode.valueOf(new Integer(PO_TaxRounding.toString()));
                }
            }
        }
        if (roundingMode == null) {
            if (provider != null && provider.getAccount() != null) {
                String roundingModeString = provider.getAccount();
                if (roundingModeString.equals("UP")) {
                    return RoundingMode.UP;
                }
                if (roundingModeString.equals("DOWN")) {
                    return RoundingMode.DOWN;
                }
                if (roundingModeString.equals("CEILING")) {
                    return RoundingMode.CEILING;
                }
                if (roundingModeString.equals("FLOOR")) {
                    return RoundingMode.FLOOR;
                }
                if (roundingModeString.equals("HALF_UP")) {
                    return RoundingMode.HALF_UP;
                }
                if (roundingModeString.equals("HALF_DOWN")) {
                    return RoundingMode.HALF_DOWN;
                }
                if (roundingModeString.equals("HALF_EVEN")) {
                    return RoundingMode.HALF_EVEN;
                }
                if (roundingModeString.equals("UNNECESSARY")) {
                    return RoundingMode.UNNECESSARY;
                }
                return RoundingMode.DOWN;
            }
            roundingMode = RoundingMode.DOWN;
        }
        return roundingMode;
    }

    @Override
    public BigDecimal calculateTax(MTax m_tax, BigDecimal amount, boolean taxIncluded, int scale, RoundingMode roundingMode) {
        if (m_tax.isZeroTax()) {
            return Env.ZERO;
        }
        BigDecimal multiplier = m_tax.getRate().divide(Env.ONEHUNDRED, 12, RoundingMode.HALF_UP);
        BigDecimal tax = null;
        if (!taxIncluded) {
            tax = amount.multiply(multiplier);
        } else {
            multiplier = multiplier.add(Env.ONE);
            BigDecimal base = amount.divide(multiplier, 12, RoundingMode.HALF_UP);
            tax = amount.subtract(base);
        }
        BigDecimal finalTax = tax.setScale(scale, roundingMode);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("calculateTax " + amount + " (incl=" + taxIncluded + ",mult=" + multiplier + ",scale=" + scale + ") = " + finalTax + " [" + tax + "]");
        }
        return finalTax;
    }

    @Override
    public boolean calculateEstimationTaxTotal(MTaxProvider provider, MEstimation estimation) {
        MEstimationTax eTax;
        BigDecimal totalLines = Env.ZERO;
        ArrayList<Integer> taxList = new ArrayList<Integer>();
        MEstimationLine[] lines = estimation.getLines();
        int i = 0;
        while (i < lines.length) {
            MTax tax;
            MEstimationLine line = lines[i];
            totalLines = totalLines.add(line.getLineNetAmt());
            Integer taxID = new Integer(line.getC_Tax_ID());
            if (!taxList.contains(taxID) && (tax = new MTax(estimation.getCtx(), taxID.intValue(), estimation.get_TrxName())).getC_TaxProvider_ID() != 0) {
                MCharge charge;
                eTax = MEstimationTax.get(line, estimation.getPrecision(), false, estimation.get_TrxName());
                eTax.setIsTaxIncluded(estimation.isTaxIncluded());
                if (line.getC_Charge_ID() != 0 && !(charge = MCharge.get((Properties)Env.getCtx(), (int)line.getC_Charge_ID())).isSameTax()) {
                    eTax.setIsTaxIncluded(charge.isTaxIncluded());
                }
                if (!this.calculateTaxFromEstimationLines(line, eTax)) {
                    return false;
                }
                if (!eTax.save(estimation.get_TrxName())) {
                    return false;
                }
                taxList.add(taxID);
            }
            ++i;
        }
        BigDecimal grandTotal = totalLines;
        MEstimationTax[] taxes = estimation.getTaxes(true);
        RoundingMode roundingMode = JPiereTaxProvider.getRoundingMode(lines[0].getParent().getC_BPartner_ID(), lines[0].getParent().isSOTrx(), (I_C_TaxProvider)provider);
        int i2 = 0;
        while (i2 < taxes.length) {
            eTax = taxes[i2];
            if (eTax.getC_TaxProvider_ID() == 0) {
                if (!eTax.isTaxIncluded()) {
                    grandTotal = grandTotal.add(eTax.getTaxAmt());
                }
            } else {
                MTax tax = MTax.get((Properties)eTax.getCtx(), (int)eTax.getC_Tax_ID());
                if (tax.isSummary()) {
                    MTax[] cTaxes = tax.getChildTaxes(false);
                    int j = 0;
                    while (j < cTaxes.length) {
                        MTax cTax = cTaxes[j];
                        BigDecimal taxAmt = this.calculateTax(cTax, eTax.getTaxBaseAmt(), eTax.isTaxIncluded(), estimation.getPrecision(), roundingMode);
                        MEstimationTax newOTax = new MEstimationTax(estimation.getCtx(), 0, estimation.get_TrxName());
                        newOTax.set_ValueOfColumn("AD_Client_ID", estimation.getAD_Client_ID());
                        newOTax.setAD_Org_ID(estimation.getAD_Org_ID());
                        newOTax.setJP_Estimation_ID(estimation.getJP_Estimation_ID());
                        newOTax.setC_Tax_ID(cTax.getC_Tax_ID());
                        newOTax.setIsTaxIncluded(eTax.isTaxIncluded());
                        newOTax.setTaxBaseAmt(eTax.getTaxBaseAmt());
                        newOTax.setTaxAmt(taxAmt);
                        if (!newOTax.save(estimation.get_TrxName())) {
                            return false;
                        }
                        if (!eTax.isTaxIncluded()) {
                            grandTotal = grandTotal.add(taxAmt);
                        }
                        ++j;
                    }
                    if (!eTax.delete(true, estimation.get_TrxName())) {
                        return false;
                    }
                    if (!eTax.save(estimation.get_TrxName())) {
                        return false;
                    }
                } else if (!eTax.isTaxIncluded()) {
                    grandTotal = grandTotal.add(eTax.getTaxAmt());
                }
            }
            ++i2;
        }
        estimation.setTotalLines(totalLines);
        estimation.setGrandTotal(grandTotal);
        return true;
    }

    private boolean calculateTaxFromEstimationLines(MEstimationLine line, MEstimationTax m_oderTax) {
        RoundingMode roundingMode;
        boolean documentLevel;
        MTax tax;
        BigDecimal taxAmt;
        BigDecimal taxBaseAmt;
        block11: {
            taxBaseAmt = Env.ZERO;
            taxAmt = Env.ZERO;
            tax = MTax.get((Properties)m_oderTax.getCtx(), (int)m_oderTax.getC_Tax_ID());
            documentLevel = tax.isDocumentLevel();
            roundingMode = JPiereTaxProvider.getRoundingMode(line.getParent().getC_BPartner_ID(), line.getParent().isSOTrx(), tax.getC_TaxProvider());
            String sql = "SELECT LineNetAmt FROM JP_EstimationLine WHERE JP_Estimation_ID=? AND C_Tax_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)m_oderTax.get_TrxName());
                    pstmt.setInt(1, m_oderTax.getJP_Estimation_ID());
                    pstmt.setInt(2, m_oderTax.getC_Tax_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        BigDecimal baseAmt = rs.getBigDecimal(1);
                        taxBaseAmt = taxBaseAmt.add(baseAmt);
                        if (documentLevel) continue;
                        taxAmt = taxAmt.add(this.calculateTax(tax, baseAmt, m_oderTax.isTaxIncluded(), line.getPrecision(), roundingMode));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, m_oderTax.get_TrxName(), (Throwable)e);
                    taxBaseAmt = null;
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (taxBaseAmt == null) {
            return false;
        }
        if (documentLevel) {
            taxAmt = this.calculateTax(tax, taxBaseAmt, m_oderTax.isTaxIncluded(), line.getPrecision(), roundingMode);
        }
        m_oderTax.setTaxAmt(taxAmt);
        if (m_oderTax.isTaxIncluded()) {
            m_oderTax.setTaxBaseAmt(taxBaseAmt.subtract(taxAmt));
        } else {
            m_oderTax.setTaxBaseAmt(taxBaseAmt);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.toString());
        }
        return true;
    }

    @Override
    public boolean recalculateTax(MTaxProvider provider, MEstimationLine line, boolean newRecord) {
        if (!newRecord && line.is_ValueChanged("C_Tax_ID") && !line.getParent().isProcessed() && !this.updateEstimationTax(line, true)) {
            return false;
        }
        if (!this.updateEstimationTax(line, false)) {
            return false;
        }
        return this.updateHeaderTax(provider, line);
    }

    @Override
    public boolean updateEstimationTax(MTaxProvider provider, MEstimationLine line) {
        return this.updateEstimationTax(line, false);
    }

    private boolean updateEstimationTax(MEstimationLine line, boolean oldTax) {
        MEstimationTax tax = MEstimationTax.get(line, line.getPrecision(), oldTax, line.get_TrxName());
        if (tax != null) {
            MCharge charge;
            if (line.getC_Charge_ID() != 0 && !(charge = MCharge.get((Properties)Env.getCtx(), (int)line.getC_Charge_ID())).isSameTax()) {
                tax.setIsTaxIncluded(charge.isTaxIncluded());
            }
            if (!this.calculateTaxFromEstimationLines(line, tax)) {
                return false;
            }
            if (tax.getTaxAmt().signum() != 0 ? !tax.save(line.get_TrxName()) : !tax.is_new() && !tax.delete(false, line.get_TrxName())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean updateHeaderTax(MTaxProvider provider, MEstimationLine line) {
        String sql = "UPDATE JP_Estimation i SET TotalLines=(SELECT COALESCE(SUM(LineNetAmt),0) FROM JP_EstimationLine il WHERE i.JP_Estimation_ID=il.JP_Estimation_ID) , JP_ScheduledCostTotalLines = (SELECT COALESCE(SUM(JP_ScheduledCostLineAmt),0) FROM JP_EstimationLine il WHERE i.JP_Estimation_ID=il.JP_Estimation_ID)WHERE JP_Estimation_ID=?";
        int no = DB.executeUpdate((String)sql, (Object[])new Object[]{new Integer(line.getJP_Estimation_ID())}, (boolean)false, (String)line.get_TrxName(), (int)0);
        if (no != 1) {
            this.log.warning("(1) #" + no);
        }
        sql = "UPDATE JP_Estimation i  SET GrandTotal=TotalLines+(SELECT COALESCE(SUM(TaxAmt),0) FROM JP_EstimationTax it WHERE i.JP_Estimation_ID=it.JP_Estimation_ID AND it.IsTaxIncluded='N' ) WHERE JP_Estimation_ID=?";
        no = DB.executeUpdate((String)sql, (Object[])new Object[]{new Integer(line.getJP_Estimation_ID())}, (boolean)false, (String)line.get_TrxName(), (int)0);
        if (no != 1) {
            this.log.warning("(2) #" + no);
        }
        line.clearParent();
        return no == 1;
    }

    @Override
    public boolean calculateRecognitionTaxTotal(MTaxProvider provider, MRecognition recognition) {
        MRecognitionTax rTax;
        BigDecimal totalLines = Env.ZERO;
        ArrayList<Integer> taxList = new ArrayList<Integer>();
        MRecognitionLine[] lines = recognition.getLines();
        int i = 0;
        while (i < lines.length) {
            MTax tax;
            MRecognitionLine line = lines[i];
            totalLines = totalLines.add(line.getLineNetAmt());
            Integer taxID = new Integer(line.getC_Tax_ID());
            if (!taxList.contains(taxID) && (tax = new MTax(recognition.getCtx(), taxID.intValue(), recognition.get_TrxName())).getC_TaxProvider_ID() != 0) {
                MCharge charge;
                rTax = MRecognitionTax.get(line, recognition.getPrecision(), false, recognition.get_TrxName());
                rTax.setIsTaxIncluded(recognition.isTaxIncluded());
                if (line.getC_Charge_ID() != 0 && !(charge = MCharge.get((Properties)Env.getCtx(), (int)line.getC_Charge_ID())).isSameTax()) {
                    rTax.setIsTaxIncluded(charge.isTaxIncluded());
                }
                if (!this.calculateTaxFromRecognitionLines(line, rTax)) {
                    return false;
                }
                if (!rTax.save(recognition.get_TrxName())) {
                    return false;
                }
                taxList.add(taxID);
            }
            ++i;
        }
        BigDecimal grandTotal = totalLines;
        MRecognitionTax[] taxes = recognition.getTaxes(true);
        RoundingMode roundingMode = JPiereTaxProvider.getRoundingMode(lines[0].getParent().getC_BPartner_ID(), lines[0].getParent().isSOTrx(), (I_C_TaxProvider)provider);
        int i2 = 0;
        while (i2 < taxes.length) {
            rTax = taxes[i2];
            if (rTax.getC_TaxProvider_ID() == 0) {
                if (!rTax.isTaxIncluded()) {
                    grandTotal = grandTotal.add(rTax.getTaxAmt());
                }
            } else {
                MTax tax = MTax.get((Properties)rTax.getCtx(), (int)rTax.getC_Tax_ID());
                if (tax.isSummary()) {
                    MTax[] cTaxes = tax.getChildTaxes(false);
                    int j = 0;
                    while (j < cTaxes.length) {
                        MTax cTax = cTaxes[j];
                        BigDecimal taxAmt = this.calculateTax(cTax, rTax.getTaxBaseAmt(), rTax.isTaxIncluded(), recognition.getPrecision(), roundingMode);
                        MRecognitionTax newOTax = new MRecognitionTax(recognition.getCtx(), 0, recognition.get_TrxName());
                        newOTax.set_ValueOfColumn("AD_Client_ID", recognition.getAD_Client_ID());
                        newOTax.setAD_Org_ID(recognition.getAD_Org_ID());
                        newOTax.setJP_Recognition_ID(recognition.getJP_Recognition_ID());
                        newOTax.setC_Tax_ID(cTax.getC_Tax_ID());
                        newOTax.setIsTaxIncluded(rTax.isTaxIncluded());
                        newOTax.setTaxBaseAmt(rTax.getTaxBaseAmt());
                        newOTax.setTaxAmt(taxAmt);
                        if (!newOTax.save(recognition.get_TrxName())) {
                            return false;
                        }
                        if (!rTax.isTaxIncluded()) {
                            grandTotal = grandTotal.add(taxAmt);
                        }
                        ++j;
                    }
                    if (!rTax.delete(true, recognition.get_TrxName())) {
                        return false;
                    }
                    if (!rTax.save(recognition.get_TrxName())) {
                        return false;
                    }
                } else if (!rTax.isTaxIncluded()) {
                    grandTotal = grandTotal.add(rTax.getTaxAmt());
                }
            }
            ++i2;
        }
        recognition.setTotalLines(totalLines);
        recognition.setGrandTotal(grandTotal);
        return true;
    }

    private boolean calculateTaxFromRecognitionLines(MRecognitionLine line, MRecognitionTax m_oderTax) {
        RoundingMode roundingMode;
        boolean documentLevel;
        MTax tax;
        BigDecimal taxAmt;
        BigDecimal taxBaseAmt;
        block11: {
            taxBaseAmt = Env.ZERO;
            taxAmt = Env.ZERO;
            tax = MTax.get((Properties)m_oderTax.getCtx(), (int)m_oderTax.getC_Tax_ID());
            documentLevel = tax.isDocumentLevel();
            roundingMode = JPiereTaxProvider.getRoundingMode(line.getParent().getC_BPartner_ID(), line.getParent().isSOTrx(), tax.getC_TaxProvider());
            String sql = "SELECT LineNetAmt FROM JP_RecognitionLine WHERE JP_Recognition_ID=? AND C_Tax_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)m_oderTax.get_TrxName());
                    pstmt.setInt(1, m_oderTax.getJP_Recognition_ID());
                    pstmt.setInt(2, m_oderTax.getC_Tax_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        BigDecimal baseAmt = rs.getBigDecimal(1);
                        taxBaseAmt = taxBaseAmt.add(baseAmt);
                        if (documentLevel) continue;
                        taxAmt = taxAmt.add(this.calculateTax(tax, baseAmt, m_oderTax.isTaxIncluded(), line.getPrecision(), roundingMode));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, m_oderTax.get_TrxName(), (Throwable)e);
                    taxBaseAmt = null;
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (taxBaseAmt == null) {
            return false;
        }
        if (documentLevel) {
            taxAmt = this.calculateTax(tax, taxBaseAmt, m_oderTax.isTaxIncluded(), line.getPrecision(), roundingMode);
        }
        m_oderTax.setTaxAmt(taxAmt);
        if (m_oderTax.isTaxIncluded()) {
            m_oderTax.setTaxBaseAmt(taxBaseAmt.subtract(taxAmt));
        } else {
            m_oderTax.setTaxBaseAmt(taxBaseAmt);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.toString());
        }
        return true;
    }

    @Override
    public boolean recalculateTax(MTaxProvider provider, MRecognitionLine line, boolean newRecord) {
        if (!newRecord && line.is_ValueChanged("C_Tax_ID") && !line.getParent().isProcessed() && !this.updateRecognitionTax(line, true)) {
            return false;
        }
        if (!this.updateRecognitionTax(line, false)) {
            return false;
        }
        return this.updateHeaderTax(provider, line);
    }

    @Override
    public boolean updateRecognitionTax(MTaxProvider provider, MRecognitionLine line) {
        return this.updateRecognitionTax(line, false);
    }

    private boolean updateRecognitionTax(MRecognitionLine line, boolean oldTax) {
        MRecognitionTax tax = MRecognitionTax.get(line, line.getPrecision(), oldTax, line.get_TrxName());
        if (tax != null) {
            MCharge charge;
            if (line.getC_Charge_ID() != 0 && !(charge = MCharge.get((Properties)Env.getCtx(), (int)line.getC_Charge_ID())).isSameTax()) {
                tax.setIsTaxIncluded(charge.isTaxIncluded());
            }
            if (!this.calculateTaxFromRecognitionLines(line, tax)) {
                return false;
            }
            if (tax.getTaxAmt().signum() != 0 ? !tax.save(line.get_TrxName()) : !tax.is_new() && !tax.delete(false, line.get_TrxName())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean updateHeaderTax(MTaxProvider provider, MRecognitionLine line) {
        String sql = "UPDATE JP_Recognition r SET TotalLines=(SELECT COALESCE(SUM(LineNetAmt),0) FROM JP_RecognitionLine rl WHERE r.JP_Recognition_ID=rl.JP_Recognition_ID) WHERE JP_Recognition_ID=?";
        int no = DB.executeUpdate((String)sql, (Object[])new Object[]{new Integer(line.getJP_Recognition_ID())}, (boolean)false, (String)line.get_TrxName(), (int)0);
        if (no != 1) {
            this.log.warning("(1) #" + no);
        }
        sql = "UPDATE JP_Recognition r  SET GrandTotal=TotalLines+(SELECT COALESCE(SUM(TaxAmt),0) FROM JP_RecognitionTax rt WHERE r.JP_Recognition_ID=rt.JP_Recognition_ID AND rt.IsTaxIncluded='N') WHERE JP_Recognition_ID=?";
        no = DB.executeUpdate((String)sql, (Object[])new Object[]{new Integer(line.getJP_Recognition_ID())}, (boolean)false, (String)line.get_TrxName(), (int)0);
        if (no != 1) {
            this.log.warning("(2) #" + no);
        }
        line.clearParent();
        return no == 1;
    }
}

