/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.sql.Timestamp;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.MInvoiceJP;
import jpiere.base.plugin.util.JPierePaymentTerms;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class JPiereInvoiceModelValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(JPiereInvoiceModelValidator.class);
    private int AD_Client_ID = -1;
    private int AD_Org_ID = -1;
    private int AD_Role_ID = -1;
    private int AD_User_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("C_Invoice", (ModelValidator)this);
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        this.AD_Org_ID = AD_Org_ID;
        this.AD_Role_ID = AD_Role_ID;
        this.AD_User_ID = AD_User_ID;
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        MInvoice invoice;
        if (type == 1 || type == 2 && po.is_ValueChanged("C_PaymentTerm_ID")) {
            MPaymentTerm pt;
            invoice = (MInvoice)po;
            MPaymentTerm paymentTerm = new MPaymentTerm(Env.getCtx(), invoice.getC_PaymentTerm_ID(), null);
            Boolean IsPaymentTerms = (Boolean)paymentTerm.get_Value("IsPaymentTermsJP");
            if (IsPaymentTerms.booleanValue() && (pt = JPierePaymentTerms.getPaymentTerm(Env.getCtx(), invoice.getC_PaymentTerm_ID(), invoice.getDateInvoiced())) != null) {
                invoice.setC_PaymentTerm_ID(pt.get_ID());
            }
        }
        if (type == 1 || type == 2 && po.is_ValueChanged("C_DocTypeTarget_ID") || type == 2 && po.is_ValueChanged("M_PriceList_ID")) {
            invoice = (MInvoice)po;
            invoice.setIsSOTrx(invoice.getC_DocTypeTarget().isSOTrx());
            invoice.setIsTaxIncluded(invoice.getM_PriceList().isTaxIncluded());
            invoice.setC_Currency_ID(invoice.getM_PriceList().getC_Currency_ID());
        }
        if (type == 2 && po.is_ValueChanged("C_DocTypeTarget_ID")) {
            invoice = (MInvoice)po;
            int C_DocTypeTarget_ID = invoice.get_ValueOldAsInt("C_DocTypeTarget_ID");
            MDocType oldDocType = MDocType.get((Properties)po.getCtx(), (int)C_DocTypeTarget_ID);
            if (!invoice.getC_DocTypeTarget().getDocBaseType().equals(oldDocType.getDocBaseType())) {
                return Msg.getMsg((Properties)po.getCtx(), (String)"JP_Can_Not_Change_Diff_DocBaseType");
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        if (timing == 1 && po instanceof MInvoiceJP) {
            MInvoiceJP inv = (MInvoiceJP)po;
            inv.explodeBOM();
        }
        if (timing == 1) {
            MInvoice invoice = (MInvoice)po;
            MPaymentTerm paymentTerm = new MPaymentTerm(Env.getCtx(), invoice.getC_PaymentTerm_ID(), null);
            if (invoice.isSOTrx()) {
                Object obj_AR_ClosingDate = paymentTerm.get_Value("JP_AR_ClosingDate");
                if (obj_AR_ClosingDate != null) {
                    Timestamp JP_AR_ClosingDate = (Timestamp)obj_AR_ClosingDate;
                    if (invoice.getDateInvoiced().compareTo(JP_AR_ClosingDate) <= 0 || invoice.getDateAcct().compareTo(JP_AR_ClosingDate) <= 0) {
                        return Msg.getMsg((Properties)po.getCtx(), (String)"JP_PaymentTerm_ClosingDate");
                    }
                }
            } else {
                Object obj_AP_ClosingDate = paymentTerm.get_Value("JP_AP_ClosingDate");
                if (obj_AP_ClosingDate != null) {
                    Timestamp JP_AP_ClosingDate = (Timestamp)obj_AP_ClosingDate;
                    if (invoice.getDateInvoiced().compareTo(JP_AP_ClosingDate) <= 0 || invoice.getDateAcct().compareTo(JP_AP_ClosingDate) <= 0) {
                        return Msg.getMsg((Properties)po.getCtx(), (String)"JP_PaymentTerm_ClosingDate");
                    }
                }
            }
        }
        return null;
    }
}

