/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.util.List;
import java.util.Properties;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.FactsValidator;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MRMA;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class JPiereContractMatchInvModelValidator
implements ModelValidator,
FactsValidator {
    private static CLogger log = CLogger.getCLogger(JPiereContractMatchInvModelValidator.class);
    private int AD_Client_ID = -1;
    private int AD_Org_ID = -1;
    private int AD_Role_ID = -1;
    private int AD_User_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("M_MatchInv", (ModelValidator)this);
        engine.addDocValidate("M_MatchInv", (ModelValidator)this);
        engine.addFactsValidate("M_MatchInv", (FactsValidator)this);
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        this.AD_Org_ID = AD_Org_ID;
        this.AD_Role_ID = AD_Role_ID;
        this.AD_User_ID = AD_User_ID;
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        return null;
    }

    public String docValidate(PO po, int timing) {
        if (timing == 7) {
            // empty if block
        }
        return null;
    }

    public String factsValidate(MAcctSchema schema, List<Fact> facts, PO po) {
        if (po.get_TableName().equals("M_MatchInv")) {
            MMatchInv matchInv = (MMatchInv)po;
            MInvoiceLine invoiceLine = new MInvoiceLine(Env.getCtx(), matchInv.getC_InvoiceLine_ID(), po.get_TrxName());
            MInvoice invoice = new MInvoice(Env.getCtx(), invoiceLine.getC_Invoice_ID(), po.get_TrxName());
            MInOutLine inoutLine = new MInOutLine(Env.getCtx(), matchInv.getM_InOutLine_ID(), po.get_TrxName());
            MInOut inout = new MInOut(Env.getCtx(), inoutLine.getM_InOut_ID(), po.get_TrxName());
            int inv_ContractContent_ID = invoice.get_ValueAsInt("JP_ContractContent_ID");
            int io_ContractContent_ID = inout.get_ValueAsInt("JP_ContractContent_ID");
            if (inv_ContractContent_ID == 0 && io_ContractContent_ID == 0) {
                return null;
            }
            if (inv_ContractContent_ID > 0 && io_ContractContent_ID <= 0) {
                String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID"), Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID")});
                return msg;
            }
            if (inv_ContractContent_ID <= 0 && io_ContractContent_ID > 0) {
                String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID"), Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID")});
                return msg;
            }
            if (inv_ContractContent_ID != io_ContractContent_ID) {
                String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID"), Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractContent_ID")});
                return msg;
            }
            int inv_Order_ID = invoice.getC_Order_ID();
            for (Fact fact : facts) {
                FactLine[] factLine = fact.getLines();
                int i = 0;
                while (i < factLine.length) {
                    if (invoice.getC_Order_ID() > 0) {
                        factLine[i].set_ValueNoCheck("JP_Order_ID", (Object)inv_Order_ID);
                    } else if (invoice.getM_RMA_ID() > 0) {
                        int M_RMA_ID = invoice.getM_RMA_ID();
                        MRMA rma = new MRMA(Env.getCtx(), M_RMA_ID, po.get_TrxName());
                        int JP_Order_ID = rma.get_ValueAsInt("JP_Order_ID");
                        if (JP_Order_ID > 0) {
                            factLine[i].set_ValueNoCheck("JP_Order_ID", (Object)JP_Order_ID);
                        }
                    }
                    factLine[i].set_ValueNoCheck("JP_ContractContent_ID", (Object)inv_ContractContent_ID);
                    ++i;
                }
            }
        }
        return null;
    }
}

