/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.base;

import java.util.Properties;
import jpiere.base.plugin.util.ZenginCheck;
import org.compiere.model.MBank;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class JPiereBankModelValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(JPiereBankModelValidator.class);
    private int AD_Client_ID = -1;
    private int AD_Org_ID = -1;
    private int AD_Role_ID = -1;
    private int AD_User_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("C_Bank", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        this.AD_Org_ID = AD_Org_ID;
        this.AD_Role_ID = AD_Role_ID;
        this.AD_User_ID = AD_User_ID;
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        MBank bank;
        String characters;
        if ((type == 1 || type == 2) && (characters = (String)(bank = (MBank)po).get_Value("JP_BankName_Kana")) != null) {
            int i = 0;
            while (i < characters.length()) {
                if (!ZenginCheck.charCheck(characters.charAt(i))) {
                    return "\u300c" + characters.charAt(i) + "\u300d\u306f\u4f7f\u3048\u306a\u3044\u6587\u5b57\u3067\u3059\u3002";
                }
                ++i;
            }
            if (characters.length() > 15) {
                return String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_BankName_Kana")) + "\u306f" + 15 + "\u4ee5\u5185\u3067\u3059\u3002";
            }
            if (bank.getRoutingNo().length() != 4) {
                return String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"RoutingNo")) + "\u306f" + 4 + "\u6841\u3067\u3059\u3002";
            }
            if (!ZenginCheck.numStringCheck(bank.getRoutingNo())) {
                return String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"RoutingNo")) + "\u306b\u534a\u89d2\u6570\u5024\u4ee5\u5916\u306e\u6587\u5b57\u304c\u4f7f\u7528\u3055\u308c\u3066\u3044\u307e\u3059\u3002";
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        return null;
    }
}

