/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.adempiere.base.IProductPricing;
import org.adempiere.model.GridTabWrapper;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.I_C_OrderLine;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MRole;
import org.compiere.model.MSequence;
import org.compiere.model.MStorageReservation;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.model.MWarehouse;
import org.compiere.model.Tax;
import org.compiere.model.X_C_POSTenderType;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CalloutOrder
extends CalloutEngine {
    private boolean steps = false;

    public String docType(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        boolean newDocNo;
        Integer C_DocType_ID = (Integer)value;
        if (C_DocType_ID == null || C_DocType_ID == 0) {
            return "";
        }
        String oldDocNo = (String)mTab.getValue("DocumentNo");
        boolean bl = newDocNo = oldDocNo == null;
        if (!newDocNo && oldDocNo.startsWith("<") && oldDocNo.endsWith(">")) {
            newDocNo = true;
        }
        Integer oldC_DocType_ID = (Integer)mTab.getValue("C_DocType_ID");
        String sql = "SELECT d.DocSubTypeSO,d.HasCharges,d.IsDocNoControlled,s.AD_Sequence_ID,d.IsSOTrx FROM C_DocType d LEFT OUTER JOIN AD_Sequence s ON (d.DocNoSequence_ID=s.AD_Sequence_ID) WHERE C_DocType_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                int oldAD_Sequence_ID = 0;
                if (!newDocNo && oldC_DocType_ID != null && oldC_DocType_ID != 0) {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, oldC_DocType_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        oldAD_Sequence_ID = rs.getInt("AD_Sequence_ID");
                    }
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                }
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_DocType_ID);
                rs = pstmt.executeQuery();
                String DocSubTypeSO = "";
                boolean IsSOTrx = true;
                if (rs.next()) {
                    DocSubTypeSO = rs.getString("DocSubTypeSO");
                    if (DocSubTypeSO == null) {
                        DocSubTypeSO = "--";
                    }
                    Env.setContext((Properties)ctx, (int)WindowNo, (String)"OrderType", (String)DocSubTypeSO);
                    if (!DocSubTypeSO.equals("SO")) {
                        mTab.setValue("IsDropShip", (Object)"N");
                    }
                    if (DocSubTypeSO.equals("WR")) {
                        mTab.setValue("DeliveryRule", (Object)"F");
                    } else if (DocSubTypeSO.equals("PR")) {
                        mTab.setValue("DeliveryRule", (Object)"R");
                    } else {
                        mTab.setValue("DeliveryRule", (Object)"A");
                    }
                    if (DocSubTypeSO.equals("WR") || DocSubTypeSO.equals("PR") || DocSubTypeSO.equals("WI")) {
                        mTab.setValue("InvoiceRule", (Object)"I");
                    } else {
                        mTab.setValue("InvoiceRule", (Object)"D");
                    }
                    if (DocSubTypeSO.equals("WR")) {
                        mTab.setValue("PaymentRule", (Object)"B");
                    } else {
                        mTab.setValue("PaymentRule", (Object)"P");
                    }
                    if ("N".equals(rs.getString("IsSOTrx"))) {
                        IsSOTrx = false;
                    }
                    Env.setContext((Properties)ctx, (int)WindowNo, (String)"HasCharges", (String)rs.getString("HasCharges"));
                    if (rs.getString("IsDocNoControlled").equals("Y")) {
                        if (!newDocNo && oldAD_Sequence_ID != rs.getInt("AD_Sequence_ID")) {
                            newDocNo = true;
                        }
                        if (newDocNo) {
                            int AD_Sequence_ID = rs.getInt("AD_Sequence_ID");
                            mTab.setValue("DocumentNo", (Object)MSequence.getPreliminaryNo((GridTab)mTab, (int)AD_Sequence_ID));
                        }
                    }
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                if (!DocSubTypeSO.equals("WR") && !DocSubTypeSO.equals("PR")) {
                    sql = "SELECT PaymentRule,C_PaymentTerm_ID,InvoiceRule,DeliveryRule,FreightCostRule,DeliveryViaRule, PaymentRulePO,PO_PaymentTerm_ID FROM C_BPartner WHERE C_BPartner_ID=?";
                    pstmt = DB.prepareStatement((String)sql, null);
                    int C_BPartner_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_BPartner_ID");
                    pstmt.setInt(1, C_BPartner_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        String s = rs.getString(IsSOTrx ? "PaymentRule" : "PaymentRulePO");
                        if (s != null && s.length() != 0) {
                            mTab.setValue("PaymentRule", (Object)s);
                        }
                        Integer ii = new Integer(rs.getInt(IsSOTrx ? "C_PaymentTerm_ID" : "PO_PaymentTerm_ID"));
                        if (!rs.wasNull()) {
                            mTab.setValue("C_PaymentTerm_ID", (Object)ii);
                        }
                        if ((s = rs.getString(3)) != null && s.length() != 0) {
                            mTab.setValue("InvoiceRule", (Object)s);
                        }
                        if ((s = rs.getString(4)) != null && s.length() != 0) {
                            mTab.setValue("DeliveryRule", (Object)s);
                        }
                        if ((s = rs.getString(5)) != null && s.length() != 0) {
                            mTab.setValue("FreightCostRule", (Object)s);
                        }
                        if ((s = rs.getString(6)) != null && s.length() != 0) {
                            mTab.setValue("DeliveryViaRule", (Object)s);
                        }
                    }
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    public String bPartner(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_BPartner_ID = (Integer)value;
        if (C_BPartner_ID == null || C_BPartner_ID == 0) {
            return "";
        }
        String sql = "SELECT p.AD_Language,p.C_PaymentTerm_ID, COALESCE(p.M_PriceList_ID,g.M_PriceList_ID) AS M_PriceList_ID, p.PaymentRule,p.POReference, p.SO_Description,p.IsDiscountPrinted, p.InvoiceRule,p.DeliveryRule,p.FreightCostRule,DeliveryViaRule, p.SO_CreditLimit, p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable, (select max(lship.C_BPartner_Location_ID) from C_BPartner_Location lship where p.C_BPartner_ID=lship.C_BPartner_ID AND lship.IsShipTo='Y' AND lship.IsActive='Y') as C_BPartner_Location_ID, (select max(c.AD_User_ID) from AD_User c where p.C_BPartner_ID=c.C_BPartner_ID AND c.IsActive='Y') as AD_User_ID, COALESCE(p.PO_PriceList_ID,g.PO_PriceList_ID) AS PO_PriceList_ID, p.PaymentRulePO,p.PO_PaymentTerm_ID, (select max(lbill.C_BPartner_Location_ID) from C_BPartner_Location lbill where p.C_BPartner_ID=lbill.C_BPartner_ID AND lbill.IsBillTo='Y' AND lbill.IsActive='Y') AS Bill_Location_ID,  p.SOCreditStatus,  p.SalesRep_ID FROM C_BPartner p INNER JOIN C_BP_Group g ON (p.C_BP_Group_ID=g.C_BP_Group_ID)WHERE p.C_BPartner_ID=? AND p.IsActive='Y'";
        boolean IsSOTrx = "Y".equals(Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsSOTrx"));
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_BPartner_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    String s;
                    double CreditLimit;
                    String cont;
                    Integer salesRep = rs.getInt("SalesRep_ID");
                    if (IsSOTrx && salesRep != 0) {
                        mTab.setValue("SalesRep_ID", (Object)salesRep);
                    }
                    Integer ii = new Integer(rs.getInt(IsSOTrx ? "M_PriceList_ID" : "PO_PriceList_ID"));
                    if (!rs.wasNull()) {
                        mTab.setValue("M_PriceList_ID", (Object)ii);
                    } else {
                        int i = Env.getContextAsInt((Properties)ctx, (String)"#M_PriceList_ID");
                        if (i != 0) {
                            MPriceList pl = new MPriceList(ctx, i, null);
                            if (IsSOTrx == pl.isSOPriceList()) {
                                mTab.setValue("M_PriceList_ID", (Object)new Integer(i));
                            } else {
                                String sql2 = "SELECT M_PriceList_ID FROM M_PriceList WHERE AD_Client_ID=? AND IsSOPriceList=? AND IsActive='Y' ORDER BY IsDefault DESC";
                                ii = DB.getSQLValue(null, (String)sql2, (Object[])new Object[]{Env.getAD_Client_ID((Properties)ctx), IsSOTrx});
                                if (ii != 0) {
                                    mTab.setValue("M_PriceList_ID", (Object)new Integer(ii));
                                }
                            }
                        }
                    }
                    mTab.setValue("Bill_BPartner_ID", (Object)C_BPartner_ID);
                    int shipTo_ID = 0;
                    int bill_Location_ID = 0;
                    if (C_BPartner_ID.toString().equals(Env.getContext((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_BPartner_ID"))) {
                        String loc = Env.getContext((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_BPartner_Location_ID");
                        int locationId = 0;
                        if (loc.length() > 0) {
                            locationId = Integer.parseInt(loc);
                        }
                        if (locationId > 0) {
                            MBPartnerLocation bpLocation = new MBPartnerLocation(ctx, locationId, null);
                            if (bpLocation.isBillTo()) {
                                bill_Location_ID = locationId;
                            }
                            if (bpLocation.isShipTo()) {
                                shipTo_ID = locationId;
                            }
                        }
                    }
                    if (bill_Location_ID == 0) {
                        bill_Location_ID = rs.getInt("Bill_Location_ID");
                    }
                    if (bill_Location_ID == 0) {
                        mTab.setValue("Bill_Location_ID", null);
                    } else {
                        mTab.setValue("Bill_Location_ID", (Object)new Integer(bill_Location_ID));
                    }
                    if (shipTo_ID == 0) {
                        shipTo_ID = rs.getInt("C_BPartner_Location_ID");
                    }
                    if (shipTo_ID == 0) {
                        mTab.setValue("C_BPartner_Location_ID", null);
                    } else {
                        mTab.setValue("C_BPartner_Location_ID", (Object)new Integer(shipTo_ID));
                    }
                    int contID = rs.getInt("AD_User_ID");
                    if (C_BPartner_ID.toString().equals(Env.getContext((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_BPartner_ID")) && (cont = Env.getContext((Properties)ctx, (int)WindowNo, (int)1113, (String)"AD_User_ID")).length() > 0) {
                        contID = Integer.parseInt(cont);
                    }
                    if (contID == 0) {
                        mTab.setValue("AD_User_ID", null);
                    } else {
                        mTab.setValue("AD_User_ID", (Object)new Integer(contID));
                        mTab.setValue("Bill_User_ID", (Object)new Integer(contID));
                    }
                    if (IsSOTrx && (CreditLimit = rs.getDouble("SO_CreditLimit")) != 0.0) {
                        double CreditAvailable = rs.getDouble("CreditAvailable");
                        if (!rs.wasNull() && CreditAvailable < 0.0) {
                            mTab.fireDataStatusEEvent("CreditLimitOver", DisplayType.getNumberFormat((int)12).format(CreditAvailable), false);
                        }
                    }
                    if ((s = rs.getString("POReference")) != null && s.length() != 0) {
                        mTab.setValue("POReference", (Object)s);
                    }
                    if ((s = rs.getString("SO_Description")) != null && s.trim().length() != 0) {
                        mTab.setValue("Description", (Object)s);
                    }
                    if ((s = rs.getString("IsDiscountPrinted")) != null && s.length() != 0) {
                        mTab.setValue("IsDiscountPrinted", (Object)s);
                    } else {
                        mTab.setValue("IsDiscountPrinted", (Object)"N");
                    }
                    String OrderType = Env.getContext((Properties)ctx, (int)WindowNo, (String)"OrderType");
                    mTab.setValue("InvoiceRule", (Object)"D");
                    mTab.setValue("DeliveryRule", (Object)"A");
                    mTab.setValue("PaymentRule", (Object)"P");
                    if (OrderType.equals("PR")) {
                        mTab.setValue("InvoiceRule", (Object)"I");
                        mTab.setValue("DeliveryRule", (Object)"R");
                    } else if (OrderType.equals("WR")) {
                        mTab.setValue("PaymentRule", (Object)"B");
                    } else {
                        s = rs.getString(IsSOTrx ? "PaymentRule" : "PaymentRulePO");
                        if (s != null && s.length() != 0) {
                            mTab.setValue("PaymentRule", (Object)s);
                        }
                        ii = new Integer(rs.getInt(IsSOTrx ? "C_PaymentTerm_ID" : "PO_PaymentTerm_ID"));
                        if (!rs.wasNull()) {
                            mTab.setValue("C_PaymentTerm_ID", (Object)ii);
                        }
                        if ((s = rs.getString("InvoiceRule")) != null && s.length() != 0) {
                            mTab.setValue("InvoiceRule", (Object)s);
                        }
                        if ((s = rs.getString("DeliveryRule")) != null && s.length() != 0) {
                            mTab.setValue("DeliveryRule", (Object)s);
                        }
                        if ((s = rs.getString("FreightCostRule")) != null && s.length() != 0) {
                            mTab.setValue("FreightCostRule", (Object)s);
                        }
                        if ((s = rs.getString("DeliveryViaRule")) != null && s.length() != 0) {
                            mTab.setValue("DeliveryViaRule", (Object)s);
                        }
                    }
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    public String bPartnerBill(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer bill_BPartner_ID = (Integer)value;
        if (bill_BPartner_ID == null || bill_BPartner_ID == 0) {
            return "";
        }
        String sql = "SELECT p.AD_Language,p.C_PaymentTerm_ID,p.M_PriceList_ID,p.PaymentRule,p.POReference,p.SO_Description,p.IsDiscountPrinted,p.InvoiceRule,p.DeliveryRule,p.FreightCostRule,DeliveryViaRule,p.SO_CreditLimit, p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable,(select max(c.AD_User_ID) from AD_User c where p.C_BPartner_ID=c.C_BPartner_ID AND c.IsActive='Y') as AD_User_ID,p.PO_PriceList_ID, p.PaymentRulePO, p.PO_PaymentTerm_ID,(select max(lbill.C_BPartner_Location_ID) from C_BPartner_Location lbill where p.C_BPartner_ID=lbill.C_BPartner_ID AND lbill.IsBillTo='Y' AND lbill.IsActive='Y') AS Bill_Location_ID FROM C_BPartner p WHERE p.C_BPartner_ID=? AND p.IsActive='Y'";
        boolean IsSOTrx = "Y".equals(Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsSOTrx"));
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, bill_BPartner_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    String s;
                    double CreditLimit;
                    String cont;
                    Integer ii = new Integer(rs.getInt(IsSOTrx ? "M_PriceList_ID" : "PO_PriceList_ID"));
                    if (!rs.wasNull()) {
                        mTab.setValue("M_PriceList_ID", (Object)ii);
                    } else {
                        int i = Env.getContextAsInt((Properties)ctx, (String)"#M_PriceList_ID");
                        if (i != 0) {
                            MPriceList pl = new MPriceList(ctx, i, null);
                            if (IsSOTrx == pl.isSOPriceList()) {
                                mTab.setValue("M_PriceList_ID", (Object)new Integer(i));
                            } else {
                                String sql2 = "SELECT M_PriceList_ID FROM M_PriceList WHERE AD_Client_ID=? AND IsSOPriceList=? AND IsActive='Y' ORDER BY IsDefault DESC";
                                ii = DB.getSQLValue(null, (String)sql2, (Object[])new Object[]{Env.getAD_Client_ID((Properties)ctx), IsSOTrx});
                                if (ii != 0) {
                                    mTab.setValue("M_PriceList_ID", (Object)new Integer(ii));
                                }
                            }
                        }
                    }
                    int bill_Location_ID = rs.getInt("Bill_Location_ID");
                    if (bill_BPartner_ID.toString().equals(Env.getContext((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_BPartner_ID"))) {
                        MBPartnerLocation bpLocation;
                        int locationId = 0;
                        String loc = Env.getContext((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_BPartner_Location_ID");
                        if (loc.length() > 0) {
                            locationId = Integer.parseInt(loc);
                        }
                        if (locationId > 0 && (bpLocation = new MBPartnerLocation(ctx, locationId, null)).isBillTo()) {
                            bill_Location_ID = locationId;
                        }
                    }
                    if (bill_Location_ID == 0) {
                        mTab.setValue("Bill_Location_ID", null);
                    } else {
                        mTab.setValue("Bill_Location_ID", (Object)new Integer(bill_Location_ID));
                    }
                    int contID = rs.getInt("AD_User_ID");
                    if (bill_BPartner_ID.toString().equals(Env.getContext((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_BPartner_ID")) && (cont = Env.getContext((Properties)ctx, (int)WindowNo, (int)1113, (String)"AD_User_ID")).length() > 0) {
                        contID = Integer.parseInt(cont);
                    }
                    if (contID == 0) {
                        mTab.setValue("Bill_User_ID", null);
                    } else {
                        mTab.setValue("Bill_User_ID", (Object)new Integer(contID));
                    }
                    if (IsSOTrx && (CreditLimit = rs.getDouble("SO_CreditLimit")) != 0.0) {
                        double CreditAvailable = rs.getDouble("CreditAvailable");
                        if (!rs.wasNull() && CreditAvailable < 0.0) {
                            mTab.fireDataStatusEEvent("CreditLimitOver", DisplayType.getNumberFormat((int)12).format(CreditAvailable), false);
                        }
                    }
                    if ((s = rs.getString("POReference")) != null && s.length() != 0) {
                        mTab.setValue("POReference", (Object)s);
                    }
                    if ((s = rs.getString("SO_Description")) != null && s.trim().length() != 0) {
                        mTab.setValue("Description", (Object)s);
                    }
                    if ((s = rs.getString("IsDiscountPrinted")) != null && s.length() != 0) {
                        mTab.setValue("IsDiscountPrinted", (Object)s);
                    } else {
                        mTab.setValue("IsDiscountPrinted", (Object)"N");
                    }
                    String OrderType = Env.getContext((Properties)ctx, (int)WindowNo, (String)"OrderType");
                    mTab.setValue("InvoiceRule", (Object)"D");
                    mTab.setValue("PaymentRule", (Object)"P");
                    if (OrderType.equals("PR")) {
                        mTab.setValue("InvoiceRule", (Object)"I");
                    } else if (OrderType.equals("WR")) {
                        mTab.setValue("PaymentRule", (Object)"B");
                    } else {
                        s = rs.getString(IsSOTrx ? "PaymentRule" : "PaymentRulePO");
                        if (s != null && s.length() != 0) {
                            mTab.setValue("PaymentRule", (Object)s);
                        }
                        ii = new Integer(rs.getInt(IsSOTrx ? "C_PaymentTerm_ID" : "PO_PaymentTerm_ID"));
                        if (!rs.wasNull()) {
                            mTab.setValue("C_PaymentTerm_ID", (Object)ii);
                        }
                        if ((s = rs.getString("InvoiceRule")) != null && s.length() != 0) {
                            mTab.setValue("InvoiceRule", (Object)s);
                        }
                    }
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, "bPartnerBill", (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    public String warehouse(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive()) {
            return "";
        }
        Integer M_Warehouse_ID = (Integer)value;
        if (M_Warehouse_ID == null || M_Warehouse_ID == 0) {
            return "";
        }
        MWarehouse wh = MWarehouse.get((Properties)ctx, (int)M_Warehouse_ID);
        String DeliveryRule = mTab.get_ValueAsString("DeliveryRule");
        if (wh.isDisallowNegativeInv() && DeliveryRule.equals("F") || DeliveryRule == null || DeliveryRule.length() == 0) {
            mTab.setValue("DeliveryRule", (Object)"A");
        }
        return "";
    }

    public String priceListFill(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, boolean readonly) {
        Integer M_PriceList_ID = (Integer)mTab.getValue("M_PriceList_ID");
        if (M_PriceList_ID == null || M_PriceList_ID == 0) {
            return "";
        }
        MPriceList pl = MPriceList.get((Properties)ctx, (int)M_PriceList_ID, null);
        if (pl != null && pl.getM_PriceList_ID() == M_PriceList_ID.intValue()) {
            if (!readonly) {
                mTab.setValue("IsTaxIncluded", (Object)pl.isTaxIncluded());
                mTab.setValue("C_Currency_ID", (Object)pl.getC_Currency_ID());
            }
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"EnforcePriceLimit", (boolean)pl.isEnforcePriceLimit());
            Timestamp date = null;
            if (mTab.getAD_Table_ID() == 259) {
                date = Env.getContextAsDate((Properties)ctx, (int)WindowNo, (String)"DateOrdered");
            } else if (mTab.getAD_Table_ID() == 318) {
                date = Env.getContextAsDate((Properties)ctx, (int)WindowNo, (String)"DateInvoiced");
            }
            MPriceListVersion plv = pl.getPriceListVersion(date);
            if (plv != null && plv.getM_PriceList_Version_ID() > 0) {
                Env.setContext((Properties)ctx, (int)WindowNo, (String)"M_PriceList_Version_ID", (int)plv.getM_PriceList_Version_ID());
            } else {
                Env.setContext((Properties)ctx, (int)WindowNo, (String)"M_PriceList_Version_ID", null);
            }
        }
        return "";
    }

    public String priceList(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        return this.priceListFill(ctx, WindowNo, mTab, mField, value, false);
    }

    public String priceListReadOnly(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        return this.priceListFill(ctx, WindowNo, mTab, mField, value, true);
    }

    @Deprecated
    public String paymentTerm(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_PaymentTerm_ID = (Integer)value;
        int C_Order_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_Order_ID");
        if (C_PaymentTerm_ID == null || C_PaymentTerm_ID == 0 || C_Order_ID == 0) {
            return "";
        }
        MPaymentTerm pt = new MPaymentTerm(ctx, C_PaymentTerm_ID.intValue(), null);
        if (pt.get_ID() == 0) {
            return "PaymentTerm not found";
        }
        boolean valid = pt.applyOrder(C_Order_ID);
        mTab.setValue("IsPayScheduleValid", (Object)(valid ? "Y" : "N"));
        return "";
    }

    public String product(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        MProduct product;
        String sql;
        Integer M_Product_ID = (Integer)value;
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        if (this.steps) {
            this.log.warning("init");
        }
        mTab.setValue("C_Charge_ID", null);
        if (Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"M_Product_ID") == M_Product_ID && Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"M_AttributeSetInstance_ID") != 0) {
            mTab.setValue("M_AttributeSetInstance_ID", (Object)Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"M_AttributeSetInstance_ID"));
        } else {
            mTab.setValue("M_AttributeSetInstance_ID", null);
        }
        int C_BPartner_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_BPartner_ID");
        BigDecimal Qty = (BigDecimal)mTab.getValue("QtyOrdered");
        boolean IsSOTrx = Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsSOTrx").equals("Y");
        IProductPricing pp = Core.getProductPricing();
        pp.setInitialValues(M_Product_ID.intValue(), C_BPartner_ID, Qty, IsSOTrx, null);
        Timestamp orderDate = (Timestamp)mTab.getValue("DateOrdered");
        pp.setPriceDate(orderDate);
        I_C_OrderLine orderLine = (I_C_OrderLine)GridTabWrapper.create((GridTab)mTab, I_C_OrderLine.class);
        pp.setOrderLine(orderLine, null);
        int M_PriceList_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_PriceList_ID");
        pp.setM_PriceList_ID(M_PriceList_ID);
        int M_PriceList_Version_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_PriceList_Version_ID");
        if (M_PriceList_Version_ID == 0 && M_PriceList_ID > 0 && (M_PriceList_Version_ID = DB.getSQLValueEx(null, (String)(sql = "SELECT plv.M_PriceList_Version_ID FROM M_PriceList_Version plv WHERE plv.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC"), (Object[])new Object[]{M_PriceList_ID, orderDate})) > 0) {
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"M_PriceList_Version_ID", (int)M_PriceList_Version_ID);
        }
        pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        mTab.setValue("PriceList", (Object)pp.getPriceList());
        mTab.setValue("PriceLimit", (Object)pp.getPriceLimit());
        mTab.setValue("PriceActual", (Object)pp.getPriceStd());
        mTab.setValue("PriceEntered", (Object)pp.getPriceStd());
        mTab.setValue("C_Currency_ID", (Object)new Integer(pp.getC_Currency_ID()));
        mTab.setValue("Discount", (Object)pp.getDiscount());
        mTab.setValue("C_UOM_ID", (Object)new Integer(pp.getC_UOM_ID()));
        mTab.setValue("QtyOrdered", mTab.getValue("QtyEntered"));
        Env.setContext((Properties)ctx, (int)WindowNo, (String)"EnforcePriceLimit", (String)(pp.isEnforcePriceLimit() ? "Y" : "N"));
        Env.setContext((Properties)ctx, (int)WindowNo, (String)"DiscountSchema", (String)(pp.isDiscountSchema() ? "Y" : "N"));
        if (Env.isSOTrx((Properties)ctx, (int)WindowNo) && (product = MProduct.get((Properties)ctx, (int)M_Product_ID)).isStocked() && Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsDropShip").equals("N")) {
            BigDecimal QtyOrdered = (BigDecimal)mTab.getValue("QtyOrdered");
            if (QtyOrdered == null) {
                QtyOrdered = Env.ZERO;
            }
            int M_Warehouse_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_Warehouse_ID");
            int M_AttributeSetInstance_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"M_AttributeSetInstance_ID");
            BigDecimal available = MStorageReservation.getQtyAvailable((int)M_Warehouse_ID, (int)M_Product_ID, (int)M_AttributeSetInstance_ID, null);
            if (available == null) {
                available = Env.ZERO;
            }
            if (available.signum() == 0) {
                mTab.fireDataStatusEEvent("NoQtyAvailable", "0", false);
            } else if (available.compareTo(QtyOrdered) < 0) {
                mTab.fireDataStatusEEvent("InsufficientQtyAvailable", available.toString(), false);
            } else {
                BigDecimal total;
                BigDecimal notReserved;
                Integer C_OrderLine_ID = (Integer)mTab.getValue("C_OrderLine_ID");
                if (C_OrderLine_ID == null) {
                    C_OrderLine_ID = new Integer(0);
                }
                if ((notReserved = MOrderLine.getNotReserved((Properties)ctx, (int)M_Warehouse_ID, (int)M_Product_ID, (int)M_AttributeSetInstance_ID, (int)C_OrderLine_ID)) == null) {
                    notReserved = Env.ZERO;
                }
                if ((total = available.subtract(notReserved)).compareTo(QtyOrdered) < 0) {
                    String info = Msg.parseTranslation((Properties)ctx, (String)("@QtyAvailable@=" + available + " - @QtyNotReserved@=" + notReserved + " = " + total));
                    mTab.fireDataStatusEEvent("InsufficientQtyAvailable", info, false);
                }
            }
        }
        if (this.steps) {
            this.log.warning("fini");
        }
        return this.tax(ctx, WindowNo, mTab, mField, value);
    }

    public String charge(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Charge_ID = (Integer)value;
        if (C_Charge_ID == null || C_Charge_ID == 0) {
            return "";
        }
        if (mTab.getValue("M_Product_ID") != null) {
            mTab.setValue("C_Charge_ID", null);
            return "ChargeExclusively";
        }
        mTab.setValue("M_AttributeSetInstance_ID", null);
        mTab.setValue("S_ResourceAssignment_ID", null);
        mTab.setValue("C_UOM_ID", (Object)new Integer(100));
        Env.setContext((Properties)ctx, (int)WindowNo, (String)"DiscountSchema", (String)"N");
        String sql = "SELECT ChargeAmt FROM C_Charge WHERE C_Charge_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_Charge_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    mTab.setValue("PriceEntered", (Object)rs.getBigDecimal(1));
                    mTab.setValue("PriceActual", (Object)rs.getBigDecimal(1));
                    mTab.setValue("PriceLimit", (Object)Env.ZERO);
                    mTab.setValue("PriceList", (Object)Env.ZERO);
                    mTab.setValue("Discount", (Object)Env.ZERO);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return this.tax(ctx, WindowNo, mTab, mField, value);
    }

    public String tax(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        int billC_BPartner_Location_ID;
        String column = mField.getColumnName();
        if (value == null) {
            return "";
        }
        if (this.steps) {
            this.log.warning("init");
        }
        int M_Product_ID = 0;
        M_Product_ID = column.equals("M_Product_ID") ? (Integer)value : Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"M_Product_ID");
        int C_Charge_ID = 0;
        C_Charge_ID = column.equals("C_Charge_ID") ? (Integer)value : Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"C_Charge_ID");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Product=" + M_Product_ID + ", C_Charge_ID=" + C_Charge_ID);
        }
        if (M_Product_ID == 0 && C_Charge_ID == 0) {
            return this.amt(ctx, WindowNo, mTab, mField, value);
        }
        int shipC_BPartner_Location_ID = 0;
        shipC_BPartner_Location_ID = column.equals("C_BPartner_Location_ID") ? (Integer)value : Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_BPartner_Location_ID");
        if (shipC_BPartner_Location_ID == 0) {
            return this.amt(ctx, WindowNo, mTab, mField, value);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Ship BP_Location=" + shipC_BPartner_Location_ID);
        }
        Timestamp billDate = Env.getContextAsDate((Properties)ctx, (int)WindowNo, (String)"DateOrdered");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Bill Date=" + billDate);
        }
        Timestamp shipDate = Env.getContextAsDate((Properties)ctx, (int)WindowNo, (String)"DatePromised");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Ship Date=" + shipDate);
        }
        int AD_Org_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"AD_Org_ID");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Org=" + AD_Org_ID);
        }
        int M_Warehouse_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_Warehouse_ID");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Warehouse=" + M_Warehouse_ID);
        }
        if ((billC_BPartner_Location_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"Bill_Location_ID")) == 0) {
            billC_BPartner_Location_ID = shipC_BPartner_Location_ID;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Bill BP_Location=" + billC_BPartner_Location_ID);
        }
        int C_Tax_ID = Tax.get((Properties)ctx, (int)M_Product_ID, (int)C_Charge_ID, (Timestamp)billDate, (Timestamp)shipDate, (int)AD_Org_ID, (int)M_Warehouse_ID, (int)billC_BPartner_Location_ID, (int)shipC_BPartner_Location_ID, (boolean)"Y".equals(Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsSOTrx")), null);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Tax ID=" + C_Tax_ID);
        }
        if (C_Tax_ID == 0) {
            mTab.fireDataStatusEEvent(CLogger.retrieveError());
        } else {
            mTab.setValue("C_Tax_ID", (Object)new Integer(C_Tax_ID));
        }
        if (this.steps) {
            this.log.warning("fini");
        }
        return this.amt(ctx, WindowNo, mTab, mField, value);
    }

    public String amt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal LineNetAmt;
        boolean enforce;
        BigDecimal QtyOrdered;
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        if (this.steps) {
            this.log.warning("init");
        }
        int C_UOM_To_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"C_UOM_ID");
        int M_Product_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"M_Product_ID");
        int M_PriceList_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"M_PriceList_ID");
        int StdPrecision = MPriceList.getStandardPrecision((Properties)ctx, (int)M_PriceList_ID);
        MPriceList pl = new MPriceList(ctx, M_PriceList_ID, null);
        boolean isEnforcePriceLimit = pl.isEnforcePriceLimit();
        BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
        if (QtyEntered == null) {
            QtyEntered = Env.ZERO;
        }
        if ((QtyOrdered = (BigDecimal)mTab.getValue("QtyOrdered")) == null) {
            QtyOrdered = Env.ZERO;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("QtyEntered=" + QtyEntered + ", Ordered=" + QtyOrdered + ", UOM=" + C_UOM_To_ID);
        }
        BigDecimal PriceEntered = (BigDecimal)mTab.getValue("PriceEntered");
        BigDecimal PriceActual = (BigDecimal)mTab.getValue("PriceActual");
        BigDecimal Discount = (BigDecimal)mTab.getValue("Discount");
        BigDecimal PriceLimit = (BigDecimal)mTab.getValue("PriceLimit");
        BigDecimal PriceList = (BigDecimal)mTab.getValue("PriceList");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("PriceList=" + PriceList + ", Limit=" + PriceLimit + ", Precision=" + StdPrecision);
            this.log.fine("PriceEntered=" + PriceEntered + ", Actual=" + PriceActual + ", Discount=" + Discount);
        }
        if (M_Product_ID == 0) {
            if (mField.getColumnName().equals("PriceActual")) {
                PriceEntered = (BigDecimal)value;
                mTab.setValue("PriceEntered", value);
            } else if (mField.getColumnName().equals("PriceEntered")) {
                PriceActual = (BigDecimal)value;
                mTab.setValue("PriceActual", value);
            }
        } else if ((mField.getColumnName().equals("QtyOrdered") || mField.getColumnName().equals("QtyEntered") || mField.getColumnName().equals("C_UOM_ID") || mField.getColumnName().equals("M_Product_ID")) && !"N".equals(Env.getContext((Properties)ctx, (int)WindowNo, (String)"DiscountSchema"))) {
            int C_BPartner_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_BPartner_ID");
            if (mField.getColumnName().equals("QtyEntered")) {
                QtyOrdered = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)QtyEntered);
            }
            if (QtyOrdered == null) {
                QtyOrdered = QtyEntered;
            }
            boolean IsSOTrx = Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsSOTrx").equals("Y");
            IProductPricing pp = Core.getProductPricing();
            pp.setInitialValues(M_Product_ID, C_BPartner_ID, QtyOrdered, IsSOTrx, null);
            Timestamp date = (Timestamp)mTab.getValue("DateOrdered");
            pp.setPriceDate(date);
            I_C_OrderLine orderLine = (I_C_OrderLine)GridTabWrapper.create((GridTab)mTab, I_C_OrderLine.class);
            pp.setOrderLine(orderLine, null);
            pp.setM_PriceList_ID(M_PriceList_ID);
            int M_PriceList_Version_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_PriceList_Version_ID");
            pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
            PriceEntered = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)pp.getPriceStd());
            if (PriceEntered == null) {
                PriceEntered = pp.getPriceStd();
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("QtyChanged -> PriceActual=" + pp.getPriceStd() + ", PriceEntered=" + PriceEntered + ", Discount=" + pp.getDiscount());
            }
            PriceActual = pp.getPriceStd();
            PriceEntered = pp.getPriceStd();
            Discount = pp.getDiscount();
            PriceLimit = pp.getPriceLimit();
            PriceList = pp.getPriceList();
            mTab.setValue("PriceList", (Object)pp.getPriceList());
            mTab.setValue("PriceLimit", (Object)pp.getPriceLimit());
            mTab.setValue("PriceActual", (Object)pp.getPriceStd());
            mTab.setValue("PriceEntered", (Object)pp.getPriceStd());
            mTab.setValue("Discount", (Object)pp.getDiscount());
            mTab.setValue("PriceEntered", (Object)PriceEntered);
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"DiscountSchema", (String)(pp.isDiscountSchema() ? "Y" : "N"));
        } else if (mField.getColumnName().equals("PriceActual")) {
            PriceActual = (BigDecimal)value;
            PriceEntered = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)PriceActual);
            if (PriceEntered == null) {
                PriceEntered = PriceActual;
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("PriceActual=" + PriceActual + " -> PriceEntered=" + PriceEntered);
            }
            mTab.setValue("PriceEntered", (Object)PriceEntered);
        } else if (mField.getColumnName().equals("PriceEntered")) {
            PriceEntered = (BigDecimal)value;
            PriceActual = MUOMConversion.convertProductTo((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)PriceEntered);
            if (PriceActual == null) {
                PriceActual = PriceEntered;
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("PriceEntered=" + PriceEntered + " -> PriceActual=" + PriceActual);
            }
            mTab.setValue("PriceActual", (Object)PriceActual);
        }
        if (mField.getColumnName().equals("Discount")) {
            if (PriceList.doubleValue() != 0.0) {
                PriceActual = BigDecimal.valueOf((100.0 - Discount.doubleValue()) / 100.0 * PriceList.doubleValue());
            }
            if (PriceActual.scale() > StdPrecision) {
                PriceActual = PriceActual.setScale(StdPrecision, 4);
            }
            if ((PriceEntered = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)PriceActual)) == null) {
                PriceEntered = PriceActual;
            }
            mTab.setValue("PriceActual", (Object)PriceActual);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
        } else {
            Discount = PriceList.compareTo(Env.ZERO) == 0 ? Env.ZERO : BigDecimal.valueOf((PriceList.doubleValue() - PriceActual.doubleValue()) / PriceList.doubleValue() * 100.0);
            if (Discount.scale() > 2) {
                Discount = Discount.setScale(2, 4);
            }
            mTab.setValue("Discount", (Object)Discount);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("PriceEntered=" + PriceEntered + ", Actual=" + PriceActual + ", Discount=" + Discount);
        }
        String epl = Env.getContext((Properties)ctx, (int)WindowNo, (String)"EnforcePriceLimit");
        boolean bl = enforce = Env.isSOTrx((Properties)ctx, (int)WindowNo) && epl != null && !epl.equals("") ? epl.equals("Y") : isEnforcePriceLimit;
        if (enforce && MRole.getDefault().isOverwritePriceLimit()) {
            enforce = false;
        }
        if (enforce && PriceLimit.doubleValue() != 0.0 && PriceActual.compareTo(PriceLimit) < 0) {
            PriceActual = PriceLimit;
            PriceEntered = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)PriceLimit);
            if (PriceEntered == null) {
                PriceEntered = PriceLimit;
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("(under) PriceEntered=" + PriceEntered + ", Actual" + PriceLimit);
            }
            mTab.setValue("PriceActual", (Object)PriceLimit);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
            mTab.fireDataStatusEEvent("UnderLimitPrice", "", false);
            if (PriceList.compareTo(Env.ZERO) != 0) {
                Discount = BigDecimal.valueOf((PriceList.doubleValue() - PriceActual.doubleValue()) / PriceList.doubleValue() * 100.0);
                if (Discount.scale() > 2) {
                    Discount = Discount.setScale(2, 4);
                }
                mTab.setValue("Discount", (Object)Discount);
            }
        }
        if ((LineNetAmt = QtyOrdered.multiply(PriceActual)).scale() > StdPrecision) {
            LineNetAmt = LineNetAmt.setScale(StdPrecision, 4);
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("LineNetAmt=" + LineNetAmt);
        }
        mTab.setValue("LineNetAmt", (Object)LineNetAmt);
        return "";
    }

    public String qty(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        MProduct product;
        int C_UOM_To_ID;
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int M_Product_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"M_Product_ID");
        if (this.steps) {
            this.log.warning("init - M_Product_ID=" + M_Product_ID + " - ");
        }
        BigDecimal QtyOrdered = Env.ZERO;
        if (M_Product_ID == 0) {
            BigDecimal QtyEntered;
            QtyOrdered = QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            mTab.setValue("QtyOrdered", (Object)QtyOrdered);
        } else if (mField.getColumnName().equals("C_UOM_ID")) {
            BigDecimal QtyEntered1;
            C_UOM_To_ID = (Integer)value;
            BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            if (QtyEntered.compareTo(QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision((Properties)ctx, (int)C_UOM_To_ID), 4)) != 0) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                }
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((QtyOrdered = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)QtyEntered)) == null) {
                QtyOrdered = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(QtyOrdered) != 0;
            BigDecimal PriceActual = (BigDecimal)mTab.getValue("PriceActual");
            BigDecimal PriceEntered = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)PriceActual);
            if (PriceEntered == null) {
                PriceEntered = PriceActual;
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered/PriceActual=" + QtyEntered + "/" + PriceActual + " -> " + conversion + " QtyOrdered/PriceEntered=" + QtyOrdered + "/" + PriceEntered);
            }
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"UOMConversion", (String)(conversion ? "Y" : "N"));
            mTab.setValue("QtyOrdered", (Object)QtyOrdered);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
        } else if (mField.getColumnName().equals("QtyEntered")) {
            boolean conversion;
            BigDecimal QtyEntered = (BigDecimal)value;
            C_UOM_To_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"C_UOM_ID");
            BigDecimal QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision((Properties)ctx, (int)C_UOM_To_ID), 4);
            if (QtyEntered.compareTo(QtyEntered1) != 0) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                }
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((QtyOrdered = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)QtyEntered)) == null) {
                QtyOrdered = QtyEntered;
            }
            boolean bl = conversion = QtyEntered.compareTo(QtyOrdered) != 0;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered=" + QtyEntered + " -> " + conversion + " QtyOrdered=" + QtyOrdered);
            }
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"UOMConversion", (String)(conversion ? "Y" : "N"));
            mTab.setValue("QtyOrdered", (Object)QtyOrdered);
        } else if (mField.getColumnName().equals("QtyOrdered")) {
            boolean conversion;
            BigDecimal QtyEntered;
            C_UOM_To_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"C_UOM_ID");
            QtyOrdered = (BigDecimal)value;
            int precision = MProduct.get((Properties)ctx, (int)M_Product_ID).getUOMPrecision();
            BigDecimal QtyOrdered1 = QtyOrdered.setScale(precision, 4);
            if (QtyOrdered.compareTo(QtyOrdered1) != 0) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Corrected QtyOrdered Scale " + QtyOrdered + "->" + QtyOrdered1);
                }
                QtyOrdered = QtyOrdered1;
                mTab.setValue("QtyOrdered", (Object)QtyOrdered);
            }
            if ((QtyEntered = MUOMConversion.convertProductTo((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)QtyOrdered)) == null) {
                QtyEntered = QtyOrdered;
            }
            boolean bl = conversion = QtyOrdered.compareTo(QtyEntered) != 0;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("UOM=" + C_UOM_To_ID + ", QtyOrdered=" + QtyOrdered + " -> " + conversion + " QtyEntered=" + QtyEntered);
            }
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"UOMConversion", (String)(conversion ? "Y" : "N"));
            mTab.setValue("QtyEntered", (Object)QtyEntered);
        } else {
            QtyOrdered = (BigDecimal)mTab.getValue("QtyOrdered");
        }
        if (M_Product_ID != 0 && Env.isSOTrx((Properties)ctx, (int)WindowNo) && QtyOrdered.signum() > 0 && (product = MProduct.get((Properties)ctx, (int)M_Product_ID)).isStocked() && Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsDropShip").equals("N")) {
            int M_AttributeSetInstance_ID;
            int M_Warehouse_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_Warehouse_ID");
            BigDecimal available = MStorageReservation.getQtyAvailable((int)M_Warehouse_ID, (int)M_Product_ID, (int)(M_AttributeSetInstance_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"M_AttributeSetInstance_ID")), null);
            if (available == null) {
                available = Env.ZERO;
            }
            if (available.signum() == 0) {
                mTab.fireDataStatusEEvent("NoQtyAvailable", "0", false);
            } else if (available.compareTo(QtyOrdered) < 0) {
                mTab.fireDataStatusEEvent("InsufficientQtyAvailable", available.toString(), false);
            } else {
                BigDecimal total;
                BigDecimal notReserved;
                Integer C_OrderLine_ID = (Integer)mTab.getValue("C_OrderLine_ID");
                if (C_OrderLine_ID == null) {
                    C_OrderLine_ID = new Integer(0);
                }
                if ((notReserved = MOrderLine.getNotReserved((Properties)ctx, (int)M_Warehouse_ID, (int)M_Product_ID, (int)M_AttributeSetInstance_ID, (int)C_OrderLine_ID)) == null) {
                    notReserved = Env.ZERO;
                }
                if ((total = available.subtract(notReserved)).compareTo(QtyOrdered) < 0) {
                    StringBuilder msgpts = new StringBuilder("@QtyAvailable@=").append(available).append("  -  @QtyNotReserved@=").append(notReserved).append("  =  ").append(total);
                    String info = Msg.parseTranslation((Properties)ctx, (String)msgpts.toString());
                    mTab.fireDataStatusEEvent("InsufficientQtyAvailable", info, false);
                }
            }
        }
        return "";
    }

    public String SalesOrderTenderType(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        this.log.info("");
        if (value == null) {
            return "";
        }
        int tendertype_id = (Integer)value;
        X_C_POSTenderType tendertype = new X_C_POSTenderType(ctx, tendertype_id, null);
        mTab.setValue("IsPostDated", (Object)tendertype.isPostDated());
        mTab.setValue("TenderType", (Object)tendertype.getTenderType());
        return "";
    }

    public String organization(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer ad_org_id;
        MOrgInfo orginfo;
        if (value == null || (Integer)value == 0) {
            return "";
        }
        this.log.info("Set default Warehouse for Organization " + value + " on Window " + WindowNo);
        Integer m_warehouse_id = (Integer)mTab.getValue("M_Warehouse_ID");
        if ((m_warehouse_id == null || m_warehouse_id == 0) && (orginfo = MOrgInfo.get((Properties)ctx, (int)(ad_org_id = (Integer)value), null)) != null && orginfo.getM_Warehouse_ID() != 0) {
            mTab.setValue("M_Warehouse_ID", (Object)orginfo.getM_Warehouse_ID());
        }
        return "";
    }

    public String navigateOrderLine(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String sql;
        Integer M_Product_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"M_Product_ID");
        if (M_Product_ID == null || M_Product_ID == 0) {
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"DiscountSchema", (String)"N");
            return "";
        }
        int C_BPartner_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_BPartner_ID");
        BigDecimal Qty = (BigDecimal)mTab.getValue("QtyOrdered");
        boolean IsSOTrx = Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsSOTrx").equals("Y");
        IProductPricing pp = Core.getProductPricing();
        pp.setInitialValues(M_Product_ID.intValue(), C_BPartner_ID, Qty, IsSOTrx, null);
        Timestamp orderDate = (Timestamp)mTab.getValue("DateOrdered");
        pp.setPriceDate(orderDate);
        I_C_OrderLine orderLine = (I_C_OrderLine)GridTabWrapper.create((GridTab)mTab, I_C_OrderLine.class);
        pp.setOrderLine(orderLine, null);
        int M_PriceList_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_PriceList_ID");
        pp.setM_PriceList_ID(M_PriceList_ID);
        int M_PriceList_Version_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_PriceList_Version_ID");
        if (M_PriceList_Version_ID == 0 && M_PriceList_ID > 0 && (M_PriceList_Version_ID = DB.getSQLValueEx(null, (String)(sql = "SELECT plv.M_PriceList_Version_ID FROM M_PriceList_Version plv WHERE plv.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC"), (Object[])new Object[]{M_PriceList_ID, orderDate})) > 0) {
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"M_PriceList_Version_ID", (int)M_PriceList_Version_ID);
        }
        pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        Env.setContext((Properties)ctx, (int)WindowNo, (String)"EnforcePriceLimit", (String)(pp.isEnforcePriceLimit() ? "Y" : "N"));
        Env.setContext((Properties)ctx, (int)WindowNo, (String)"DiscountSchema", (String)(pp.isDiscountSchema() ? "Y" : "N"));
        return "";
    }
}

