/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.spifly.dynamic;

import java.util.Set;
import org.apache.aries.spifly.Util;
import org.apache.aries.spifly.WeavingData;
import org.apache.aries.spifly.dynamic.DynamicWeavingActivator;
import org.apache.aries.spifly.dynamic.OSGiFriendlyClassWriter;
import org.apache.aries.spifly.weaver.TCCLSetterVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;

public class ClientWeavingHook
implements WeavingHook {
    private final String addedImport;
    private final DynamicWeavingActivator activator;

    ClientWeavingHook(BundleContext context, DynamicWeavingActivator dwActivator) {
        this.activator = dwActivator;
        this.addedImport = Util.class.getPackage().getName();
    }

    public void weave(WovenClass wovenClass) {
        Bundle consumerBundle = wovenClass.getBundleWiring().getBundle();
        Set<WeavingData> wd = this.activator.getWeavingData(consumerBundle);
        if (wd != null) {
            this.activator.log(4, "Weaving class " + wovenClass.getClassName());
            ClassReader cr = new ClassReader(wovenClass.getBytes());
            OSGiFriendlyClassWriter cw = new OSGiFriendlyClassWriter(3, wovenClass.getBundleWiring().getClassLoader());
            TCCLSetterVisitor tsv = new TCCLSetterVisitor((ClassVisitor)cw, wovenClass.getClassName(), wd);
            cr.accept((ClassVisitor)tsv, 4);
            if (tsv.isWoven()) {
                wovenClass.setBytes(cw.toByteArray());
                if (tsv.additionalImportRequired()) {
                    wovenClass.getDynamicImports().add(this.addedImport);
                }
            }
        }
    }
}

