/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.matrixwindow.form;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import jpiere.plugin.matrixwindow.form.AbstractMatrixWindowForm;
import jpiere.plugin.matrixwindow.form.JPListModelMapTable;
import jpiere.plugin.matrixwindow.form.JPMatrixGridRowRenderer;
import jpiere.plugin.matrixwindow.form.JPiereMatrixWindowProcessModelDialog;
import jpiere.plugin.matrixwindow.form.JPiereMatrixWindowQuickEntry;
import jpiere.plugin.matrixwindow.model.MMatrixField;
import jpiere.plugin.matrixwindow.model.MMatrixSearch;
import jpiere.plugin.matrixwindow.model.MMatrixWindow;
import org.adempiere.base.IModelFactory;
import org.adempiere.base.Service;
import org.adempiere.exceptions.DBException;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.adwindow.ProcessButtonPopup;
import org.adempiere.webui.adwindow.ToolbarProcessButton;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.IZoomableEditor;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.editor.WStringEditor;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.editor.WYesNoEditor;
import org.adempiere.webui.editor.WebEditorFactory;
import org.adempiere.webui.event.ActionEvent;
import org.adempiere.webui.event.ActionListener;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.event.WTableModelEvent;
import org.adempiere.webui.event.WTableModelListener;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.CustomForm;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridTabVO;
import org.compiere.model.GridWindow;
import org.compiere.model.GridWindowVO;
import org.compiere.model.I_AD_Column;
import org.compiere.model.I_AD_Field;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MField;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MRefTable;
import org.compiere.model.MRole;
import org.compiere.model.MTab;
import org.compiere.model.MTable;
import org.compiere.model.MToolBarButton;
import org.compiere.model.MToolBarButtonRestrict;
import org.compiere.model.PO;
import org.compiere.model.X_AD_ToolBarButton;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.compiere.util.Util;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Auxhead;
import org.zkoss.zul.Auxheader;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Center;
import org.zkoss.zul.Columns;
import org.zkoss.zul.Frozen;
import org.zkoss.zul.Groupbox;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.North;
import org.zkoss.zul.RowRenderer;
import org.zkoss.zul.impl.XulElement;

public class JPiereMatrixWindow
extends AbstractMatrixWindowForm
implements EventListener<Event>,
ValueChangeListener,
WTableModelListener,
ActionListener {
    private static CLogger log = CLogger.getCLogger(JPiereMatrixWindow.class);
    private CustomForm form = new CustomForm();
    private Borderlayout mainLayout = new Borderlayout();
    private Panel parameterPanel = new Panel();
    private Grid parameterLayout = GridFactory.newGridLayout();
    private Panel displayDataPanel = new Panel();
    private Borderlayout displayDataLayout = new Borderlayout();
    private Grid matrixGrid = new Grid();
    private Button SearchButton;
    private Button SaveButton;
    private Button CreateButton;
    private Button ProcessButton;
    private boolean m_calculating = false;
    private PO[] m_POs;
    private StringBuilder message = new StringBuilder();
    private LinkedHashMap<Object, TreeMap<Integer, Object>> viewModel = new LinkedHashMap();
    private LinkedHashMap<Object, TreeMap<Integer, Object>> conversionTable = new LinkedHashMap();
    private HashMap<Integer, PO> tableModel = new HashMap();
    private HashMap<Integer, PO> dirtyModel = new HashMap();
    private ArrayList<PO> notSavePO = null;
    private LinkedHashMap<Object, LinkedHashMap<Object, PO>> keyColumnModel = new LinkedHashMap();
    private ArrayList<Object> columnKeys = new ArrayList();
    private HashMap<Object, String> columnKeyNameMap = new HashMap();
    private LinkedHashMap<Object, GridTab> virtualTabMap = new LinkedHashMap();
    private ArrayList<Object> rowKeys = new ArrayList();
    private HashMap<Integer, String> columnNameMap = new HashMap();
    private HashMap<Integer, Integer> columnLengthMap = new HashMap();
    private HashMap<Integer, GridField> columnGridFieldMap = new HashMap();
    private HashMap<Integer, Boolean> columnSummarizedMap = new HashMap();
    private TreeMap<Integer, String> fixItem = new TreeMap();
    private TreeMap<Integer, Integer> fixItemFieldIDMap = new TreeMap();
    private String whereClause;
    private JPMatrixGridRowRenderer renderer;
    private MMatrixWindow m_matrixWindow;
    private MTab m_Tab;
    private MMatrixField[] m_matrixFields;
    private MField[] m_contentFields;
    private MColumn[] m_contentColumns;
    private MMatrixSearch[] m_matrixSearches;
    private ArrayList<ToolbarProcessButton> toolbarProcessButtons = new ArrayList();
    private JPiereMatrixWindowQuickEntry quickEntry = null;
    public static final String EDITMODE_EDIT = "edit";
    public static final String EDITMODE_TEST = "test";
    public static final String EDITMODE_READ = "read";
    private String editMode = "edit";
    private HashMap<String, WEditor> searchEditorMap = new HashMap();
    private I_AD_Column m_columnKeyColumn;
    private I_AD_Column m_rowKeyColumn;
    private int AD_WINDOW_ID = 0;
    private String TABLE_NAME;
    private int FIX_ITEM_FIELD_ID = 0;
    private GridTab gridTab;
    private GridField[] gridFields;
    Auxhead auxhead;
    String sum = Msg.getMsg((Properties)Env.getCtx(), (String)"Sum");

    public ADForm getForm() {
        return this.form;
    }

    @Override
    public void createMatrixWindow(String Value) {
        try {
            this.prepare(Value);
            this.zkInit();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
    }

    private void prepare(String Value) throws Exception {
        this.m_matrixWindow = MMatrixWindow.get(Env.getCtx(), Value);
        if (this.m_matrixWindow == null) {
            // empty if block
        }
        this.m_matrixFields = this.m_matrixWindow.getMatrixFields();
        this.m_contentFields = this.m_matrixWindow.getContentFields();
        this.m_matrixSearches = this.m_matrixWindow.getMatrixSearches();
        this.m_contentColumns = new MColumn[this.m_contentFields.length];
        int i = 0;
        while (i < this.m_contentFields.length) {
            this.m_contentColumns[i] = new MColumn(Env.getCtx(), this.m_contentFields[i].getAD_Column_ID(), null);
            ++i;
        }
        this.AD_WINDOW_ID = this.m_matrixWindow.getAD_Window_ID();
        this.m_Tab = new MTab(Env.getCtx(), this.m_matrixWindow.getAD_Tab_ID(), null);
        this.TABLE_NAME = MTable.get((Properties)Env.getCtx(), (int)this.m_Tab.getAD_Table_ID()).getTableName();
        this.m_columnKeyColumn = this.m_matrixWindow.getJP_MatrixColumnKey().getAD_Column();
        this.m_rowKeyColumn = this.m_matrixWindow.getJP_MatrixRowKey().getAD_Column();
        this.FIX_ITEM_FIELD_ID = this.m_matrixWindow.getJP_MatrixRowKey().getAD_Field_ID();
        this.fixItem.put(0, this.m_rowKeyColumn.getColumnName());
        this.fixItemFieldIDMap.put(0, this.FIX_ITEM_FIELD_ID);
        GridWindowVO gridWindowVO = AEnv.getMWindowVO((int)this.form.getWindowNo(), (int)this.m_matrixWindow.getAD_Window_ID(), (int)0);
        GridWindow gridWindow = new GridWindow(gridWindowVO);
        int i2 = 0;
        while (i2 < gridWindow.getTabCount()) {
            GridTab gtab = gridWindow.getTab(i2);
            if (gtab.getAD_Tab_ID() == this.m_matrixWindow.getAD_Tab_ID()) {
                this.gridTab = gtab;
                break;
            }
            ++i2;
        }
        this.gridTab.initTab(false);
        this.gridFields = this.gridTab.getFields();
        String discription = this.m_matrixWindow.getDescription();
        this.editMode = this.gridTab.isReadOnly() ? EDITMODE_READ : (discription != null && !discription.isEmpty() && discription.contains(EDITMODE_TEST) ? EDITMODE_TEST : EDITMODE_EDIT);
    }

    private void zkInit() throws Exception {
        this.form.appendChild((Component)this.mainLayout);
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.form, (String)"100%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.mainLayout, (String)"100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.mainLayout, (String)"100%");
        North north = new North();
        this.mainLayout.appendChild((Component)north);
        north.appendChild((Component)this.parameterPanel);
        north.setStyle("border: none");
        this.parameterPanel.appendChild((Component)this.parameterLayout);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.parameterLayout, (String)"100%");
        Rows parameterLayoutRows = this.parameterLayout.newRows();
        Row row = null;
        if (this.m_matrixSearches.length > 0) {
            int maxColspan = 0;
            int tmpColspan = 0;
            int i = 0;
            while (i < this.m_matrixSearches.length) {
                tmpColspan = this.m_matrixSearches[i].getXPosition() + this.m_matrixSearches[i].getColumnSpan();
                if (maxColspan < tmpColspan) {
                    maxColspan = tmpColspan;
                }
                ++i;
            }
            row = parameterLayoutRows.newRow();
            Groupbox searchGB = new Groupbox();
            row.appendCellChild((Component)searchGB, maxColspan >= 10 ? maxColspan + 2 : 10);
            searchGB.appendChild((Component)new Caption(Msg.getMsg((Properties)Env.getCtx(), (String)"SearchCriteria")));
            Grid searchGrid = new Grid();
            searchGrid.setStyle("background-color: #E9F0FF");
            searchGrid.setStyle("border: none");
            searchGB.appendChild((Component)searchGrid);
            Rows rows = searchGrid.newRows();
            int actualxpos = 0;
            int i2 = 0;
            while (i2 < this.m_matrixSearches.length) {
                MMatrixSearch searchField = this.m_matrixSearches[i2];
                if (i2 == 0 || actualxpos > searchField.getXPosition()) {
                    actualxpos = 0;
                    row = rows.newRow();
                    row.setStyle("background-color: #ffffff");
                }
                WEditor editor = null;
                int j = 0;
                while (j < this.gridFields.length) {
                    if (this.m_matrixSearches[i2].getAD_Field_ID() == this.gridFields[j].getAD_Field_ID()) {
                        editor = WebEditorFactory.getEditor((GridField)this.gridFields[j], (boolean)false);
                        break;
                    }
                    ++j;
                }
                if (editor == null) {
                    GridField[] gFields = GridField.createFields((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)0, (int)searchField.getAD_Tab_ID());
                    int k = 0;
                    while (k < gFields.length) {
                        if (this.m_matrixSearches[i2].getAD_Field_ID() == gFields[k].getAD_Field_ID()) {
                            editor = WebEditorFactory.getEditor((GridField)gFields[k], (boolean)false);
                            break;
                        }
                        ++k;
                    }
                }
                if (editor != null) {
                    String DefaultValue = this.m_matrixSearches[i2].getDefaultValue();
                    if (DefaultValue != null && !DefaultValue.isEmpty()) {
                        String value = Env.parseContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)DefaultValue, (boolean)false);
                        Env.setContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)editor.getColumnName(), (String)value);
                        editor.setValue((Object)Env.parseContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)DefaultValue, (boolean)false));
                        if (editor instanceof WTableDirEditor) {
                            ((WTableDirEditor)editor).actionRefresh();
                            ((WTableDirEditor)editor).getLookup().setSelectedItem((Object)"");
                        }
                    }
                    if (!editor.isReadWrite()) {
                        editor.setReadWrite(true);
                        if (editor instanceof WTableDirEditor) {
                            ((WTableDirEditor)editor).actionRefresh();
                        }
                    }
                    if (editor instanceof WSearchEditor || editor instanceof WTableDirEditor) {
                        editor.getLabel().addEventListener("onClick", (EventListener)new ZoomListener((IZoomableEditor)editor));
                        if (this.m_matrixSearches[i2].isMandatory() && editor.getValue() == null) {
                            editor.getLabel().setStyle("cursor: pointer; text-decoration: underline;color: #333; color:red;");
                        } else {
                            editor.getLabel().setStyle("cursor: pointer; text-decoration: underline;color: #333;");
                        }
                    } else if (editor instanceof WStringEditor) {
                        String stringValue = (String)editor.getValue();
                        if (this.m_matrixSearches[i2].isMandatory() && Util.isEmpty((String)stringValue)) {
                            editor.getLabel().setStyle("color:red;");
                        }
                    }
                    editor.setMandatory(this.m_matrixSearches[i2].isMandatory());
                    row.appendCellChild(editor.getLabel().rightAlign(), 1);
                    ++actualxpos;
                    row.appendCellChild(editor.getComponent(), searchField.getColumnSpan());
                    ZKUpdateUtil.setHflex((HtmlBasedComponent)((HtmlBasedComponent)editor.getComponent()), (String)"true");
                    actualxpos += searchField.getColumnSpan();
                    WEditorPopupMenu popupMenu = editor.getPopupMenu();
                    List listcomp = popupMenu.getChildren();
                    Menuitem menuItem = null;
                    String image = null;
                    for (Component comp : listcomp) {
                        if (!(comp instanceof Menuitem)) continue;
                        menuItem = (Menuitem)comp;
                        image = menuItem.getImage();
                        if (image != null && (image.endsWith("Zoom16.png") || image.endsWith("Refresh16.png") || image.endsWith("New16.png") || image.endsWith("InfoBPartner16.png"))) {
                            menuItem.setVisible(true);
                            continue;
                        }
                        menuItem.setVisible(false);
                    }
                    if (popupMenu != null) {
                        popupMenu.addMenuListener((ContextMenuListener)editor);
                        row.appendChild((Component)popupMenu);
                        popupMenu.addContextElement((XulElement)editor.getComponent());
                    }
                    editor.addValueChangeListener((ValueChangeListener)this);
                    this.searchEditorMap.put(editor.getColumnName(), editor);
                }
                ++i2;
            }
            for (Map.Entry<String, WEditor> entry : this.searchEditorMap.entrySet()) {
                WEditor otherEditor = entry.getValue();
                GridField gridField = otherEditor.getGridField();
                if (!(otherEditor instanceof WTableDirEditor) && !(otherEditor instanceof WSearchEditor)) continue;
                if (gridField.getVFormat() != null && gridField.getVFormat().indexOf(64) != -1) {
                    String validated;
                    ((MLookup)gridField.getLookup()).getLookupInfo().ValidationCode = validated = Env.parseContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)gridField.getVFormat(), (boolean)false);
                } else if (gridField.getLookup().getValidation().indexOf(64) != -1) {
                    String validated;
                    gridField.setVFormat(gridField.getLookup().getValidation());
                    ((MLookup)gridField.getLookup()).getLookupInfo().ValidationCode = validated = Env.parseContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)gridField.getVFormat(), (boolean)false);
                }
                if (!(otherEditor instanceof WTableDirEditor)) continue;
                ((WTableDirEditor)otherEditor).getLookup().refresh();
            }
        }
        row = parameterLayoutRows.newRow();
        this.SearchButton = new Button(Msg.getMsg((Properties)Env.getCtx(), (String)"search"));
        this.SearchButton.setId("SearchButton");
        this.SearchButton.addActionListener((EventListener)this);
        this.SearchButton.setEnabled(true);
        if ("Y".equals(Env.getContext((Properties)Env.getCtx(), (String)"#THEME_USE_FONT_ICON_FOR_IMAGE"))) {
            this.SearchButton.setIconSclass("z-icon-Find");
        } else {
            this.SearchButton.setImage(ThemeManager.getThemeResource((String)"images/Find16.png"));
        }
        row.appendCellChild((Component)this.SearchButton);
        this.SaveButton = new Button(Msg.getMsg((Properties)Env.getCtx(), (String)"save"));
        this.SaveButton.setId("SaveButton");
        this.SaveButton.addActionListener((EventListener)this);
        this.SaveButton.setEnabled(false);
        if ("Y".equals(Env.getContext((Properties)Env.getCtx(), (String)"#THEME_USE_FONT_ICON_FOR_IMAGE"))) {
            this.SaveButton.setIconSclass("z-icon-Save");
        } else {
            this.SaveButton.setImage(ThemeManager.getThemeResource((String)"images/Save16.png"));
        }
        if (!this.editMode.equals(EDITMODE_READ)) {
            row.appendCellChild((Component)this.SaveButton);
        }
        this.CreateButton = new Button(Msg.getMsg((Properties)Env.getCtx(), (String)"NewRecord"));
        this.CreateButton.setId("CreateButton");
        this.CreateButton.addActionListener((EventListener)this);
        this.CreateButton.setEnabled(false);
        if ("Y".equals(Env.getContext((Properties)Env.getCtx(), (String)"#THEME_USE_FONT_ICON_FOR_IMAGE"))) {
            this.CreateButton.setIconSclass("z-icon-New");
        } else {
            this.CreateButton.setImage(ThemeManager.getThemeResource((String)"images/New16.png"));
        }
        if (this.m_matrixWindow.getJP_QuickEntryWindow_ID() > 0 && !this.editMode.equals(EDITMODE_READ)) {
            row.appendCellChild((Component)this.CreateButton);
        }
        this.loadToolbarButtons();
        this.ProcessButton = new Button(Msg.getMsg((Properties)Env.getCtx(), (String)"Process"));
        this.ProcessButton.setId("ProcessButton");
        this.ProcessButton.addActionListener((EventListener)this);
        this.ProcessButton.setEnabled(false);
        if ("Y".equals(Env.getContext((Properties)Env.getCtx(), (String)"#THEME_USE_FONT_ICON_FOR_IMAGE"))) {
            this.ProcessButton.setIconSclass("z-icon-Process");
        } else {
            this.ProcessButton.setImage(ThemeManager.getThemeResource((String)"images/Process16.png"));
        }
        if (this.toolbarProcessButtons.size() > 0 && !this.editMode.equals(EDITMODE_READ)) {
            row.appendCellChild((Component)this.ProcessButton);
        }
        Center center = new Center();
        center.setStyle("padding-top: 16px");
        this.mainLayout.appendChild((Component)center);
        center.appendChild((Component)this.displayDataPanel);
        this.displayDataPanel.appendChild((Component)this.displayDataLayout);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.displayDataPanel, (String)"100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.displayDataPanel, (String)"100%");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.displayDataPanel, (String)"1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.displayDataPanel, (String)"1");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.displayDataLayout, (String)"100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.displayDataLayout, (String)"100%");
        this.displayDataLayout.setStyle("border: none");
        center = new Center();
        this.displayDataLayout.appendChild((Component)center);
        center.appendChild((Component)this.matrixGrid);
        center.setStyle("border: none");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.matrixGrid, (String)"100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.matrixGrid, (String)"100%");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.matrixGrid, (String)"true");
        this.matrixGrid.setVisible(false);
        this.matrixGrid.setMold("paging");
        this.matrixGrid.setPageSize(this.m_matrixWindow.getJP_PageSize());
    }

    public void tableChanged(WTableModelEvent e) {
        int row = e.getFirstRow();
        int col = e.getColumn();
        ListModel listModel = e.getModel();
        this.updateModel(listModel, row, col);
        this.m_calculating = false;
    }

    private void updateModel(ListModel<?> listmodel, int row, int col) {
        if (this.m_calculating) {
            return;
        }
        if (col < this.fixItemFieldIDMap.size()) {
            this.m_calculating = false;
            return;
        }
        Map.Entry mapEntry = (Map.Entry)listmodel.getElementAt(row);
        Object mapKey = mapEntry.getKey();
        TreeMap mapValue = (TreeMap)mapEntry.getValue();
        Object value = mapValue.get(col);
        Object poID = this.conversionTable.get(mapKey).get(col);
        PO po = this.tableModel.get(poID);
        String columnName = this.columnGridFieldMap.get(col).getColumnName();
        po.set_ValueNoCheck(columnName, value);
        this.dirtyModel.put(po.get_ID(), po);
        if (this.renderer != null && this.renderer.isEditing()) {
            this.renderer.stopEditing();
        }
        this.m_calculating = true;
    }

    public void valueChange(ValueChangeEvent e) {
        WEditor editor = this.searchEditorMap.get(e.getPropertyName());
        editor.setValue(e.getNewValue());
        if (editor instanceof WYesNoEditor) {
            Env.setContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)editor.getColumnName(), (String)(e.getNewValue().equals("true") ? "Y" : "N"));
        } else {
            Env.setContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)editor.getColumnName(), e.getNewValue() == null ? null : e.getNewValue().toString());
        }
        this.SearchButton.setEnabled(true);
        this.SaveButton.setEnabled(false);
        this.CreateButton.setEnabled(false);
        this.ProcessButton.setEnabled(false);
        this.quickEntry = null;
        this.matrixGrid.setVisible(false);
        if (e.getNewValue() == null) {
            if (editor.isMandatory() && (editor instanceof WSearchEditor || editor instanceof WTableDirEditor)) {
                editor.getLabel().setStyle("cursor: pointer; text-decoration: underline;color: #333; color:red;");
            }
        } else if (editor.isMandatory() && (editor instanceof WSearchEditor || editor instanceof WTableDirEditor)) {
            editor.getLabel().setStyle("cursor: pointer; text-decoration: underline;color: #333; ");
        } else if (editor.isMandatory() && editor instanceof WStringEditor) {
            String stringValue = (String)e.getNewValue();
            if (Util.isEmpty((String)stringValue)) {
                editor.getLabel().setStyle("color:red;");
            } else {
                editor.getLabel().setStyle("color:#333;");
            }
        }
        for (Map.Entry<String, WEditor> entry : this.searchEditorMap.entrySet()) {
            String validated;
            WEditor otherEditor = entry.getValue();
            GridField gridField = otherEditor.getGridField();
            if (otherEditor.getColumnName().equals(editor.getColumnName()) || !(otherEditor instanceof WTableDirEditor) && !(otherEditor instanceof WSearchEditor)) continue;
            if (gridField.getVFormat() != null && gridField.getVFormat().indexOf(64) != -1) {
                ((MLookup)gridField.getLookup()).getLookupInfo().ValidationCode = validated = Env.parseContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)gridField.getVFormat(), (boolean)false);
            } else if (gridField.getLookup().getValidation().indexOf(64) != -1) {
                gridField.setVFormat(gridField.getLookup().getValidation());
                ((MLookup)gridField.getLookup()).getLookupInfo().ValidationCode = validated = Env.parseContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)gridField.getVFormat(), (boolean)false);
            }
            if (!(otherEditor instanceof WTableDirEditor)) continue;
            ((WTableDirEditor)otherEditor).getLookup().refresh();
        }
    }

    public void onEvent(Event e) throws Exception {
        if (this.message != null && !Util.isEmpty((String)this.message.toString())) {
            FDialog.info((int)this.form.getWindowNo(), null, (String)this.message.toString());
            this.message = new StringBuilder();
            return;
        }
        if (e == null) {
            return;
        }
        if (e.getTarget() == this.matrixGrid && "onClick".equals(e.getName())) {
            Object data = e.getData();
            org.zkoss.zul.Row row = null;
            if (data != null && data instanceof Component) {
                AbstractComponent cmp = (AbstractComponent)data;
                if (cmp instanceof Cell && !(cmp.getChildren().get(0) instanceof Label) && this.renderer.setFocus((Component)cmp.getChildren().get(0))) {
                    return;
                }
                if (cmp.getParent() instanceof org.zkoss.zul.Row) {
                    row = (org.zkoss.zul.Row)cmp.getParent();
                }
            }
            if (row != null) {
                this.renderer.setCurrentRow(this.renderer.getCurrentRow());
                this.renderer.editCurrentRow();
            }
            e.stopPropagation();
        } else if (e.getName().equals("Cancel")) {
            if (!this.createView()) {
                this.SearchButton.setEnabled(true);
                this.SaveButton.setEnabled(false);
                this.CreateButton.setEnabled(false);
                this.ProcessButton.setEnabled(false);
                this.matrixGrid.setVisible(false);
                FDialog.info((int)this.form.getWindowNo(), null, (String)this.message.toString());
                return;
            }
            this.SearchButton.setEnabled(false);
            this.SaveButton.setEnabled(true);
            this.CreateButton.setEnabled(true);
            this.ProcessButton.setEnabled(true);
            this.quickEntry = null;
        } else if (e.getName().equals("Ok")) {
            Events.sendEvent((String)"onClick", (Component)this.CreateButton, null);
        } else if (e.getTarget().equals(this.SearchButton) || e.getName().equals("onComplete")) {
            if (!this.createView()) {
                this.SearchButton.setEnabled(true);
                this.SaveButton.setEnabled(false);
                this.CreateButton.setEnabled(true);
                this.ProcessButton.setEnabled(true);
                this.matrixGrid.setVisible(false);
                return;
            }
            this.SearchButton.setEnabled(false);
            this.SaveButton.setEnabled(true);
            this.CreateButton.setEnabled(true);
            this.ProcessButton.setEnabled(true);
            if (e.getName().equals("onComplete")) {
                JPiereMatrixWindowProcessModelDialog dialog = (JPiereMatrixWindowProcessModelDialog)e.getTarget();
                ProcessInfo pInfo = dialog.getProcessInfo();
                FDialog.info((int)this.form.getWindowNo(), null, (String)pInfo.getSummary(), (String)pInfo.getLogInfo(), (String)pInfo.getTitle());
            }
        } else if (e.getTarget().equals(this.SaveButton)) {
            boolean isOK = this.saveData();
            if (isOK) {
                this.dirtyModel.clear();
                if (!this.createView()) {
                    this.matrixGrid.setVisible(false);
                    FDialog.info((int)this.form.getWindowNo(), null, (String)this.message.toString());
                    return;
                }
            }
        } else if (e.getTarget().equals(this.CreateButton)) {
            List<WEditor> editors;
            Object old_rowKeyColumn_Value = null;
            Object old_columnKeyColumn_Value = null;
            if (this.quickEntry == null) {
                this.saveData();
            } else {
                editors = this.quickEntry.getQuickEditors();
                for (WEditor editor : editors) {
                    if (editor.getColumnName().equals(this.m_rowKeyColumn.getColumnName())) {
                        old_rowKeyColumn_Value = editor.getValue();
                        continue;
                    }
                    if (!editor.getColumnName().equals(this.m_columnKeyColumn.getColumnName())) continue;
                    old_columnKeyColumn_Value = editor.getValue();
                }
            }
            this.quickEntry = new JPiereMatrixWindowQuickEntry(this.form.getWindowNo(), this.m_matrixWindow.getJP_QuickEntryWindow_ID(), this);
            this.quickEntry.loadRecord(0);
            editors = this.quickEntry.getQuickEditors();
            String JP_QuickEntryConf = this.m_matrixWindow.getJP_QuickEntryConf();
            for (WEditor editor : editors) {
                for (Map.Entry<String, WEditor> entry : this.searchEditorMap.entrySet()) {
                    if (!editor.getColumnName().equals(entry.getKey())) continue;
                    editor.setValue(entry.getValue().getValue());
                    if (entry.getValue().getValue() == null) {
                        editor.setReadWrite(true);
                        continue;
                    }
                    if (editor instanceof WStringEditor) {
                        editor.setReadWrite(true);
                        continue;
                    }
                    editor.setReadWrite(false);
                }
                if (JP_QuickEntryConf == null) continue;
                if (JP_QuickEntryConf.equals("01")) {
                    if (!editor.getColumnName().equals(this.m_columnKeyColumn.getColumnName())) continue;
                    editor.setValue(old_columnKeyColumn_Value);
                    continue;
                }
                if (JP_QuickEntryConf.equals("02")) {
                    if (!editor.getColumnName().equals(this.m_rowKeyColumn.getColumnName())) continue;
                    editor.setValue(old_rowKeyColumn_Value);
                    continue;
                }
                if (!JP_QuickEntryConf.equals("03")) continue;
                if (editor.getColumnName().equals(this.m_rowKeyColumn.getColumnName())) {
                    editor.setValue(old_rowKeyColumn_Value);
                    continue;
                }
                if (!editor.getColumnName().equals(this.m_columnKeyColumn.getColumnName())) continue;
                editor.setValue(old_columnKeyColumn_Value);
            }
            AEnv.showWindow((Window)this.quickEntry);
        } else if (e.getTarget().equals(this.ProcessButton)) {
            ProcessButtonPopup popup = new ProcessButtonPopup();
            popup.setWidgetAttribute("instanceName", "processButtonPopup");
            ArrayList<org.zkoss.zul.Button> buttonList = new ArrayList<org.zkoss.zul.Button>();
            for (ToolbarProcessButton processButton : this.toolbarProcessButtons) {
                if (!processButton.getButton().isVisible()) continue;
                buttonList.add(processButton.getButton());
            }
            popup.render(buttonList);
            LayoutUtils.openPopupWindow((Component)this.ProcessButton, (org.zkoss.zul.Window)popup, (String)"after_start");
        }
    }

    private void loadToolbarButtons() {
        int[] ids;
        MToolBarButton[] mToolbarButtons;
        MToolBarButton[] mToolBarButtonArray = mToolbarButtons = MToolBarButton.getProcessButtonOfTab((int)this.gridTab.getAD_Tab_ID(), null);
        int n = mToolbarButtons.length;
        int n2 = 0;
        while (n2 < n) {
            MToolBarButton mToolbarButton = mToolBarButtonArray[n2];
            Boolean access = MRole.getDefault().getProcessAccess(mToolbarButton.getAD_Process_ID());
            if (access != null && access.booleanValue()) {
                ToolbarProcessButton toolbarProcessButton = new ToolbarProcessButton(mToolbarButton, null, (ActionListener)this, this.form.getWindowNo());
                this.toolbarProcessButtons.add(toolbarProcessButton);
            }
            ++n2;
        }
        if (this.toolbarProcessButtons.size() > 0 && (ids = MToolBarButtonRestrict.getProcessButtonOfTab((Properties)Env.getCtx(), (int)Env.getAD_Role_ID((Properties)Env.getCtx()), (int)this.gridTab.getAD_Tab_ID(), null)) != null && ids.length > 0) {
            int[] nArray = ids;
            int n3 = ids.length;
            n = 0;
            while (n < n3) {
                int id = nArray[n];
                X_AD_ToolBarButton tbt = new X_AD_ToolBarButton(Env.getCtx(), id, null);
                for (ToolbarProcessButton btn : this.toolbarProcessButtons) {
                    if (!tbt.getComponentName().equals(btn.getColumnName())) continue;
                    this.toolbarProcessButtons.remove(btn);
                    break;
                }
                ++n;
            }
        }
    }

    private boolean createView() throws Exception {
        this.matrixGrid.setVisible(true);
        this.whereClause = this.createWhere();
        if (!Util.isEmpty((String)this.message.toString())) {
            FDialog.info((int)this.form.getWindowNo(), null, (String)this.message.toString());
            this.message = new StringBuilder();
            return false;
        }
        this.columnKeys = this.createColumnKeys(this.whereClause);
        if (this.columnKeys.size() == 0) {
            this.message.append(String.valueOf(System.getProperty("line.separator")) + Msg.getMsg((Properties)Env.getCtx(), (String)"not.found"));
            FDialog.info((int)this.form.getWindowNo(), null, (String)this.message.toString());
            this.message = new StringBuilder();
            return false;
        }
        this.virtualTabMap = this.createVirtualTabMap(this.columnKeys);
        if (this.virtualTabMap == null || this.virtualTabMap.size() == 0) {
            this.message.append(String.valueOf(System.getProperty("line.separator")) + Msg.getMsg((Properties)Env.getCtx(), (String)"not.found"));
            FDialog.info((int)this.form.getWindowNo(), null, (String)this.message.toString());
            this.message = new StringBuilder();
            return false;
        }
        this.rowKeys = this.createRowKeys(this.whereClause);
        if (this.rowKeys.size() == 0) {
            this.message.append(String.valueOf(System.getProperty("line.separator")) + Msg.getMsg((Properties)Env.getCtx(), (String)"not.found"));
            FDialog.info((int)this.form.getWindowNo(), null, (String)this.message.toString());
            this.message = new StringBuilder();
            return false;
        }
        this.m_POs = this.getPOs(this.whereClause, true);
        if (this.m_POs.length == 0) {
            this.message.append(String.valueOf(System.getProperty("line.separator")) + Msg.getMsg((Properties)Env.getCtx(), (String)"not.found"));
            FDialog.info((int)this.form.getWindowNo(), null, (String)this.message.toString());
            this.message = new StringBuilder();
            return false;
        }
        this.tableModel = this.createTableModel(this.m_POs);
        this.keyColumnModel = this.createKeyColumnModel(this.m_POs);
        this.viewModel = this.createViewModelConvetionTable();
        this.conversionTable = this.createViewModelConvetionTable();
        this.setViewModelConvetionTable();
        JPListModelMapTable vmListModelMap = new JPListModelMapTable(this.viewModel);
        JPListModelMapTable ctListModelMap = new JPListModelMapTable(this.conversionTable);
        vmListModelMap.addTableModelListener(this);
        this.matrixGrid.setModel((ListModel)vmListModelMap);
        Columns columns = this.matrixGrid.getColumns();
        if (columns == null) {
            this.auxhead = this.createAuxhead();
            this.matrixGrid.appendChild((Component)this.auxhead);
            this.createtColumnMap();
            org.adempiere.webui.component.Columns clms = this.createColumns();
            clms.setSizable(true);
            this.matrixGrid.appendChild((Component)clms);
            Frozen frozen = new Frozen();
            frozen.setColumns(this.fixItemFieldIDMap.size());
            this.matrixGrid.appendChild((Component)frozen);
        } else {
            this.matrixGrid.removeChild((Component)columns);
            this.matrixGrid.removeChild((Component)this.auxhead);
            this.auxhead = this.createAuxhead();
            this.matrixGrid.appendChild((Component)this.auxhead);
            this.createtColumnMap();
            org.adempiere.webui.component.Columns clms = this.createColumns();
            clms.setSizable(true);
            this.matrixGrid.appendChild((Component)clms);
        }
        this.updateColumn();
        this.renderer = new JPMatrixGridRowRenderer(vmListModelMap, ctListModelMap, this.tableModel, this.dirtyModel, this.form, this);
        this.renderer.setcColumnsSize(this.columnNameMap.size());
        this.renderer.setGridTab(this.gridTab);
        this.renderer.setColumnGridFieldMap(this.columnGridFieldMap);
        this.renderer.createRecordProcessDialog();
        this.matrixGrid.setRowRenderer((RowRenderer)this.renderer);
        this.matrixGrid.addEventListener("onClick", (EventListener)this);
        return true;
    }

    private String createWhere() {
        MRole role;
        String orgAccessSQL;
        StringBuilder whereClause = new StringBuilder(" WHERE " + this.TABLE_NAME + ".AD_Client_ID = " + Env.getAD_Client_ID((Properties)Env.getCtx()));
        for (Map.Entry<String, WEditor> entry : this.searchEditorMap.entrySet()) {
            String stringValue;
            Object value = entry.getValue().getValue();
            if (entry.getValue() instanceof WStringEditor && Util.isEmpty((String)(stringValue = (String)entry.getValue().getValue()))) {
                value = null;
            }
            if (value != null) {
                String tableName = null;
                GridField gField = entry.getValue().getGridField();
                GridTab gTab = gField.getGridTab();
                if (gTab != null) {
                    tableName = gTab.getTableName();
                } else {
                    int AD_Tab_ID = gField.getAD_Tab_ID();
                    MTab tab = new MTab(Env.getCtx(), AD_Tab_ID, null);
                    tableName = tab.getAD_Table().getTableName();
                }
                if (entry.getValue() instanceof WYesNoEditor) {
                    if (entry.getValue().getValue().equals(true)) {
                        whereClause.append(" AND " + tableName + "." + entry.getKey() + " = " + "'Y'");
                        continue;
                    }
                    whereClause.append(" AND " + tableName + "." + entry.getKey() + " = " + "'N'");
                    continue;
                }
                if (entry.getValue().getGridField().getDisplayType() == 17) {
                    whereClause.append(" AND " + tableName + "." + entry.getKey() + " = " + "'" + entry.getValue().getValue() + "'");
                    continue;
                }
                if (DisplayType.isText((int)entry.getValue().getGridField().getDisplayType())) {
                    String string = (String)entry.getValue().getValue();
                    if (string.isEmpty()) continue;
                    whereClause.append(" AND " + tableName + "." + entry.getKey() + " LIKE " + "'" + string + "'");
                    continue;
                }
                if (DisplayType.isDate((int)entry.getValue().getGridField().getDisplayType())) {
                    Timestamp timestamp = (Timestamp)entry.getValue().getValue();
                    whereClause.append(" AND " + tableName + "." + entry.getKey() + "=" + "TO_DATE('" + timestamp.toString() + "','YYYY-MM-DD HH24:MI:SS')");
                    continue;
                }
                whereClause.append(" AND " + tableName + "." + entry.getKey() + " = " + entry.getValue().getValue());
                continue;
            }
            if (!entry.getValue().isMandatory()) continue;
            this.message.append(String.valueOf(System.getProperty("line.separator")) + Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory") + entry.getValue().getLabel().getValue());
        }
        if (this.m_matrixWindow.getWhereClause() != null) {
            whereClause.append(" AND " + this.m_matrixWindow.getWhereClause());
        }
        if ((orgAccessSQL = (role = MRole.get((Properties)Env.getCtx(), (int)Env.getAD_Role_ID((Properties)Env.getCtx()))).getOrgWhere(false)) != null) {
            whereClause.append(" AND ").append(this.gridTab.getTableName()).append(".").append(orgAccessSQL);
        }
        return whereClause.toString();
    }

    private ArrayList<Object> createColumnKeys(String whereClause) {
        ResultSet rs;
        CPreparedStatement pstmt;
        I_AD_Column keyColumn;
        I_AD_Field keyField;
        ArrayList<Object> list;
        block25: {
            list = new ArrayList<Object>();
            StringBuilder sql = new StringBuilder("SELECT DISTINCT " + this.TABLE_NAME + "." + this.m_columnKeyColumn.getColumnName() + " FROM " + this.TABLE_NAME);
            if (this.m_matrixWindow.getJP_JoinClause() != null) {
                sql.append(" " + this.m_matrixWindow.getJP_JoinClause());
            }
            sql.append(whereClause).append(" ORDER BY " + this.TABLE_NAME + "." + this.m_columnKeyColumn.getColumnName());
            keyField = this.m_matrixWindow.getJP_MatrixColumnKey();
            keyColumn = keyField.getAD_Column();
            pstmt = null;
            rs = null;
            this.columnKeyNameMap.clear();
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        if (keyColumn.getAD_Reference_ID() == 19 || keyColumn.getAD_Reference_ID() == 18 || keyColumn.getAD_Reference_ID() == 30) {
                            list.add(rs.getInt(1));
                            this.columnKeyNameMap.put(rs.getInt(1), this.getDisplayValue(this.m_columnKeyColumn.getAD_Column_ID(), rs.getInt(1)));
                            continue;
                        }
                        if (keyColumn.getAD_Reference_ID() == 11) {
                            list.add(rs.getInt(1));
                            continue;
                        }
                        if (keyColumn.getAD_Reference_ID() == 10) {
                            list.add(rs.getString(1));
                            continue;
                        }
                        if (keyColumn.getAD_Reference_ID() == 15 || keyColumn.getAD_Reference_ID() == 16 || keyColumn.getAD_Reference_ID() == 24) {
                            list.add(rs.getTimestamp(1));
                            continue;
                        }
                        list.add(rs.getObject(1));
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block25;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (keyColumn.getAD_Reference_ID() == 19 || keyColumn.getAD_Reference_ID() == 18 || keyColumn.getAD_Reference_ID() == 30) {
            ArrayList<Object> sortedList = new ArrayList<Object>();
            StringBuilder sortSQL = new StringBuilder("SELECT ");
            int AD_Reference_Value_ID = 0;
            if (keyField.getAD_Reference_Value_ID() != 0) {
                AD_Reference_Value_ID = keyField.getAD_Reference_Value_ID();
            } else if (keyColumn.getAD_Reference_Value_ID() != 0) {
                AD_Reference_Value_ID = keyColumn.getAD_Reference_Value_ID();
            }
            if (AD_Reference_Value_ID == 0) {
                return list;
            }
            MRefTable ref = new MRefTable(Env.getCtx(), AD_Reference_Value_ID, null);
            sortSQL.append(MColumn.getColumnName((Properties)Env.getCtx(), (int)ref.getAD_Key()));
            sortSQL.append(" FROM ").append(ref.getAD_Table().getTableName());
            sortSQL.append(" WHERE ").append(MColumn.getColumnName((Properties)Env.getCtx(), (int)ref.getAD_Key()));
            sortSQL.append(" IN (");
            int i = 0;
            while (i < list.size()) {
                if (i == 0) {
                    sortSQL.append(list.get(i));
                } else {
                    sortSQL.append("," + list.get(i));
                }
                ++i;
            }
            sortSQL.append(" )");
            sortSQL.append(" ORDER BY ").append(ref.getOrderByClause());
            try {
                try {
                    pstmt = DB.prepareStatement((String)sortSQL.toString(), null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        sortedList.add(rs.getInt(1));
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sortSQL.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                }
            }
            finally {
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            return sortedList;
        }
        return list;
    }

    private LinkedHashMap<Object, GridTab> createVirtualTabMap(ArrayList<Object> columnKeys) {
        GridWindowVO gridWindowVO = GridWindowVO.create((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)this.AD_WINDOW_ID);
        this.virtualTabMap = new LinkedHashMap();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT * FROM AD_Tab_vt WHERE AD_Tab_ID=? ";
        pstmt = DB.prepareStatement((String)sql, null);
        try {
            try {
                int i = 0;
                while (i < columnKeys.size()) {
                    pstmt.setInt(1, this.gridTab.getAD_Tab_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        GridTabVO gridTabVO = GridTabVO.create((GridWindowVO)gridWindowVO, (int)i, (ResultSet)rs, (boolean)this.editMode.equals(EDITMODE_READ), (boolean)true);
                        if (gridTabVO == null) break;
                        GridTab gtab = new GridTab(gridTabVO, this.gridTab.getGridWindow());
                        this.virtualTabMap.put(columnKeys.get(i), gtab);
                    }
                    ++i;
                }
            }
            catch (SQLException e) {
                CLogger.get().log(Level.SEVERE, "createTabs", (Throwable)e);
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
        }
        finally {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return this.virtualTabMap;
    }

    private ArrayList<Object> createRowKeys(String whereClause) {
        ResultSet rs;
        CPreparedStatement pstmt;
        I_AD_Column keyColumn;
        I_AD_Field keyField;
        ArrayList<Object> list;
        block26: {
            list = new ArrayList<Object>();
            StringBuilder sql = new StringBuilder("SELECT DISTINCT " + this.TABLE_NAME + "." + this.m_rowKeyColumn.getColumnName() + " FROM " + this.TABLE_NAME);
            if (this.m_matrixWindow.getJP_JoinClause() != null) {
                sql.append(" " + this.m_matrixWindow.getJP_JoinClause());
            }
            sql.append(whereClause).append(" ORDER BY " + this.TABLE_NAME + "." + this.m_rowKeyColumn.getColumnName());
            keyField = this.m_matrixWindow.getJP_MatrixRowKey();
            keyColumn = keyField.getAD_Column();
            pstmt = null;
            rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        if (keyColumn.getAD_Reference_ID() == 19 || keyColumn.getAD_Reference_ID() == 18 || keyColumn.getAD_Reference_ID() == 30) {
                            list.add(rs.getInt(1));
                            continue;
                        }
                        if (keyColumn.getAD_Reference_ID() == 11) {
                            list.add(rs.getInt(1));
                            continue;
                        }
                        if (keyColumn.getAD_Reference_ID() == 10) {
                            list.add(rs.getString(1));
                            continue;
                        }
                        if (keyColumn.getAD_Reference_ID() == 15 || keyColumn.getAD_Reference_ID() == 16 || keyColumn.getAD_Reference_ID() == 24) {
                            list.add(rs.getTimestamp(1));
                            continue;
                        }
                        list.add(rs.getObject(1));
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block26;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (keyColumn.getAD_Reference_ID() == 19 || keyColumn.getAD_Reference_ID() == 18 || keyColumn.getAD_Reference_ID() == 30) {
            ArrayList<Object> sortedList = new ArrayList<Object>();
            StringBuilder sortSQL = new StringBuilder("SELECT ");
            int AD_Reference_Value_ID = 0;
            if (keyField.getAD_Reference_Value_ID() != 0) {
                AD_Reference_Value_ID = keyField.getAD_Reference_Value_ID();
            } else if (keyColumn.getAD_Reference_Value_ID() != 0) {
                AD_Reference_Value_ID = keyColumn.getAD_Reference_Value_ID();
            }
            if (AD_Reference_Value_ID == 0) {
                return list;
            }
            MRefTable ref = new MRefTable(Env.getCtx(), AD_Reference_Value_ID, null);
            sortSQL.append(MColumn.getColumnName((Properties)Env.getCtx(), (int)ref.getAD_Key()));
            sortSQL.append(" FROM ").append(ref.getAD_Table().getTableName());
            sortSQL.append(" WHERE ").append(MColumn.getColumnName((Properties)Env.getCtx(), (int)ref.getAD_Key()));
            sortSQL.append(" IN (");
            int i = 0;
            while (i < list.size()) {
                if (i == 0) {
                    sortSQL.append(list.get(i));
                } else {
                    sortSQL.append("," + list.get(i));
                }
                ++i;
            }
            sortSQL.append(" )");
            if (!Util.isEmpty((String)ref.getOrderByClause())) {
                sortSQL.append(" ORDER BY ").append(ref.getOrderByClause());
            }
            try {
                try {
                    pstmt = DB.prepareStatement((String)sortSQL.toString(), null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        sortedList.add(rs.getInt(1));
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sortSQL.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                }
            }
            finally {
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            return sortedList;
        }
        return list;
    }

    private PO[] getPOs(String whereClause, boolean reload) {
        ArrayList<PO> list;
        block10: {
            if (!reload && this.m_POs != null && this.m_POs.length != 0) {
                return this.m_POs;
            }
            list = new ArrayList<PO>();
            StringBuilder sql = new StringBuilder("SELECT " + this.TABLE_NAME + ".* FROM " + this.TABLE_NAME);
            if (this.m_matrixWindow.getJP_JoinClause() != null) {
                sql.append(" " + this.m_matrixWindow.getJP_JoinClause());
            }
            sql.append(String.valueOf(whereClause) + " ORDER BY " + this.m_columnKeyColumn.getColumnName() + "," + this.m_rowKeyColumn.getColumnName());
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                    rs = pstmt.executeQuery();
                    List factoryList = Service.locator().list(IModelFactory.class).getServices();
                    if (factoryList == null) {
                        // empty if block
                    }
                    PO po = null;
                    block4: while (rs.next()) {
                        for (IModelFactory factory : factoryList) {
                            po = factory.getPO(this.TABLE_NAME, rs, null);
                            if (po == null) continue;
                            list.add(po);
                            continue block4;
                        }
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_POs = new PO[list.size()];
        list.toArray(this.m_POs);
        return this.m_POs;
    }

    private HashMap<Integer, PO> createTableModel(PO[] POs) {
        int i = 0;
        while (i < POs.length) {
            this.tableModel.put(POs[i].get_ID(), POs[i]);
            ++i;
        }
        return this.tableModel;
    }

    private LinkedHashMap<Object, LinkedHashMap<Object, PO>> createKeyColumnModel(PO[] POs) {
        this.keyColumnModel.clear();
        Object columnKey = null;
        LinkedHashMap<Object, Object> mapObj = null;
        int i = 0;
        while (i < this.columnKeys.size()) {
            columnKey = this.columnKeys.get(i);
            mapObj = null;
            int j = 0;
            while (j < POs.length) {
                if (columnKey.equals(POs[j].get_Value(this.m_columnKeyColumn.getColumnName()))) {
                    mapObj = this.keyColumnModel.get(columnKey);
                    if (mapObj == null) {
                        mapObj = new LinkedHashMap();
                        mapObj.put(POs[j].get_Value(this.m_rowKeyColumn.getColumnName()), POs[j]);
                        this.keyColumnModel.put(columnKey, mapObj);
                    } else {
                        mapObj.put(POs[j].get_Value(this.m_rowKeyColumn.getColumnName()), POs[j]);
                    }
                }
                ++j;
            }
            ++i;
        }
        return this.keyColumnModel;
    }

    private LinkedHashMap<Object, TreeMap<Integer, Object>> createViewModelConvetionTable() {
        LinkedHashMap<Object, TreeMap<Integer, Object>> y = new LinkedHashMap<Object, TreeMap<Integer, Object>>();
        int i = 0;
        while (i < this.rowKeys.size()) {
            TreeMap<Integer, Object> x = new TreeMap<Integer, Object>();
            Object obj = this.rowKeys.get(i);
            y.put(obj, x);
            x.put(0, obj);
            int columnNum = this.columnKeys.size() * this.m_contentFields.length;
            int j = 1;
            while (j < columnNum + 1) {
                x.put(j, null);
                ++j;
            }
            ++i;
        }
        return y;
    }

    private void setViewModelConvetionTable() {
        Set<Object> keyColumnModelKeySet = this.keyColumnModel.keySet();
        int i = 0;
        for (Object keyColumn : keyColumnModelKeySet) {
            LinkedHashMap<Object, PO> POs = this.keyColumnModel.get(keyColumn);
            Set<Object> rowKeys = POs.keySet();
            for (Object rowKey : rowKeys) {
                TreeMap<Integer, Object> vmRow = this.viewModel.get(POs.get(rowKey).get_Value(this.m_rowKeyColumn.getColumnName()));
                TreeMap<Integer, Object> ctRow = this.conversionTable.get(POs.get(rowKey).get_Value(this.m_rowKeyColumn.getColumnName()));
                int k = 0;
                while (k < this.m_contentFields.length) {
                    vmRow.put(this.fixItemFieldIDMap.size() + i * this.m_contentFields.length + k, POs.get(rowKey).get_Value(this.m_contentColumns[k].getColumnName()));
                    ctRow.put(this.fixItemFieldIDMap.size() + i * this.m_contentFields.length + k, POs.get(rowKey).get_ID());
                    ++k;
                }
            }
            ++i;
        }
    }

    private Auxhead createAuxhead() throws ClassNotFoundException {
        Auxhead auxhead;
        block4: {
            I_AD_Column keyColumn;
            block5: {
                block3: {
                    auxhead = new Auxhead();
                    Auxheader fix = new Auxheader("");
                    auxhead.appendChild((Component)fix);
                    fix.setColspan(this.fixItemFieldIDMap.size());
                    keyColumn = this.m_matrixWindow.getJP_MatrixColumnKey().getAD_Column();
                    if (keyColumn.getAD_Reference_ID() != 19 && keyColumn.getAD_Reference_ID() != 18 && keyColumn.getAD_Reference_ID() != 30) break block3;
                    int i = 0;
                    while (i < this.columnKeys.size()) {
                        Auxheader auxheader = new Auxheader(this.columnKeyNameMap.get(this.columnKeys.get(i)));
                        auxhead.appendChild((Component)auxheader);
                        auxheader.setColspan(this.m_contentFields.length);
                        auxheader.setAlign("center");
                        ++i;
                    }
                    break block4;
                }
                if (keyColumn.getAD_Reference_ID() == 11) break block4;
                if (keyColumn.getAD_Reference_ID() != 10) break block5;
                int i = 0;
                while (i < this.columnKeys.size()) {
                    Auxheader auxheader = new Auxheader((String)this.columnKeys.get(i));
                    auxhead.appendChild((Component)auxheader);
                    auxheader.setColspan(this.m_contentFields.length);
                    auxheader.setAlign("center");
                    ++i;
                }
                break block4;
            }
            if (keyColumn.getAD_Reference_ID() != 15 && keyColumn.getAD_Reference_ID() != 16 && keyColumn.getAD_Reference_ID() != 24) break block4;
            int i = 0;
            while (i < this.columnKeys.size()) {
                Auxheader auxheader = new Auxheader(this.columnKeys.get(i).toString());
                auxhead.appendChild((Component)auxheader);
                auxheader.setColspan(this.m_contentFields.length);
                auxheader.setAlign("center");
                ++i;
            }
        }
        return auxhead;
    }

    private org.adempiere.webui.component.Columns createColumns() {
        org.adempiere.webui.component.Columns clms = new org.adempiere.webui.component.Columns();
        Column col = null;
        int i = 0;
        while (i < this.columnNameMap.size()) {
            col = new Column(this.columnNameMap.get(i));
            if (this.columnLengthMap.get(i) == 0) {
                col.setHflex("min");
            } else {
                col.setWidth(this.columnLengthMap.get(i) + "px");
            }
            col.setDraggable("false");
            clms.appendChild((Component)col);
            ++i;
        }
        return clms;
    }

    private String getDisplayValue(int AD_Column_ID, int Record_ID) {
        MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)0, (int)AD_Column_ID, (int)30);
        WSearchEditor keyColumn = new WSearchEditor("keyColumn", true, false, true, (Lookup)lookup);
        keyColumn.setValue((Object)Record_ID);
        return keyColumn.getDisplay();
    }

    private void createtColumnMap() {
        int c = 0;
        this.columnNameMap.clear();
        this.columnLengthMap.clear();
        this.columnGridFieldMap.clear();
        this.columnSummarizedMap.clear();
        int i = 0;
        while (i < this.fixItemFieldIDMap.size()) {
            this.columnNameMap.put(c, Msg.getElement((Properties)Env.getCtx(), (String)this.fixItem.get(i)));
            this.columnLengthMap.put(c, this.m_matrixWindow.getFieldLength());
            this.columnSummarizedMap.put(c, false);
            int j = 0;
            while (j < this.gridFields.length) {
                if (this.fixItemFieldIDMap.get(i).intValue() == this.gridFields[j].getAD_Field_ID()) {
                    this.columnGridFieldMap.put(c, this.gridFields[j]);
                }
                ++j;
            }
            ++c;
            ++i;
        }
        i = 0;
        while (i < this.columnKeys.size()) {
            GridTab gtab = this.virtualTabMap.get(this.columnKeys.get(i));
            gtab.initTab(false);
            GridField[] gFields = gtab.getFields();
            int j = 0;
            while (j < this.m_contentFields.length) {
                this.columnNameMap.put(c, Msg.getElement((Properties)Env.getCtx(), (String)this.m_contentColumns[j].getColumnName()));
                this.columnLengthMap.put(c, this.m_matrixFields[j].getFieldLength());
                this.columnSummarizedMap.put(c, this.m_matrixFields[j].isSummarized());
                int k = 0;
                while (k < gFields.length) {
                    if (this.m_contentFields[j].getAD_Field_ID() == gFields[k].getAD_Field_ID()) {
                        this.columnGridFieldMap.put(c, gFields[k]);
                    }
                    ++k;
                }
                ++c;
                ++j;
            }
            ++i;
        }
    }

    private void updateColumn() {
        Columns columns = this.matrixGrid.getColumns();
        List columnList = columns.getChildren();
        BigDecimal[] totalValues = new BigDecimal[columnList.size()];
        int i = 0;
        while (i < totalValues.length) {
            totalValues[i] = new BigDecimal(0);
            ++i;
        }
        TreeMap<Integer, Object> columnDataMap = null;
        int columnDisplayType = 0;
        Object valuObj = null;
        for (Object rowKey : this.rowKeys) {
            columnDataMap = this.viewModel.get(rowKey);
            int i2 = 0;
            while (i2 < totalValues.length) {
                if (i2 != 0) {
                    columnDisplayType = this.columnGridFieldMap.get(i2).getDisplayType();
                    if (columnDisplayType == 22 || columnDisplayType == 29 || columnDisplayType == 12 || columnDisplayType == 37) {
                        valuObj = columnDataMap.get(i2);
                        if (valuObj != null) {
                            totalValues[i2] = totalValues[i2].add((BigDecimal)valuObj);
                        }
                    } else if (columnDisplayType == 11 && (valuObj = columnDataMap.get(i2)) != null) {
                        totalValues[i2] = totalValues[i2].add(new BigDecimal(valuObj.toString()));
                    }
                    valuObj = null;
                }
                ++i2;
            }
        }
        int c = 0;
        columnDisplayType = 0;
        for (Component column : columnList) {
            if (c == 0) {
                ++c;
                continue;
            }
            columnDisplayType = this.columnGridFieldMap.get(c).getDisplayType();
            Column col = (Column)column;
            if ((columnDisplayType == 22 || columnDisplayType == 29 || columnDisplayType == 12 || columnDisplayType == 11 || columnDisplayType == 37) && this.columnSummarizedMap.get(c).booleanValue()) {
                DecimalFormat format = DisplayType.getNumberFormat((int)columnDisplayType);
                col.setLabel(String.valueOf(this.columnNameMap.get(c)) + "(" + this.sum + ":" + format.format(totalValues[c]) + ")");
            }
            ++c;
        }
    }

    private boolean saveData() {
        this.notSavePO = new ArrayList();
        try {
            Trx.run((TrxRunnable)new TrxRunnable(){

                public void run(String trxName) {
                    Collection POs = JPiereMatrixWindow.this.dirtyModel.values();
                    for (PO po : POs) {
                        if (JPiereMatrixWindow.this.checkExclusiveControl(po)) {
                            po.saveEx(trxName);
                            continue;
                        }
                        JPiereMatrixWindow.this.notSavePO.add(po);
                    }
                    JPiereMatrixWindow.this.updateColumn();
                }
            });
            if (this.notSavePO.size() > 0) {
                String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"SaveErrorDataChanged");
                for (PO po : this.notSavePO) {
                    msg = String.valueOf(msg) + System.lineSeparator() + po.toString();
                }
                FDialog.error((int)this.form.getWindowNo(), (Component)this.form, (String)"Next", (String)msg);
                this.createView();
            }
            return true;
        }
        catch (Exception e) {
            FDialog.error((int)this.form.getWindowNo(), (Component)this.form, (String)"SaveError", (String)e.getLocalizedMessage());
            return false;
        }
    }

    private boolean checkExclusiveControl(PO po) {
        int colUpdated = po.get_ColumnIndex("Updated");
        int colProcessed = po.get_ColumnIndex("Processed");
        boolean hasUpdated = colUpdated > 0;
        boolean hasProcessed = colProcessed > 0;
        String columns = null;
        if (hasUpdated && hasProcessed) {
            columns = new String("Updated, Processed");
        } else if (hasUpdated) {
            columns = new String("Updated");
        } else if (hasProcessed) {
            columns = new String("Processed");
        } else {
            return false;
        }
        Timestamp dbUpdated = null;
        String dbProcessedS = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT " + columns + " FROM " + this.TABLE_NAME + " WHERE " + this.TABLE_NAME + "_ID=?";
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, po.get_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    int idx = 1;
                    if (hasUpdated) {
                        dbUpdated = rs.getTimestamp(idx++);
                    }
                    if (hasProcessed) {
                        dbProcessedS = rs.getString(idx++);
                    }
                } else if (log.isLoggable(Level.INFO)) {
                    log.info("No Value " + sql);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        if (hasUpdated) {
            Timestamp memUpdated = null;
            memUpdated = (Timestamp)po.get_Value(colUpdated);
            if (memUpdated != null && !memUpdated.equals(dbUpdated)) {
                return false;
            }
        }
        if (hasProcessed) {
            Boolean memProcessed = null;
            memProcessed = (Boolean)po.get_Value(colProcessed);
            Boolean dbProcessed = Boolean.TRUE;
            if (!dbProcessedS.equals("Y")) {
                dbProcessed = Boolean.FALSE;
            }
            if (memProcessed != null && !memProcessed.equals(dbProcessed)) {
                return false;
            }
        }
        return true;
    }

    public String getEditMode() {
        return this.editMode;
    }

    public void actionPerformed(ActionEvent event) {
        boolean isOK;
        if (this.dirtyModel.size() > 0 && (isOK = this.saveData())) {
            this.dirtyModel.clear();
        }
        ToolbarProcessButton button = (ToolbarProcessButton)event.getSource();
        JPiereMatrixWindowProcessModelDialog dialog = new JPiereMatrixWindowProcessModelDialog(this.form.getWindowNo(), button.getProcess_ID(), 0, 0, false, this);
        if (dialog.isValid()) {
            dialog.setBorder("normal");
            this.form.getParent().appendChild((Component)dialog);
            LayoutUtils.openOverlappedWindow((Component)this.form.getParent(), (org.zkoss.zul.Window)dialog, (String)"middle_center");
            dialog.focus();
        }
    }

    static class ZoomListener
    implements EventListener<Event> {
        private IZoomableEditor searchEditor;

        ZoomListener(IZoomableEditor editor) {
            this.searchEditor = editor;
        }

        public void onEvent(Event event) throws Exception {
            if ("onClick".equals(event.getName())) {
                this.searchEditor.actionZoom();
            }
        }
    }
}

