/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.annotation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitDestroyAnnotationBeanPostProcessor
implements DestructionAwareBeanPostProcessor,
MergedBeanDefinitionPostProcessor,
PriorityOrdered,
Serializable {
    private Class<? extends Annotation> initAnnotationType;
    private Class<? extends Annotation> destroyAnnotationType;
    private int order = Integer.MAX_VALUE;
    private final transient Map<Class<?>, LifecycleMetadata> lifecycleMetadataCache = new ConcurrentHashMap();

    public void setInitAnnotationType(Class<? extends Annotation> initAnnotationType) {
        this.initAnnotationType = initAnnotationType;
    }

    public void setDestroyAnnotationType(Class<? extends Annotation> destroyAnnotationType) {
        this.destroyAnnotationType = destroyAnnotationType;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class beanType, String beanName) {
        if (beanType != null) {
            LifecycleMetadata metadata = this.findLifecycleMetadata(beanType);
            for (LifecycleElement lifecycleElement : metadata.getInitMethods()) {
                beanDefinition.registerExternallyManagedInitMethod(lifecycleElement.getMethod().getName());
            }
            for (LifecycleElement lifecycleElement : metadata.getDestroyMethods()) {
                beanDefinition.registerExternallyManagedDestroyMethod(lifecycleElement.getMethod().getName());
            }
        }
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        LifecycleMetadata metadata = this.findLifecycleMetadata(bean.getClass());
        try {
            metadata.invokeInitMethods(bean);
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Invocation of init method failed", ex);
        }
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        LifecycleMetadata metadata = this.findLifecycleMetadata(bean.getClass());
        try {
            metadata.invokeDestroyMethods(bean);
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Invocation of destroy method failed", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LifecycleMetadata findLifecycleMetadata(Class clazz) {
        if (this.lifecycleMetadataCache == null) {
            return this.buildLifecycleMetadata(clazz);
        }
        LifecycleMetadata metadata = this.lifecycleMetadataCache.get(clazz);
        if (metadata == null) {
            Map<Class<?>, LifecycleMetadata> map = this.lifecycleMetadataCache;
            synchronized (map) {
                metadata = this.lifecycleMetadataCache.get(clazz);
                if (metadata == null) {
                    metadata = this.buildLifecycleMetadata(clazz);
                    this.lifecycleMetadataCache.put(clazz, metadata);
                }
                return metadata;
            }
        }
        return metadata;
    }

    private LifecycleMetadata buildLifecycleMetadata(Class clazz) {
        final LifecycleMetadata newMetadata = new LifecycleMetadata();
        ReflectionUtils.doWithMethods((Class)clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) {
                if (InitDestroyAnnotationBeanPostProcessor.this.initAnnotationType != null && method.getAnnotation(InitDestroyAnnotationBeanPostProcessor.this.initAnnotationType) != null) {
                    newMetadata.addInitMethod(method);
                }
                if (InitDestroyAnnotationBeanPostProcessor.this.destroyAnnotationType != null && method.getAnnotation(InitDestroyAnnotationBeanPostProcessor.this.destroyAnnotationType) != null) {
                    newMetadata.addDestroyMethod(method);
                }
            }
        });
        return newMetadata;
    }

    private static class LifecycleElement {
        private final Method method;

        public LifecycleElement(Method method) {
            if (method.getParameterTypes().length != 0) {
                throw new IllegalStateException("Lifecycle method annotation requires a no-arg method: " + method);
            }
            this.method = method;
        }

        public Method getMethod() {
            return this.method;
        }

        public void invoke(Object target) throws Throwable {
            ReflectionUtils.makeAccessible((Method)this.method);
            try {
                this.method.invoke(target, (Object[])null);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }

        public boolean equals(Object other) {
            return this == other || other instanceof LifecycleElement && this.method.getName().equals(((LifecycleElement)other).method.getName());
        }

        public int hashCode() {
            return this.method.getName().hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LifecycleMetadata {
        private final Set<LifecycleElement> initMethods = new LinkedHashSet<LifecycleElement>();
        private final Set<LifecycleElement> destroyMethods = new LinkedHashSet<LifecycleElement>();

        private LifecycleMetadata() {
        }

        public void addInitMethod(Method method) {
            this.initMethods.add(new LifecycleElement(method));
        }

        public Set<LifecycleElement> getInitMethods() {
            return this.initMethods;
        }

        public void invokeInitMethods(Object target) throws Throwable {
            for (LifecycleElement lifecycleElement : this.initMethods) {
                lifecycleElement.invoke(target);
            }
        }

        public void addDestroyMethod(Method method) {
            this.destroyMethods.add(new LifecycleElement(method));
        }

        public Set<LifecycleElement> getDestroyMethods() {
            return this.destroyMethods;
        }

        public void invokeDestroyMethods(Object target) throws Throwable {
            for (LifecycleElement lifecycleElement : this.destroyMethods) {
                lifecycleElement.invoke(target);
            }
        }
    }
}

