/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.sys;

import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.StubEvent;
import org.zkoss.zk.ui.ext.Native;
import org.zkoss.zk.ui.ext.Scope;
import org.zkoss.zk.ui.sys.EventListenerMap;

public class StubComponent
extends AbstractComponent {
    public StubComponent() {
        super(true);
    }

    public String getId(String uuid) {
        if (uuid.equals(this.getUuid())) {
            return StubComponent.id0(this.getId());
        }
        return StubComponent.getIdFromChild(this, uuid);
    }

    private static String getIdFromChild(Component comp, String uuid) {
        for (Component child = comp.getFirstChild(); child != null; child = child.getNextSibling()) {
            String id;
            if (child instanceof StubComponent) {
                id = ((StubComponent)child).getId(uuid);
                if (id == null) continue;
                return id;
            }
            if (uuid.equals(child.getUuid())) {
                return StubComponent.id0(child.getId());
            }
            id = StubComponent.getIdFromChild(child, uuid);
            if (id == null) continue;
            return id;
        }
        return null;
    }

    private static String id0(String id) {
        return id != null && id.length() > 0 ? id : null;
    }

    public void replace(Component comp, boolean bFellow, boolean bListener, boolean bChildren) {
        super.replace(comp, bFellow, bListener, bChildren);
    }

    public String getWidgetClass() {
        return "#stub";
    }

    public void service(AuRequest request, boolean everError) {
        Events.postEvent(StubEvent.getStubEvent(request));
    }

    public void service(Event event, Scope scope) throws Exception {
        if (event instanceof StubEvent) {
            EventListenerMap map = this.getEventListenerMap();
            if (map != null) {
                map.service(event, scope, this, ((StubEvent)event).getCommand());
            } else {
                this.postToNonStubAncestor((StubEvent)event);
            }
        } else {
            super.service(event, scope);
        }
    }

    void postToNonStubAncestor(StubEvent event) {
        Component target;
        for (target = event.getTarget(); target != null && (target instanceof Native || target instanceof StubComponent); target = target.getParent()) {
        }
        if (target != null) {
            Events.postEvent(new StubEvent(event, target));
        }
    }
}

