/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.select;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.VariableResolver;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zk.ui.select.annotation.WireVariable;
import org.zkoss.zk.ui.select.impl.ComponentIterator;
import org.zkoss.zk.ui.select.impl.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selectors {
    private static final String EVT_LIS = "_SELECTOR_COMPOSER_EVENT_LISTENERS";

    public static Iterable<Component> iterable(final Page page, final String selector) {
        return new Iterable<Component>(){

            @Override
            public Iterator<Component> iterator() {
                return new ComponentIterator(page, selector);
            }
        };
    }

    public static Iterable<Component> iterable(final Component root, final String selector) {
        return new Iterable<Component>(){

            @Override
            public Iterator<Component> iterator() {
                return new ComponentIterator(root, selector);
            }
        };
    }

    public static List<Component> find(Page page, String selector) {
        return Selectors.toList(Selectors.iterable(page, selector));
    }

    public static List<Component> find(Component root, String selector) {
        return Selectors.toList(Selectors.iterable(root, selector));
    }

    public static void wireVariables(Component component, Object controller, List<org.zkoss.xel.VariableResolver> extraResolvers) {
        new Wirer(controller, false).wireVariables(new ComponentFunctor(component), extraResolvers);
    }

    public static void wireVariables(Page page, Object controller, List<org.zkoss.xel.VariableResolver> extraResolvers) {
        new Wirer(controller, false).wireVariables(new PageFunctor(page), extraResolvers);
    }

    public static void wireComponents(Component component, Object controller, boolean ignoreNonNull) {
        new Wirer(controller, false).wireComponents(new ComponentFunctor(component), ignoreNonNull);
    }

    public static void wireComponents(Page page, Object controller, boolean ignoreNonNull) {
        new Wirer(controller, false).wireComponents(new PageFunctor(page), ignoreNonNull);
    }

    public static void rewireVariablesOnActivate(Component component, Object controller, List<org.zkoss.xel.VariableResolver> extraResolvers) {
        new Wirer(controller, true).wireVariables(new ComponentFunctor(component), extraResolvers);
    }

    public static void rewireComponentsOnActivate(Component component, Object controller) {
        new Wirer(controller, true).wireComponents(new ComponentFunctor(component), false);
    }

    public static void wireEventListeners(Component component, Object controller) {
        Selectors.wireEventListeners0(component, controller, false);
    }

    private static void wireEventListeners0(final Component component, final Object controller, final boolean rewire) {
        Reflections.forMethods(controller.getClass(), Listen.class, new Reflections.MethodRunner<Listen>(){

            @Override
            public void onMethod(Class<?> clazz, Method method, Listen anno) {
                if ((method.getModifiers() & 8) != 0) {
                    throw new UiException("Cannot add forward to static method: " + method.getName());
                }
                if (method.getParameterTypes().length > 1) {
                    throw new UiException("Event handler method should have at most one parameter: " + method.getName());
                }
                for (String[] strs : Selectors.splitListenAnnotationValues(anno.value())) {
                    String name = strs[0];
                    if (name == null) {
                        name = "onClick";
                    }
                    int prio = 0;
                    int idx = name.indexOf(40);
                    if (idx > 0) {
                        int li = name.indexOf(41);
                        prio = Integer.parseInt(name.substring(idx + 1, li));
                        name = name.substring(0, idx);
                    }
                    Iterable<Component> iter = Selectors.iterable(component, strs[1]);
                    HashSet<Component> rewired = rewire ? new HashSet<Component>() : null;
                    for (Component c : iter) {
                        String mhash;
                        Set set;
                        if (rewired != null && !rewired.contains(c)) {
                            rewired.add(c);
                            c.removeAttribute(Selectors.EVT_LIS);
                            Iterable<EventListener<? extends Event>> listeners = c.getEventListeners(name);
                            if (listeners != null) {
                                for (EventListener<? extends Event> listener : listeners) {
                                    if (!(listener instanceof ComposerEventListener)) continue;
                                    c.removeEventListener(name, listener);
                                }
                            }
                        }
                        if ((set = Selectors.getEvtLisSet(c, Selectors.EVT_LIS)).contains(mhash = name + "#" + method.toString())) continue;
                        c.addEventListener(prio, name, new ComposerEventListener(method, controller));
                        set.add(mhash);
                    }
                }
            }
        });
    }

    static void rewireEventListeners(Component component, Object controller) {
        Selectors.wireEventListeners0(component, controller, true);
    }

    private static Set<String> getEvtLisSet(Component comp, String name) {
        Object obj = comp.getAttribute(name);
        if (obj != null) {
            return (Set)obj;
        }
        HashSet<String> set = new HashSet<String>();
        comp.setAttribute(name, set);
        return set;
    }

    public static List<org.zkoss.xel.VariableResolver> newVariableResolvers(Class<?> cls, Class<?> untilClass) {
        ArrayList<org.zkoss.xel.VariableResolver> resolvers = new ArrayList<org.zkoss.xel.VariableResolver>();
        while (cls != null && cls != untilClass) {
            VariableResolver anno = cls.getAnnotation(VariableResolver.class);
            if (anno != null) {
                for (Class<? extends org.zkoss.xel.VariableResolver> rc : anno.value()) {
                    try {
                        resolvers.add(rc.getConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                    catch (Exception e) {
                        throw UiException.Aide.wrap(e);
                    }
                }
            }
            cls = cls.getSuperclass();
        }
        return resolvers;
    }

    private static String[][] splitListenAnnotationValues(String str) {
        String last;
        ArrayList<String[]> result = new ArrayList<String[]>();
        int len = str.length();
        boolean inSqBracket = false;
        boolean inQuote = false;
        boolean escaped = false;
        String evtName = null;
        int i = 0;
        for (int j = 0; j < len; ++j) {
            char c = str.charAt(j);
            if (!escaped) {
                switch (c) {
                    case '[': {
                        inSqBracket = true;
                        break;
                    }
                    case ']': {
                        inSqBracket = false;
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        inQuote = !inQuote;
                        break;
                    }
                    case '=': {
                        if (inSqBracket || inQuote) break;
                        if (evtName != null) {
                            throw new UiException("Illegal value of @Listen: " + str);
                        }
                        evtName = str.substring(i, j).trim();
                        if (evtName.length() < 3 || !evtName.startsWith("on") || !Character.isUpperCase(evtName.charAt(2))) {
                            throw new UiException("Illegal value of @Listen: " + str);
                        }
                        i = j + 1;
                        break;
                    }
                    case ';': {
                        if (inQuote) break;
                        String target = str.substring(i, j).trim();
                        if (target.length() == 0) {
                            throw new UiException("Illegal value of @Listen: " + str);
                        }
                        result.add(new String[]{evtName, target});
                        i = j + 1;
                        evtName = null;
                        break;
                    }
                }
            }
            escaped = !escaped && c == '\\';
        }
        if (i < len && (last = str.substring(i).trim()).length() > 0) {
            result.add(new String[]{evtName, last});
        }
        return (String[][])result.toArray((T[])new String[0][0]);
    }

    private static <T> List<T> toList(Iterable<T> iterable) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : iterable) {
            result.add(t);
        }
        return result;
    }

    private static String guessImplicitObjectName(Class<?> cls) {
        if (Execution.class.equals(cls)) {
            return "execution";
        }
        if (Page.class.equals(cls)) {
            return "page";
        }
        if (Desktop.class.equals(cls)) {
            return "desktop";
        }
        if (Session.class.equals(cls)) {
            return "session";
        }
        if (WebApp.class.equals(cls)) {
            return "application";
        }
        if (Logger.class.equals(cls)) {
            return "log";
        }
        return null;
    }

    private static boolean isSessionOrWebApp(Class<?> cls) {
        return Session.class.equals(cls) || WebApp.class.equals(cls);
    }

    private static boolean isValidValue(Object value, Class<?> clazz) {
        return value != null && clazz.isAssignableFrom(value.getClass());
    }

    private static String desetterize(String name) {
        if (name.length() < 4 || !name.startsWith("set") || Character.isLowerCase(name.charAt(3))) {
            throw new UiException("Expecting method name in form setXxx: " + name);
        }
        return Character.toLowerCase(name.charAt(3)) + name.substring(4);
    }

    private static Collection getCollectionInstanceIfPossible(Class<?> clazz) {
        if (clazz.isAssignableFrom(ArrayList.class)) {
            return new ArrayList();
        }
        if (clazz.isAssignableFrom(HashSet.class)) {
            return new HashSet();
        }
        if (clazz.isAssignableFrom(TreeSet.class)) {
            return new TreeSet();
        }
        try {
            return (Collection)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static <T> T[] generateArray(Class<T> clazz, Iterable<Component> comps) {
        ArrayList<Component> list = new ArrayList<Component>();
        for (Component c : comps) {
            if (!clazz.isAssignableFrom(c.getClass())) continue;
            list.add(c);
        }
        return list.toArray((Object[])Array.newInstance(clazz, 0));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComponentFunctor
    implements PsdoCompFunctor {
        private final Component _comp;

        private ComponentFunctor(Component comp) {
            this._comp = comp;
        }

        @Override
        public Iterable<Component> iterable(String selector) {
            return Selectors.iterable(this._comp, selector);
        }

        @Override
        public Object getImplicit(String name) {
            return Components.getImplicit(this._comp, name);
        }

        @Override
        public Object getXelVariable(String name) {
            return this.getPage().getXelVariable(null, null, name, true);
        }

        @Override
        public Object getAttribute(String name) {
            return this._comp.getAttribute(name, true);
        }

        @Override
        public Component getFellowIfAny(String name) {
            return this._comp.getFellowIfAny(name);
        }

        private Page getPage() {
            return Components.getCurrentPage(this._comp);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PageFunctor
    implements PsdoCompFunctor {
        private final Page _page;

        private PageFunctor(Page page) {
            this._page = page;
        }

        @Override
        public Iterable<Component> iterable(String selector) {
            return Selectors.iterable(this._page, selector);
        }

        @Override
        public Object getImplicit(String name) {
            return Components.getImplicit(this._page, name);
        }

        @Override
        public Object getXelVariable(String name) {
            return this._page.getXelVariable(null, null, name, true);
        }

        @Override
        public Object getAttribute(String name) {
            return this._page.getAttribute(name, true);
        }

        @Override
        public Component getFellowIfAny(String name) {
            return this._page.getFellowIfAny(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface PsdoCompFunctor {
        public Iterable<Component> iterable(String var1);

        public Object getImplicit(String var1);

        public Object getAttribute(String var1);

        public Object getXelVariable(String var1);

        public Component getFellowIfAny(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ComposerEventListener
    implements EventListener<Event> {
        private final Method _ctrlMethod;
        private final Object _ctrl;

        public ComposerEventListener(Method method, Object controller) {
            this._ctrlMethod = method;
            this._ctrl = controller;
        }

        @Override
        public void onEvent(Event event) throws Exception {
            if (this._ctrlMethod.getParameterTypes().length == 0) {
                this._ctrlMethod.invoke(this._ctrl, new Object[0]);
            } else {
                this._ctrlMethod.invoke(this._ctrl, event);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Wirer {
        private final Object _controller;
        private final boolean _rewire;

        private Wirer(Object controller, boolean rewire) {
            this._controller = controller;
            this._rewire = rewire;
        }

        private void wireComponents(final PsdoCompFunctor functor, final boolean ignoreNonNull) {
            Class<?> ctrlClass = this._controller.getClass();
            Reflections.forFields(ctrlClass, Wire.class, new Reflections.FieldRunner<Wire>(){

                @Override
                public void onField(Class<?> clazz, Field field, Wire anno) {
                    Object value;
                    if ((field.getModifiers() & 8) != 0) {
                        throw new UiException("Cannot wire variable to static field: " + field.getName());
                    }
                    if (Wirer.this._rewire && !anno.rewireOnActivate()) {
                        return;
                    }
                    if (!(!ignoreNonNull || (value = Reflections.getFieldValue(Wirer.this._controller, field)) == null || value instanceof Collection && ((Collection)value).isEmpty())) {
                        return;
                    }
                    String selector = anno.value();
                    if (!Strings.isEmpty((String)selector)) {
                        Wirer.this.injectComponent(field, (Iterable<Component>)functor.iterable(selector));
                    } else {
                        Component value2 = Wirer.this.getComponentByName(functor, field.getName(), field.getType());
                        if (value2 != null) {
                            Reflections.setFieldValue(Wirer.this._controller, field, value2);
                        }
                    }
                }
            });
            Reflections.forMethods(ctrlClass, Wire.class, new Reflections.MethodRunner<Wire>(){

                @Override
                public void onMethod(Class<?> clazz, Method method, Wire anno) {
                    String name = method.getName();
                    if ((method.getModifiers() & 8) != 0) {
                        throw new UiException("Cannot wire component by static method: " + name);
                    }
                    Class<?>[] paramTypes = method.getParameterTypes();
                    if (paramTypes.length != 1) {
                        throw new UiException("Setter method should have only one parameter: " + name);
                    }
                    if (Wirer.this._rewire && !anno.rewireOnActivate()) {
                        return;
                    }
                    String selector = anno.value();
                    if (!Strings.isEmpty((String)selector)) {
                        Wirer.this.injectComponent(method, (Iterable<Component>)functor.iterable(selector));
                    } else {
                        Component value = Wirer.this.getComponentByName(functor, Selectors.desetterize(method.getName()), paramTypes[0]);
                        Reflections.invokeMethod(method, this, value);
                    }
                }
            });
        }

        private void wireVariables(final PsdoCompFunctor functor, final List<org.zkoss.xel.VariableResolver> resolvers) {
            Class<?> ctrlClass = this._controller.getClass();
            Reflections.forFields(ctrlClass, WireVariable.class, new Reflections.FieldRunner<WireVariable>(){

                @Override
                public void onField(Class<?> clazz, Field field, WireVariable anno) {
                    Object value;
                    if ((field.getModifiers() & 8) != 0) {
                        throw new UiException("Cannot wire variable to static field: " + field.getName());
                    }
                    if (Wirer.this._rewire && !anno.rewireOnActivate() && !Selectors.isSessionOrWebApp(field.getType())) {
                        return;
                    }
                    String name = anno.value();
                    if (Strings.isEmpty((String)name)) {
                        name = Selectors.guessImplicitObjectName(field.getType());
                    }
                    if (Strings.isEmpty((String)name)) {
                        name = field.getName();
                    }
                    if ((value = Wirer.this.getObjectByName(functor, name, field.getType(), resolvers)) != null) {
                        Reflections.setFieldValue(Wirer.this._controller, field, value);
                    }
                }
            });
            Reflections.forMethods(ctrlClass, WireVariable.class, new Reflections.MethodRunner<WireVariable>(){

                @Override
                public void onMethod(Class<?> clazz, Method method, WireVariable anno) {
                    String mname = method.getName();
                    if ((method.getModifiers() & 8) != 0) {
                        throw new UiException("Cannot wire variable by static method: " + mname);
                    }
                    Class<?>[] paramTypes = method.getParameterTypes();
                    if (paramTypes.length != 1) {
                        throw new UiException("Setter method should have exactly one parameter: " + mname);
                    }
                    if (Wirer.this._rewire && !anno.rewireOnActivate() && !Selectors.isSessionOrWebApp(paramTypes[0])) {
                        return;
                    }
                    String name = anno.value();
                    if (Strings.isEmpty((String)name)) {
                        name = Selectors.guessImplicitObjectName(paramTypes[0]);
                    }
                    if (Strings.isEmpty((String)name)) {
                        name = Selectors.desetterize(method.getName());
                    }
                    Object value = Wirer.this.getObjectByName(functor, name, paramTypes[0], resolvers);
                    Reflections.invokeMethod(method, Wirer.this._controller, value);
                }
            });
        }

        private void injectComponent(Method method, Iterable<Component> iter) {
            this.injectComponent(new MethodFunctor(method), iter);
        }

        private void injectComponent(Field field, Iterable<Component> iter) {
            this.injectComponent(new FieldFunctor(field), iter);
        }

        private void injectComponent(InjectionFunctor injector, Iterable<Component> comps) {
            Class<?> type = injector.getType();
            boolean isField = injector instanceof FieldFunctor;
            if (type.isArray()) {
                injector.inject(this._controller, Selectors.generateArray(type.getComponentType(), comps));
                return;
            }
            if (Collection.class.isAssignableFrom(type)) {
                Collection collection = null;
                if (isField) {
                    Field field = ((FieldFunctor)injector).getField();
                    try {
                        collection = (Collection)field.get(this._controller);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Field " + field + " not accessible or not declared by" + this._controller);
                    }
                }
                if (collection == null) {
                    collection = Selectors.getCollectionInstanceIfPossible(type);
                    if (collection == null) {
                        throw new UiException("Cannot initiate collection for " + (isField ? "field" : "method") + ": " + injector.getName() + " on " + this._controller);
                    }
                    if (isField) {
                        injector.inject(this._controller, collection);
                    }
                }
                collection.clear();
                for (Component c : comps) {
                    if (!Reflections.isAppendableToCollection(injector.getGenericType(), c)) continue;
                    collection.add(c);
                }
                if (!isField) {
                    injector.inject(this._controller, collection);
                }
                return;
            }
            for (Component c : comps) {
                if (!type.isInstance(c)) continue;
                injector.inject(this._controller, c);
                return;
            }
            injector.inject(this._controller, null);
        }

        private Component getComponentByName(PsdoCompFunctor functor, String name, Class<?> type) {
            Component result = functor.getFellowIfAny(name);
            return Selectors.isValidValue(result, type) ? result : null;
        }

        private Object getObjectByName(PsdoCompFunctor functor, String name, Class<?> type, List<org.zkoss.xel.VariableResolver> resolvers) {
            Object result = functor.getXelVariable(name);
            if (Selectors.isValidValue(result, type)) {
                return result;
            }
            if (resolvers != null) {
                for (org.zkoss.xel.VariableResolver resv : resolvers) {
                    result = resv.resolveVariable(name);
                    if (!Selectors.isValidValue(result, type)) continue;
                    return result;
                }
            }
            return Selectors.isValidValue(result = functor.getImplicit(name), type) ? result : null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class MethodFunctor
        implements InjectionFunctor {
            private final Method _method;

            private MethodFunctor(Method method) {
                this._method = method;
            }

            @Override
            public void inject(Object obj, Object value) {
                Reflections.invokeMethod(this._method, obj, value);
            }

            @Override
            public String getName() {
                return this._method.getName();
            }

            @Override
            public Class<?> getType() {
                return this._method.getParameterTypes()[0];
            }

            @Override
            public Type getGenericType() {
                return this._method.getGenericParameterTypes()[0];
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class FieldFunctor
        implements InjectionFunctor {
            private final Field _field;

            private FieldFunctor(Field field) {
                this._field = field;
            }

            @Override
            public void inject(Object obj, Object value) {
                Reflections.setFieldValue(obj, this._field, value);
            }

            @Override
            public String getName() {
                return this._field.getName();
            }

            @Override
            public Class<?> getType() {
                return this._field.getType();
            }

            @Override
            public Type getGenericType() {
                return this._field.getGenericType();
            }

            public Field getField() {
                return this._field;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static interface InjectionFunctor {
            public void inject(Object var1, Object var2);

            public String getName();

            public Class<?> getType();

            public Type getGenericType();
        }
    }
}

