/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.lang.Classes;
import org.zkoss.util.resource.Location;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.AnnotationMap;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.Property;
import org.zkoss.zk.ui.metainfo.ShadowInfo;
import org.zkoss.zk.ui.metainfo.impl.MacroDefinition;
import org.zkoss.zk.ui.metainfo.impl.NativeDefinition;
import org.zkoss.zk.ui.metainfo.impl.ShadowDefinitionImpl;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.EvaluatorRef;
import org.zkoss.zk.xel.ExValue;
import org.zkoss.zk.xel.impl.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentDefinitionImpl
implements ComponentDefinition,
Serializable {
    private String _name;
    private transient LanguageDefinition _langdef;
    private transient PageDefinition _pgdef;
    private EvaluatorRef _evalr;
    private Object _implcls;
    private Map<String, ExValue> _molds;
    private ExValue _defWgtClass;
    private Map<String, ExValue> _custAttrs;
    private List<Property> _props;
    private String _curdir;
    private String _textAs;
    private AnnotationMap _annots;
    private URL _declURL;
    private ExValue[] _apply;
    private boolean _blankpresv;
    private boolean _childAllowedInTextAs;

    public ComponentDefinitionImpl(LanguageDefinition langdef, PageDefinition pgdef, String name, Class<? extends Component> cls) {
        if (cls != null && !Component.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException(cls + " must implement " + Component.class);
        }
        this.init(langdef, pgdef, name, cls);
    }

    public ComponentDefinitionImpl(LanguageDefinition langdef, PageDefinition pgdef, String name, String clsnm) {
        this.init(langdef, pgdef, name, clsnm);
    }

    private void init(LanguageDefinition langdef, PageDefinition pgdef, String name, Object cls) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (langdef != null && pgdef != null) {
            throw new IllegalArgumentException("langdef and pgdef cannot both null or both non-null");
        }
        this._langdef = langdef;
        this._pgdef = pgdef;
        this._name = name;
        this._implcls = cls;
        this._evalr = this._langdef != null ? this._langdef.getEvaluatorRef() : (this._pgdef != null ? this._pgdef.getEvaluatorRef() : null);
    }

    public static final ComponentDefinition newShadowDefinition(LanguageDefinition langdef, PageDefinition pgdef, String name, Class<? extends Component> cls, String templateURI) {
        return new ShadowDefinitionImpl(langdef, pgdef, name, cls, templateURI);
    }

    public static final ComponentDefinition newMacroDefinition(LanguageDefinition langdef, PageDefinition pgdef, String name, Class<? extends Component> cls, String macroURI, boolean inline) {
        return new MacroDefinition(langdef, pgdef, name, cls, macroURI, inline);
    }

    public static final ComponentDefinition newNativeDefinition(LanguageDefinition langdef, String name, Class<? extends Component> cls) {
        return new NativeDefinition(langdef, name, cls);
    }

    public void addCustomAttribute(String name, String value) {
        if (name == null || value == null || name.length() == 0 || value.length() == 0) {
            throw new IllegalArgumentException();
        }
        ExValue ev = new ExValue(value, Object.class);
        if (this._custAttrs == null) {
            this._custAttrs = new HashMap<String, ExValue>(4);
        }
        this._custAttrs.put(name, ev);
    }

    public void addAnnotation(String propName, String annotName, Map<String, String[]> annotAttrs, Location loc) {
        if (this._annots == null) {
            this._annots = new AnnotationMap();
        }
        this._annots.addAnnotation(propName, annotName, annotAttrs, loc);
    }

    public String getCurrentDirectory() {
        return this._curdir;
    }

    public void setCurrentDirectory(String curdir) {
        this._curdir = curdir != null && curdir.length() > 0 ? (curdir.charAt(curdir.length() - 1) != '/' ? curdir + '/' : curdir) : null;
    }

    public void setTextAs(String propnm) {
        this._textAs = propnm != null && propnm.length() > 0 ? propnm : null;
    }

    public void setBlankPreserved(boolean preserve) {
        this._blankpresv = preserve;
    }

    public void setChildAllowedInTextAs(boolean allowed) {
        this._childAllowedInTextAs = allowed;
    }

    public void setDeclarationURL(URL url) {
        this._declURL = url;
    }

    @Override
    public LanguageDefinition getLanguageDefinition() {
        return this._langdef;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getTextAs() {
        return this._textAs;
    }

    @Override
    public boolean isChildAllowedInTextAs() {
        return this._childAllowedInTextAs;
    }

    @Override
    public boolean isBlankPreserved() {
        return this._blankpresv;
    }

    @Override
    public boolean isMacro() {
        return false;
    }

    @Override
    public String getMacroURI() {
        return null;
    }

    @Override
    public boolean isInlineMacro() {
        return false;
    }

    @Override
    public boolean isNative() {
        return false;
    }

    @Override
    public Object getImplementationClass() {
        return this._implcls;
    }

    @Override
    public void setImplementationClass(Class<? extends Component> cls) {
        if (!Component.class.isAssignableFrom(cls)) {
            throw new UiException(Component.class.getName() + " must be implemented by " + cls);
        }
        this._implcls = cls;
    }

    @Override
    public void setImplementationClass(String clsnm) {
        if (clsnm == null || clsnm.length() == 0) {
            throw new UiException("Non-empty class name is required");
        }
        this._implcls = clsnm;
    }

    @Override
    public Component newInstance(Page page, String clsnm) {
        try {
            return this.newInstance(this.resolveImplementationClass(page, clsnm));
        }
        catch (ClassNotFoundException ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Component newInstance(Class<? extends Component> cls) {
        Component comp;
        Object curInfo = ComponentsCtrl.getCurrentInfo();
        boolean bSet = true;
        if (curInfo instanceof ComponentInfo) {
            bSet = ((ComponentInfo)curInfo).getComponentDefinition() != this;
        } else if (curInfo instanceof ShadowInfo) {
            boolean bl = bSet = ((ShadowInfo)curInfo).getComponentDefinition() != this;
        }
        if (bSet) {
            ComponentsCtrl.setCurrentInfo(this);
        }
        try {
            try {
                comp = cls.newInstance();
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap(ex);
            }
            Object var7_5 = null;
            if (!bSet) return comp;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (!bSet) throw throwable;
            ComponentsCtrl.setCurrentInfo((ComponentDefinition)null);
            throw throwable;
        }
        ComponentsCtrl.setCurrentInfo((ComponentDefinition)null);
        return comp;
    }

    @Override
    public boolean isInstance(Component comp) {
        Class<?> cls;
        if (this._implcls instanceof String) {
            try {
                cls = this.resolveImplementationClass(comp.getPage(), null);
            }
            catch (ClassNotFoundException ex) {
                return true;
            }
        } else {
            cls = (Class<?>)this._implcls;
        }
        return cls.isInstance(comp);
    }

    @Override
    public Class<?> resolveImplementationClass(Page page, String clsnm) throws ClassNotFoundException {
        Object cls;
        Object object = cls = clsnm != null ? clsnm : this._implcls;
        if (cls instanceof String) {
            Class<?> found;
            clsnm = (String)cls;
            Class<?> clazz = found = page != null ? page.resolveClass(clsnm) : Classes.forNameByThread((String)clsnm);
            if (clsnm.equals(this._implcls)) {
                this._implcls = found;
            }
            return found;
        }
        return (Class)cls;
    }

    @Override
    public AnnotationMap getAnnotationMap() {
        return this._annots;
    }

    @Override
    public String getApply() {
        if (this._apply == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < this._apply.length; ++j) {
            if (j > 0) {
                sb.append(',');
            }
            sb.append(this._apply[j].getRawValue());
        }
        return sb.toString();
    }

    @Override
    public void setApply(String apply) {
        this._apply = Utils.parseList(apply, Object.class, true);
    }

    @Override
    public ExValue[] getParsedApply() {
        return this._apply;
    }

    @Override
    public URL getDeclarationURL() {
        return this._declURL;
    }

    @Override
    public void addProperty(String name, String value) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name");
        }
        Property prop = new Property(this._evalr, name, value, null);
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        this._props.add(prop);
    }

    @Override
    public void applyProperties(Component comp) {
        if (this._props != null) {
            for (Property prop : this._props) {
                prop.assign(comp);
            }
        }
    }

    @Override
    public void applyAttributes(Component comp) {
        if (this._custAttrs != null) {
            for (Map.Entry<String, ExValue> me : this._custAttrs.entrySet()) {
                comp.setAttribute(me.getKey(), me.getValue().getValue((Evaluator)this._evalr, comp));
            }
        }
    }

    @Override
    public Map<String, Object> evalProperties(Map<String, Object> propmap, Page owner, Component parent) {
        if (propmap == null) {
            propmap = new HashMap<String, Object>();
        }
        if (this._props != null) {
            for (Property prop : this._props) {
                if (parent != null) {
                    if (!prop.isEffective(parent)) continue;
                    propmap.put(prop.getName(), prop.getValue(parent));
                    continue;
                }
                if (!prop.isEffective(owner)) continue;
                propmap.put(prop.getName(), prop.getValue(owner));
            }
        }
        return propmap;
    }

    @Override
    public void addMold(String name, String widgetClass) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (this._molds == null) {
            this._molds = new HashMap<String, ExValue>(2);
        }
        this._molds.put(name, new ExValue(widgetClass, String.class));
    }

    @Override
    public boolean hasMold(String name) {
        return this._molds != null && this._molds.containsKey(name);
    }

    @Override
    public Collection<String> getMoldNames() {
        if (this._molds != null) {
            return this._molds.keySet();
        }
        return Collections.emptyList();
    }

    @Override
    public String getWidgetClass(Component comp, String moldName) {
        String s;
        ExValue wc;
        if (this._molds != null && (wc = this._molds.get(moldName)) != null && (s = (String)wc.getValue((Evaluator)this._evalr, comp)) != null) {
            return s;
        }
        return this.getDefaultWidgetClass(comp);
    }

    @Override
    public String getDefaultWidgetClass(Component comp) {
        return this._defWgtClass != null ? (String)this._defWgtClass.getValue((Evaluator)this._evalr, comp) : null;
    }

    @Override
    public void setDefaultWidgetClass(String widgetClass) {
        ExValue oldwc = this._defWgtClass;
        this._defWgtClass = new ExValue(widgetClass, String.class);
        if (oldwc != null && this._molds != null) {
            for (Map.Entry<String, ExValue> me : this._molds.entrySet()) {
                if (!oldwc.equals(me.getValue())) continue;
                me.setValue(this._defWgtClass);
            }
        }
    }

    private String toAbsoluteURI(String uri) {
        char cc;
        if (this._curdir != null && uri != null && uri.length() > 0 && (cc = uri.charAt(0)) != '/' && cc != '~' && !Servlets.isUniversalURL((String)uri)) {
            return this._curdir + uri;
        }
        return uri;
    }

    @Override
    public boolean isShadowElement() {
        return false;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this._langdef != null ? this._langdef.getName() : null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        String langnm = (String)s.readObject();
        if (langnm != null) {
            this._langdef = LanguageDefinition.lookup(langnm);
        }
    }

    public String toString() {
        return "[ComponentDefinition: " + this._name + ']';
    }

    @Override
    public Object clone() {
        ComponentDefinitionImpl compdef;
        try {
            compdef = (ComponentDefinitionImpl)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
        if (this._annots != null) {
            compdef._annots = (AnnotationMap)this._annots.clone();
        }
        if (this._props != null) {
            compdef._props = new LinkedList<Property>(this._props);
        }
        if (this._molds != null) {
            compdef._molds = new HashMap<String, ExValue>(this._molds);
        }
        if (this._custAttrs != null) {
            compdef._custAttrs = new HashMap<String, ExValue>(this._custAttrs);
        }
        return compdef;
    }

    @Override
    public ComponentDefinition clone(LanguageDefinition langdef, String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("empty");
        }
        ComponentDefinitionImpl cd = (ComponentDefinitionImpl)this.clone();
        cd._name = name;
        cd._langdef = langdef;
        return cd;
    }
}

