/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.html.HTMLs;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.util.ConditionImpl;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.ExValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderInfo {
    private final String _name;
    private final List<AttrInfo> _attrs;
    private final ConditionImpl _cond;

    public HeaderInfo(String name, Map<String, String> attrs, ConditionImpl cond) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("empty");
        }
        this._name = name;
        this._cond = cond;
        if (attrs == null || attrs.isEmpty()) {
            this._attrs = Collections.emptyList();
        } else {
            this._attrs = new LinkedList<AttrInfo>();
            for (Map.Entry<String, String> me : attrs.entrySet()) {
                String nm = me.getKey();
                String val = me.getValue();
                this._attrs.add(new AttrInfo(nm, new ExValue(val, String.class)));
            }
        }
    }

    public String getName() {
        return this._name;
    }

    public String toHTML(PageDefinition pgdef, Page page) {
        String nm;
        Evaluator eval = pgdef.getEvaluator();
        if (this._cond != null && !this._cond.isEffective(eval, page)) {
            return "";
        }
        boolean bScript = "script".equals(this._name);
        boolean bStyle = !bScript && "style".equals(this._name);
        StringBuffer sb = new StringBuffer(128);
        if (bScript || bStyle) {
            String content = null;
            boolean srcFound = false;
            for (AttrInfo attr : this._attrs) {
                nm = attr.name;
                if ("content".equals(nm)) {
                    content = (String)attr.value.getValue(eval, page);
                    continue;
                }
                srcFound = srcFound || "src".equals(nm) || "href".equals(nm);
            }
            if (content != null) {
                sb.append('<').append(this._name).append(" type=\"text/").append(bScript ? "javascript" : "css").append("\">\n").append(content).append("\n</").append(this._name).append('>');
                if (srcFound) {
                    sb.append('\n');
                }
            }
            if (!srcFound) {
                return sb.toString();
            }
        }
        sb.append('<').append(bStyle ? "link" : this._name);
        boolean relFound = false;
        boolean typeFound = false;
        for (AttrInfo attr : this._attrs) {
            nm = attr.name;
            if ((bScript || bStyle) && "content".equals(nm)) continue;
            relFound = bStyle && (relFound || "rel".equals(nm));
            typeFound = !(!bScript && !bStyle || !typeFound && !"type".equals(nm));
            String val = (String)attr.value.getValue(eval, page);
            if (val == null || val.length() == 0) {
                val = "";
            } else if ("href".equals(nm) || (bScript || bStyle) && "src".equals(nm)) {
                val = Executions.encodeURL(val);
            }
            HTMLs.appendAttribute((StringBuffer)sb, (String)(bStyle && "src".equals(nm) ? "href" : (bScript && "href".equals(nm) ? "src" : nm)), (String)val);
        }
        if (bStyle && !relFound) {
            sb.append(" rel=\"stylesheet\"");
        }
        if ((bScript || bStyle) && !typeFound) {
            sb.append(" type=\"text/").append(bScript ? "javascript" : "css").append('\"');
        }
        return sb.append(bScript ? ">\n</script>" : "/>").toString();
    }

    private static class AttrInfo {
        private final String name;
        private final ExValue value;

        private AttrInfo(String name, ExValue value) {
            this.name = name;
            this.value = value;
        }
    }
}

