/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.DesktopUnavailableException;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.impl.ExecutionCarryOver;
import org.zkoss.zk.ui.sys.Scheduler;
import org.zkoss.zk.ui.sys.ServerPush;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollingServerPush
implements ServerPush {
    private static final Logger log = LoggerFactory.getLogger(PollingServerPush.class);
    private static final int GIVEUP = -99;
    private Desktop _desktop;
    private final List<ThreadInfo> _pending = new LinkedList<ThreadInfo>();
    private ThreadInfo _active;
    private ExecutionCarryOver _carryOver;
    private final int _min;
    private final int _max;
    private final int _factor;
    private final Object _mutex = new Object();

    public PollingServerPush() {
        this(-1, -1, -1);
    }

    public PollingServerPush(int min, int max, int factor) {
        this._min = min;
        this._max = max;
        this._factor = factor;
    }

    protected void startClientPush() {
        Clients.response("zk.clientpush", new AuScript(null, this.getStartScript()));
    }

    protected void stopClientPush() {
        Clients.response("zk.clientpush", new AuScript(null, this.getStopScript()));
    }

    protected String getStartScript() {
        int factor;
        String start = this._desktop.getWebApp().getConfiguration().getPreference("PollingServerPush.start", null);
        if (start != null) {
            return start;
        }
        StringBuffer sb = new StringBuffer(128).append("zk.load('zk.cpsp');zk.afterLoad(function(){zk.cpsp.start('").append(this._desktop.getId()).append('\'');
        int min = this._min > 0 ? this._min : this.getIntPref("PollingServerPush.delay.min");
        int max = this._max > 0 ? this._max : this.getIntPref("PollingServerPush.delay.max");
        int n = factor = this._factor > 0 ? this._factor : this.getIntPref("PollingServerPush.delay.factor");
        if (min > 0 || max > 0 || factor > 0) {
            sb.append(',').append(min).append(',').append(max).append(',').append(factor);
        }
        return sb.append(");});").toString();
    }

    private int getIntPref(String key) {
        String s = this._desktop.getWebApp().getConfiguration().getPreference(key, null);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                log.warn("Not a number specified at " + key);
            }
        }
        return -1;
    }

    protected String getStopScript() {
        String stop = this._desktop.getWebApp().getConfiguration().getPreference("PollingServerPush.stop", null);
        return stop != null ? stop : "zk.cpsp.stop('" + this._desktop.getId() + "');";
    }

    @Override
    public boolean isActive() {
        return this._active != null && this._active.nActive > 0;
    }

    @Override
    public void start(Desktop desktop) {
        if (this._desktop != null) {
            log.warn("Ignored: Sever-push already started");
            return;
        }
        this._desktop = desktop;
        this.startClientPush();
    }

    @Override
    public void resume() {
        if (this._desktop == null) {
            throw new IllegalStateException("ServerPush cannot be resumed without desktop, or has been stopped!call #start(desktop)} instead");
        }
        this.startClientPush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        block10: {
            Object object;
            if (this._desktop == null) {
                log.warn("Ignored: Sever-push not started");
                return;
            }
            Execution exec = Executions.getCurrent();
            boolean inexec = exec != null && exec.getDesktop() == this._desktop;
            try {
                if (inexec && this._desktop.isAlive()) {
                    this.stopClientPush();
                }
                Object var4_3 = null;
                this._desktop = null;
                this.wakePending();
                if (inexec) break block10;
                object = this._mutex;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this._desktop = null;
                this.wakePending();
                if (!inexec) {
                    Object object2 = this._mutex;
                    synchronized (object2) {
                        this._mutex.notify();
                    }
                }
                throw throwable;
            }
            synchronized (object) {
                this._mutex.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakePending() {
        List<ThreadInfo> list = this._pending;
        synchronized (list) {
            Iterator<ThreadInfo> i$ = this._pending.iterator();
            while (i$.hasNext()) {
                ThreadInfo info;
                ThreadInfo threadInfo = info = i$.next();
                synchronized (threadInfo) {
                    info.notify();
                }
            }
            this._pending.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPiggyback() {
        if (this._desktop == null) {
            return;
        }
        Configuration config = this._desktop.getWebApp().getConfiguration();
        long tmexpired = 0L;
        int cnt = 0;
        while (!this._pending.isEmpty()) {
            ThreadInfo info;
            if (tmexpired == 0L) {
                tmexpired = System.currentTimeMillis() + (long)(config.getMaxProcessTime() >> 1);
                cnt = this._pending.size() + 3;
            } else if (--cnt < 0 || System.currentTimeMillis() > tmexpired) break;
            Object object = this._pending;
            synchronized (object) {
                if (this._pending.isEmpty()) {
                    return;
                }
                info = this._pending.remove(0);
            }
            object = this._mutex;
            synchronized (object) {
                this._carryOver = new ExecutionCarryOver(this._desktop);
                ThreadInfo threadInfo = info;
                synchronized (threadInfo) {
                    if (info.nActive == -99) {
                        continue;
                    }
                    info.nActive = 1;
                    info.notify();
                }
                if (this._desktop == null) {
                    break;
                }
                try {
                    this._mutex.wait();
                }
                catch (InterruptedException ex) {
                    throw UiException.Aide.wrap(ex);
                }
            }
        }
    }

    @Override
    public <T extends Event> void schedule(EventListener<T> listener, T event, Scheduler<T> scheduler) {
        scheduler.schedule(listener, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean activate(long timeout) throws InterruptedException, DesktopUnavailableException {
        boolean loop;
        Thread curr = Thread.currentThread();
        if (this._active != null && this._active.thread.equals(curr)) {
            ++this._active.nActive;
            return true;
        }
        ThreadInfo info = new ThreadInfo(curr);
        List<ThreadInfo> list = this._pending;
        synchronized (list) {
            if (this._desktop != null) {
                this._pending.add(info);
            }
        }
        do {
            loop = false;
            ThreadInfo threadInfo = info;
            synchronized (threadInfo) {
                if (this._desktop != null) {
                    if (info.nActive == 0) {
                        info.wait(timeout <= 0L ? 600000L : timeout);
                    }
                    if (info.nActive <= 0) {
                        boolean bDead;
                        boolean bTimeout = timeout > 0L;
                        boolean bl = bDead = this._desktop == null || !this._desktop.isAlive();
                        if (bTimeout || bDead) {
                            info.nActive = -99;
                            List<ThreadInfo> list2 = this._pending;
                            synchronized (list2) {
                                this._pending.remove(info);
                            }
                            if (bDead) {
                                throw new DesktopUnavailableException("Stopped");
                            }
                            return false;
                        }
                        log.debug("Executions.activate() took more than 10 minutes");
                        loop = true;
                    }
                }
            }
        } while (loop);
        if (this._desktop == null) {
            throw new DesktopUnavailableException("Stopped");
        }
        this._carryOver.carryOver();
        this._active = info;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deactivate(boolean stop) {
        boolean stopped = false;
        if (this._active != null && Thread.currentThread().equals(this._active.thread) && --this._active.nActive <= 0) {
            if (stop) {
                this.stopClientPush();
            }
            this._carryOver.cleanup();
            this._carryOver = null;
            this._active.nActive = 0;
            this._active = null;
            if (stop) {
                this.wakePending();
                this._desktop = null;
                stopped = true;
            }
            Object object = this._mutex;
            synchronized (object) {
                this._mutex.notify();
            }
            try {
                Thread.sleep(100L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return stopped;
    }

    private static class ThreadInfo {
        private final Thread thread;
        private int nActive;

        private ThreadInfo(Thread thread) {
            this.thread = thread;
        }

        public String toString() {
            return "[" + this.thread + ',' + this.nActive + ']';
        }
    }
}

