/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Strings;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.http.HttpBufferedResponse;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.http.I18Ns;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.impl.RequestInfoImpl;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.sys.RequestInfo;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.UiFactory;
import org.zkoss.zk.ui.sys.WebAppCtrl;

public class DHtmlLayoutFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(DHtmlLayoutFilter.class);
    private ServletContext _ctx;
    private String _ext = "html";
    private String _charset = "UTF-8";
    private boolean _compress = true;

    protected void process(HttpServletRequest request, HttpServletResponse response, String content) throws ServletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("Content to filter:\n" + content);
        }
        WebManager webman = WebManager.getWebManager(this._ctx);
        WebApp wapp = webman.getWebApp();
        WebAppCtrl wappc = (WebAppCtrl)((Object)wapp);
        Session sess = WebManager.getSession(this._ctx, request);
        Object old = I18Ns.setup(sess, (ServletRequest)request, (ServletResponse)response, this._charset);
        try {
            String path = Https.getThisServletPath((ServletRequest)request);
            Desktop desktop = webman.getDesktop(sess, (ServletRequest)request, (ServletResponse)response, path, true);
            if (desktop == null) {
                return;
            }
            RequestInfoImpl ri = new RequestInfoImpl(wapp, sess, desktop, request, null);
            ((SessionCtrl)((Object)sess)).notifyClientRequest(true);
            UiFactory uf = wappc.getUiFactory();
            PageDefinition pagedef = uf.getPageDefinitionDirectly((RequestInfo)ri, content, this._ext);
            Page page = WebManager.newPage(uf, (RequestInfo)ri, pagedef, (ServletResponse)response, path);
            ExecutionImpl exec = new ExecutionImpl(this._ctx, request, response, desktop, page);
            StringWriter out = new StringWriter(8192);
            wappc.getUiEngine().execNewPage((Execution)exec, pagedef, page, (Writer)out);
            String cs = response.getCharacterEncoding();
            if (cs == null || cs.length() == 0) {
                cs = this._charset != null ? this._charset : "UTF-8";
            }
            String result = out.toString();
            try {
                byte[] bs;
                ServletOutputStream os = response.getOutputStream();
                byte[] data = result.getBytes(cs);
                if (this._compress && !Servlets.isIncluded((ServletRequest)request) && data.length > 200 && (bs = Https.gzip((HttpServletRequest)request, (HttpServletResponse)response, null, (byte[])data)) != null) {
                    data = bs;
                }
                response.setContentLength(data.length);
                os.write(data);
            }
            catch (IllegalStateException ex) {
                response.getWriter().write(result);
            }
        }
        catch (UiException ex) {
            log.error("Failed to process:\n" + content);
            throw ex;
        }
        finally {
            I18Ns.cleanup((ServletRequest)request, old);
        }
    }

    private static String xmlfilter(StringBuffer sb) {
        int len = sb.length();
        block0: for (int j = 0; j < len; ++j) {
            char cc = sb.charAt(j);
            if (cc != '<') continue;
            if (++j >= len || sb.charAt(j) != '!' || (j = Strings.skipWhitespaces((CharSequence)sb, (int)(j + 1))) + 7 >= len || !"DOCTYPE".equalsIgnoreCase(sb.substring(j, j + 7))) break;
            for (int k = j += 7; k < len; ++k) {
                if (sb.charAt(k) != '>') continue;
                if (!DHtmlLayoutFilter.shallFilter(sb.substring(j, k))) break block0;
                return sb.substring(k + 1);
            }
            break;
        }
        return sb.toString();
    }

    private static boolean shallFilter(String pubId) {
        int j = (pubId = pubId.toUpperCase()).indexOf("//DTD");
        if (j >= 0) {
            return (j = Strings.skipWhitespaces((CharSequence)pubId, (int)(j + 5))) + 4 < pubId.length() && "HTML".equals(pubId.substring(j, j + 4));
        }
        return false;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        StringWriter sw = new StringWriter(8192);
        HttpServletResponse hres = (HttpServletResponse)response;
        HttpBufferedResponse hbufres = (HttpBufferedResponse)HttpBufferedResponse.getInstance((HttpServletResponse)hres, (Writer)sw);
        chain.doFilter(request, (ServletResponse)hbufres);
        if (!hbufres.isSendRedirect()) {
            this.process((HttpServletRequest)request, hres, DHtmlLayoutFilter.xmlfilter(sw.getBuffer()));
        }
    }

    public void destroy() {
    }

    public final void init(FilterConfig config) throws ServletException {
        this._ctx = config.getServletContext();
        String param = config.getInitParameter("extension");
        if (param != null && param.length() > 0) {
            this._ext = param;
        }
        if ((param = config.getInitParameter("charset")) != null) {
            String string = this._charset = param.length() > 0 ? param : null;
        }
        if ((param = config.getInitParameter("compress")) != null) {
            this._compress = "true".equals(param);
        }
    }
}

