/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.scripting.bsh;

import bsh.BshClassManager;
import bsh.BshMethod;
import bsh.EvalError;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.UtilEvalError;
import bsh.Variable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.lang.reflect.Fields;
import org.zkoss.xel.Function;
import org.zkoss.zk.scripting.HierachicalAware;
import org.zkoss.zk.scripting.Interpreter;
import org.zkoss.zk.scripting.SerializableAware;
import org.zkoss.zk.scripting.bsh.NSWrap;
import org.zkoss.zk.scripting.util.GenericInterpreter;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.Scope;
import org.zkoss.zk.ui.ext.ScopeListener;
import org.zkoss.zk.ui.sys.ExecutionCtrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BSHInterpreter
extends GenericInterpreter
implements SerializableAware,
HierachicalAware {
    static final Logger log = LoggerFactory.getLogger(BSHInterpreter.class);
    private static final String VAR_NSW = "z_bshnsw";
    private bsh.Interpreter _ip;
    private GlobalNS _bshns;
    private static final String[] _nonSerNames = new String[]{"log", "page", "desktop", "pageScope", "desktopScope", "applicationScope", "requestScope", "spaceOwner", "session", "sessionScope", "execution"};

    protected void loadDefaultImports(NameSpace bshns) {
    }

    @Override
    protected void exec(String script) {
        try {
            Scope scope = this.getCurrent();
            if (scope != null) {
                this._ip.eval(script, this.prepareNS(scope));
            } else {
                this._ip.eval(script);
            }
        }
        catch (EvalError ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    @Override
    protected boolean contains(String name) {
        try {
            return this._ip.getNameSpace().getVariable(name) != Primitive.VOID;
        }
        catch (UtilEvalError ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    @Override
    protected boolean contains(Scope scope, String name) {
        NameSpace bshns;
        if (scope != null && (bshns = this.prepareNS(scope)) != this._bshns) {
            try {
                return bshns.getVariable(name) != Primitive.VOID;
            }
            catch (UtilEvalError ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
        return this.contains(name);
    }

    @Override
    protected Object get(String name) {
        try {
            return Primitive.unwrap((Object)this._ip.get(name));
        }
        catch (EvalError ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    @Override
    protected Object get(Scope scope, String name) {
        NameSpace bshns;
        if (scope != null && (bshns = this.prepareNS(scope)) != this._bshns) {
            try {
                return Primitive.unwrap((Object)bshns.getVariable(name));
            }
            catch (UtilEvalError ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
        return this.get(name);
    }

    @Override
    protected void set(String name, Object val) {
        try {
            this._ip.set(name, val);
        }
        catch (EvalError ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    @Override
    protected void set(Scope scope, String name, Object val) {
        NameSpace bshns;
        if (scope != null && (bshns = this.prepareNS(scope)) != this._bshns) {
            try {
                bshns.setVariable(name, val != null ? val : Primitive.NULL, false);
                return;
            }
            catch (UtilEvalError ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
        this.set(name, val);
    }

    @Override
    protected void unset(String name) {
        try {
            this._ip.unset(name);
        }
        catch (EvalError ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    @Override
    protected void unset(Scope scope, String name) {
        NameSpace bshns;
        if (scope != null && (bshns = this.prepareNS(scope)) != this._bshns) {
            bshns.unsetVariable(name);
            return;
        }
        this.unset(name);
    }

    @Override
    public void init(Page owner, String zslang) {
        super.init(owner, zslang);
        this._ip = new bsh.Interpreter();
        this._ip.setClassLoader(Classes.getContextClassLoader(BSHInterpreter.class));
        this._bshns = new GlobalNS(this._ip.getClassManager(), "global");
        this._ip.setNameSpace((NameSpace)this._bshns);
    }

    @Override
    public void destroy() {
        this.getOwner().removeAttribute(VAR_NSW);
        try {
            this._bshns.clear();
            this._ip.setNameSpace(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this._ip = null;
        this._bshns = null;
        super.destroy();
    }

    @Override
    public Object getNativeInterpreter() {
        return this._ip;
    }

    @Override
    public Class<?> getClass(String clsnm) {
        try {
            return this._bshns.getClass(clsnm);
        }
        catch (UtilEvalError ex) {
            throw new UiException("Failed to load class " + clsnm, (Throwable)ex);
        }
    }

    @Override
    public Function getFunction(String name, Class[] argTypes) {
        return this.getFunction0(this._bshns, name, argTypes);
    }

    @Override
    public Function getFunction(Scope scope, String name, Class[] argTypes) {
        return this.getFunction0(this.prepareNS(scope), name, argTypes);
    }

    private Function getFunction0(NameSpace bshns, String name, Class[] argTypes) {
        try {
            BshMethod m = bshns.getMethod(name, argTypes != null ? argTypes : new Class[]{}, false);
            return m != null ? new BSHFunction(m) : null;
        }
        catch (UtilEvalError ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    private NameSpace prepareNS(Scope scope) {
        if ((scope = BSHInterpreter.getIdSpace(scope)) == null || scope == this.getOwner()) {
            return this._bshns;
        }
        NSWrap nsw = (NSWrap)scope.getAttribute(VAR_NSW);
        if (nsw != null) {
            return nsw.unwrap(scope);
        }
        NS bshns = this.newNS(scope);
        scope.setAttribute(VAR_NSW, NSWrap.getInstance(bshns));
        return bshns;
    }

    NS newNS(Scope scope) {
        Scope p = BSHInterpreter.getParentIdSpace(scope = BSHInterpreter.getIdSpace(scope));
        return new NS((NameSpace)(p != null ? this.prepareNS(p) : this._bshns), this._ip.getClassManager(), scope);
    }

    private static NameSpace prepareDetachedNS(Scope scope) {
        if ((scope = BSHInterpreter.getIdSpace(scope)) == null) {
            return null;
        }
        NSWrap nsw = (NSWrap)scope.getAttribute(VAR_NSW);
        if (nsw != null) {
            return nsw.unwrap(scope);
        }
        Scope p = BSHInterpreter.getParentIdSpace(scope);
        NS bshns = new NS(p != null ? BSHInterpreter.prepareDetachedNS(p) : null, null, scope);
        scope.setAttribute(VAR_NSW, NSWrap.getInstance(bshns));
        return bshns;
    }

    static BSHInterpreter getInterpreter(Scope scope) {
        Page owner = BSHInterpreter.getPage(scope);
        if (owner != null) {
            for (Interpreter ip : owner.getLoadedInterpreters()) {
                if (!(ip instanceof BSHInterpreter)) continue;
                return (BSHInterpreter)ip;
            }
        }
        return null;
    }

    private static Scope getIdSpace(Scope scope) {
        if (scope instanceof IdSpace) {
            return scope;
        }
        if (scope instanceof Component && (scope = ((Component)scope).getSpaceOwner()) != null) {
            return scope;
        }
        return null;
    }

    private static Scope getParentIdSpace(Scope scope) {
        if (scope == null || !(scope instanceof Component)) {
            return null;
        }
        Component p = ((Component)scope).getParent();
        return p != null ? p.getSpaceOwner() : null;
    }

    private static Page getPage(Scope scope) {
        return scope instanceof Component ? ((Component)scope).getPage() : (scope instanceof Page ? (Page)scope : null);
    }

    @Override
    public void write(ObjectOutputStream s, SerializableAware.Filter filter) throws IOException {
        BSHInterpreter.write(this._bshns, s, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void write(NameSpace ns, ObjectOutputStream s, SerializableAware.Filter filter) throws IOException {
        int j;
        String[] vars = ns.getVariableNames();
        int n = j = vars != null ? vars.length : 0;
        while (--j >= 0) {
            String nm = vars[j];
            if (nm == null || "bsh".equals(nm) || !BSHInterpreter.isVariableSerializable(nm)) continue;
            try {
                Object val = ns.getVariable(nm, false);
                if (val != null && !(val instanceof Serializable) && !(val instanceof Externalizable) || val instanceof Component || filter != null && !filter.accept(nm, val)) continue;
                s.writeObject(nm);
                s.writeObject(val);
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                log.warn("Ignored failure to write " + nm, ex);
            }
        }
        s.writeObject(null);
        if (BSHInterpreter.shallSerializeMethod()) {
            int j2;
            BshMethod[] mtds = ns.getMethods();
            int n2 = j2 = mtds != null ? mtds.length : 0;
            while (--j2 >= 0) {
                String nm = mtds[j2].getName();
                if (!BSHInterpreter.isMethodSerializable(nm) || filter != null && !filter.accept(nm, mtds[j2])) continue;
                Field f = null;
                boolean acs = false;
                try {
                    f = Classes.getAnyField(BshMethod.class, (String)"declaringNameSpace");
                    acs = f.isAccessible();
                    Fields.setAccessible((AccessibleObject)f, (boolean)true);
                    Object old = f.get(mtds[j2]);
                    try {
                        f.set(mtds[j2], null);
                        s.writeObject(mtds[j2]);
                    }
                    finally {
                        f.set(mtds[j2], old);
                    }
                }
                catch (IOException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    log.warn("Ignored failure to write " + nm, ex);
                }
                finally {
                    if (f != null) {
                        Fields.setAccessible((AccessibleObject)f, (boolean)acs);
                    }
                }
            }
        }
        s.writeObject(null);
        Field f = null;
        boolean acs = false;
        try {
            f = Classes.getAnyField(NameSpace.class, (String)"importedClasses");
            acs = f.isAccessible();
            Fields.setAccessible((AccessibleObject)f, (boolean)true);
            Map clses = (Map)f.get(ns);
            if (clses != null) {
                for (String clsnm : clses.values()) {
                    if (clsnm.startsWith("bsh.")) continue;
                    s.writeObject(clsnm);
                }
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            log.warn("Ignored failure to write imported classes", ex);
        }
        finally {
            if (f != null) {
                Fields.setAccessible((AccessibleObject)f, (boolean)acs);
            }
        }
        s.writeObject(null);
        f = null;
        acs = false;
        try {
            f = Classes.getAnyField(NameSpace.class, (String)"importedPackages");
            acs = f.isAccessible();
            Fields.setAccessible((AccessibleObject)f, (boolean)true);
            Collection pkgs = (Collection)f.get(ns);
            if (pkgs != null) {
                for (String pkgnm : pkgs) {
                    if (pkgnm.startsWith("java.awt") || pkgnm.startsWith("javax.swing")) continue;
                    s.writeObject(pkgnm);
                }
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            log.warn("Ignored failure to write imported packages", ex);
        }
        finally {
            if (f != null) {
                Fields.setAccessible((AccessibleObject)f, (boolean)acs);
            }
        }
        s.writeObject(null);
    }

    @Override
    public void read(ObjectInputStream s) throws IOException, ClassNotFoundException {
        BSHInterpreter.read(this._bshns, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void read(NameSpace ns, ObjectInputStream s) throws IOException {
        String nm;
        while (true) {
            try {
                while ((nm = (String)s.readObject()) != null) {
                    ns.setVariable(nm, s.readObject(), false);
                }
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                log.warn("Ignored failure to read", ex);
                continue;
            }
            break;
        }
        while (true) {
            try {
                BshMethod mtd;
                while ((mtd = (BshMethod)s.readObject()) != null) {
                    Field f = null;
                    boolean acs = false;
                    try {
                        f = Classes.getAnyField(BshMethod.class, (String)"declaringNameSpace");
                        acs = f.isAccessible();
                        Fields.setAccessible((AccessibleObject)f, (boolean)true);
                        f.set(mtd, ns);
                    }
                    finally {
                        if (f != null) {
                            Fields.setAccessible((AccessibleObject)f, (boolean)acs);
                        }
                    }
                    ns.setMethod(mtd.getName(), mtd);
                }
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                log.warn("Ignored failure to read", ex);
                continue;
            }
            break;
        }
        while (true) {
            try {
                while ((nm = (String)s.readObject()) != null) {
                    ns.importClass(nm);
                }
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                log.warn("Ignored failure to read", ex);
                continue;
            }
            break;
        }
        while (true) {
            try {
                while ((nm = (String)s.readObject()) != null) {
                    ns.importPackage(nm);
                }
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                log.warn("Ignored failure to read", ex);
                continue;
            }
            break;
        }
    }

    private static boolean isVariableSerializable(String name) {
        int j = _nonSerNames.length;
        while (--j >= 0) {
            if (!_nonSerNames[j].equals(name)) continue;
            return false;
        }
        return true;
    }

    private static boolean isMethodSerializable(String name) {
        return !"alert".equals(name);
    }

    private static boolean shallSerializeMethod() {
        String s = Library.getProperty((String)"org.zkoss.zk.scripting.bsh.method.serializable");
        return s == null || !"false".equals(s);
    }

    private class BSHFunction
    implements Function {
        private final BshMethod _method;

        private BSHFunction(BshMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("null");
            }
            this._method = method;
        }

        public Class[] getParameterTypes() {
            return this._method.getParameterTypes();
        }

        public Class getReturnType() {
            return this._method.getReturnType();
        }

        public Object invoke(Object obj, Object ... args) throws Exception {
            return this._method.invoke(args != null ? args : new Object[]{}, BSHInterpreter.this._ip);
        }

        public Method toMethod() {
            return null;
        }
    }

    private static class NSCListener
    implements ScopeListener {
        private final NS _bshns;

        private NSCListener(NS bshns) {
            this._bshns = bshns;
        }

        public void attributeAdded(Scope scope, String name, Object value) {
        }

        public void attributeReplaced(Scope scope, String name, Object value) {
        }

        public void attributeRemoved(Scope scope, String name) {
        }

        public void parentChanged(Scope scope, Scope newparent) {
        }

        public void idSpaceChanged(Scope scope, IdSpace newIdSpace) {
            if (newIdSpace instanceof Scope) {
                BSHInterpreter ip = BSHInterpreter.getInterpreter(this._bshns._scope);
                this._bshns.setParent(ip != null ? ip.prepareNS(newIdSpace) : BSHInterpreter.prepareDetachedNS(newIdSpace));
                return;
            }
            this._bshns.setParent(null);
        }
    }

    static class NS
    extends AbstractNS {
        private Scope _scope;

        private NS(NameSpace parent, BshClassManager classManager, Scope scope) {
            super(parent, classManager, "scope" + System.identityHashCode(scope));
            this._scope = scope;
            this._scope.addScopeListener(new NSCListener(this));
        }

        protected Object getFromScope(String name) {
            Component comp;
            Object val;
            Scope curr;
            BSHInterpreter ip = BSHInterpreter.getInterpreter(this._scope);
            Scope scope = curr = ip != null ? ip.getCurrent() : null;
            if (curr == null) {
                return BSHInterpreter.getImplicit(name);
            }
            if (this._firstGet) {
                this._firstGet = false;
                Execution exec = Executions.getCurrent();
                if (exec != null && exec != curr) {
                    Object object = val = exec instanceof ExecutionCtrl ? ((ExecutionCtrl)((Object)exec)).getExtraXelVariable(name) : null;
                    if (val != null) {
                        return val;
                    }
                    val = exec.getAttribute(name);
                    if (val != null) {
                        return val;
                    }
                }
                if (curr != this._scope && curr instanceof Component) {
                    for (Component c = (Component)curr; c != null && c != this._scope; c = c.getParent()) {
                        Object o = c.getShadowVariable((Component)curr, name, false);
                        if (o == null) continue;
                        return o;
                    }
                }
            }
            return (val = (comp = (Component)this._scope).getAttributeOrFellow(name, false)) != null || comp.hasAttributeOrFellow(name, false) ? val : BSHInterpreter.getImplicit(name);
        }
    }

    private class GlobalNS
    extends AbstractNS {
        private GlobalNS(BshClassManager classManager, String name) {
            super(null, classManager, name);
        }

        protected Object getFromScope(String name) {
            Page page;
            Object val;
            Scope curr = BSHInterpreter.this.getCurrent();
            if (curr == null) {
                return BSHInterpreter.getImplicit(name);
            }
            if (this._firstGet) {
                Object o;
                this._firstGet = false;
                Execution exec = Executions.getCurrent();
                if (exec != null) {
                    Object object = val = exec instanceof ExecutionCtrl ? ((ExecutionCtrl)((Object)exec)).getExtraXelVariable(name) : null;
                    if (val != null) {
                        return val;
                    }
                    val = exec.getAttribute(name);
                    if (val != null) {
                        return val;
                    }
                }
                if (curr instanceof Component && (o = ((Component)curr).getShadowVariable(name, true)) != null) {
                    return o;
                }
            }
            if ((val = (page = BSHInterpreter.this.getOwner()).getAttributeOrFellow(name, true)) != null || page.hasAttributeOrFellow(name, true)) {
                return val;
            }
            val = page.getXelVariable(null, null, name, true);
            return val != null ? val : BSHInterpreter.getImplicit(name);
        }

        public void loadDefaultImports() {
            BSHInterpreter.this.loadDefaultImports(this);
        }
    }

    private static abstract class AbstractNS
    extends NameSpace {
        private boolean _inGet;
        protected boolean _firstGet;

        protected AbstractNS(NameSpace parent, BshClassManager classManager, String name) {
            super(parent, classManager, name);
        }

        protected abstract Object getFromScope(String var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Variable getVariableImpl(String name, boolean recurse) throws UtilEvalError {
            Variable var = super.getVariableImpl(name, false);
            if (!this._inGet && var == null) {
                this._firstGet = true;
                Object v = this.getFromScope(name);
                if (v != GenericInterpreter.UNDEFINED) {
                    this._inGet = true;
                    try {
                        this.setVariable(name, v != null ? v : Primitive.NULL, false);
                        var = super.getVariableImpl(name, false);
                        this.unsetVariable(name);
                    }
                    finally {
                        this._inGet = false;
                    }
                }
                if (var == null && recurse) {
                    NameSpace parent = this.getParent();
                    if (parent instanceof AbstractNS) {
                        var = ((AbstractNS)parent).getVariableImpl(name, true);
                    } else if (parent != null) {
                        try {
                            Method m = NameSpace.class.getDeclaredMethod("getVariableImpl", String.class, Boolean.TYPE);
                            m.setAccessible(true);
                            var = (Variable)m.invoke((Object)parent, name, Boolean.TRUE);
                        }
                        catch (Exception ex) {
                            throw UiException.Aide.wrap(ex);
                        }
                    }
                }
            }
            return var;
        }

        public void loadDefaultImports() {
        }
    }
}

