/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.scripting;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.idom.Element;
import org.zkoss.idom.util.IDOMs;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Generics;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.scripting.Interpreter;
import org.zkoss.zk.scripting.InterpreterNotFoundException;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interpreters {
    private static final Logger log = LoggerFactory.getLogger(Interpreters.class);
    private static final Map<String, Object> _ips = new HashMap<String, Object>();
    private static final Set<String> _zslangs = Collections.synchronizedSet(new LinkedHashSet());

    private Interpreters() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Interpreter newInterpreter(String zslang, Page owner) {
        Class cls;
        Object clsnm;
        if (zslang == null || zslang.length() == 0 || owner == null) {
            throw new IllegalArgumentException("empty or null");
        }
        String zsl = zslang.toLowerCase(Locale.ENGLISH);
        Map<String, Object> map = _ips;
        synchronized (map) {
            clsnm = _ips.get(zsl);
        }
        if (clsnm == null) {
            throw new InterpreterNotFoundException(zslang, MZk.NOT_FOUND, zslang);
        }
        if (clsnm instanceof Class) {
            cls = Generics.cast((Class)((Class)clsnm));
        } else {
            Class c;
            try {
                c = Classes.forNameByThread((String)((String)clsnm));
            }
            catch (ClassNotFoundException ex) {
                throw new UiException("Failed to load class " + clsnm);
            }
            if (!Interpreter.class.isAssignableFrom(c)) {
                throw new IllegalArgumentException(c + " must implements " + Interpreter.class);
            }
            cls = Generics.cast((Class)c);
            Map<String, Object> map2 = _ips;
            synchronized (map2) {
                Object old = _ips.put(zsl, cls);
                if (old != clsnm) {
                    _ips.put(zsl, old);
                }
            }
        }
        try {
            Interpreter ip = (Interpreter)cls.newInstance();
            ip.init(owner, zslang);
            return ip;
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap((Throwable)ex, "Unable to create " + cls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean exists(String zslang) {
        if (zslang == null) {
            return false;
        }
        zslang = zslang.toLowerCase(Locale.ENGLISH);
        Map<String, Object> map = _ips;
        synchronized (map) {
            return _ips.containsKey(zslang);
        }
    }

    public static final Set<String> getZScriptLanguages() {
        return _zslangs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String add(String zslang, String ipcls) {
        Object old;
        if (zslang == null || zslang.length() == 0 || ipcls == null || ipcls.length() == 0) {
            throw new IllegalArgumentException("emty or null");
        }
        int j = zslang.length();
        while (--j >= 0) {
            char cc = zslang.charAt(j);
            if (Interpreters.isLegalName(cc)) continue;
            throw new IllegalArgumentException(39 + cc + "' not allowed in a language name, " + zslang);
        }
        if (log.isDebugEnabled()) {
            log.debug("Scripting language is added: " + zslang + ", " + ipcls);
        }
        _zslangs.add(zslang);
        String zsl = zslang.toLowerCase(Locale.ENGLISH);
        Map<String, Object> map = _ips;
        synchronized (map) {
            old = _ips.put(zsl, ipcls);
        }
        return old instanceof Class ? ((Class)old).getName() : (String)old;
    }

    public static final String add(Element config) {
        String zslang = IDOMs.getRequiredElementValue((Element)config, (String)"language-name");
        String clsnm = IDOMs.getRequiredElementValue((Element)config, (String)"interpreter-class");
        return Interpreters.add(zslang, clsnm);
    }

    public static boolean isLegalName(char cc) {
        return cc >= 'a' && cc <= 'z' || cc >= 'A' && cc <= 'Z' || cc >= '0' && cc <= '9' || cc == '_';
    }
}

