/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.math.BigDecimal;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.util.PaymentUtil;
import org.compiere.grid.PaymentForm;
import org.compiere.model.GridTab;
import org.compiere.model.MBankAccountProcessor;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentProcessor;
import org.compiere.model.MPaymentTransaction;
import org.compiere.model.MPaymentValidate;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public abstract class PaymentFormCreditCard
extends PaymentForm {
    private static final String PAYMENTRULE = "K";
    public int m_C_Payment_ID = 0;
    public MPayment m_mPayment = null;
    public MPayment m_mPaymentOriginal = null;
    public MPaymentTransaction m_mPaymentTransaction = null;
    public String m_CCType = "";
    public ValueNamePair selectedCreditCard;
    public String processMsg = null;

    public PaymentFormCreditCard(int windowNo, GridTab mTab) {
        super(windowNo, mTab);
    }

    @Override
    public void loadData() {
        int C_Invoice_ID;
        int C_Order_ID;
        if (this.getGridTab().getValue("C_Payment_ID") != null) {
            this.m_C_Payment_ID = (Integer)this.getGridTab().getValue("C_Payment_ID");
            if (this.m_C_Payment_ID != 0) {
                this.m_mPayment = new MPayment(Env.getCtx(), this.m_C_Payment_ID, null);
                this.m_mPaymentOriginal = new MPayment(Env.getCtx(), this.m_C_Payment_ID, null);
            }
        }
        if (this.m_mPayment == null || this.m_mPayment.getC_Payment_ID() == 0) {
            int[] ids;
            C_Order_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getWindowNo(), (String)"C_Order_ID");
            C_Invoice_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getWindowNo(), (String)"C_Invoice_ID");
            if (C_Invoice_ID == 0 && this.m_DocStatus.equals("CO")) {
                C_Invoice_ID = this.getInvoiceID(C_Order_ID);
            }
            boolean found = false;
            if ((C_Order_ID > 0 || C_Invoice_ID > 0) && (ids = MPaymentTransaction.getAuthorizationPaymentTransactionIDs((int)C_Order_ID, (int)C_Invoice_ID, null)).length > 0) {
                MPaymentTransaction pt;
                int id;
                int n;
                int n2;
                int[] nArray;
                if (C_Invoice_ID > 0) {
                    nArray = ids;
                    n2 = ids.length;
                    n = 0;
                    while (n < n2) {
                        id = nArray[n];
                        pt = new MPaymentTransaction(Env.getCtx(), id, null);
                        if (pt.getC_Invoice_ID() == C_Invoice_ID) {
                            this.m_mPaymentTransaction = new MPaymentTransaction(Env.getCtx(), id, null);
                            found = true;
                            break;
                        }
                        ++n;
                    }
                }
                if (!found) {
                    nArray = ids;
                    n2 = ids.length;
                    n = 0;
                    while (n < n2) {
                        id = nArray[n];
                        pt = new MPaymentTransaction(Env.getCtx(), id, null);
                        if (pt.getC_Order_ID() == C_Order_ID) {
                            this.m_mPaymentTransaction = new MPaymentTransaction(Env.getCtx(), id, null);
                            break;
                        }
                        ++n;
                    }
                }
            }
        }
        if (this.m_mPayment == null || this.m_mPayment.getC_Payment_ID() == 0) {
            int[] ids;
            MDocType mDocType;
            C_Order_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getWindowNo(), (String)"C_Order_ID");
            C_Invoice_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getWindowNo(), (String)"C_Invoice_ID");
            if (C_Invoice_ID == 0 && this.m_DocStatus.equals("CO")) {
                C_Invoice_ID = this.getInvoiceID(C_Order_ID);
            }
            BigDecimal grandTotal = (BigDecimal)this.getGridTab().getValue("GrandTotal");
            boolean isCreditMemo = false;
            int doctype = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getWindowNo(), (String)"C_DocTypeTarget_ID");
            if (doctype > 0 && "ARC".equals((mDocType = MDocType.get((Properties)Env.getCtx(), (int)doctype)).getDocBaseType())) {
                isCreditMemo = true;
            }
            boolean found = false;
            if ((C_Order_ID > 0 || C_Invoice_ID > 0) && (ids = MPayment.getCompletedPaymentIDs((int)C_Order_ID, (int)C_Invoice_ID, null)).length > 0) {
                BigDecimal payAmt;
                MPayment p;
                int n;
                int[] nArray;
                if (C_Invoice_ID > 0) {
                    nArray = ids;
                    n = ids.length;
                    int n3 = 0;
                    while (n3 < n) {
                        int id = nArray[n3];
                        p = new MPayment(Env.getCtx(), id, null);
                        payAmt = p.getPayAmt();
                        if (isCreditMemo) {
                            payAmt = payAmt.negate();
                        }
                        if (p.getC_Invoice_ID() == C_Invoice_ID && payAmt.compareTo(grandTotal) >= 0) {
                            this.m_C_Payment_ID = id;
                            this.m_mPayment = p;
                            this.m_mPaymentOriginal = new MPayment(Env.getCtx(), id, null);
                            found = true;
                            break;
                        }
                        ++n3;
                    }
                }
                if (!found) {
                    nArray = ids;
                    n = ids.length;
                    int n4 = 0;
                    while (n4 < n) {
                        int id = nArray[n4];
                        p = new MPayment(Env.getCtx(), id, null);
                        payAmt = p.getPayAmt();
                        if (isCreditMemo) {
                            payAmt = payAmt.negate();
                        }
                        if (p.getC_Order_ID() == C_Order_ID && payAmt.compareTo(grandTotal) >= 0) {
                            this.m_C_Payment_ID = id;
                            this.m_mPayment = p;
                            this.m_mPaymentOriginal = new MPayment(Env.getCtx(), id, null);
                            break;
                        }
                        ++n4;
                    }
                }
            }
        }
        if (this.m_mPayment == null) {
            this.m_mPayment = new MPayment(Env.getCtx(), 0, null);
            this.m_mPayment.setAD_Org_ID(this.m_AD_Org_ID);
            this.m_mPayment.setAmount(this.m_C_Currency_ID, this.m_Amount);
        }
        if (this.m_C_Payment_ID > 0 && this.m_mPayment != null) {
            this.m_CCType = this.m_mPayment.getCreditCardType();
        }
        if (this.m_mPaymentTransaction != null) {
            this.m_CCType = this.m_mPaymentTransaction.getCreditCardType();
        }
    }

    public ValueNamePair[] getCreditCardList() {
        this.selectedCreditCard = null;
        ValueNamePair[] ccs = this.m_mPayment.getCreditCards();
        int i = 0;
        while (i < ccs.length) {
            if (ccs[i].getValue().equals(this.m_CCType)) {
                this.selectedCreditCard = ccs[i];
            }
            ++i;
        }
        return ccs;
    }

    @Override
    public boolean saveChanges() {
        boolean ok = super.saveChanges();
        if (this.m_mPayment != null) {
            this.m_mPayment.set_TrxName(null);
        }
        if (this.m_mPaymentOriginal != null) {
            this.m_mPaymentOriginal.set_TrxName(null);
        }
        if (this.m_mPaymentTransaction != null) {
            this.m_mPaymentTransaction.set_TrxName(null);
        }
        return ok;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean save(String newCCType, String newCCNumber, String newCCExp, BigDecimal newAmount, String trxName) {
        MInvoice invoice;
        String payTypes;
        if (this.m_mPayment != null) {
            this.m_mPayment.set_TrxName(trxName);
        }
        if (this.m_mPaymentOriginal != null) {
            this.m_mPaymentOriginal.set_TrxName(trxName);
        }
        if (this.m_mPaymentTransaction != null) {
            this.m_mPaymentTransaction.set_TrxName(trxName);
        }
        if (this.m_mPaymentTransaction != null) {
            return true;
        }
        this.processMsg = null;
        String string = payTypes = this.m_Cash_As_Payment ? "KTSDB" : "KTSD";
        if (!PAYMENTRULE.equals(this.m_PaymentRule)) {
            boolean ok;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Changed PaymentRule: " + this.m_PaymentRule + " -> " + PAYMENTRULE);
            }
            if (payTypes.indexOf(this.m_PaymentRule) != -1 && payTypes.indexOf(PAYMENTRULE) != -1 && this.m_mPaymentOriginal != null) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Old Payment(1) - " + this.m_mPaymentOriginal);
                }
                this.m_mPaymentOriginal.setDocAction("RC");
                ok = this.m_mPaymentOriginal.processIt("RC");
                this.m_mPaymentOriginal.saveEx();
                if (!ok) {
                    this.processMsg = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"PaymentNotCancelled")) + " " + this.m_mPaymentOriginal.getDocumentNo();
                    throw new AdempiereException(this.processMsg);
                }
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Payment Cancelled - " + this.m_mPaymentOriginal);
                }
                this.m_mPayment.resetNew();
            } else if (payTypes.indexOf(this.m_PaymentRule) != -1 && payTypes.indexOf(PAYMENTRULE) == -1) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Old Payment(2) - " + this.m_mPaymentOriginal);
                }
                if (this.m_mPaymentOriginal != null) {
                    this.m_mPaymentOriginal.setDocAction("RC");
                    ok = this.m_mPaymentOriginal.processIt("RC");
                    this.m_mPaymentOriginal.saveEx();
                    if (!ok) {
                        this.processMsg = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"PaymentNotCancelled")) + " " + this.m_mPayment.getDocumentNo();
                        throw new AdempiereException(this.processMsg);
                    }
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("PaymentCancelled " + this.m_mPayment.getDocumentNo());
                    }
                    this.getGridTab().getTableModel().dataSave(true);
                    this.m_mPayment.resetNew();
                    this.m_mPayment.setAmount(this.m_C_Currency_ID, this.m_Amount);
                }
            }
        }
        int C_Order_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getWindowNo(), (String)"C_Order_ID");
        int C_Invoice_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getWindowNo(), (String)"C_Invoice_ID");
        if (C_Invoice_ID == 0 && this.m_DocStatus.equals("CO")) {
            C_Invoice_ID = this.getInvoiceID(C_Order_ID);
        }
        boolean isPOSOrder = false;
        boolean isInvoice = false;
        boolean isCreditMemo = false;
        int doctype = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getWindowNo(), (String)"C_DocTypeTarget_ID");
        if (doctype > 0) {
            MDocType mDocType = MDocType.get((Properties)Env.getCtx(), (int)doctype);
            if ("WR".equals(mDocType.getDocSubTypeSO())) {
                isPOSOrder = true;
            } else if ("ARI".equals(mDocType.getDocBaseType())) {
                isInvoice = true;
            } else if ("ARC".equals(mDocType.getDocBaseType())) {
                isCreditMemo = true;
            }
        }
        BigDecimal payAmount = this.m_Amount;
        if (isCreditMemo) {
            payAmount = this.m_Amount.negate();
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Payment - K");
        }
        this.m_mPayment.setAmount(this.m_C_Currency_ID, payAmount);
        this.m_mPayment.setCreditCard("S", newCCType, newCCNumber, "", newCCExp);
        this.m_mPayment.setPaymentProcessor();
        if (isPOSOrder || isInvoice) {
            this.m_mPayment.setTrxType("S");
        } else if (isCreditMemo) {
            this.m_mPayment.setTrxType("C");
        } else if (C_Invoice_ID != 0) {
            invoice = new MInvoice(Env.getCtx(), C_Invoice_ID, null);
            if (invoice.isComplete()) {
                this.m_mPayment.setTrxType("S");
            }
        } else {
            MPaymentProcessor paymentProcessor = new MPaymentProcessor(this.m_mPayment.getCtx(), this.m_mPayment.getC_PaymentProcessor_ID(), this.m_mPayment.get_TrxName());
            if (paymentProcessor.getTrxType() != null) {
                this.m_mPayment.setTrxType(paymentProcessor.getTrxType());
            }
        }
        this.m_mPayment.setC_BPartner_ID(this.m_C_BPartner_ID);
        this.m_mPayment.setC_Invoice_ID(C_Invoice_ID);
        invoice = null;
        if (C_Invoice_ID != 0) {
            invoice = new MInvoice(Env.getCtx(), C_Invoice_ID, null);
        }
        MOrder order = null;
        if (invoice == null && C_Order_ID != 0) {
            order = new MOrder(Env.getCtx(), C_Order_ID, null);
        }
        if (order != null) {
            this.m_mPayment.setC_Order_ID(C_Order_ID);
            this.m_needSave = true;
        }
        this.m_mPayment.setDateTrx(this.m_DateAcct);
        this.m_mPayment.setDateAcct(this.m_DateAcct);
        this.setCustomizeValues((PO)this.m_mPayment);
        if (!this.m_mPayment.isOnline() && !this.m_mPayment.isApproved()) {
            this.processMsg = Msg.getMsg((Properties)Env.getCtx(), (String)"CardNotProcessed");
            throw new AdempiereException(this.processMsg);
        }
        this.m_mPayment.saveEx();
        if (this.m_mPayment.get_ID() > 0 && "DR".equals(this.m_mPayment.getDocStatus())) {
            boolean ok = this.m_mPayment.processIt("CO");
            this.m_mPayment.saveEx();
            if (!ok) {
                this.processMsg = Msg.getMsg((Properties)Env.getCtx(), (String)"PaymentNotCreated");
                throw new AdempiereException(this.processMsg);
            }
            this.processMsg = this.m_mPayment.getDocumentNo();
        } else {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("NotDraft " + this.m_mPayment);
            }
            this.m_mPayment.setCreditCardNumber(PaymentUtil.encrpytCreditCard((String)this.m_mPayment.getCreditCardNumber()));
            this.m_mPayment.setCreditCardVV(PaymentUtil.encrpytCvv((String)this.m_mPayment.getCreditCardVV()));
            this.m_mPayment.saveEx();
        }
        this.log.config("Saving changes");
        if (this.m_mPayment.getC_Payment_ID() == this.m_C_Payment_ID) return true;
        if (this.m_mPayment.getC_Payment_ID() == 0) {
            this.getGridTab().setValue("C_Payment_ID", null);
            return true;
        }
        this.getGridTab().setValue("C_Payment_ID", (Object)new Integer(this.m_mPayment.getC_Payment_ID()));
        return true;
    }

    public boolean processOnline(String CCType, String CCNumber, String CCVV, String CCExp) {
        return this.processOnline(CCType, CCNumber, CCVV, CCExp, 0);
    }

    public boolean processOnline(String CCType, String CCNumber, String CCVV, String CCExp, int C_PaymentProcessor_ID) {
        this.processMsg = null;
        boolean error = false;
        int C_Order_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getWindowNo(), (String)"C_Order_ID");
        int C_Invoice_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getWindowNo(), (String)"C_Invoice_ID");
        if (C_Invoice_ID == 0 && this.m_DocStatus.equals("CO")) {
            C_Invoice_ID = this.getInvoiceID(C_Order_ID);
        }
        boolean isPOSOrder = false;
        boolean isInvoice = false;
        boolean isCreditMemo = false;
        int doctype = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getWindowNo(), (String)"C_DocTypeTarget_ID");
        if (doctype > 0) {
            MDocType mDocType = MDocType.get((Properties)Env.getCtx(), (int)doctype);
            if ("WR".equals(mDocType.getDocSubTypeSO())) {
                isPOSOrder = true;
            } else if ("ARI".equals(mDocType.getDocBaseType())) {
                isInvoice = true;
            } else if ("ARC".equals(mDocType.getDocBaseType())) {
                isCreditMemo = true;
            }
        }
        boolean approved = false;
        BigDecimal payAmount = this.m_Amount;
        if (isCreditMemo) {
            payAmount = this.m_Amount.negate();
        }
        MPaymentTransaction mpt = new MPaymentTransaction(Env.getCtx(), 0, null);
        mpt.setAD_Org_ID(this.m_AD_Org_ID);
        mpt.setCreditCard("S", CCType, CCNumber, CCVV != null ? CCVV : "", CCExp);
        mpt.setAmount(this.m_C_Currency_ID, payAmount);
        mpt.setC_PaymentProcessor_ID(C_PaymentProcessor_ID);
        mpt.setPaymentProcessor();
        if (isPOSOrder || isInvoice) {
            mpt.setTrxType("S");
        } else if (isCreditMemo) {
            mpt.setTrxType("C");
        } else if (C_Invoice_ID != 0) {
            MInvoice invoice = new MInvoice(Env.getCtx(), C_Invoice_ID, null);
            if (invoice.isComplete()) {
                mpt.setTrxType("S");
            }
        } else {
            MPaymentProcessor paymentProcessor = new MPaymentProcessor(mpt.getCtx(), mpt.getC_PaymentProcessor_ID(), null);
            if (paymentProcessor.getTrxType() != null) {
                mpt.setTrxType(paymentProcessor.getTrxType());
            }
        }
        mpt.setC_BPartner_ID(this.m_C_BPartner_ID);
        mpt.setC_Order_ID(C_Order_ID);
        mpt.setC_Invoice_ID(C_Invoice_ID);
        mpt.setDateTrx(this.m_DateAcct);
        this.setCustomizeValues((PO)mpt);
        String msg = this.validateCreditCard(CCType, CCNumber, CCVV != null ? CCVV : "", CCExp, mpt.getC_BP_BankAccount_ID(), mpt.getCustomerPaymentProfileID());
        if (msg != null && msg.trim().length() > 0) {
            this.processMsg = Msg.getMsg((Properties)Env.getCtx(), (String)msg);
            return false;
        }
        if (!mpt.save()) {
            this.processMsg = Msg.getMsg((Properties)Env.getCtx(), (String)"PaymentNotCreated");
            return false;
        }
        mpt.setCreditCardVV(CCVV != null ? CCVV : "");
        approved = mpt.processOnline();
        mpt.saveEx();
        if (approved) {
            this.m_needSave = true;
            if (mpt.getC_Payment_ID() > 0) {
                this.m_mPayment = new MPayment(mpt.getCtx(), mpt.getC_Payment_ID(), null);
                String info = String.valueOf(this.m_mPayment.getR_RespMsg()) + " (" + this.m_mPayment.getR_AuthCode() + ") ID=" + this.m_mPayment.getR_PnRef();
                this.processMsg = String.valueOf(info) + "\n" + this.m_mPayment.getDocumentNo();
                this.saveChanges();
            } else {
                String info;
                this.processMsg = info = String.valueOf(mpt.getR_RespMsg()) + " (" + mpt.getR_AuthCode() + ") ID=" + mpt.getR_PnRef();
            }
        } else {
            this.processMsg = mpt.getErrorMessage();
            error = true;
        }
        return !error;
    }

    public boolean isBankAccountProcessorExist(String CCType, BigDecimal PayAmt) {
        return this.isBankAccountProcessorExist(Env.getCtx(), "C", CCType, Env.getAD_Client_ID((Properties)Env.getCtx()), this.m_C_Currency_ID, PayAmt, null);
    }

    public MBankAccountProcessor getBankAccountProcessor(String CCType, BigDecimal PayAmt) {
        return this.getBankAccountProcessor(Env.getCtx(), "C", CCType, Env.getAD_Client_ID((Properties)Env.getCtx()), this.m_C_Currency_ID, PayAmt, null);
    }

    @Override
    public boolean isApproved() {
        return this.m_mPayment.isApproved();
    }

    public String validateCreditCard(String CCType, String CCNumber, String CCVV, String CCExp, int C_BP_BankAccount_ID, String CustomerPaymentProfileID) throws IllegalArgumentException {
        String msg = null;
        if (C_BP_BankAccount_ID != 0 || CustomerPaymentProfileID != null && CustomerPaymentProfileID.length() > 0) {
            return msg;
        }
        msg = MPaymentValidate.validateCreditCardNumber((String)CCNumber, (String)CCType);
        if (msg != null && msg.length() > 0) {
            return Msg.getMsg((Properties)Env.getCtx(), (String)msg);
        }
        msg = MPaymentValidate.validateCreditCardExp((int)MPaymentValidate.getCreditCardExpMM((String)CCExp), (int)MPaymentValidate.getCreditCardExpYY((String)CCExp));
        if (msg != null && msg.length() > 0) {
            return Msg.getMsg((Properties)Env.getCtx(), (String)msg);
        }
        if (CCVV != null && CCVV.length() > 0 && (msg = MPaymentValidate.validateCreditCardVV((String)CCVV, (String)CCType)) != null && msg.length() > 0) {
            return Msg.getMsg((Properties)Env.getCtx(), (String)msg);
        }
        return msg;
    }
}

