/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.grid.PaymentForm;
import org.compiere.model.GridTab;
import org.compiere.model.MCash;
import org.compiere.model.MCashLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public abstract class PaymentFormCash
extends PaymentForm {
    private static final String PAYMENTRULE = "B";
    public int m_C_Payment_ID = 0;
    public MPayment m_mPayment = null;
    public MPayment m_mPaymentOriginal = null;
    public int m_C_BankAccount_ID = 0;
    public int m_C_CashLine_ID = 0;
    public MCashLine m_cashLine = null;
    public int m_C_CashBook_ID = 0;
    public KeyNamePair selectedBankAccount;
    public KeyNamePair selectedCashBook;
    public String processMsg;

    public PaymentFormCash(int windowNo, GridTab mTab) {
        super(windowNo, mTab);
    }

    @Override
    public void loadData() {
        if (this.getGridTab().getValue("C_Payment_ID") != null) {
            this.m_C_Payment_ID = (Integer)this.getGridTab().getValue("C_Payment_ID");
            if (this.m_C_Payment_ID != 0) {
                this.m_mPayment = new MPayment(Env.getCtx(), this.m_C_Payment_ID, null);
                this.m_mPaymentOriginal = new MPayment(Env.getCtx(), this.m_C_Payment_ID, null);
            }
        }
        if (this.m_mPayment == null) {
            this.m_mPayment = new MPayment(Env.getCtx(), 0, null);
            this.m_mPayment.setAD_Org_ID(this.m_AD_Org_ID);
            this.m_mPayment.setAmount(this.m_C_Currency_ID, this.m_Amount);
        }
        if (this.m_C_Payment_ID > 0 && this.m_mPayment != null) {
            this.m_C_BankAccount_ID = this.m_mPayment.getC_BankAccount_ID();
        }
        this.m_cashLine = null;
        this.m_C_CashLine_ID = 0;
        if (this.getGridTab().getValue("C_CashLine_ID") != null) {
            this.m_C_CashLine_ID = (Integer)this.getGridTab().getValue("C_CashLine_ID");
            if (this.m_C_CashLine_ID == 0) {
                this.m_cashLine = null;
            } else {
                this.m_cashLine = new MCashLine(Env.getCtx(), this.m_C_CashLine_ID, null);
                this.m_DateAcct = this.m_cashLine.getStatementDate();
                this.m_C_CashBook_ID = this.m_cashLine.getCashBook().getC_CashBook_ID();
            }
        }
    }

    public ArrayList<KeyNamePair> getBankAccountList() {
        ArrayList<KeyNamePair> list;
        block7: {
            this.selectedBankAccount = null;
            list = new ArrayList<KeyNamePair>();
            String SQL = MRole.getDefault().addAccessSQL("SELECT C_BankAccount_ID, ba.Name || ' ' || ba.AccountNo, ba.IsDefault FROM C_BankAccount ba INNER JOIN C_Bank b ON (ba.C_Bank_ID=b.C_Bank_ID) WHERE b.IsActive='Y' AND ba.IsActive='Y'", "ba", true, false);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)SQL, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int key = rs.getInt(1);
                        String name = rs.getString(2);
                        KeyNamePair pp = new KeyNamePair(key, name);
                        list.add(pp);
                        if (key == this.m_C_BankAccount_ID) {
                            this.selectedBankAccount = pp;
                        }
                        if (this.selectedBankAccount != null || !rs.getString(3).equals("Y")) continue;
                        this.selectedBankAccount = pp;
                    }
                }
                catch (SQLException ept) {
                    this.log.log(Level.SEVERE, SQL, (Throwable)ept);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return list;
    }

    public ArrayList<KeyNamePair> getCashBookList() {
        ArrayList<KeyNamePair> list;
        block8: {
            this.selectedCashBook = null;
            list = new ArrayList<KeyNamePair>();
            String SQL = MRole.getDefault().addAccessSQL("SELECT C_CashBook_ID, Name, AD_Org_ID FROM C_CashBook WHERE IsActive='Y'", "C_CashBook", false, false);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)SQL, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int key = rs.getInt(1);
                        String name = rs.getString(2);
                        KeyNamePair pp = new KeyNamePair(key, name);
                        list.add(pp);
                        if (key == this.m_C_CashBook_ID) {
                            this.selectedCashBook = pp;
                        }
                        if (this.selectedCashBook != null || key != this.m_AD_Org_ID) continue;
                        this.selectedCashBook = pp;
                    }
                }
                catch (SQLException epc) {
                    this.log.log(Level.SEVERE, SQL, (Throwable)epc);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (this.selectedCashBook != null && this.m_C_CashBook_ID == 0) {
            this.m_C_CashBook_ID = this.selectedCashBook.getKey();
        }
        return list;
    }

    @Override
    public boolean saveChanges() {
        boolean ok = super.saveChanges();
        if (this.m_cashLine != null) {
            this.m_cashLine.set_TrxName(null);
        }
        if (this.m_mPayment != null) {
            this.m_mPayment.set_TrxName(null);
        }
        if (this.m_mPaymentOriginal != null) {
            this.m_mPaymentOriginal.set_TrxName(null);
        }
        return ok;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean save(int newC_BankAccount_ID, int newC_CashBook_ID, Timestamp newDateAcct, BigDecimal newAmount, String trxName) {
        if (this.m_cashLine != null) {
            this.m_cashLine.set_TrxName(trxName);
        }
        if (this.m_mPayment != null) {
            this.m_mPayment.set_TrxName(trxName);
        }
        if (this.m_mPaymentOriginal != null) {
            this.m_mPaymentOriginal.set_TrxName(trxName);
        }
        this.processMsg = null;
        int newC_CashLine_ID = this.m_C_CashLine_ID;
        if (!PAYMENTRULE.equals(this.m_PaymentRule)) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Changed PaymentRule: " + this.m_PaymentRule + " -> " + PAYMENTRULE);
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Old Cash - " + this.m_cashLine);
            }
            if (this.m_cashLine != null) {
                MCashLine cl = this.m_cashLine.createReversal();
                if (!cl.save()) {
                    this.processMsg = Msg.getMsg((Properties)Env.getCtx(), (String)"CashNotCancelled");
                    throw new AdempiereException(this.processMsg);
                }
                this.log.config("CashCancelled");
            }
            newC_CashLine_ID = 0;
        }
        int C_Order_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getWindowNo(), (String)"C_Order_ID");
        int C_Invoice_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getWindowNo(), (String)"C_Invoice_ID");
        if (C_Invoice_ID == 0 && this.m_DocStatus.equals("CO")) {
            C_Invoice_ID = this.getInvoiceID(C_Order_ID);
        }
        MInvoice invoice = null;
        if (C_Invoice_ID != 0) {
            invoice = new MInvoice(Env.getCtx(), C_Invoice_ID, null);
        }
        MOrder order = null;
        if (invoice == null && C_Order_ID != 0) {
            order = new MOrder(Env.getCtx(), C_Order_ID, null);
        }
        BigDecimal payAmount = newAmount;
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("C_Order_ID=" + C_Order_ID + ", C_Invoice_ID=" + C_Invoice_ID);
        }
        if (!this.m_Cash_As_Payment) {
            this.log.fine("Cash");
            if (C_Invoice_ID == 0 && order == null) {
                this.log.config("No Invoice!");
                this.processMsg = Msg.getMsg((Properties)Env.getCtx(), (String)"CashNotCreated");
                throw new AdempiereException(this.processMsg);
            }
            if (this.m_cashLine != null && payAmount.compareTo(this.m_cashLine.getAmount()) != 0) {
                this.log.config("Changed CashBook Amount");
                this.m_cashLine.setAmount(newAmount);
                this.m_cashLine.saveEx();
            }
            if (!(this.m_cashLine == null || newC_CashBook_ID == this.m_C_CashBook_ID && TimeUtil.isSameDay((Timestamp)this.m_cashLine.getStatementDate(), (Timestamp)newDateAcct))) {
                if (this.log.isLoggable(Level.CONFIG)) {
                    this.log.config("Changed CashBook/Date: " + this.m_C_CashBook_ID + "->" + newC_CashBook_ID);
                }
                MCashLine reverse = this.m_cashLine.createReversal();
                reverse.saveEx();
                this.m_cashLine = null;
            }
            if (this.m_cashLine == null) {
                this.log.config("New CashBook");
                int C_Currency_ID = 0;
                if (invoice != null) {
                    C_Currency_ID = invoice.getC_Currency_ID();
                }
                if (C_Currency_ID == 0 && order != null) {
                    C_Currency_ID = order.getC_Currency_ID();
                }
                MCash cash = null;
                cash = newC_CashBook_ID != 0 ? MCash.get((Properties)Env.getCtx(), (int)newC_CashBook_ID, (Timestamp)newDateAcct, null) : MCash.get((Properties)Env.getCtx(), (int)this.m_AD_Org_ID, (Timestamp)newDateAcct, (int)C_Currency_ID, null);
                if (cash == null || cash.get_ID() == 0) {
                    this.processMsg = CLogger.retrieveErrorString((String)"CashNotCreated");
                    throw new AdempiereException(this.processMsg);
                }
                MCashLine cl = new MCashLine(cash);
                if (invoice != null) {
                    cl.setInvoice(invoice);
                }
                if (order != null) {
                    cl.setOrder(order, null);
                    this.m_needSave = true;
                }
                cl.setAmount(newAmount);
                cl.saveEx();
                this.log.config("CashCreated");
                if (invoice == null && C_Invoice_ID != 0) {
                    invoice = new MInvoice(Env.getCtx(), C_Invoice_ID, null);
                }
                if (invoice != null) {
                    invoice.setC_CashLine_ID(cl.getC_CashLine_ID());
                    invoice.saveEx(trxName);
                }
                if (order == null && C_Order_ID != 0) {
                    order = new MOrder(Env.getCtx(), C_Order_ID, null);
                }
                if (order != null) {
                    order.setC_CashLine_ID(cl.getC_CashLine_ID());
                    order.saveEx(trxName);
                }
                this.log.config("Update Order & Invoice with CashLine");
            }
        }
        if (this.m_Cash_As_Payment) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Payment - B");
            }
            this.m_mPayment.setAmount(this.m_C_Currency_ID, payAmount);
            this.m_mPayment.setTenderType("X");
            this.m_mPayment.setBankCash(newC_BankAccount_ID, this.m_isSOTrx, "X");
            this.m_mPayment.setC_BPartner_ID(this.m_C_BPartner_ID);
            this.m_mPayment.setC_Invoice_ID(C_Invoice_ID);
            if (order != null) {
                this.m_mPayment.setC_Order_ID(C_Order_ID);
                this.m_needSave = true;
            }
            this.m_mPayment.setDateTrx(newDateAcct);
            this.m_mPayment.setDateAcct(newDateAcct);
            this.m_mPayment.saveEx();
            if (this.m_mPayment.get_ID() > 0 && "DR".equals(this.m_mPayment.getDocStatus())) {
                boolean ok = this.m_mPayment.processIt("CO");
                this.m_mPayment.saveEx();
                if (!ok) {
                    this.processMsg = Msg.getMsg((Properties)Env.getCtx(), (String)"PaymentNotCreated");
                    throw new AdempiereException(this.processMsg);
                }
                this.processMsg = this.m_mPayment.getDocumentNo();
            } else if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("NotDraft " + this.m_mPayment);
            }
        }
        this.log.config("Saving changes");
        if (this.m_mPayment.getC_Payment_ID() != this.m_C_Payment_ID) {
            if (this.m_mPayment.getC_Payment_ID() == 0) {
                this.getGridTab().setValue("C_Payment_ID", null);
            } else {
                this.getGridTab().setValue("C_Payment_ID", (Object)new Integer(this.m_mPayment.getC_Payment_ID()));
            }
        }
        if (newC_CashLine_ID == this.m_C_CashLine_ID) return true;
        if (newC_CashLine_ID == 0) {
            this.getGridTab().setValue("C_CashLine_ID", null);
            return true;
        }
        this.getGridTab().setValue("C_CashLine_ID", (Object)new Integer(newC_CashLine_ID));
        return true;
    }
}

