/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.apps.IStatusBar;
import org.compiere.grid.CreateFrom;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public abstract class CreateFromRMA
extends CreateFrom {
    public CreateFromRMA(GridTab mTab) {
        super(mTab);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(mTab.toString());
        }
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        this.setTitle(String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"M_RMA_ID")) + " .. " + Msg.translate((Properties)Env.getCtx(), (String)"CreateFrom"));
        return true;
    }

    protected Vector<Vector<Object>> getRMAData() {
        Vector<Vector<Object>> data;
        block6: {
            int M_InOut_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getGridTab().getWindowNo(), (String)"InOut_ID");
            int M_RMA_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getGridTab().getWindowNo(), (String)"M_RMA_ID");
            data = new Vector<Vector<Object>>();
            StringBuilder sqlStmt = new StringBuilder();
            sqlStmt.append("SELECT iol.M_InOutLine_ID, iol.Line, ");
            sqlStmt.append("COALESCE(p.Name, c.Name) AS ProductName, ");
            sqlStmt.append("iol.QtyEntered, ");
            sqlStmt.append("iol.movementQty-(SELECT COALESCE((SELECT SUM(rmal.qty) FROM M_RMALine rmal JOIN M_RMA rma ON rma.M_RMA_ID=rmal.M_RMA_ID WHERE rmal.M_InOutLine_ID=iol.M_InOutLine_ID AND rma.DocStatus IN ('CO','CL')),0)) AS MovementQty, ");
            sqlStmt.append("CASE WHEN iol.M_AttributeSetInstance_ID IS NOT NULL THEN (SELECT SerNo FROM M_AttributeSetInstance asi WHERE asi.M_AttributeSetInstance_ID=iol.M_AttributeSetInstance_ID) END as ASI, ");
            sqlStmt.append("iol.Description ");
            sqlStmt.append("FROM M_InOutLine iol ");
            sqlStmt.append("LEFT JOIN M_Product p ON p.M_Product_ID = iol.M_Product_ID ");
            sqlStmt.append("LEFT JOIN C_Charge c ON c.C_Charge_ID = iol.C_Charge_ID ");
            sqlStmt.append("WHERE M_InOut_ID=? ");
            sqlStmt.append("AND iol.M_InOutLine_ID NOT IN (SELECT rmal.M_InOutLine_ID FROM M_RMALine rmal WHERE rmal.M_RMA_ID=?)");
            sqlStmt.append(" ORDER BY iol.Line ");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sqlStmt.toString(), null);
                    pstmt.setInt(1, M_InOut_ID);
                    pstmt.setInt(2, M_RMA_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>(8);
                        line.add(new Boolean(false));
                        KeyNamePair lineKNPair = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        line.add(lineKNPair);
                        line.add(rs.getString(3));
                        line.add(rs.getString(6));
                        BigDecimal qtyEntered = rs.getBigDecimal(4);
                        BigDecimal movementQty = rs.getBigDecimal(5);
                        line.add(qtyEntered);
                        line.add(movementQty);
                        line.add(rs.getString(7));
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sqlStmt.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    @Override
    public void info(IMiniTable miniTable, IStatusBar statusBar) {
    }

    protected void configureMiniTable(IMiniTable miniTable) {
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, String.class, true);
        miniTable.setColumnClass(2, String.class, true);
        miniTable.setColumnClass(3, String.class, true);
        miniTable.setColumnClass(4, BigDecimal.class, true);
        miniTable.setColumnClass(5, BigDecimal.class, false);
        miniTable.setColumnClass(6, String.class, true);
        miniTable.autoSize();
    }

    @Override
    public boolean save(IMiniTable miniTable, String trxName) {
        this.log.config("");
        int M_RMA_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getGridTab().getWindowNo(), (String)"M_RMA_ID");
        MRMA rma = new MRMA(Env.getCtx(), M_RMA_ID, trxName);
        int i = 0;
        while (i < miniTable.getRowCount()) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                BigDecimal d = (BigDecimal)miniTable.getValueAt(i, 5);
                KeyNamePair pp = (KeyNamePair)miniTable.getValueAt(i, 1);
                int inOutLineId = pp.getKey();
                MRMALine rmaLine = new MRMALine(rma.getCtx(), 0, rma.get_TrxName());
                rmaLine.setM_RMA_ID(M_RMA_ID);
                rmaLine.setM_InOutLine_ID(inOutLineId);
                rmaLine.setQty(d);
                rmaLine.setAD_Org_ID(rma.getAD_Org_ID());
                rmaLine.setDescription((String)miniTable.getValueAt(i, 6));
                if (!rmaLine.save()) {
                    throw new IllegalStateException("Could not create RMA Line");
                }
            }
            ++i;
        }
        rma.saveEx();
        return true;
    }

    protected Vector<String> getOISColumnNames() {
        Vector<String> columnNames = new Vector<String>(7);
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Line"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"M_Product_ID"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"SerNo"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Quantity"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"QtyDelivered", (boolean)false));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Description"));
        return columnNames;
    }
}

