/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.io.InvalidClassException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.IProcessUI;
import org.adempiere.util.ProcessUtil;
import org.compiere.db.CConnection;
import org.compiere.interfaces.Server;
import org.compiere.model.MPInstance;
import org.compiere.print.ReportCtl;
import org.compiere.process.ClientProcess;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.wf.MWFProcess;

public abstract class AbstractProcessCtl
implements Runnable {
    private int windowno;
    private IProcessUI m_processUI;
    private ProcessInfo m_pi;
    private Trx m_trx;
    private boolean m_IsServerProcess = false;
    private static CLogger log = CLogger.getCLogger(AbstractProcessCtl.class);

    public AbstractProcessCtl(IProcessUI aProcessUI, int WindowNo, ProcessInfo pi, Trx trx) {
        this.windowno = WindowNo;
        this.m_processUI = aProcessUI;
        this.m_pi = pi;
        this.m_trx = trx;
    }

    public void start() {
        Thread thread = new Thread(this);
        if (this.m_pi != null) {
            thread.setName(String.valueOf(this.m_pi.getTitle()) + "-" + this.m_pi.getAD_PInstance_ID());
        }
        thread.start();
    }

    @Override
    public void run() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("AD_PInstance_ID=" + this.m_pi.getAD_PInstance_ID() + ", Record_ID=" + this.m_pi.getRecord_ID());
        }
        this.lock();
        String ProcedureName = "";
        String JasperReport = "";
        int AD_ReportView_ID = 0;
        int AD_Workflow_ID = 0;
        boolean IsReport = false;
        boolean IsDirectPrint = false;
        boolean isPrintPreview = this.m_pi.isPrintPreview();
        String sql = "SELECT p.Name, p.ProcedureName,p.ClassName, p.AD_Process_ID, p.isReport,p.IsDirectPrint,p.AD_ReportView_ID,p.AD_Workflow_ID, CASE WHEN COALESCE(p.Statistic_Count,0)=0 THEN 0 ELSE p.Statistic_Seconds/p.Statistic_Count END CASE, p.IsServerProcess, p.JasperReport FROM AD_Process p INNER JOIN AD_PInstance i ON (p.AD_Process_ID=i.AD_Process_ID) WHERE p.IsActive='Y' AND i.AD_PInstance_ID=?";
        if (!Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Process")) {
            sql = "SELECT t.Name, p.ProcedureName,p.ClassName, p.AD_Process_ID, p.isReport, p.IsDirectPrint,p.AD_ReportView_ID,p.AD_Workflow_ID, CASE WHEN COALESCE(p.Statistic_Count,0)=0 THEN 0 ELSE p.Statistic_Seconds/p.Statistic_Count END CASE, p.IsServerProcess, p.JasperReport FROM AD_Process p INNER JOIN AD_PInstance i ON (p.AD_Process_ID=i.AD_Process_ID)  INNER JOIN AD_Process_Trl t ON (p.AD_Process_ID=t.AD_Process_ID AND t.AD_Language='" + Env.getAD_Language((Properties)Env.getCtx()) + "') " + "WHERE p.IsActive='Y'" + " AND i.AD_PInstance_ID=?";
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (int)1003, (int)1007, null);
                pstmt.setInt(1, this.m_pi.getAD_PInstance_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.m_pi.setTitle(rs.getString(1));
                    this.updateProgressWindowTitle(this.m_pi.getTitle());
                    ProcedureName = rs.getString(2);
                    this.m_pi.setClassName(rs.getString(3));
                    this.m_pi.setAD_Process_ID(rs.getInt(4));
                    if ("Y".equals(rs.getString(5))) {
                        IsReport = true;
                        if ("Y".equals(rs.getString(6)) && !Ini.isPropertyBool((String)"PrintPreview") && !isPrintPreview) {
                            IsDirectPrint = true;
                        }
                    }
                    AD_ReportView_ID = rs.getInt(7);
                    AD_Workflow_ID = rs.getInt(8);
                    int estimate = rs.getInt(9);
                    if (estimate != 0) {
                        this.m_pi.setEstSeconds(estimate + 1);
                        this.updateProgressWindowTimerEstimate(this.m_pi.getEstSeconds());
                    }
                    this.m_IsServerProcess = "Y".equals(rs.getString(10));
                    JasperReport = rs.getString(11);
                } else {
                    log.log(Level.SEVERE, "No AD_PInstance_ID=" + this.m_pi.getAD_PInstance_ID());
                }
            }
            catch (Throwable e) {
                this.m_pi.setSummary(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"ProcessNoProcedure")) + " " + e.getLocalizedMessage(), true);
                this.unlock();
                log.log(Level.SEVERE, "run", e);
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        if (ProcedureName == null) {
            ProcedureName = "";
        }
        if (AD_Workflow_ID > 0) {
            this.startWorkflow(AD_Workflow_ID);
            this.unlock();
            return;
        }
        boolean isJasper = false;
        if (JasperReport != null && JasperReport.trim().length() > 0) {
            isJasper = true;
            if ("org.adempiere.report.jasper.ReportStarter".equals(this.m_pi.getClassName())) {
                this.m_pi.setClassName(null);
            }
        }
        if (this.m_pi.getClassName() != null) {
            if (isJasper) {
                this.m_pi.setReportingProcess(true);
            }
            if (!this.startProcess()) {
                this.unlock();
                return;
            }
            if (!IsReport && ProcedureName.length() == 0) {
                this.unlock();
                return;
            }
            if (IsReport && AD_ReportView_ID == 0 && !isJasper) {
                this.unlock();
                return;
            }
        }
        if (IsReport && ProcedureName.length() > 0) {
            this.m_pi.setReportingProcess(true);
            if (!this.startDBProcess(ProcedureName)) {
                this.unlock();
                return;
            }
        }
        if (isJasper) {
            this.m_pi.setReportingProcess(true);
            this.m_pi.setClassName("org.adempiere.report.jasper.ReportStarter");
            this.startProcess();
            MPInstance pinstance = new MPInstance(Env.getCtx(), this.m_pi.getAD_PInstance_ID(), null);
            String errmsg = pinstance.getErrorMsg();
            errmsg = Util.isEmpty((String)errmsg, (boolean)true) ? "Rows=" + String.valueOf(this.m_pi.getRowCount()) : String.valueOf(errmsg) + " Rows=" + this.m_pi.getRowCount();
            pinstance.setErrorMsg(errmsg);
            pinstance.saveEx();
            this.unlock();
            return;
        }
        if (IsReport) {
            this.m_pi.setReportingProcess(true);
            boolean ok = ReportCtl.start(this.m_processUI, this.windowno, this.m_pi, IsDirectPrint);
            this.m_pi.setSummary(Msg.getCleanMsg((Properties)Env.getCtx(), (String)"Report"), !ok);
            MPInstance pinstance = new MPInstance(Env.getCtx(), this.m_pi.getAD_PInstance_ID(), null);
            String errmsg = pinstance.getErrorMsg();
            errmsg = Util.isEmpty((String)errmsg, (boolean)true) ? "Rows=" + String.valueOf(this.m_pi.getRowCount()) : String.valueOf(errmsg) + " Rows=" + this.m_pi.getRowCount();
            pinstance.setErrorMsg(errmsg);
            pinstance.saveEx();
            this.unlock();
        } else {
            if (!this.startDBProcess(ProcedureName)) {
                this.unlock();
                return;
            }
            ProcessInfoUtil.setSummaryFromDB((ProcessInfo)this.m_pi);
            this.unlock();
        }
    }

    protected abstract void updateProgressWindowTimerEstimate(int var1);

    protected abstract void updateProgressWindowTitle(String var1);

    protected abstract void lock();

    protected abstract void unlock();

    protected int getWindowNo() {
        return this.windowno;
    }

    protected ProcessInfo getProcessInfo() {
        return this.m_pi;
    }

    protected IProcessUI getProcessMonitor() {
        return this.m_processUI;
    }

    protected IProcessUI getParent() {
        return this.getProcessMonitor();
    }

    protected boolean isServerProcess() {
        return this.m_IsServerProcess;
    }

    private boolean startWorkflow(int AD_Workflow_ID) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.valueOf(AD_Workflow_ID) + " - " + this.m_pi);
        }
        boolean started = false;
        if (this.m_IsServerProcess) {
            Server server = CConnection.get().getServer();
            try {
                if (server != null) {
                    this.m_pi = server.workflow(Env.getRemoteCallCtx((Properties)Env.getCtx()), this.m_pi, AD_Workflow_ID);
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("server => " + this.m_pi);
                    }
                    started = true;
                }
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "AppsServer error", (Throwable)ex);
                started = false;
            }
        }
        if (!started && !this.m_IsServerProcess) {
            MWFProcess wfProcess;
            if (this.m_trx != null) {
                this.m_pi.setTransactionName(this.m_trx.getTrxName());
            }
            started = (wfProcess = ProcessUtil.startWorkFlow((Properties)Env.getCtx(), (ProcessInfo)this.m_pi, (int)AD_Workflow_ID)) != null;
        }
        return started;
    }

    private boolean startProcess() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.m_pi.toString());
        }
        boolean started = false;
        boolean clientOnly = false;
        if (!this.m_pi.getClassName().toLowerCase().startsWith("@script:")) {
            try {
                Class<?> processClass = Class.forName(this.m_pi.getClassName());
                if (ClientProcess.class.isAssignableFrom(processClass)) {
                    clientOnly = true;
                }
            }
            catch (Exception processClass) {
                // empty catch block
            }
        }
        if (this.m_IsServerProcess && !clientOnly) {
            Server server = CConnection.get().getServer();
            try {
                if (server != null) {
                    this.m_pi = server.process(Env.getRemoteCallCtx((Properties)Env.getCtx()), this.m_pi);
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("server => " + this.m_pi);
                    }
                    started = true;
                }
            }
            catch (UndeclaredThrowableException ex) {
                Throwable cause = ex.getCause();
                if (cause != null) {
                    if (cause instanceof InvalidClassException) {
                        log.log(Level.SEVERE, "Version Server <> Client: " + cause.toString() + " - " + this.m_pi, (Throwable)ex);
                    } else {
                        log.log(Level.SEVERE, "AppsServer error(1b): " + cause.toString() + " - " + this.m_pi, (Throwable)ex);
                    }
                } else {
                    log.log(Level.SEVERE, " AppsServer error(1) - " + this.m_pi, (Throwable)ex);
                }
                started = false;
            }
            catch (Exception ex) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                }
                log.log(Level.SEVERE, "AppsServer error - " + this.m_pi, cause);
                started = false;
            }
        }
        if (!(started || this.m_IsServerProcess && !clientOnly)) {
            if (this.m_pi.getClassName().toLowerCase().startsWith("@script:")) {
                return ProcessUtil.startScriptProcess((Properties)Env.getCtx(), (ProcessInfo)this.m_pi, (Trx)this.m_trx);
            }
            return ProcessUtil.startJavaProcess((Properties)Env.getCtx(), (ProcessInfo)this.m_pi, (Trx)this.m_trx, (boolean)true, (IProcessUI)this.m_processUI);
        }
        return !this.m_pi.isError();
    }

    private boolean startDBProcess(String ProcedureName) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.valueOf(ProcedureName) + "(" + this.m_pi.getAD_PInstance_ID() + ")");
        }
        boolean started = false;
        if (this.m_IsServerProcess) {
            Server server = CConnection.get().getServer();
            try {
                if (server != null) {
                    this.m_pi = server.dbProcess(Env.getRemoteCallCtx((Properties)Env.getCtx()), this.m_pi, ProcedureName);
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("server => " + this.m_pi);
                    }
                    started = true;
                }
            }
            catch (UndeclaredThrowableException ex) {
                Throwable cause = ex.getCause();
                if (cause != null) {
                    if (cause instanceof InvalidClassException) {
                        log.log(Level.SEVERE, "Version Server <> Client: " + cause.toString() + " - " + this.m_pi, (Throwable)ex);
                    } else {
                        log.log(Level.SEVERE, "AppsServer error(1b): " + cause.toString() + " - " + this.m_pi, (Throwable)ex);
                    }
                } else {
                    log.log(Level.SEVERE, " AppsServer error(1) - " + this.m_pi, (Throwable)ex);
                    cause = ex;
                }
                this.m_pi.setSummary(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"ProcessRunError")) + " " + cause.getLocalizedMessage());
                this.m_pi.setError(true);
                return false;
            }
            catch (Exception ex) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                }
                log.log(Level.SEVERE, "AppsServer error - " + this.m_pi, cause);
                this.m_pi.setSummary(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"ProcessRunError")) + " " + cause.getLocalizedMessage());
                this.m_pi.setError(true);
                return false;
            }
        }
        if (!started) {
            return ProcessUtil.startDatabaseProcedure((ProcessInfo)this.m_pi, (String)ProcedureName, (Trx)this.m_trx);
        }
        return true;
    }
}

