/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.concurrent.TimeUnit;
import org.idempiere.ui.zk.selenium.Widget;
import org.idempiere.ui.zk.selenium.Zk;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.FirefoxDriver;

public class AbstractTestCase {
    protected WebDriver driver;
    protected StringBuffer verificationErrors = new StringBuffer();
    private String baseUrl;

    @Before
    public void setUp() throws Exception {
        this.driver = new FirefoxDriver();
        this.baseUrl = "http://localhost:8080/webui/";
        this.driver.manage().timeouts().implicitlyWait(10L, TimeUnit.SECONDS);
        this.driver.manage().window().maximize();
    }

    protected void type(String locator, String value) {
        WebElement element = this.driver.findElement(Zk.jq(locator));
        element.clear();
        element.sendKeys(new CharSequence[]{value});
    }

    protected void comboboxSelectItem(String locator, String label) {
        Widget widget = new Widget(locator);
        widget.execute(this.driver, "setValue('" + label + "')");
        widget.execute(this.driver, "fireOnChange()");
        WebElement element = widget.$n(this.driver, "real");
        element.click();
    }

    protected void comboboxSelectItem(WebElement select, String label) {
        Widget widget = new Widget(select);
        widget.execute(this.driver, "setValue('" + label + "')");
        widget.execute(this.driver, "fireOnChange()");
        WebElement element = widget.$n(this.driver, "real");
        element.click();
    }

    protected void search(String locator, String label) {
        Widget widget = new Widget(String.valueOf(locator) + " @textbox");
        WebElement element = widget.findElement((SearchContext)this.driver);
        element.click();
        widget.execute(this.driver, "setValue('" + label + "')");
        widget.execute(this.driver, "fireOnChange()");
    }

    protected void selectCheckbox(String locator, boolean select) {
        WebElement element = this.driver.findElement(Zk.jq("$" + locator + " ~ input"));
        if (element.isSelected()) {
            if (!select) {
                element.click();
            }
        } else if (select) {
            element.click();
        }
    }

    protected void clickButton(String locator) {
        this.driver.findElement(Zk.jq(locator)).click();
    }

    protected void selectTab(String locator, int index) {
        Widget widget = new Widget(locator);
        WebElement element = (WebElement)widget.eval(this.driver, "getTabs().getChildAt(" + index + ").$n('cnt');");
        element.click();
    }

    protected void selectTab(String locator, String label) {
        Widget widget = new Widget(String.valueOf(locator) + " @tab[label=\"" + label + "\"]");
        widget.$n(this.driver, "cnt").click();
    }

    protected String selectedTab(String locator) {
        Widget widget = new Widget(locator);
        return (String)widget.eval(this.driver, "getSelectedTab().getLabel()");
    }

    protected void waitResponse() {
        this.waitResponse(5000);
    }

    /*
     * Unable to fully structure code
     */
    protected void waitResponse(int timeout) {
        block2: {
            s = System.currentTimeMillis();
            i = 0;
            ms = 500;
            script = "!!zAu.processing() || !!jq.timers.length";
            break block2;
            while (System.currentTimeMillis() - s <= (long)timeout) {
                i = 0;
                this.sleep(ms);
lbl9:
                // 2 sources

                ** while (!Boolean.valueOf((String)this.getEval((String)script)).booleanValue())
lbl10:
                // 1 sources

            }
lbl11:
            // 2 sources

            ++i;
            this.sleep(ms);
        }
        if (i < 2) ** GOTO lbl9
    }

    public String getEval(String script) {
        return String.valueOf(((JavascriptExecutor)this.driver).executeScript("return (" + script + ");", new Object[0]));
    }

    protected void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void login() throws Exception {
        this.driver.get(this.baseUrl);
        this.waitResponse();
        this.type("$loginPanel $txtUserId", "GardenAdmin");
        this.type("$loginPanel $txtPassword", "GardenAdmin");
        this.comboboxSelectItem("$loginPanel $lstLanguage", "English");
        this.selectCheckbox("$loginPanel $chkSelectRole", true);
        this.clickButton("$loginPanel $Ok");
        this.selectRole("GardenWorld", "GardenWorld Admin", "HQ");
        WebElement loginUserElement = this.waitForElement("$loginUserAndRole");
        Assert.assertEquals((Object)"GardenAdmin@GardenWorld.HQ/GardenWorld Admin", (Object)loginUserElement.getText());
    }

    protected WebElement waitForElement(String locator) throws InterruptedException {
        By loginUserQuery = Zk.jq(locator);
        int second = 0;
        while (true) {
            if (second >= 60) {
                Assert.fail((String)"timeout");
            }
            try {
                if (this.isElementPresent(loginUserQuery)) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sleep(1000L);
            ++second;
        }
        return this.driver.findElement(loginUserQuery);
    }

    protected void selectRole(String client, String role, String org) throws InterruptedException {
        WebElement lstClient = this.waitForElement("$rolePanel $lstClient");
        if (lstClient != null && lstClient.isDisplayed()) {
            this.comboboxSelectItem(lstClient, client);
        }
        this.comboboxSelectItem("$rolePanel $lstRole", role);
        this.comboboxSelectItem("$rolePanel $lstOrganisation", org);
        this.clickButton("$rolePanel $Ok");
    }

    protected boolean isElementPresent(By by) {
        try {
            this.driver.findElement(by);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    protected void openWindow(String label) {
        this.comboboxSelectItem("$treeSearchCombo", label);
    }

    protected void clickProcessButton(String windowId, String btnId) {
        this.clickButton("$" + windowId + " $windowToolbar $BtnProcess");
        this.waitResponse();
        this.clickButton("@window[instanceName=\"processButtonPopup\"] $" + btnId);
    }

    protected void clickToolbarButton(String windowId, String toolBarButtonId) {
        this.clickButton("$" + windowId + " $windowToolbar $" + toolBarButtonId);
    }

    protected void clickDetailToolbarButton(String windowId, String toolBarButtonId) {
        this.clickButton("$" + windowId + " $detailPane $" + toolBarButtonId + ":visible");
    }

    protected WebElement getWindowMessageLabel(String windowId) {
        return this.driver.findElement(Zk.jq("$" + windowId + " $messages @label"));
    }

    protected void nextRecord(String windowId) {
        this.clickButton("$" + windowId + " $breadCrumb $Next");
    }

    protected void previousRecord(String windowId) {
        this.clickButton("$" + windowId + " $breadCrumb $Previous");
    }

    @After
    public void tearDown() throws Exception {
        String verificationErrorString = this.verificationErrors.toString();
        if (!"".equals(verificationErrorString)) {
            Assert.fail((String)verificationErrorString);
        }
    }

    protected String escape(String role) {
        return role.replace(" ", "\\\\ ");
    }
}

