/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.zk;

import fitlibrary.annotation.SimpleAction;
import fitlibrary.spider.AbstractSpiderFixture;
import fitlibrary.spider.Finder;
import fitlibrary.spider.SpiderFixture;
import fitlibrary.spider.polling.PollForMatches;
import fitlibrary.spider.polling.PollForWithError;
import java.io.File;
import java.util.List;
import org.idempiere.ui.zk.selenium.Widget;
import org.idempiere.ui.zk.selenium.Zk;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.DesiredCapabilities;

public class ZkFixture
extends SpiderFixture {
    private Finder _finder = this.getFinder();

    public ZkFixture() {
        this.setElementFinder(new ZkFinder());
    }

    public boolean checkbox(String locator) {
        locator = String.valueOf(locator) + " ~ input";
        return super.checkbox(locator);
    }

    public boolean withSelect(String locator, final boolean select) {
        final Widget widget = new Widget(locator);
        WebElement element = widget.$n(this.webDriver, "real");
        if (element.isSelected()) {
            if (!select) {
                element.click();
            }
        } else if (select) {
            element.click();
        }
        this.ensureMatchesNoException((PollForMatches)new PollForWithError(){

            public boolean matches() {
                WebElement e = widget.$n(ZkFixture.this.webDriver, "real");
                return e.isSelected() == select;
            }

            public String error() {
                return "Not selected correctly";
            }
        });
        return true;
    }

    @SimpleAction(wiki="|''<i>combobox</i>''|zk locator|''<i>selected value</i>''|", tooltip="Return current selected value")
    public String comboboxSelectedValue(String locator) {
        Widget widget = new Widget(locator);
        return (String)widget.eval(this.webDriver, "getValue()");
    }

    @SimpleAction(wiki="|''<i>combobox</i>''|xpath, id or other locator|''<i>select item</i>''|label of item|", tooltip="Changes the selected item in the given comboBox.")
    public boolean comboboxSelectItem(String locator, String label) {
        Widget widget = new Widget(locator);
        widget.execute(this.webDriver, "open()");
        this.waitResponse();
        List list = this.webDriver.findElements(Zk.jq(String.valueOf(locator) + " @comboitem"));
        if (list != null && list.size() > 0) {
            for (WebElement element : list) {
                widget = new Widget("#" + element.getAttribute("id"));
                String elementLabel = (String)widget.eval(this.webDriver, "getLabel()");
                if (!elementLabel.equals(label)) continue;
                element.click();
                this.waitResponse();
                String selected = this.comboboxSelectedValue(locator);
                return label.equals(selected);
            }
        }
        return false;
    }

    @SimpleAction(wiki="|''<i>combobox</i>''|xpath, id or other locator|''<i>select item at</i>''|index|", tooltip="Changes the selected item to the nth one, in the given comboBox.")
    public boolean comboboxSelectItemAt(String locator, int index) {
        Widget widget = new Widget(locator);
        widget.execute(this.webDriver, "open()");
        List list = this.webDriver.findElements(Zk.jq(String.valueOf(locator) + " @Comboitem"));
        if (list != null && index < list.size()) {
            WebElement element = (WebElement)list.get(index);
            element.click();
            Widget item = new Widget("#" + element.getAttribute("id"));
            String label = (String)item.eval(this.webDriver, "getLabel()");
            return label.equals(this.comboboxSelectedValue(locator));
        }
        return false;
    }

    @SimpleAction(wiki="|''<i>combobox</i>''|zk locator|''<i>set text</i>''|text|", tooltip="Enter text into combobox and fire onChange event")
    public boolean comboboxSetText(String locator, String text) {
        Widget widget = new Widget(locator);
        widget.execute(this.webDriver, "setValue('" + text + "', true)");
        widget.execute(this.webDriver, "fireOnChange()");
        WebElement element = widget.$n(this.webDriver, "real");
        element.click();
        this.waitResponse();
        return text.equals(this.comboboxSelectedValue(locator));
    }

    @SimpleAction(wiki="|''<i>tabbox</i>''|xpath, id or other locator|''<i>select tab at</i>''|index|", tooltip="Changes the selected tab to the nth one, in the given tabbox.")
    public void tabboxSelectTabAt(String locator, int index) {
        Widget widget = new Widget(locator);
        WebElement element = (WebElement)widget.eval(this.webDriver, "getTabs().getChildAt(" + index + ").$n('cnt');");
        element.click();
    }

    @SimpleAction(wiki="|''<i>tabbox</i>''|xpath, id or other locator|''<i>select tab</i>''|label|", tooltip="Changes the selected tab in the given tabbox.")
    public void tabboxSelectTab(String locator, String label) {
        Widget widget = new Widget(String.valueOf(locator) + " @tab[label=\"" + label + "\"]");
        widget.$n(this.webDriver, "cnt").click();
    }

    @SimpleAction(wiki="|''<i>selected tab</i>''|xpath, id or other locator|", tooltip="Get the label of the selected tab in the given tabbox.")
    public String selectedTab(String locator) {
        Widget widget = new Widget(locator);
        return (String)widget.eval(this.webDriver, "getSelectedTab().getLabel()");
    }

    @SimpleAction(wiki="|''<i>lookup</i>''|xpath, id or other locator|''<i>search</i>''|value|", tooltip="Search lookup with value.")
    public void lookupSearch(String locator, String value) {
        Widget widget = new Widget(String.valueOf(locator) + " @textbox");
        WebElement element = widget.findElement((SearchContext)this.webDriver);
        element.click();
        widget.execute(this.webDriver, "setValue(\"" + value + "\")");
        widget.execute(this.webDriver, "fireOnChange()");
    }

    @SimpleAction(wiki="|''<i>open window</i>''|menu label|", tooltip="Open window with label.")
    public void openWindow(String label) {
        Widget widget = new Widget("$treeSearchCombo");
        String search = label.indexOf("&") > 0 ? label.substring(0, label.indexOf("&")) : label;
        WebElement element = widget.$n(this.webDriver, "real");
        element.clear();
        element.sendKeys(new CharSequence[]{search});
        this.waitResponse();
        this.comboboxSelectItem("$treeSearchCombo", label);
    }

    @SimpleAction(wiki="|''<i>window</i>''|xpath, id or other locator|''<i>click process button</i>''|button id|", tooltip="Click a window's process button.")
    public void windowClickProcessButton(String windowLocator, String btnId) {
        this.click(String.valueOf(windowLocator) + " $windowToolbar $BtnProcess");
        this.waitResponse();
        this.click("@window[instanceName=\"processButtonPopup\"] $" + btnId);
    }

    @SimpleAction(wiki="|''<i>window</i>''|xpath, id or other locator|''<i>click toolbar</i>''|value|", tooltip="Click a window's toolbar button")
    public void windowClickToolbar(String windowLocator, String toolbarButtonId) {
        this.click(String.valueOf(windowLocator) + " $windowToolbar $" + toolbarButtonId);
    }

    @SimpleAction(wiki="|''<i>window</i>''|xpath, id or other locator|''<i>click detail toolbar</i>''|value|", tooltip="Click the detailpane's toolbar button")
    public void windowClickDetailToolbar(String windowLocator, String toolbarButtonId) {
        this.click(String.valueOf(windowLocator) + " $detailPane $" + toolbarButtonId + ":visible");
    }

    @SimpleAction(wiki="|''<i>window message</i>''|xpath, id or other locator|", tooltip="Current status message display for a window")
    public String windowMessage(String windowLocator) {
        return this.webDriver.findElement(Zk.jq(String.valueOf(windowLocator) + " $messages @label")).getText();
    }

    @SimpleAction(wiki="|''<i>window</i>''|xpath, id or other locator|''<i>next record</i>''|value|", tooltip="Navigate to next record.")
    public void windowNextRecord(String windowLocator) {
        this.click(String.valueOf(windowLocator) + " $breadCrumb $Next");
    }

    @SimpleAction(wiki="|''<i>window</i>''|xpath, id or other locator|''<i>previous record</i>''|value|", tooltip="Navigate to previous record.")
    public void windowPreviousRecord(String windowLocator) {
        this.click(String.valueOf(windowLocator) + " $breadCrumb $Previous");
    }

    @SimpleAction(wiki="|''<i>wait response</i>''|", tooltip="Wait for ajax response with default timeout value.")
    public void waitResponse() {
        this.waitResponseWithTimeout(5000);
    }

    /*
     * Unable to fully structure code
     */
    @SimpleAction(wiki="|''<i>wait response with timeout</i>''|timeout|", tooltip="Wait for ajax response with set timeout value.")
    public void waitResponseWithTimeout(int timeout) {
        block2: {
            s = System.currentTimeMillis();
            i = 0;
            ms = 500;
            script = "!!zAu.processing() || !!jq.timers.length";
            break block2;
            while (System.currentTimeMillis() - s <= (long)timeout) {
                i = 0;
                this.sleep(ms);
lbl9:
                // 2 sources

                ** while (!Boolean.valueOf((String)this.getEval((String)script)).booleanValue())
lbl10:
                // 1 sources

            }
lbl11:
            // 2 sources

            ++i;
            this.sleep(ms);
        }
        if (i < 2) ** GOTO lbl9
    }

    @SimpleAction(wiki="|''<i>focus</i>''|xpath, id or other locator|", tooltip="Set focus to a zk widget")
    public void focus(String locator) {
        Widget widget = new Widget(locator);
        widget.execute(this.webDriver, "focus_(100)");
    }

    @SimpleAction(wiki="|''<i>with widget</i>''|zk locator|''<i>execute</i>''|command|", tooltip="Execute zk widget command")
    public void withWidgetExecute(String locator, String command) {
        Widget widget = new Widget(locator);
        widget.execute(this.webDriver, command);
    }

    @SimpleAction(wiki="|''<i>with widget</i>''|zk locator|''<i>eval</i>''|command|", tooltip="Execute zk widget command and return the result")
    public Object withWidgetEval(String locator, String command) {
        Widget widget = new Widget(locator);
        return widget.eval(this.webDriver, command);
    }

    @SimpleAction(wiki="|''<i>context click</i>''|zk locator|", tooltip="Open context menu")
    public void contextClick(String locator) {
        Widget widget = new Widget(locator);
        WebElement element = widget.findElement((SearchContext)this.webDriver);
        Actions actions = new Actions(this.webDriver);
        actions.contextClick(element).build().perform();
    }

    @SimpleAction(wiki="|''<i>file upload</i>''|xpath, id or other locator|''<i>file path</i>''|path of file|", tooltip="Uploads file from the given path.")
    public boolean fileUploadFilePath(String locator, String filePath) throws Exception {
        if (filePath.equals("")) {
            throw new Exception("file path is not specified.");
        }
        File file = new File(filePath);
        String ext = filePath.substring(filePath.trim().lastIndexOf("."), filePath.length()).toLowerCase();
        if (!(file.exists() && (ext.endsWith(".jpg") || ext.endsWith(".bmp") || ext.endsWith(".png") || ext.endsWith(".ico")))) {
            throw new Exception("Upload an image of type jpg, bmp, png or ico.");
        }
        WebElement fileInput = this.webDriver.findElement(By.xpath((String)locator));
        fileInput.sendKeys(new CharSequence[]{filePath});
        return true;
    }

    @SimpleAction(wiki="|''<i>sleep</i>''|millisecond|", tooltip="sleep")
    public void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected String getEval(String script) {
        return String.valueOf(this.executeJavaScript("return (" + script + ");"));
    }

    public WebDriver webDriver() {
        String driver;
        if (this.webDriver == null && "phantomjs".equals(driver = this.getDynamicVariable("webDriver.driver", "htmlunit").toString())) {
            this.webDriver = this.phantomjsDriver();
            return this.webDriver;
        }
        return super.webDriver();
    }

    public void screenShot() {
        if (this.webDriver instanceof TakesScreenshot) {
            String s = (String)((TakesScreenshot)this.webDriver).getScreenshotAs(OutputType.BASE64);
            this.show("<img src=\"data:image/png;base64," + s + "\" />");
        } else {
            Augmenter augmenter = new Augmenter();
            TakesScreenshot ts = (TakesScreenshot)augmenter.augment(this.webDriver);
            String s = (String)ts.getScreenshotAs(OutputType.BASE64);
            this.show("<img src=\"data:image/png;base64," + s + "\" />");
        }
    }

    public void maximizeWindow() {
        this.webDriver.manage().window().maximize();
    }

    private WebDriver phantomjsDriver() {
        DesiredCapabilities caps = new DesiredCapabilities();
        caps.setJavascriptEnabled(true);
        caps.setCapability("takesScreenshot", true);
        PhantomJSDriver driver = new PhantomJSDriver((Capabilities)caps);
        driver.manage().window().setSize(new Dimension(1366, 768));
        return driver;
    }

    class ZkFinder
    implements Finder {
        ZkFinder() {
        }

        public WebElement findElement(String locator) {
            if (locator.startsWith("$") || locator.startsWith("@")) {
                return this.findElement(Zk.jq(locator));
            }
            return ZkFixture.this._finder.findElement(locator);
        }

        public WebElement findElement(By by) {
            return ZkFixture.this._finder.findElement(by);
        }

        public List<WebElement> findElements(String locator) {
            if (locator.startsWith("$") || locator.startsWith("@")) {
                return ZkFixture.this.webDriver.findElements(Zk.jq(locator));
            }
            return ZkFixture.this._finder.findElements(locator);
        }

        public WebElement findOption(String locator, String option, AbstractSpiderFixture abstractSpiderFixture) {
            return ZkFixture.this._finder.findOption(locator, option, abstractSpiderFixture);
        }
    }
}

