/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.fitnesse.fixture;

import fit.Parse;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.MClient;
import org.compiere.model.MSystem;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.idempiere.fitnesse.fixture.Instance;
import org.idempiere.fitnesse.fixture.Static_iDempiereInstance;

public class Util {
    private static CLogger log = CLogger.getCLogger(Util.class);
    private static boolean s_initOK = false;

    public static boolean initWeb() {
        if (s_initOK) {
            return true;
        }
        try {
            s_initOK = Adempiere.startup((boolean)false);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "startup", (Throwable)ex);
        }
        if (!s_initOK) {
            return false;
        }
        Properties ctx = new Properties();
        MClient client = MClient.get((Properties)ctx, (int)0);
        MSystem system = MSystem.get((Properties)ctx);
        return s_initOK;
    }

    public static String evaluate(Properties ctx, int windowNo, String cell_value, Parse parse) {
        if (cell_value == null || cell_value.length() == 0) {
            return cell_value;
        }
        if (cell_value.toLowerCase().startsWith("@sql=")) {
            String sqlcmd = Env.parseContext((Properties)ctx, (int)windowNo, (String)Util.lowerContextTableColumn(cell_value.substring(5)), (boolean)false, (boolean)false);
            String newval = DB.getSQLValueStringEx(null, (String)sqlcmd, (Object[])new Object[0]);
            if (parse != null) {
                parse.addToBody("<hr/>" + newval);
            }
            if (log.isLoggable(Level.CONFIG)) {
                log.config("Cell value " + cell_value + " evaluated to " + newval);
            }
            return newval;
        }
        if (cell_value.toLowerCase().startsWith("@ref=")) {
            int pos_opsqb = cell_value.indexOf("[");
            int pos_clsqb = cell_value.indexOf("].");
            if (pos_opsqb < 0 || pos_clsqb < 0) {
                return cell_value;
            }
            String tablename = cell_value.substring(5, pos_opsqb);
            String where = cell_value.substring(pos_opsqb + 1, pos_clsqb);
            String whereParsed = Env.parseContext((Properties)ctx, (int)windowNo, (String)where, (boolean)false);
            if (ctx != null) {
                whereParsed = "(" + whereParsed + ") AND AD_Client_ID IN (0," + Env.getAD_Client_ID((Properties)ctx) + ")";
            }
            String columnname = cell_value.substring(pos_clsqb + 2);
            String newval = DB.getSQLValueStringEx(null, (String)("SELECT " + columnname + " FROM " + tablename + " WHERE " + whereParsed), (Object[])new Object[0]);
            if (parse != null) {
                parse.addToBody("<hr/>" + newval);
            }
            if (log.isLoggable(Level.CONFIG)) {
                log.config("Cell value " + cell_value + " evaluated to " + newval);
            }
            return newval;
        }
        if ((cell_value.toLowerCase().startsWith("@random_number(") || cell_value.toLowerCase().startsWith("@random_string(")) && cell_value.endsWith(")")) {
            String newval;
            char c;
            Random rndgen = new Random(System.currentTimeMillis());
            String prefix = "";
            String suffix = "";
            int length = 10;
            int decs = 0;
            String[] tokens = cell_value.substring(15, cell_value.length() - 1).split(",");
            int it = 0;
            while (it < tokens.length) {
                String tok = tokens[it];
                if (tok != null && tok.length() > 0) {
                    switch (it) {
                        case 0: {
                            prefix = tok;
                            break;
                        }
                        case 1: {
                            suffix = tok;
                            break;
                        }
                        case 2: {
                            try {
                                length = Integer.parseInt(tok);
                            }
                            catch (NumberFormatException e) {
                                length = 10;
                            }
                            break;
                        }
                        case 3: {
                            try {
                                decs = Integer.parseInt(tok);
                                break;
                            }
                            catch (NumberFormatException e) {
                                decs = 0;
                            }
                        }
                    }
                }
                ++it;
            }
            StringBuilder randomstr = new StringBuilder();
            if (prefix != null && prefix.length() > 0) {
                randomstr.append(prefix);
            }
            int i = 0;
            while (i < length) {
                int r = 0;
                r = cell_value.toLowerCase().startsWith("@random_number(") ? rndgen.nextInt(10) + 48 : rndgen.nextInt(26) + 65;
                c = (char)r;
                randomstr.append(c);
                ++i;
            }
            if (decs > 0) {
                randomstr.append(".");
            }
            i = 0;
            while (i < decs) {
                int r = rndgen.nextInt(10) + 48;
                c = (char)r;
                randomstr.append(c);
                ++i;
            }
            if (suffix != null && suffix.length() > 0) {
                randomstr.append(suffix);
            }
            if ((newval = randomstr.toString()) == null) {
                return cell_value;
            }
            if (parse != null) {
                parse.addToBody("<hr/>" + newval);
            }
            if (log.isLoggable(Level.CONFIG)) {
                log.config("Cell value " + cell_value + " evaluated to " + newval);
            }
            return newval;
        }
        if (cell_value.startsWith("@") && cell_value.endsWith("@")) {
            String newval;
            int posdot = cell_value.indexOf(".");
            if (posdot >= 0) {
                cell_value = cell_value.toLowerCase();
            }
            if ((newval = Env.getContext((Properties)ctx, (int)windowNo, (String)cell_value.substring(1, cell_value.length() - 1))) == null) {
                return cell_value;
            }
            if (parse != null) {
                parse.addToBody("<hr/>" + newval);
            }
            if (log.isLoggable(Level.CONFIG)) {
                log.config("Cell value " + cell_value + " evaluated to " + newval);
            }
            return newval;
        }
        if (cell_value.matches(".*@.*@.*")) {
            String newval = Env.parseContext((Properties)ctx, (int)windowNo, (String)cell_value, (boolean)false, (boolean)false);
            if (newval == null || newval.length() == 0) {
                return cell_value;
            }
            if (parse != null) {
                parse.addToBody("<hr/>" + newval);
            }
            if (log.isLoggable(Level.CONFIG)) {
                log.config("Cell value " + cell_value + " evaluated to " + newval);
            }
            return newval;
        }
        if (cell_value.startsWith("\\@")) {
            cell_value = cell_value.substring(1);
        }
        return cell_value;
    }

    public static String lowerContextTableColumn(String value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        String inStr = new String(value);
        StringBuilder outStr = new StringBuilder();
        int i = inStr.indexOf(64);
        while (i != -1) {
            outStr.append(inStr.substring(0, i));
            outStr.append("@");
            inStr = inStr.substring(i + 1, inStr.length());
            int j = inStr.indexOf(64);
            if (j < 0) {
                return "";
            }
            String token = inStr.substring(0, j);
            if (token.indexOf(".") >= 0) {
                token = token.toLowerCase();
            }
            outStr.append(token);
            outStr.append("@");
            inStr = inStr.substring(j + 1, inStr.length());
            i = inStr.indexOf(64);
        }
        outStr.append(inStr);
        return outStr.toString();
    }

    public static String evaluate(String expr) {
        Instance adempiereInstance = Static_iDempiereInstance.getInstance();
        Properties ctx = adempiereInstance.getAdempiereService().getCtx();
        int windowNo = adempiereInstance.getAdempiereService().getWindowNo();
        return Util.evaluate(ctx, windowNo, expr, null);
    }

    public static boolean evaluateError(String error, String cell, boolean isExpectedError) {
        boolean evaluate = false;
        if (error == null) {
            error = "";
        }
        if (cell == null) {
            cell = "";
        }
        evaluate = isExpectedError ? (cell.length() > 0 ? error.contains(cell) : true) : false;
        return evaluate;
    }
}

