/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.fitnesse.fixture;

import fitnesse.slim.ConverterSupport;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.idempiere.fitnesse.server.slim.ISlimFixtureFactory;

public class SlimFixtureFactory
implements ISlimFixtureFactory {
    private List<String> paths = new ArrayList<String>();

    public SlimFixtureFactory() {
        this.paths.add("org.idempiere.fitnesse.fixture");
    }

    public Object getFixture(String className, Object[] args) {
        Class<?> k = this.searchPathsForClass(className);
        if (k == null) {
            return null;
        }
        Constructor<?> constructor = this.getConstructor(k.getConstructors(), args);
        if (constructor == null) {
            return null;
        }
        try {
            Object newInstance = constructor.newInstance(ConverterSupport.convertArgs((Object[])args, (Class[])constructor.getParameterTypes()));
            return newInstance;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Constructor<?> getConstructor(Constructor<?>[] constructors, Object[] args) {
        Constructor<?>[] constructorArray = constructors;
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            Class<?>[] arguments = constructor.getParameterTypes();
            if (arguments.length == args.length) {
                return constructor;
            }
            ++n2;
        }
        return null;
    }

    private Class<?> searchPathsForClass(String className) {
        Class<?> k = this.getClass(className);
        if (k != null) {
            return k;
        }
        ArrayList<String> reversedPaths = new ArrayList<String>(this.paths);
        Collections.reverse(reversedPaths);
        for (String path : reversedPaths) {
            k = this.getClass(String.valueOf(path) + "." + className);
            if (k == null) continue;
            return k;
        }
        return null;
    }

    private Class<?> getClass(String className) {
        try {
            return this.getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

