/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.fitnesse.fixture;

import fitnesse.fixtures.TableFixture;
import java.util.Properties;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CLogger;
import org.compiere.util.Trx;
import org.idempiere.fitnesse.fixture.Instance;
import org.idempiere.fitnesse.fixture.Static_iDempiereInstance;
import org.idempiere.fitnesse.fixture.Util;

public class SetDocAction
extends TableFixture {
    private static volatile Instance adempiereInstance = null;

    protected void doStaticTable(int rows) {
        if (adempiereInstance == null) {
            adempiereInstance = Static_iDempiereInstance.getInstance();
        }
        if (adempiereInstance.getAdempiereService() == null || !adempiereInstance.getAdempiereService().isLoggedIn()) {
            this.wrong(rows - 1, 1);
            this.getCell(rows - 1, 1).addToBody("not logged in");
            return;
        }
        Properties ctx = adempiereInstance.getAdempiereService().getCtx();
        int windowNo = adempiereInstance.getAdempiereService().getWindowNo();
        PO gpo = null;
        String tableName = new String("");
        String columnName = null;
        boolean tableOK = false;
        MTable table = null;
        int recordID = -1;
        String docAction = null;
        int i = 0;
        while (i < rows) {
            String cell_title = this.getText(i, 0);
            String cell_value = this.getText(i, 1);
            if (cell_title.equalsIgnoreCase("*Table*")) {
                if (i > 0) {
                    this.exception(this.getCell(i, 1), new Exception("*Table* must be defined in first row"));
                }
                if ((table = MTable.get((Properties)ctx, (String)(tableName = cell_value))) == null || table.get_ID() <= 0) {
                    this.wrong(i, 1);
                    tableOK = false;
                } else {
                    tableOK = true;
                }
            } else if (cell_title.equalsIgnoreCase("*Save*")) {
                if (i != rows - 1) {
                    this.exception(this.getCell(i, 1), new Exception("*Save* must be called in last row"));
                    return;
                }
                if (!tableOK) {
                    this.getCell(i, 1).addToBody("Table " + tableName + " does not exist");
                    this.wrong(i, 1);
                    return;
                }
                if (recordID == -1 || docAction == null) {
                    this.exception(this.getCell(i, 1), new Exception("You need to assign " + tableName + "_ID and DocAction"));
                    return;
                }
                Trx trx = Trx.get((String)Trx.createTrxName((String)"FixtureSetDocAction"), (boolean)true);
                trx.setDisplayName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "_doStaticTable");
                gpo = table.getPO(recordID, trx.getTrxName());
                if (gpo == null) {
                    this.exception(this.getCell(i, 1), new Exception("No Record " + recordID + " in " + tableName));
                    return;
                }
                DocumentEngine engine = new DocumentEngine((DocAction)gpo, ((DocAction)gpo).getDocStatus());
                if (!engine.isValidAction(docAction)) {
                    StringBuilder msg = new StringBuilder("Not a valid action for docStatus=");
                    msg.append(((DocAction)gpo).getDocStatus()).append(" valid actions are:");
                    String[] stringArray = engine.getActionOptions();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        msg.append(" ").append(s);
                        ++n2;
                    }
                    this.exception(this.getCell(i, 1), new Exception(msg.toString()));
                    return;
                }
                if (!"PO".equals(docAction)) {
                    if (!gpo.set_ValueOfColumnReturningBoolean("DocAction", (Object)docAction)) {
                        this.exception(this.getCell(i, 1), new Exception("No Record " + recordID + " in " + tableName));
                        return;
                    }
                    if (!gpo.save()) {
                        this.exception(this.getCell(i, 1), new Exception("Cannot save before setDocAction: " + CLogger.retrieveErrorString((String)"no log message")));
                        return;
                    }
                }
                try {
                    if (!((DocAction)gpo).processIt(docAction)) {
                        this.exception(this.getCell(i, 1), new Exception("Couldn't set docAction: " + ((DocAction)gpo).getProcessMsg()));
                        return;
                    }
                }
                catch (Exception e) {
                    this.exception(this.getCell(i, 1), e);
                }
                if (!gpo.save()) {
                    this.exception(this.getCell(i, 1), new Exception("Cannot save after setDocAction: " + CLogger.retrieveErrorString((String)"no log message")));
                    return;
                }
                if (!trx.commit()) {
                    this.exception(this.getCell(i, 1), new Exception("Cannot commit: " + CLogger.retrieveErrorString((String)"no log message")));
                    return;
                }
                trx.close();
                StringBuffer expected = new StringBuffer();
                if (this.validateResult(docAction, ((DocAction)gpo).getDocStatus(), expected)) {
                    this.right(i, 1);
                } else {
                    this.wrong(i, 1);
                }
                this.getCell(i, 1).addToBody("DocStatus=" + ((DocAction)gpo).getDocStatus() + " expected " + expected.toString());
                gpo = null;
            } else if (tableOK) {
                columnName = cell_title;
                String value_evaluated = Util.evaluate(ctx, windowNo, cell_value, this.getCell(i, 1));
                if (columnName.equalsIgnoreCase(String.valueOf(tableName) + "_ID")) {
                    try {
                        recordID = Integer.parseInt(value_evaluated);
                    }
                    catch (NumberFormatException e) {
                        this.exception(this.getCell(i, 1), e);
                        return;
                    }
                } else if (columnName.equalsIgnoreCase("DocAction")) {
                    docAction = value_evaluated;
                } else {
                    this.exception(this.getCell(i, 1), new Exception("Column not allowed, just assign " + tableName + "_ID or DocAction"));
                    return;
                }
            }
            ++i;
        }
    }

    private boolean validateResult(String docAction, String docStatus, StringBuffer expected) {
        if ("XL".equals(docAction)) {
            expected.append("DR");
            return "DR".equals(docStatus);
        }
        if ("IN".equals(docAction)) {
            expected.append("IN");
            return "IN".equals(docStatus);
        }
        if ("PR".equals(docAction)) {
            expected.append("IP");
            return "IP".equals(docStatus);
        }
        if ("AP".equals(docAction)) {
            expected.append("AP");
            return "AP".equals(docStatus);
        }
        if ("RJ".equals(docAction)) {
            expected.append("NA");
            return "NA".equals(docStatus);
        }
        if ("CO".equals(docAction) || "WC".equals(docAction)) {
            expected.append("CO").append(" - ");
            expected.append("IP").append(" - ");
            expected.append("WP").append(" - ");
            expected.append("WC");
            return "CO".equals(docStatus) || "IP".equals(docStatus) || "WP".equals(docStatus) || "WC".equals(docStatus);
        }
        if ("RE".equals(docAction)) {
            expected.append("IP");
            return "IP".equals(docStatus);
        }
        if ("RA".equals(docAction)) {
            expected.append("RE");
            return "RE".equals(docStatus);
        }
        if ("RC".equals(docAction)) {
            expected.append("RE");
            return "RE".equals(docStatus);
        }
        if ("CL".equals(docAction)) {
            expected.append("CL");
            return "CL".equals(docStatus);
        }
        if ("VO".equals(docAction)) {
            expected.append("VO");
            return "VO".equals(docStatus);
        }
        if ("PO".equals(docAction)) {
            expected.append(docStatus);
            return true;
        }
        return false;
    }
}

