/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.fitnesse.fixture;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Login;
import org.idempiere.fitnesse.fixture.Util;

public class Service {
    private static CLogger log = CLogger.getCLogger(Service.class);
    public static final String datePattern = "dd-MM-yyyy";
    private String m_trx_name = null;
    private int m_AD_Client_ID;
    private int m_AD_Org_ID;
    private int m_AD_User_ID;
    private int m_AD_Role_ID;
    private int m_M_Warehouse_ID;
    private String m_Lang;
    private String m_User;
    private int m_WindowNo = 1;
    private boolean LoggedIn = false;
    public SimpleDateFormat dateFormat = null;
    public SimpleDateFormat dateTimeFormat = null;
    public DecimalFormat amountFormat = null;
    public DecimalFormat integerFormat = null;
    public DecimalFormat numberFormat = null;
    public DecimalFormat quantityFormat = null;
    public SimpleDateFormat modelDateFormat = null;
    public SimpleDateFormat modelDateTimeFormat = null;
    public DecimalFormat modelAmountFormat = null;
    public DecimalFormat modelIntegerFormat = null;
    public DecimalFormat modelNumberFormat = null;
    public DecimalFormat modelQuantityFormat = null;
    private Language m_lang;
    public final String dateFormatOnlyForCtx = "yyyy-MM-dd";

    public int getM_AD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public void setM_AD_Client_ID(int client_ID) {
        this.m_AD_Client_ID = client_ID;
    }

    public int getM_AD_Org_ID() {
        return this.m_AD_Org_ID;
    }

    public void setM_AD_Org_ID(int org_ID) {
        this.m_AD_Org_ID = org_ID;
    }

    public Properties getCtx() {
        return Env.getCtx();
    }

    public String get_TrxName() {
        return this.m_trx_name;
    }

    public void set_TrxName(String m_trx_name) {
        this.m_trx_name = m_trx_name;
    }

    public void connect() {
        Util.initWeb();
        this.getCtx().setProperty("#AD_Client_ID", "0");
        Env.setContext((Properties)this.getCtx(), (String)"#AD_Language", (String)"en_US");
        this.m_lang = Language.getLanguage((String)"en_US");
        Language m_lang2 = Language.getLanguage((String)"pl_PL");
        this.dateFormat = new SimpleDateFormat(datePattern);
        this.dateTimeFormat = new SimpleDateFormat(datePattern);
        this.amountFormat = DisplayType.getNumberFormat((int)12, (Language)m_lang2);
        this.integerFormat = DisplayType.getNumberFormat((int)11, (Language)m_lang2);
        this.numberFormat = DisplayType.getNumberFormat((int)22, (Language)m_lang2);
        this.quantityFormat = DisplayType.getNumberFormat((int)29, (Language)m_lang2);
    }

    public Language getM_lang() {
        return this.m_lang;
    }

    public void setM_lang(Language m_lang) {
        this.m_lang = m_lang;
    }

    public boolean isLoggedIn() {
        return this.LoggedIn;
    }

    private String checkLogin(Properties ctx, int AD_User_ID, int AD_Role_ID, int AD_Client_ID, int AD_Org_ID, int M_Warehouse_ID) {
        String loginInfo;
        block8: {
            loginInfo = null;
            String sql = "SELECT u.Name || '@' || c.Name || '.' || o.Name AS Text FROM AD_User u, AD_Client c, AD_Org o, AD_User_Roles ur WHERE u.AD_User_ID=? AND c.AD_Client_ID=? AND o.AD_Org_ID=? AND ur.AD_Role_ID=? AND ur.AD_User_ID=u.AD_User_ID AND (o.AD_Client_ID = 0 OR o.AD_Client_ID=c.AD_Client_ID) AND c.AD_Client_ID IN (SELECT AD_Client_ID FROM AD_Role_OrgAccess ca WHERE ca.AD_Role_ID=ur.AD_Role_ID) AND o.AD_Org_ID IN (SELECT AD_Org_ID FROM AD_Role_OrgAccess ca WHERE ca.AD_Role_ID=ur.AD_Role_ID)";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, AD_User_ID);
                    pstmt.setInt(2, AD_Client_ID);
                    pstmt.setInt(3, AD_Org_ID);
                    pstmt.setInt(4, AD_Role_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        loginInfo = rs.getString(1);
                    }
                }
                catch (SQLException sQLException) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (loginInfo == null) {
            return null;
        }
        KeyNamePair org = new KeyNamePair(AD_Org_ID, String.valueOf(AD_Org_ID));
        KeyNamePair wh = null;
        if (M_Warehouse_ID > 0) {
            wh = new KeyNamePair(M_Warehouse_ID, String.valueOf(M_Warehouse_ID));
        }
        Timestamp date = null;
        String printer = null;
        Login login = new Login(ctx);
        login.loadPreferences(org, wh, date, printer);
        Env.setContext((Properties)ctx, (String)"#ShowAcct", (String)"N");
        Env.setContext((Properties)ctx, (String)"#ShowTrl", (String)"N");
        return loginInfo;
    }

    public boolean login(int AD_User_ID, int AD_Role_ID, int AD_Client_ID, int AD_Org_ID, int AD_Warehouse_ID, String Lang) {
        this.LoggedIn = false;
        String loginInfo = this.checkLogin(this.getCtx(), AD_User_ID, AD_Role_ID, AD_Client_ID, AD_Org_ID, AD_Warehouse_ID);
        if (loginInfo == null) {
            return false;
        }
        this.m_AD_Client_ID = AD_Client_ID;
        this.m_AD_Org_ID = AD_Org_ID;
        this.m_AD_User_ID = AD_User_ID;
        this.m_AD_Role_ID = AD_Role_ID;
        this.m_M_Warehouse_ID = AD_Warehouse_ID;
        this.m_Lang = Lang;
        this.m_User = MUser.getNameOfUser((int)this.m_AD_User_ID);
        Env.setContext((Properties)this.getCtx(), (String)"#AD_Language", (String)Lang);
        this.m_lang = Language.getLanguage((String)Lang);
        Env.verifyLanguage((Properties)this.getCtx(), (Language)this.m_lang);
        this.modelDateFormat = new SimpleDateFormat(datePattern);
        this.modelDateTimeFormat = new SimpleDateFormat(datePattern);
        this.modelAmountFormat = DisplayType.getNumberFormat((int)12, (Language)this.m_lang);
        this.modelIntegerFormat = DisplayType.getNumberFormat((int)11, (Language)this.m_lang);
        this.modelNumberFormat = DisplayType.getNumberFormat((int)22, (Language)this.m_lang);
        this.modelQuantityFormat = DisplayType.getNumberFormat((int)29, (Language)this.m_lang);
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        SimpleDateFormat dateFormat4Timestamp = new SimpleDateFormat("yyyy-MM-dd");
        Env.setContext((Properties)this.getCtx(), (String)"#Date", (String)(String.valueOf(dateFormat4Timestamp.format(ts)) + " 00:00:00"));
        if (log.isLoggable(Level.INFO)) {
            log.info(" #Date = " + Env.getContextAsDate((Properties)this.getCtx(), (String)"#Date"));
        }
        Env.setContext((Properties)this.getCtx(), (String)"#M_Warehouse_ID", (int)AD_Warehouse_ID);
        Env.setContext((Properties)this.getCtx(), (String)"#AD_Language", (String)this.m_lang.getAD_Language());
        this.LoggedIn = true;
        return true;
    }

    public void setAD_User_ID(int m_AD_User_ID) {
        this.m_AD_User_ID = m_AD_User_ID;
    }

    public int getAD_User_ID() {
        return this.m_AD_User_ID;
    }

    public void setAD_Role_ID(int m_AD_Role_ID) {
        this.m_AD_Role_ID = m_AD_Role_ID;
    }

    public int getAD_Role_ID() {
        return this.m_AD_Role_ID;
    }

    public void setLanguage(String m_Lang) {
        this.m_Lang = m_Lang;
    }

    public String getLanguage() {
        return this.m_Lang;
    }

    public void setM_Warehouse_ID(int m_AD_Warehouse_ID) {
        this.m_M_Warehouse_ID = m_AD_Warehouse_ID;
    }

    public int getM_Warehouse_ID() {
        return this.m_M_Warehouse_ID;
    }

    public void setUser(String m_User) {
        this.m_User = m_User;
    }

    public String getUser() {
        return this.m_User;
    }

    public int getWindowNo() {
        return this.m_WindowNo;
    }

    public void setWindowNo(int windowNo) {
        this.m_WindowNo = windowNo;
    }

    public int nextWindowNo() {
        ++this.m_WindowNo;
        return this.m_WindowNo;
    }
}

