/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.fitnesse.fixture;

import fitnesse.fixtures.TableFixture;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.Lookup;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstanceLog;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Trx;
import org.compiere.wf.MWFProcess;
import org.compiere.wf.MWorkflow;
import org.idempiere.fitnesse.fixture.Instance;
import org.idempiere.fitnesse.fixture.Static_iDempiereInstance;
import org.idempiere.fitnesse.fixture.Util;

public class RunProcess
extends TableFixture {
    private static volatile Instance adempiereInstance = null;
    private static CLogger log = CLogger.getCLogger(RunProcess.class);

    protected void doStaticTable(int rows) {
        if (adempiereInstance == null) {
            adempiereInstance = Static_iDempiereInstance.getInstance();
        }
        if (adempiereInstance.getAdempiereService() == null || !adempiereInstance.getAdempiereService().isLoggedIn()) {
            this.wrong(rows - 1, 1);
            this.getCell(rows - 1, 1).addToBody("not logged in");
            return;
        }
        Properties ctx = adempiereInstance.getAdempiereService().getCtx();
        int windowNo = adempiereInstance.getAdempiereService().getWindowNo();
        MProcess process = null;
        MProcessPara[] processParams = null;
        MPInstance pInstance = null;
        HashMap<String, Object> fmap = new HashMap<String, Object>();
        int recordID = 0;
        String docAction = null;
        boolean isErrorExpected = "*Run*Error*".equalsIgnoreCase(this.getText(rows - 1, 0));
        String msgerror1 = this.getText(rows - 1, 1);
        int i = 0;
        while (i < rows) {
            String cell_title = this.getText(i, 0);
            String cell_value = this.getText(i, 1);
            if (cell_title.equalsIgnoreCase("*ProcessValue*")) {
                if (i > 0) {
                    this.exception(this.getCell(i, 1), new Exception("*ProcessValue* must be defined in first row"));
                    return;
                }
                String processValue = cell_value;
                int processID = MProcess.getProcess_ID((String)processValue, null);
                if (processID <= 0) {
                    boolean ok = Util.evaluateError(msgerror1, "Process with Value=" + processValue + " doesn't exist", isErrorExpected);
                    if (ok) {
                        this.right(this.getCell(i, 1));
                    } else {
                        this.exception(this.getCell(i, 1), new Exception("Process with Value=" + processValue + " doesn't exist"));
                    }
                    return;
                }
                process = new MProcess(ctx, processID, null);
            } else if (cell_title.equalsIgnoreCase("*ProcessID*")) {
                if (i > 0) {
                    this.exception(this.getCell(i, 1), new Exception("*ProcessID* must be defined in first row"));
                    return;
                }
                int processID = this.getInt(i, 1);
                process = new MProcess(ctx, processID, null);
                if (process == null || process.get_ID() <= 0) {
                    boolean ok = Util.evaluateError(msgerror1, "Process with ID=" + processID + " doesn't exist", isErrorExpected);
                    if (ok) {
                        this.right(this.getCell(i, 1));
                    } else {
                        this.exception(this.getCell(i, 1), new Exception("Process with ID=" + processID + " doesn't exist"));
                    }
                    return;
                }
            } else if (cell_title.equalsIgnoreCase("*Run*") || cell_title.equalsIgnoreCase("*Run*Error*")) {
                boolean jasperreport;
                PO po;
                MTable table;
                MWorkflow wf;
                boolean ok;
                if (i != rows - 1) {
                    this.exception(this.getCell(i, 1), new Exception("*Run* must be called in last row"));
                    return;
                }
                processParams = process.getParameters();
                pInstance = new MPInstance(process, 0);
                MPInstancePara[] iParams = pInstance.getParameters();
                String errorMsg = this.setParams(process, iParams, fmap);
                if (errorMsg != null && !(ok = Util.evaluateError(msgerror1, errorMsg, isErrorExpected))) {
                    this.exception(this.getCell(i, 1), new Exception(errorMsg));
                }
                if (recordID > 0) {
                    pInstance.setRecord_ID(recordID);
                }
                pInstance.saveEx();
                if (docAction != null && docAction != null && docAction.length() > 0 && process.getAD_Workflow_ID() > 0 && (wf = MWorkflow.get((Properties)ctx, (int)process.getAD_Workflow_ID())).getWorkflowType().equals("P") && (table = MTable.get((Properties)ctx, (int)wf.getAD_Table_ID())) != null && (po = table.getPO(recordID, null)) != null) {
                    po.set_ValueOfColumn("DocAction", (Object)docAction);
                    po.saveEx();
                }
                ProcessInfo pi = new ProcessInfo(process.getName(), process.getAD_Process_ID());
                pi.setAD_User_ID(Env.getAD_User_ID((Properties)ctx));
                pi.setAD_Client_ID(Env.getAD_Client_ID((Properties)ctx));
                pi.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
                if (recordID > 0) {
                    pi.setRecord_ID(recordID);
                }
                boolean processOK = false;
                boolean bl = jasperreport = process != null && (process.getJasperReport() != null || process.getClassname() != null && process.getClassname().indexOf("org.adempiere.report.jasper.ReportStarter") >= 0);
                if (process.isWorkflow()) {
                    try {
                        int AD_Workflow_ID = process.getAD_Workflow_ID();
                        MWorkflow wf2 = MWorkflow.get((Properties)ctx, (int)AD_Workflow_ID);
                        MWFProcess wfProcess = wf2.startWait(pi);
                        if (wfProcess != null) {
                            this.getCell(i, 1).addToBody(Msg.parseTranslation((Properties)ctx, (String)pi.getSummary()));
                            this.addLogInfo(pInstance, i);
                            if (wf2.getWorkflowType().equals("P")) {
                                MTable table2 = MTable.get((Properties)ctx, (int)wf2.getAD_Table_ID());
                                if (table2 != null) {
                                    PO po2 = table2.getPO(recordID, null);
                                    if (!docAction.equals(po2.get_Value("DocStatus"))) {
                                        this.getCell(i, 1).addToBody("<br>Expected " + docAction + "<br>Received " + po2.get_Value("DocStatus"));
                                        boolean ok2 = Util.evaluateError(Msg.parseTranslation((Properties)ctx, (String)pi.getSummary()), msgerror1, isErrorExpected);
                                        if (ok2) {
                                            this.right(this.getCell(i, 1));
                                        } else {
                                            this.wrong(this.getCell(i, 1));
                                        }
                                    } else if (isErrorExpected) {
                                        this.wrong(this.getCell(i, 1));
                                    } else {
                                        this.right(this.getCell(i, 1));
                                    }
                                }
                            } else if (isErrorExpected) {
                                this.wrong(this.getCell(i, 1));
                            } else {
                                this.right(this.getCell(i, 1));
                            }
                        }
                    }
                    catch (Exception ex) {
                        boolean ok3 = Util.evaluateError(ex.getMessage(), cell_value, isErrorExpected);
                        if (ok3) {
                            this.right(this.getCell(i, 1));
                        }
                        this.exception(this.getCell(i, 1), ex);
                    }
                }
                if (process.isJavaProcess() && !jasperreport) {
                    Trx trx = Trx.get((String)Trx.createTrxName((String)"FixturePrc"), (boolean)true);
                    trx.setDisplayName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "_doStaticTable");
                    try {
                        processOK = process.processIt(pi, trx);
                        trx.commit();
                        trx.close();
                    }
                    catch (Throwable t) {
                        trx.rollback();
                        trx.close();
                    }
                    if (!processOK || pi.isError()) {
                        boolean ok4 = Util.evaluateError(msgerror1, pi.getSummary(), isErrorExpected);
                        if (ok4) {
                            this.right(this.getCell(i, 1));
                            processOK = true;
                        } else {
                            this.exception(this.getCell(i, 1), new Exception(pi.getSummary()));
                            processOK = false;
                        }
                    } else if (isErrorExpected) {
                        this.wrong(this.getCell(i, 1));
                    } else {
                        this.getCell(i, 1).addToBody(Msg.parseTranslation((Properties)ctx, (String)pi.getSummary()));
                        this.addLogInfo(pInstance, i);
                        this.right(this.getCell(i, 1));
                    }
                }
                if (process.isReport() || jasperreport) {
                    this.exception(this.getCell(i, 1), new Exception("Report not supported yet"));
                    return;
                }
            } else {
                if (i <= 0 || i >= rows - 1) {
                    this.exception(this.getCell(i, 1), new Exception("Parameters must be defined in middle rows"));
                    return;
                }
                String parameterName = cell_title;
                String value_evaluated = Util.evaluate(ctx, windowNo, cell_value, this.getCell(i, 1));
                if (parameterName.equalsIgnoreCase("*RecordID*")) {
                    try {
                        recordID = Integer.parseInt(value_evaluated);
                    }
                    catch (NumberFormatException e) {
                        this.exception(this.getCell(i, 1), e);
                    }
                } else if (parameterName.equalsIgnoreCase("*DocAction*")) {
                    docAction = value_evaluated;
                } else {
                    String param = DB.getSQLValueStringEx(null, (String)"SELECT ColumnName FROM AD_Process_Para WHERE IsActive='Y' AND AD_Process_ID=? AND LOWER(ColumnName)=?", (Object[])new Object[]{process.getAD_Process_ID(), parameterName.toLowerCase()});
                    if (param == null) {
                        boolean ok = Util.evaluateError(msgerror1, "Parameter Not Found", isErrorExpected);
                        if (ok) {
                            this.right(this.getCell(i, 1));
                        } else {
                            this.exception(this.getCell(i, 1), new Exception("Parameter Not Found"));
                        }
                    } else {
                        fmap.put(param, value_evaluated);
                    }
                }
            }
            ++i;
        }
    }

    private void addLogInfo(MPInstance pInstance, int i) {
        MPInstanceLog[] pils = pInstance.getLog();
        if (pils != null && pils.length > 0) {
            this.getCell(i, 1).addToBody("<hr>");
            SimpleDateFormat dateFormat = DisplayType.getDateFormat((int)16);
            MPInstanceLog[] mPInstanceLogArray = pInstance.getLog();
            int n = mPInstanceLogArray.length;
            int n2 = 0;
            while (n2 < n) {
                MPInstanceLog pil = mPInstanceLogArray[n2];
                if (pil.getP_Date() != null) {
                    this.getCell(i, 1).addToBody(String.valueOf(dateFormat.format(pil.getP_Date())) + " \t");
                }
                if (pil.getP_Number() != null) {
                    this.getCell(i, 1).addToBody(pil.getP_Number() + " \t");
                }
                if (pil.getP_Msg() != null) {
                    this.getCell(i, 1).addToBody(Msg.parseTranslation((Properties)adempiereInstance.getAdempiereService().getCtx(), (String)pil.getP_Msg()).replaceAll("\\n", "<br>"));
                }
                ++n2;
            }
        }
    }

    private String setParams(MProcess process, MPInstancePara[] iParams, HashMap<String, Object> fmap) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
        int pi = 0;
        while (pi < iParams.length) {
            MPInstancePara iPara = iParams[pi];
            String key = iPara.getParameterName();
            MProcessPara pPara = process.getParameter(key);
            if (pPara == null) {
                return "Parameter not found: " + key;
            }
            int displayType = pPara.getAD_Reference_ID();
            String valueString = null;
            Object ob = fmap.get(key);
            if (ob != null) {
                valueString = ob.toString();
            }
            String valueString2 = null;
            if (pPara.isRange() && (ob = fmap.get(String.valueOf(key) + "_2")) != null) {
                valueString2 = ob.toString();
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("fillParameter - " + key + " = " + valueString);
            }
            String value = valueString;
            if (valueString != null && valueString.length() == 0) {
                value = null;
            }
            if (value != null && (17 == displayType || 19 == displayType || 18 == displayType) && value.equals("-1")) {
                value = null;
            }
            if (value == null && 20 != pPara.getAD_Reference_ID()) {
                if (pPara.isMandatory()) {
                    return "Parameter " + pPara.getName() + " is required";
                }
            } else {
                try {
                    if (DisplayType.isNumeric((int)displayType) || DisplayType.isID((int)displayType)) {
                        BigDecimal bd = null;
                        bd = value instanceof BigDecimal ? (BigDecimal)((Object)value) : (value instanceof Integer ? new BigDecimal((Integer)((Object)value)) : new BigDecimal(value.toString()));
                        iPara.setP_Number(bd);
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("fillParameter - " + key + " = " + valueString + " (=" + bd + "=)");
                        }
                        if (pPara.isRange()) {
                            bd = null;
                            bd = new BigDecimal(valueString2.toString());
                            iPara.setP_Number_To(bd);
                        }
                    } else if (DisplayType.isDate((int)displayType)) {
                        Date d = displayType == 16 ? dateFormat.parse(value.toString()) : dateFormat.parse(value.toString());
                        Timestamp ts = null;
                        ts = new Timestamp(d.getTime());
                        iPara.setP_Date(ts);
                        if (pPara.isRange()) {
                            d = displayType == 16 ? dateFormat.parse(valueString2) : (valueString2 == null || valueString2.length() == 0 ? new Date() : dateFormat.parse(valueString2));
                            ts = new Timestamp(d.getTime());
                            iPara.setP_Date_To(ts);
                        }
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("fillParameter - " + key + " = " + valueString + " (=" + ts + "=)");
                        }
                    } else if (20 == pPara.getAD_Reference_ID()) {
                        String bv = "N";
                        bv = value == null ? "N" : ("true".equalsIgnoreCase(valueString) || "y".equalsIgnoreCase(valueString) ? "Y" : "N");
                        iPara.setP_String(bv);
                    } else {
                        iPara.setP_String(value.toString());
                    }
                    if (pPara.isLookup()) {
                        NamePair np;
                        Lookup lok = pPara.getLookup();
                        if (lok != null && (np = lok.getDirect((Object)value, false, false)) != null) {
                            iPara.setInfo(np.getName());
                        }
                    } else {
                        if (value != null) {
                            iPara.setInfo(value.toString());
                        }
                        if (valueString2 != null) {
                            iPara.setInfo_To(valueString2);
                        }
                    }
                    iPara.saveEx();
                }
                catch (Exception e) {
                    return "fillParameter - " + key + " = " + valueString + " (" + value + ") " + value.getClass().getName() + " - " + e.getLocalizedMessage();
                }
            }
            ++pi;
        }
        return null;
    }
}

