/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.fitnesse.fixture;

import fitnesse.fixtures.TableFixture;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.idempiere.fitnesse.fixture.Instance;
import org.idempiere.fitnesse.fixture.Static_iDempiereInstance;
import org.idempiere.fitnesse.fixture.Util;

public class ReadRecord
extends TableFixture {
    private static volatile Instance adempiereInstance = null;

    protected void doStaticTable(int rows) {
        if (adempiereInstance == null) {
            adempiereInstance = Static_iDempiereInstance.getInstance();
        }
        if (adempiereInstance.getAdempiereService() == null || !adempiereInstance.getAdempiereService().isLoggedIn()) {
            this.wrong(rows - 1, 1);
            this.getCell(rows - 1, 1).addToBody("not logged in");
            return;
        }
        Properties ctx = adempiereInstance.getAdempiereService().getCtx();
        int windowNo = adempiereInstance.getAdempiereService().getWindowNo();
        PO gpo = null;
        String tableName = new String("");
        boolean tableOK = false;
        MTable table = null;
        POInfo poinfo = null;
        boolean alreadyread = false;
        StringBuilder whereclause = new StringBuilder();
        boolean isErrorExpected = false;
        int i = 0;
        while (i < rows) {
            String cell_title = this.getText(i, 0);
            String cell_value = this.getText(i, 1);
            if (cell_title.equalsIgnoreCase("*Table*")) {
                if (i > 0) {
                    this.exception(this.getCell(i, 1), new Exception("*Table* must be defined in first row"));
                    return;
                }
                tableName = cell_value;
                table = MTable.get((Properties)ctx, (String)tableName);
                if (table == null || table.get_ID() <= 0) {
                    this.wrong(i, 1);
                    tableOK = false;
                } else {
                    tableOK = true;
                }
                poinfo = POInfo.getPOInfo((Properties)ctx, (int)(table != null ? table.getAD_Table_ID() : 0));
            } else if (cell_title.equalsIgnoreCase("*Where*")) {
                if (i != 1) {
                    this.exception(this.getCell(i, 1), new Exception("*Where* must be defined in second row"));
                    return;
                }
                whereclause.append(cell_value);
            } else if (cell_title.equalsIgnoreCase("*Read*") || cell_title.equalsIgnoreCase("*Read*Error*")) {
                ResultSet rs;
                CPreparedStatement pstmt;
                block38: {
                    block39: {
                        boolean ok;
                        String sql;
                        block36: {
                            block37: {
                                if (!tableOK) {
                                    this.getCell(i, 1).addToBody("Table " + tableName + " does not exist");
                                    this.wrong(i, 1);
                                    return;
                                }
                                isErrorExpected = "*Read*Error*".equalsIgnoreCase(cell_title);
                                if (whereclause.length() == 0) {
                                    this.getCell(i, 1).addToBody("No where clause");
                                    this.wrong(i, 1);
                                    return;
                                }
                                whereclause.insert(0, "(");
                                whereclause.append(") AND AD_Client_ID IN (0,").append(Env.getAD_Client_ID((Properties)ctx)).append(")");
                                sql = "SELECT * FROM " + tableName + " WHERE " + whereclause;
                                pstmt = null;
                                rs = null;
                                pstmt = DB.prepareStatement((String)sql, null);
                                rs = pstmt.executeQuery();
                                if (rs.next()) {
                                    gpo = table.getPO(rs, null);
                                    if (isErrorExpected) {
                                        this.wrong(i, 1);
                                    }
                                    break block36;
                                }
                                this.getCell(i, 1).addToBody("No record found: " + sql);
                                ok = Util.evaluateError("No record found: ", cell_value, isErrorExpected);
                                if (ok) {
                                    this.right(i, 1);
                                    break block37;
                                }
                                this.wrong(i, 1);
                            }
                            DB.close((ResultSet)rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                            return;
                        }
                        try {
                            if (!rs.next()) break block38;
                            this.getCell(i, 1).addToBody("More than one record found: " + sql);
                            ok = Util.evaluateError("More than one record found: ", cell_value, isErrorExpected);
                            if (ok) {
                                this.right(i, 1);
                                break block39;
                            }
                            this.wrong(i, 1);
                        }
                        catch (SQLException e) {
                            block40: {
                                try {
                                    boolean ok2 = Util.evaluateError(e.getMessage(), cell_value, isErrorExpected);
                                    if (ok2) {
                                        this.right(this.getCell(i, 1));
                                        break block40;
                                    }
                                    this.exception(this.getCell(i, 1), e);
                                }
                                catch (Throwable throwable) {
                                    DB.close(rs, (Statement)pstmt);
                                    rs = null;
                                    pstmt = null;
                                    throw throwable;
                                }
                            }
                            DB.close((ResultSet)rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                            return;
                        }
                    }
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    return;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                this.right(i, 1);
                if (gpo != null) {
                    this.getCell(i, 1).addToBody(gpo.toString());
                }
                int idx = 0;
                while (idx < poinfo.getColumnCount()) {
                    String colname = poinfo.getColumnName(idx);
                    Object result = gpo.get_Value(colname);
                    if (result != null) {
                        Env.setContext((Properties)ctx, (int)windowNo, (String)(String.valueOf(poinfo.getTableName().toLowerCase()) + "." + colname.toLowerCase()), (String)result.toString());
                    }
                    ++idx;
                }
                alreadyread = true;
            } else if (tableOK) {
                if (!alreadyread) {
                    String value_evaluated = Util.evaluate(ctx, windowNo, cell_value, this.getCell(i, 1));
                    if (whereclause.length() > 0) {
                        whereclause.insert(0, "(");
                        whereclause.append(") AND ");
                    }
                    whereclause.append(cell_title).append("=").append(value_evaluated);
                } else if (gpo != null) {
                    if (poinfo.getColumnIndex(cell_title) < 0) {
                        this.wrong(i, 0);
                    } else {
                        Object result = gpo.get_Value(cell_title);
                        if (result != null) {
                            this.getCell(i, 1).addToBody(result.toString());
                        }
                    }
                }
            }
            ++i;
        }
    }
}

