/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.fitnesse.fixture;

import fitnesse.fixtures.TableFixture;
import java.util.Properties;
import org.compiere.model.MSession;
import org.compiere.model.MUser;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.idempiere.fitnesse.fixture.Instance;
import org.idempiere.fitnesse.fixture.Service;
import org.idempiere.fitnesse.fixture.Static_iDempiereInstance;
import org.idempiere.fitnesse.fixture.Util;

public class Login
extends TableFixture {
    private static final String LANGUAGE_EN_US = "en_US";
    private static volatile Instance adempiereInstance = null;
    private String m_user;
    private String m_password;
    private String m_language;
    private int m_client_id = -1;
    private int m_org_id = 0;
    private int m_role_id = -1;
    private int m_warehouse_id = 0;

    protected void doStaticTable(int rows) {
        if (adempiereInstance == null) {
            adempiereInstance = Static_iDempiereInstance.getInstance();
        }
        Properties ctx = adempiereInstance.getAdempiereService().getCtx();
        boolean isErrorExpected = "*Login*Error*".equalsIgnoreCase(this.getText(rows - 1, 0));
        String msgerror = this.getText(rows - 1, 1);
        int i = 0;
        while (i < rows) {
            String cell_title = this.getText(i, 0);
            String cell_value = this.getText(i, 1);
            String value_evaluated = Util.evaluate(null, 0, cell_value, this.getCell(i, 1));
            if (cell_title.equalsIgnoreCase("User")) {
                this.m_user = value_evaluated;
            } else if (cell_title.equalsIgnoreCase("Password")) {
                this.m_password = value_evaluated;
            } else if (cell_title.equalsIgnoreCase("Language")) {
                this.m_language = value_evaluated;
            } else if (cell_title.equalsIgnoreCase("AD_Role_ID")) {
                try {
                    this.m_role_id = Integer.parseInt(value_evaluated);
                }
                catch (NumberFormatException e) {
                    this.exception(this.getCell(i, 1), e);
                }
            } else if (cell_title.equalsIgnoreCase("AD_Client_ID")) {
                try {
                    this.m_client_id = Integer.parseInt(value_evaluated);
                }
                catch (NumberFormatException e) {
                    this.exception(this.getCell(i, 1), e);
                }
            } else if (cell_title.equalsIgnoreCase("AD_Org_ID")) {
                try {
                    this.m_org_id = Integer.parseInt(value_evaluated);
                }
                catch (NumberFormatException e) {
                    this.exception(this.getCell(i, 1), e);
                }
            } else if (cell_title.equalsIgnoreCase("M_Warehouse_ID")) {
                try {
                    this.m_warehouse_id = Integer.parseInt(value_evaluated);
                }
                catch (NumberFormatException e) {
                    this.exception(this.getCell(i, 1), e);
                }
            } else if (cell_title.equalsIgnoreCase("*Login*") || cell_title.equalsIgnoreCase("*Login*Error*")) {
                if (i != rows - 1) {
                    this.exception(this.getCell(i, 1), new Exception("*Login* must be called in last row"));
                    return;
                }
                if (this.m_language == null || this.m_language.length() == 0) {
                    this.m_language = LANGUAGE_EN_US;
                }
                if (this.m_user == null || this.m_user.length() == 0 || this.m_password == null || this.m_password.length() == 0 || this.m_role_id < 0 || this.m_client_id < 0) {
                    boolean ok = Util.evaluateError("Incomplete data to login, needed User|Password|AD_Role_ID|AD_Client_ID", msgerror, isErrorExpected);
                    if (ok) {
                        this.right(i, 1);
                    } else {
                        this.exception(this.getCell(rows - 1, 1), new Exception("Incomplete data to login, needed User|Password|AD_Role_ID|AD_Client_ID"));
                    }
                } else {
                    String msg = this.modelLogin();
                    if (msg == null || msg.length() == 0) {
                        MSession.get((Properties)ctx, (boolean)true);
                        if (isErrorExpected) {
                            this.wrong(rows - 1, 0);
                            this.wrong(rows - 1, 1);
                        } else {
                            this.right(rows - 1, 0);
                            this.right(rows - 1, 1);
                        }
                    } else {
                        boolean ok = Util.evaluateError(msg, msgerror, isErrorExpected);
                        if (ok) {
                            this.right(rows - 1, 0);
                        } else {
                            this.wrong(rows - 1, 0);
                            this.exception(this.getCell(rows - 1, 1), new Exception(msg));
                        }
                    }
                }
            } else {
                this.wrong(i, 0);
            }
            ++i;
        }
    }

    private String modelLogin() {
        KeyNamePair[] roles;
        Service m_ads = adempiereInstance.getAdempiereService();
        if (m_ads != null && m_ads.isLoggedIn() && m_ads.getM_AD_Client_ID() == this.m_client_id && m_ads.getM_AD_Org_ID() == this.m_org_id && m_ads.getAD_Role_ID() == this.m_role_id && m_ads.getM_Warehouse_ID() == this.m_warehouse_id && m_ads.getUser().equals(this.m_user)) {
            return null;
        }
        org.compiere.util.Login login = new org.compiere.util.Login(m_ads != null ? m_ads.getCtx() : null);
        KeyNamePair[] clients = login.getClients(this.m_user, this.m_password);
        boolean okclient = false;
        KeyNamePair selectedClient = null;
        KeyNamePair[] keyNamePairArray = clients;
        int n = clients.length;
        int n2 = 0;
        while (n2 < n) {
            KeyNamePair client = keyNamePairArray[n2];
            if (client.getKey() == this.m_client_id) {
                okclient = true;
                selectedClient = client;
                break;
            }
            ++n2;
        }
        if (!okclient) {
            return "Error logging in - client not allowed for this user";
        }
        Env.setContext((Properties)m_ads.getCtx(), (String)"#AD_Client_ID", (String)selectedClient.getID());
        MUser user = MUser.get((Properties)m_ads.getCtx(), (String)this.m_user);
        if (user != null) {
            Env.setContext((Properties)m_ads.getCtx(), (String)"#AD_User_ID", (int)user.getAD_User_ID());
            Env.setContext((Properties)m_ads.getCtx(), (String)"#AD_User_Name", (String)user.getName());
            Env.setContext((Properties)m_ads.getCtx(), (String)"#SalesRep_ID", (int)user.getAD_User_ID());
        }
        if ((roles = login.getRoles(this.m_user, selectedClient)) != null) {
            boolean okrole = false;
            KeyNamePair[] keyNamePairArray2 = roles;
            int n3 = roles.length;
            int n4 = 0;
            while (n4 < n3) {
                KeyNamePair role = keyNamePairArray2[n4];
                if (role.getKey() == this.m_role_id) {
                    okrole = true;
                    break;
                }
                ++n4;
            }
            if (!okrole) {
                return "Error logging in - role not allowed for this user";
            }
            KeyNamePair[] orgs = login.getOrgs(new KeyNamePair(this.m_role_id, ""));
            if (orgs == null) {
                return "Error logging in - no organizations for this role";
            }
            KeyNamePair orglogin = null;
            boolean okorg = false;
            KeyNamePair[] keyNamePairArray3 = orgs;
            int n5 = orgs.length;
            int n6 = 0;
            while (n6 < n5) {
                KeyNamePair org = keyNamePairArray3[n6];
                if (org.getKey() == this.m_org_id) {
                    okorg = true;
                    orglogin = org;
                    break;
                }
                ++n6;
            }
            if (!okorg) {
                return "Error logging in - org not allowed for this role";
            }
            KeyNamePair[] warehouses = login.getWarehouses(new KeyNamePair(this.m_org_id, ""));
            boolean okwh = false;
            if (warehouses == null || warehouses.length == 0) {
                if (this.m_org_id == 0 && this.m_warehouse_id == 0) {
                    okwh = true;
                }
            } else {
                KeyNamePair[] keyNamePairArray4 = warehouses;
                int n7 = warehouses.length;
                int n8 = 0;
                while (n8 < n7) {
                    KeyNamePair warehouse = keyNamePairArray4[n8];
                    if (warehouse.getKey() == this.m_warehouse_id) {
                        okwh = true;
                        break;
                    }
                    ++n8;
                }
            }
            if (!okwh) {
                return "Error logging in - warehouse not allowed for this org";
            }
            String error = login.validateLogin(orglogin);
            if (error != null && error.length() > 0) {
                return error;
            }
            int m_user_id = Env.getAD_User_ID((Properties)m_ads.getCtx());
            if (!m_ads.login(m_user_id, this.m_role_id, this.m_client_id, this.m_org_id, this.m_warehouse_id, this.m_language)) {
                return "Error logging in";
            }
        } else {
            return "Error logging in - no roles or user/pwd invalid for user " + this.m_user;
        }
        int windowNo = adempiereInstance.getAdempiereService().nextWindowNo();
        return null;
    }
}

