/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.fitnesse.fixture;

import fitnesse.fixtures.TableFixture;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.idempiere.fitnesse.fixture.Instance;
import org.idempiere.fitnesse.fixture.Static_iDempiereInstance;
import org.idempiere.fitnesse.fixture.Util;

public class AssertRecord
extends TableFixture {
    private static volatile Instance adempiereInstance = null;

    protected void doStaticTable(int rows) {
        if (adempiereInstance == null) {
            adempiereInstance = Static_iDempiereInstance.getInstance();
        }
        if (adempiereInstance.getAdempiereService() == null || !adempiereInstance.getAdempiereService().isLoggedIn()) {
            this.wrong(rows - 1, 1);
            this.getCell(rows - 1, 1).addToBody("not logged in");
            return;
        }
        Properties ctx = adempiereInstance.getAdempiereService().getCtx();
        int windowNo = adempiereInstance.getAdempiereService().getWindowNo();
        PO gpo = null;
        String tableName = new String("");
        boolean tableOK = false;
        MTable table = null;
        POInfo poinfo = null;
        boolean alreadyread = false;
        StringBuilder whereclause = new StringBuilder();
        boolean isErrorExpected = false;
        int i = 0;
        while (i < rows) {
            String cell_title = this.getText(i, 0);
            String cell_value = this.getText(i, 1);
            if (cell_title.equalsIgnoreCase("*Table*")) {
                if (i > 0) {
                    this.exception(this.getCell(i, 1), new Exception("*Table* must be defined in first row"));
                    return;
                }
                tableName = cell_value;
                table = MTable.get((Properties)ctx, (String)tableName);
                if (table == null || table.get_ID() <= 0) {
                    this.wrong(i, 1);
                    tableOK = false;
                } else {
                    tableOK = true;
                }
                poinfo = POInfo.getPOInfo((Properties)ctx, (int)table.getAD_Table_ID());
            } else if (cell_title.equalsIgnoreCase("*Where*")) {
                if (i != 1) {
                    this.exception(this.getCell(i, 1), new Exception("*Where* must be defined in second row"));
                    return;
                }
                whereclause.append(cell_value);
            } else if (cell_title.equalsIgnoreCase("*Read*") || cell_title.equalsIgnoreCase("*Read*Error*")) {
                ResultSet rs;
                CPreparedStatement pstmt;
                block41: {
                    block42: {
                        String sql;
                        block39: {
                            block40: {
                                block38: {
                                    isErrorExpected = "*Read*Error*".equalsIgnoreCase(cell_title);
                                    if (!tableOK) {
                                        this.getCell(i, 1).addToBody("Table " + tableName + " does not exist");
                                        this.wrong(i, 1);
                                        return;
                                    }
                                    if (whereclause.length() == 0) {
                                        this.getCell(i, 1).addToBody("No where clause");
                                        this.wrong(i, 1);
                                        return;
                                    }
                                    whereclause.insert(0, "(");
                                    whereclause.append(") AND AD_Client_ID IN (0,").append(Env.getAD_Client_ID((Properties)ctx)).append(")");
                                    sql = "SELECT * FROM " + tableName + " WHERE " + whereclause;
                                    pstmt = null;
                                    rs = null;
                                    pstmt = DB.prepareStatement((String)sql, null);
                                    rs = pstmt.executeQuery();
                                    if (!rs.next()) break block38;
                                    gpo = table.getPO(rs, null);
                                    if (!isErrorExpected) break block39;
                                    this.wrong(i, 1);
                                    DB.close((ResultSet)rs, (Statement)pstmt);
                                    rs = null;
                                    pstmt = null;
                                    return;
                                }
                                this.getCell(i, 1).addToBody("No record found: " + sql);
                                boolean ok = Util.evaluateError("No record found: ", cell_value, isErrorExpected);
                                if (ok) {
                                    this.right(i, 1);
                                    break block40;
                                }
                                this.wrong(i, 1);
                            }
                            DB.close((ResultSet)rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                            return;
                        }
                        try {
                            if (!rs.next()) break block41;
                            this.getCell(i, 1).addToBody("More than one record found: " + sql);
                            boolean ok = Util.evaluateError("More than one record found: ", cell_value, isErrorExpected);
                            if (ok) {
                                this.right(i, 1);
                                break block42;
                            }
                            this.wrong(i, 1);
                        }
                        catch (SQLException e) {
                            block43: {
                                try {
                                    boolean ok = Util.evaluateError(e.getMessage(), cell_value, isErrorExpected);
                                    if (ok) {
                                        this.right(this.getCell(i, 1));
                                        break block43;
                                    }
                                    this.exception(this.getCell(i, 1), e);
                                }
                                catch (Throwable throwable) {
                                    DB.close(rs, (Statement)pstmt);
                                    rs = null;
                                    pstmt = null;
                                    throw throwable;
                                }
                            }
                            DB.close((ResultSet)rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                            return;
                        }
                    }
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    return;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                this.right(i, 1);
                if (gpo != null) {
                    this.getCell(i, 1).addToBody(gpo.toString());
                }
                alreadyread = true;
            } else if (tableOK) {
                if (!alreadyread) {
                    String value_evaluated = Util.evaluate(ctx, windowNo, cell_value, this.getCell(i, 1));
                    if (whereclause.length() > 0) {
                        whereclause.insert(0, "(");
                        whereclause.append(") AND ");
                    }
                    whereclause.append(cell_title).append("=").append(value_evaluated);
                } else {
                    String title_evaluated = "";
                    if (gpo != null) {
                        if (poinfo.getColumnIndex(cell_title) < 0) {
                            this.wrong(i, 0);
                        } else {
                            Object result = gpo.get_Value(cell_title);
                            if (result != null) {
                                this.getCell(i, 0).addToBody("<hr/>" + result.toString());
                                title_evaluated = result.toString();
                            }
                            String value_evaluated = cell_value;
                            if (cell_value.startsWith("@")) {
                                value_evaluated = Util.evaluate(ctx, windowNo, cell_value, this.getCell(i, 1));
                            }
                            if (title_evaluated.equals(value_evaluated)) {
                                this.right(i, 1);
                            } else {
                                this.wrong(i, 1);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        int idx = 0;
        while (idx < poinfo.getColumnCount()) {
            String colname = poinfo.getColumnName(idx);
            Object result = gpo.get_Value(colname);
            if (result != null) {
                Env.setContext((Properties)ctx, (int)windowNo, (String)(String.valueOf(tableName.toLowerCase()) + "." + colname.toLowerCase()), (String)result.toString());
            }
            ++idx;
        }
    }
}

