/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.barcode4j;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.components.barcode4j.BarcodeComponent;
import net.sf.jasperreports.components.barcode4j.OrientationEnum;
import net.sf.jasperreports.components.barcode4j.TextPositionEnum;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import org.krysalis.barcode4j.HumanReadablePlacement;

public abstract class Barcode4jComponent
extends BarcodeComponent {
    public static final String PROPERTY_ORIENTATION = "orientation";
    public static final String PROPERTY_PATTERN_EXPRESSION = "patternExpression";
    public static final String PROPERTY_MODULE_WIDTH = "moduleWidth";
    public static final String PROPERTY_TEXT_POSITION = "textPosition";
    public static final String PROPERTY_QUIET_ZONE = "quietZone";
    public static final String PROPERTY_VERTICAL_QUIET_ZONE = "verticalQuietZone";
    private static final long serialVersionUID = 10200L;
    private OrientationEnum orientationValue;
    private JRExpression patternExpression;
    private Double moduleWidth;
    private TextPositionEnum textPositionValue;
    private Double quietZone;
    private Double verticalQuietZone;

    public int getOrientation() {
        return this.getOrientationValue().getValue();
    }

    public void setOrientation(int orientation) {
        this.setOrientation(OrientationEnum.getByValue(orientation));
    }

    public OrientationEnum getOrientationValue() {
        return this.orientationValue == null ? OrientationEnum.UP : this.orientationValue;
    }

    public void setOrientationValue(OrientationEnum orientationValue) {
        this.setOrientation(orientationValue);
    }

    public void setOrientation(OrientationEnum orientationValue) {
        OrientationEnum old = this.orientationValue;
        this.orientationValue = orientationValue;
        this.getEventSupport().firePropertyChange(PROPERTY_ORIENTATION, old, this.orientationValue);
    }

    public JRExpression getPatternExpression() {
        return this.patternExpression;
    }

    public void setPatternExpression(JRExpression patternExpression) {
        JRExpression old = this.patternExpression;
        this.patternExpression = patternExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_PATTERN_EXPRESSION, old, this.patternExpression);
    }

    public Double getModuleWidth() {
        return this.moduleWidth;
    }

    public void setModuleWidth(Double moduleWidth) {
        Double old = this.moduleWidth;
        this.moduleWidth = moduleWidth;
        this.getEventSupport().firePropertyChange(PROPERTY_MODULE_WIDTH, old, this.moduleWidth);
    }

    public String getTextPosition() {
        return this.getTextPositionValue() == null ? null : this.getTextPositionValue().getName();
    }

    public void setTextPosition(String textPosition) {
        this.setTextPosition(TextPositionEnum.getByName(textPosition));
    }

    public TextPositionEnum getTextPositionValue() {
        return this.textPositionValue;
    }

    public void setTextPositionValue(TextPositionEnum textPositionValue) {
        this.setTextPosition(textPositionValue);
    }

    public void setTextPosition(TextPositionEnum textPositionValue) {
        TextPositionEnum old = this.textPositionValue;
        this.textPositionValue = textPositionValue;
        this.getEventSupport().firePropertyChange(PROPERTY_TEXT_POSITION, old, this.textPositionValue);
    }

    public void setTextPosition(HumanReadablePlacement textPosition) {
        this.setTextPosition(textPosition == null ? null : textPosition.getName());
    }

    @Override
    public Object clone() {
        Barcode4jComponent clone = (Barcode4jComponent)super.clone();
        clone.patternExpression = JRCloneUtils.nullSafeClone(this.patternExpression);
        return clone;
    }

    public Double getQuietZone() {
        return this.quietZone;
    }

    public void setQuietZone(Double quietZone) {
        Double old = this.quietZone;
        this.quietZone = quietZone;
        this.getEventSupport().firePropertyChange(PROPERTY_QUIET_ZONE, old, this.quietZone);
    }

    public Double getVerticalQuietZone() {
        return this.verticalQuietZone;
    }

    public void setVerticalQuietZone(Double verticalQuietZone) {
        Double old = this.verticalQuietZone;
        this.verticalQuietZone = verticalQuietZone;
        this.getEventSupport().firePropertyChange(PROPERTY_VERTICAL_QUIET_ZONE, old, this.verticalQuietZone);
    }

    protected final void copyBarcodeComponentFields(ObjectInputStream.GetField fields) throws IOException {
        int orientation = fields.get(PROPERTY_ORIENTATION, 0);
        this.orientationValue = OrientationEnum.getByValue(orientation);
        this.patternExpression = (JRExpression)fields.get(PROPERTY_PATTERN_EXPRESSION, null);
        this.moduleWidth = (Double)fields.get(PROPERTY_MODULE_WIDTH, null);
        String textPosition = (String)fields.get(PROPERTY_TEXT_POSITION, null);
        this.textPositionValue = TextPositionEnum.getByName(textPosition);
        this.quietZone = (Double)fields.get(PROPERTY_QUIET_ZONE, null);
        this.verticalQuietZone = (Double)fields.get(PROPERTY_VERTICAL_QUIET_ZONE, null);
    }
}

