/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.util.CollectionsX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Locales {
    private static final InheritableThreadLocal<Locale> _thdLocale = new InheritableThreadLocal();
    private static Map<Locale, Locale> _founds = new HashMap<Locale, Locale>(16);

    public static final Locale getCurrent() {
        Locale l = (Locale)_thdLocale.get();
        return l != null ? l : Locale.getDefault();
    }

    public static final boolean testCurrent(String lang, String country) {
        Locale l = Locales.getCurrent();
        return !(lang != null && !lang.equals(l.getLanguage()) || country != null && !country.equals(l.getCountry()));
    }

    public static final Locale setThreadLocal(Locale locale) {
        Locale old = (Locale)_thdLocale.get();
        _thdLocale.set(locale);
        return old;
    }

    public static final Locale getThreadLocal() {
        return (Locale)_thdLocale.get();
    }

    public static final Locale getLocale(String localeString, char separator) {
        if (localeString == null) {
            return null;
        }
        if (separator == '\u0000') {
            separator = (char)(localeString.indexOf(95) >= 0 ? 95 : 44);
        }
        LinkedList<String> list = new LinkedList<String>();
        CollectionsX.parse(list, localeString, separator);
        String lang = "";
        String cnt = "";
        String var = "";
        switch (list.size()) {
            case 0: {
                return null;
            }
            default: {
                assert (list.size() <= 3);
                var = list.get(2);
            }
            case 2: {
                cnt = list.get(1);
                if (cnt.length() == 2) break;
                throw new IllegalArgumentException("Not a valid country: " + localeString);
            }
            case 1: 
        }
        lang = list.get(0);
        if (lang.length() != 2) {
            throw new IllegalArgumentException("Not a valid language: " + localeString);
        }
        return Locales.getLocale(new Locale(lang, cnt, var));
    }

    public static final Locale getLocale(String localeString) {
        return Locales.getLocale(localeString, '\u0000');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Locale getLocale(Locale locale) {
        Locale l = _founds.get(locale);
        if (l != null) {
            return l;
        }
        Map<Locale, Locale> map = _founds;
        synchronized (map) {
            HashMap<Locale, Locale> fs = new HashMap<Locale, Locale>(_founds);
            fs.put(locale, locale);
            _founds = fs;
        }
        return locale;
    }

    public static Locale getByFallback(Collection<Locale> values, Locale locale) {
        if (values.contains(locale)) {
            return locale;
        }
        String lang = locale.getLanguage();
        String cnty = locale.getCountry();
        String var = locale.getVariant();
        if (var != null && var.length() > 0 && values.contains(locale = new Locale(lang, cnty))) {
            return locale;
        }
        if (cnty != null && cnty.length() > 0 && values.contains(locale = new Locale(lang, ""))) {
            return locale;
        }
        Locale rtn = null;
        for (Locale l : values) {
            if (!l.getLanguage().equals(lang)) continue;
            if (var == null || var.length() == 0 || Objects.equals(l.getCountry(), cnty)) {
                return l;
            }
            if (rtn != null) continue;
            rtn = l;
        }
        return rtn;
    }

    public static int indexOfUnderline(String s, int j) {
        int k;
        int last = s.length() - 2;
        while ((k = s.indexOf(95, j)) >= 0 && k < last) {
            char cc = s.charAt(k + 1);
            if (cc >= 'a' && cc <= 'z' && (cc = s.charAt(k + 2)) >= 'a' && cc <= 'z' && ((cc = s.charAt(k + 3)) < 'a' || cc > 'z')) {
                return k;
            }
            j = k + 1;
        }
        return -1;
    }

    public static int indexOfUnderline(String s) {
        return Locales.indexOfUnderline(s, 0);
    }

    static {
        Locale[] ls = new Locale[]{Locale.TRADITIONAL_CHINESE, Locale.SIMPLIFIED_CHINESE, Locale.ENGLISH, Locale.US, Locale.JAPAN, Locale.JAPANESE, Locale.KOREA, Locale.KOREAN, Locale.FRANCE, Locale.FRENCH, Locale.GERMANY, Locale.GERMAN, Locale.CHINESE};
        for (int j = 0; j < ls.length; ++j) {
            _founds.put(ls[j], ls[j]);
        }
    }
}

