-- phpMyAdmin SQL Dump
-- version 2.11.4
-- http://www.phpmyadmin.net
--
-- ホスト: localhost
-- 生成時間: 2008 年 8 月 24 日 11:24
-- サーバのバージョン: 5.0.51
-- PHP のバージョン: 5.2.5

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";

--
-- データベース: `inqman`
--

-- --------------------------------------------------------

--
-- テーブルの構造 `l_authority_parent`
--

DROP TABLE IF EXISTS `l_authority_parent`;
CREATE TABLE IF NOT EXISTS `l_authority_parent` (
  `id` int(11) NOT NULL auto_increment,
  `authority_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `authority_id` (`authority_id`,`parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=23 ;

--
-- テーブルのデータをダンプしています `l_authority_parent`
--

-- --------------------------------------------------------

--
-- テーブルの構造 `m_acl_privilege`
--

DROP TABLE IF EXISTS `m_acl_privilege`;
CREATE TABLE IF NOT EXISTS `m_acl_privilege` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(200) NOT NULL,
  `code` varchar(200) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;

--
-- テーブルのデータをダンプしています `m_acl_privilege`
--

INSERT INTO `m_acl_privilege` (`id`, `name`, `code`) VALUES
(1, '参照する', 'read'),
(2, '作成する', 'create'),
(3, '更新する', 'update'),
(4, '削除する', 'delete'),
(5, '受け付ける', 'accept'),
(6, '承認する', 'approve'),
(7, '担当する', 'takecharge'),
(8, '設定する', 'setup'),
(9, '参照させる', 'reference'),
(10, '派生させる', 'derivation'),
(11, '期限を決める', 'setlimit'),
(12, 'マージする', 'merge'),
(13, '保留にする', 'suspend'),
(14, '解決にする', 'solution');

-- --------------------------------------------------------

--
-- テーブルの構造 `m_acl_resource`
--

DROP TABLE IF EXISTS `m_acl_resource`;
CREATE TABLE IF NOT EXISTS `m_acl_resource` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(200) NOT NULL,
  `code` varchar(200) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=12 ;

--
-- テーブルのデータをダンプしています `m_acl_resource`
--

INSERT INTO `m_acl_resource` (`id`, `name`, `code`) VALUES
(1, 'コメント', 'comment'),
(2, '回答', 'reply'),
(3, '未処理問い合わせ', 'unaccept'),
(4, '未承認問い合わせ', 'unapprove'),
(5, '問い合わせ', 'inquiry'),
(6, '顧客情報', 'customer'),
(7, 'メールテンプレート', 'mail_template'),
(8, 'イベント', 'event'),
(9, '操作履歴', 'op_history'),
(10, 'ユーザ情報', 'user'),
(11, 'サービス', 'service');

-- --------------------------------------------------------

--
-- テーブルの構造 `m_acl_role`
--

DROP TABLE IF EXISTS `m_acl_role`;
CREATE TABLE IF NOT EXISTS `m_acl_role` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL,
  `code` varchar(200) NOT NULL,
  `initial_giving` tinyint(1) NOT NULL default '0',
  `parent_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- テーブルのデータをダンプしています `m_acl_role`
--

INSERT INTO `m_acl_role` (`id`, `name`, `code`, `initial_giving`, `parent_id`) VALUES
(1, 'アドバイザ', 'adviser', 1, 0),
(2, 'オペレータ', 'operator', 1, 1),
(3, 'マネージャ', 'manager', 1, 2),
(4, 'システム管理者', 'sysadm', 0, 3);

-- --------------------------------------------------------

--
-- テーブルの構造 `m_acl_struct`
--

DROP TABLE IF EXISTS `m_acl_struct`;
CREATE TABLE IF NOT EXISTS `m_acl_struct` (
  `id` int(11) NOT NULL auto_increment,
  `resource_id` int(11) NOT NULL,
  `privilege_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `role_id` (`resource_id`,`privilege_id`,`role_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=64 ;

--
-- テーブルのデータをダンプしています `m_acl_struct`
--

INSERT INTO `m_acl_struct` (`id`, `resource_id`, `privilege_id`, `role_id`) VALUES
(1, 1, 1, 1),
(2, 1, 2, 1),
(3, 1, 3, 2),
(4, 1, 4, 2),
(5, 2, 1, 1),
(6, 2, 2, 2),
(7, 2, 3, 3),
(8, 2, 4, 3),
(10, 3, 1, 1),
(11, 3, 4, 2),
(12, 3, 3, 2),
(13, 5, 5, 2),
(14, 4, 1, 2),
(15, 4, 4, 3),
(16, 4, 3, 3),
(17, 5, 6, 3),
(18, 5, 1, 1),
(19, 5, 4, 3),
(20, 5, 3, 3),
(21, 5, 7, 2),
(22, 5, 9, 2),
(23, 5, 10, 2),
(24, 5, 11, 2),
(25, 5, 12, 2),
(26, 7, 1, 1),
(27, 7, 2, 1),
(28, 7, 3, 1),
(29, 7, 4, 1),
(30, 8, 8, 3),
(31, 9, 2, 2),
(32, 9, 4, 3),
(33, 6, 1, 2),
(34, 6, 2, 2),
(35, 6, 3, 2),
(36, 6, 4, 2),
(37, 10, 1, 4),
(38, 10, 2, 4),
(39, 10, 3, 4),
(40, 10, 4, 4),
(41, 11, 1, 4),
(42, 11, 2, 4),
(43, 11, 3, 4),
(44, 11, 4, 4),
(9, 5, 2, 1),
(58, 5, 13, 3),
(59, 5, 14, 3),
(60, 7, 1, 4),
(61, 7, 2, 4),
(62, 7, 3, 4),
(63, 7, 4, 4);

-- --------------------------------------------------------

--
-- テーブルの構造 `m_event_action`
--

DROP TABLE IF EXISTS `m_event_action`;
CREATE TABLE IF NOT EXISTS `m_event_action` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(200) NOT NULL,
  `event_timing` int(11) NOT NULL COMMENT 'event_id',
  `event_to` int(11) NOT NULL,
  `event_mail` int(11) NOT NULL COMMENT 'default_mailtemplate_id',
  `enable` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=16 ;

--
-- テーブルのデータをダンプしています `m_event_action`
--

INSERT INTO `m_event_action` (`id`, `name`, `event_timing`, `event_to`, `event_mail`, `enable`) VALUES
(1, '問い合わせのメール投稿時に投稿者に自動返信する', 1, 1, 1, 0),
(2, '問い合わせ登録時に指定グループに通知する', 1, 0, 2, 1),
(3, '問い合わせの起票時に起票者に自動返信する', 2, 2, 3, 0),
(4, '問い合わせの起票時に指定グループに通知する', 2, 0, 4, 1),
(5, '問い合わせの却下時に起票者に通知する', 3, 2, 5, 0),
(6, '問い合わせの却下時に指定グループに通知する', 3, 0, 5, 1),
(7, '問い合わせの承認時に起票者に通知する', 4, 2, 6, 0),
(8, '問い合わせの承認時に指定グループに通知する', 4, 0, 6, 1),
(9, 'コメント投稿時に投稿者に自動返信する', 5, 4, 7, 0),
(10, 'コメント投稿時に指定グループに通知する', 5, 0, 8, 1),
(11, '回答時に質問者に自動返信する', 6, 1, 9, 1),
(12, '回答時に指定グループに通知する', 6, 0, 10, 1),
(13, '問い合わせの保留時に指定グループに通知する', 7, 0, 11, 0),
(14, '問い合わせの期限切れ時に指定グループに通知する', 8, 0, 12, 0),
(15, '問い合わせの解決時に指定グループに通知する', 9, 0, 13, 0);

-- --------------------------------------------------------

--
-- テーブルの構造 `m_event_timing`
--

DROP TABLE IF EXISTS `m_event_timing`;
CREATE TABLE IF NOT EXISTS `m_event_timing` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(200) NOT NULL,
  `code` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- テーブルのデータをダンプしています `m_event_timing`
--

INSERT INTO `m_event_timing` (`id`, `name`, `code`) VALUES
(1, 'メール投稿時', 10),
(2, '起票時', 20),
(3, '却下時', 30),
(4, '承認時', 40),
(5, '回答時', 50),
(6, 'コメント投稿時', 60),
(7, '保留時', 70),
(8, '期限切れ時', 80),
(9, '解決時', 90);

-- --------------------------------------------------------

--
-- テーブルの構造 `m_service`
--

DROP TABLE IF EXISTS `m_service`;
CREATE TABLE IF NOT EXISTS `m_service` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  `inquiry_mailaddress` varchar(255) default NULL,
  `comment_mailaddress` varchar(255) default NULL,
  `code` varchar(50) default NULL,
  `enable` tinyint(1) NOT NULL default '0',
  `deleted` tinyint(1) NOT NULL default '0',
  `create_datetime` datetime default NULL,
  `update_datetime` datetime default NULL,
  `delete_datetime` datetime default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `inquiry_mailaddress` (`inquiry_mailaddress`),
  UNIQUE KEY `comment_mailaddress` (`comment_mailaddress`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- テーブルのデータをダンプしています `m_service`
--

INSERT INTO `m_service` (`id`, `name`, `inquiry_mailaddress`, `comment_mailaddress`, `code`, `enable`, `deleted`) VALUES
(1, 'グローバルサービス（全サービス共通）', NULL, NULL, 'global', 0, 0);

-- --------------------------------------------------------

--
-- テーブルの構造 `m_sysvar`
--

DROP TABLE IF EXISTS `m_sysvar`;
CREATE TABLE IF NOT EXISTS `m_sysvar` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL,
  `var_name` varchar(100) NOT NULL,
  `table_name` varchar(100) NOT NULL,
  `column_name` varchar(100) NOT NULL,
  `category` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `var_name` (`var_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=16 ;

--
-- テーブルのデータをダンプしています `m_sysvar`
--

INSERT INTO `m_sysvar` (`id`, `name`, `var_name`, `table_name`, `column_name`, `category`) VALUES
(1, '回答件名', '{$reply_subject}', 'reply', 'subject', 0),
(2, '回答内容', '{$reply_content}', 'reply', 'content', 0),
(3, 'コメント件名', '{$comment_subject}', 'comment', 'subject', 0),
(4, 'コメント内容', '{$comment_content}', 'comment', 'content', 0),
(5, 'サービス名', '{$service_name}', 'service', 'name', 0),
(6, '問い合わせ件名', '{$inquiry_subject}', 'inquiry', 'subject', 0),
(7, '問い合わせ内容', '{$inquiry_content}', 'inquiry', 'content', 0),
(8, '担当者ユーザID', '{$operator_userid}', 'inquiry', 'operator_userid', 0),
(9, '担当者名', '{$operator_name}', 'inquiry', 'operator_name', 0),
(10, '担当者メールアドレス', '{$operator_mailaddress}', 'inquiry', 'operator_mailaddress', 0),
(11, '問い合わせ用メールアドレス', '{$service_inquiry_mailaddress}', 'service', 'inquiry_mailaddress', 0),
(12, 'コメント用メールアドレス', '{$service_comment_mailaddress}', 'service', 'comment_mailaddress', 0),
(13, '問い合わせID', '{$inquiry_id}', 'inquiry', 'id', 0),
(14, '問い合わせ送信者', '{$inquiry_received_from}', 'inquiry', 'received_from', 0),
(15, '回答送信者', '{$reply_received_from}', 'reply', 'received_from', 0);

-- --------------------------------------------------------

--
-- テーブルの構造 `m_user`
--

DROP TABLE IF EXISTS `m_user`;
CREATE TABLE IF NOT EXISTS `m_user` (
  `id` int(11) NOT NULL auto_increment,
  `user_id` varchar(50) NOT NULL,
  `name` varchar(100) NOT NULL,
  `password` varchar(200) NOT NULL,
  `mailaddress` varchar(100) NOT NULL,
  `enable` tinyint(1) NOT NULL,
  `deleted` tinyint(1) NOT NULL,
  `create_datetime` datetime default NULL,
  `update_datetime` datetime default NULL,
  `delete_datetime` datetime default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `user_id` (`user_id`),
  UNIQUE KEY `mailaddress` (`mailaddress`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;

--
-- テーブルのデータをダンプしています `m_user`
--

INSERT INTO `m_user` (`id`, `user_id`, `name`, `password`, `mailaddress`, `enable`, `deleted`) VALUES
(1, 'root', 'システム管理ユーザ', 'aaa351c4b31f65a33bf5fe1a3b0424ff7bdb197c', 'root@example.com', 0, 0);

-- --------------------------------------------------------

--
-- テーブルの構造 `t_acl_authority`
--

DROP TABLE IF EXISTS `t_acl_authority`;
CREATE TABLE IF NOT EXISTS `t_acl_authority` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(200) NOT NULL,
  `role_id` int(11) NOT NULL,
  `service_id` int(11) default NULL,
  `enable` tinyint(4) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `role_id` (`role_id`,`service_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- テーブルのデータをダンプしています `t_acl_authority`
--

INSERT INTO `t_acl_authority` (`id`, `name`, `role_id`, `service_id`, `enable`) VALUES
(1, 'システム管理', 4, 1, 1);

-- --------------------------------------------------------

--
-- テーブルの構造 `t_acl_serial`
--

DROP TABLE IF EXISTS `t_acl_serial`;
CREATE TABLE IF NOT EXISTS `t_acl_serial` (
  `id` int(11) NOT NULL auto_increment,
  `service_id` int(11) NOT NULL,
  `dump_text` text NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `service_id` (`service_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- テーブルのデータをダンプしています `t_acl_serial`
--


-- --------------------------------------------------------

--
-- テーブルの構造 `t_acl_user`
--

DROP TABLE IF EXISTS `t_acl_user`;
CREATE TABLE IF NOT EXISTS `t_acl_user` (
  `id` int(11) NOT NULL auto_increment,
  `user_id` int(11) NOT NULL,
  `authority_id` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `user_id` (`user_id`,`authority_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- テーブルのデータをダンプしています `t_acl_user`
--

INSERT INTO `t_acl_user` (`id`, `user_id`, `authority_id`) VALUES
(1, 1, 1);

-- --------------------------------------------------------

--
-- テーブルの構造 `t_inquiry`
--

DROP TABLE IF EXISTS `t_inquiry`;
CREATE TABLE IF NOT EXISTS `t_inquiry` (
  `id` int(11) NOT NULL auto_increment,
  `number` int(11) NOT NULL,
  `subject` varchar(200) NOT NULL,
  `content` text NOT NULL,
  `create_datetime` datetime NOT NULL,
  `accept_datetime` datetime default NULL,
  `approval_datetime` datetime default NULL,
  `assign_datetime` datetime default NULL,
  `replylimit_datetime` datetime default NULL,
  `suspension_datetime` datetime default NULL,
  `solution_datetime` datetime default NULL,
  `status` tinyint(4) NOT NULL default '0',
  `priority` tinyint(4) NOT NULL default '0',
  `service_id` int(11) NOT NULL,
  `registrant_id` int(4) default NULL,
  `accepter_id` int(11) default NULL,
  `approver_id` int(11) default NULL,
  `operator_id` int(11) default NULL,
  `parent_inquiry_id` int(11) default NULL,
  `customer_id` int(11) default NULL,
  `received_from` varchar(200) default NULL,
  `memo` text,
  `message_id` varchar(200) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `number` (`number`,`service_id`),
  KEY `service_id` (`service_id`),
  KEY `parent_inquiry_id` (`parent_inquiry_id`),
  KEY `operator_id` (`operator_id`),
  KEY `approver_id` (`approver_id`),
  KEY `accepter_id` (`accepter_id`),
  KEY `registrant_id` (`registrant_id`),
  KEY `status` (`status`),
  KEY `create_datetime` (`create_datetime`),
  KEY `accept_datetime` (`accept_datetime`),
  KEY `approval_datetime` (`approval_datetime`),
  KEY `assign_datetime` (`assign_datetime`),
  KEY `replylimit_datetime` (`replylimit_datetime`),
  KEY `suspension_datetime` (`suspension_datetime`),
  KEY `solution_datetime` (`solution_datetime`),
  KEY `message_id` (`message_id`),
  KEY `received_from` (`received_from`),
  FULLTEXT KEY `content` (`content`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- テーブルのデータをダンプしています `t_inquiry`
--


-- --------------------------------------------------------

--
-- テーブルの構造 `t_inquiry_attach`
--

DROP TABLE IF EXISTS `t_inquiry_attach`;
CREATE TABLE IF NOT EXISTS `t_inquiry_attach` (
  `id` int(11) NOT NULL auto_increment,
  `inquiry_id` int(11) NOT NULL,
  `name` varchar(200) NOT NULL,
  `mime_type` varchar(100) NOT NULL,
  `enced_content` longtext NOT NULL,
  `register_datetime` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `inquiry_id` (`inquiry_id`),
  KEY `name` (`name`),
  KEY `register_datetime` (`register_datetime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- テーブルのデータをダンプしています `t_inquiry_attach`
--


-- --------------------------------------------------------

--
-- テーブルの構造 `t_inquiry_reference`
--

DROP TABLE IF EXISTS `t_inquiry_reference`;
CREATE TABLE IF NOT EXISTS `t_inquiry_reference` (
  `id` int(11) NOT NULL auto_increment,
  `referenced_inquiry_id` int(11) NOT NULL,
  `inquiry_id` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `referenced_inquiry_id` (`referenced_inquiry_id`,`inquiry_id`),
  KEY `referenced_inquiry_id_2` (`referenced_inquiry_id`),
  KEY `inquiry_id` (`inquiry_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- テーブルのデータをダンプしています `t_inquiry_reference`
--


-- --------------------------------------------------------

--
-- テーブルの構造 `t_maildump`
--

DROP TABLE IF EXISTS `t_maildump`;
CREATE TABLE IF NOT EXISTS `t_maildump` (
  `id` int(11) NOT NULL auto_increment,
  `unique_id` varchar(200) NOT NULL,
  `header` text NOT NULL,
  `content` text NOT NULL,
  `create_datetime` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `unique_id` (`unique_id`),
  KEY `create_datetime` (`create_datetime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- テーブルのデータをダンプしています `t_maildump`
--


-- --------------------------------------------------------

--
-- テーブルの構造 `t_mailtemplate`
--

DROP TABLE IF EXISTS `t_mailtemplate`;
CREATE TABLE IF NOT EXISTS `t_mailtemplate` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(200) NOT NULL,
  `subject` varchar(200) default NULL,
  `content` text,
  `mail_from` varchar(200) default NULL,
  `service_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

--
-- テーブルのデータをダンプしています `t_mailtemplate`
--

INSERT INTO `t_mailtemplate` (`id`, `name`, `subject`, `content`, `mail_from`, `service_id`) VALUES
(1, '登録知用テンプレート', '問合せが登録されました：{$inquiry_subject}', '「{$service_name}」に問い合わせが登録されました。\r\nSubject:{$inquiry_subject}\r\nFrom:{$inquiry_received_from}\r\n\r\n----------------------- \r\n\r\n{$inquiry_content}\r\n\r\n----------------------- \r\nこのメールはINQMANにより発行されました。', '{$service_inquiry_mailaddress}', 1),
(2, '起票知用テンプレート', '問合せが起票（受付）されました：{$inquiry_subject}', '「{$service_name}」の問い合わせ「{$inquiry_subject}」が起票（受付）されました。\r\nSubject:{$inquiry_subject}\r\nFrom:{$inquiry_received_from}\r\n\r\n----------------------- \r\n\r\n{$inquiry_content}\r\n\r\n----------------------- \r\nこのメールはINQMANにより発行されました。', '{$service_inquiry_mailaddress}', 1),
(3, '却下通知用テンプレート', '問い合わせが却下されました：{$inquiry_subject}', '問い合わせ「{$inquiry_subject}」が起票されました。\r\nSubject:{$inquiry_subject}\r\nFrom:{$inquiry_received_from}\r\n\r\n----------------------- \r\n\r\n{$inquiry_content}\r\n\r\n----------------------- \r\nこのメールはINQMANにより発行されました。', '{$service_inquiry_mailaddress}', 1),
(4, '承認通知用テンプレート', '問い合わせが承認されました：{$inquiry_subject}', '問い合わせ「{$inquiry_subject}」が承認されました。\r\nSubject:{$inquiry_subject}\r\nFrom:{$inquiry_received_from}\r\n\r\n----------------------- \r\n\r\n{$inquiry_content}\r\n\r\n----------------------- \r\nこのメールはINQMANにより発行されました。', '{$service_inquiry_mailaddress}', 1),
(5, '回答通知用テンプレート', '回答がありました：{$reply_subject}', '「{$service_name}」の問い合わせ「{$inquiry_subject}」に回答がありました。\r\nSubject:{$reply_subject}\r\nFrom:{$reply_received_from}\r\n\r\n----------------------- \r\n\r\n{$reply_content}\r\n\r\n----------------------- \r\nこのメールはINQMANにより発行されました。', '{$service_comment_mailaddress}', 1),
(6, 'コメント通知用テンプレート', 'コメントがありました：{$reply_subject}', '「{$service_name}」の問い合わせ「{$inquiry_subject}」にコメントがありました。\r\nSubject:\r\n{$reply_subject}From:{$reply_received_from}\r\n\r\n----------------------- \r\n{$reply_content}\r\n----------------------- \r\nこのメールはINQMANにより発行されました。', '{$service_comment_mailaddress}', 1),
(7, '返信用テンプレート', '{$reply_subject}', '{$reply_content}', '{$service_inquiry_mailaddress}', 1);


-- --------------------------------------------------------

--
-- テーブルの構造 `t_reply`
--

DROP TABLE IF EXISTS `t_reply`;
CREATE TABLE IF NOT EXISTS `t_reply` (
  `id` int(11) NOT NULL auto_increment,
  `type` tinyint(4) NOT NULL default '0',
  `inquiry_id` int(11) NOT NULL default '0',
  `parent_id` int(11) NOT NULL default '0',
  `subject` varchar(200) NOT NULL,
  `content` text NOT NULL,
  `reply_datetime` datetime NOT NULL,
  `method` tinyint(4) NOT NULL default '0',
  `respondent_id` int(11) NOT NULL default '0',
  `received_from` varchar(200) default NULL,
  `status` tinyint(4) NOT NULL default '0',
  `priority` tinyint(4) NOT NULL default '0',
  `level` tinyint(4) NOT NULL default '0',
  `message_id` varchar(200) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `inquiry_id` (`inquiry_id`),
  KEY `parent_id` (`parent_id`),
  KEY `subject` (`subject`),
  KEY `reply_datetime` (`reply_datetime`),
  KEY `respondent_id` (`respondent_id`),
  KEY `received_from` (`received_from`),
  KEY `status` (`status`),
  KEY `message_id` (`message_id`),
  FULLTEXT KEY `content` (`content`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- テーブルのデータをダンプしています `t_reply`
--


-- --------------------------------------------------------

--
-- テーブルの構造 `t_reply_attach`
--

DROP TABLE IF EXISTS `t_reply_attach`;
CREATE TABLE IF NOT EXISTS `t_reply_attach` (
  `id` int(11) NOT NULL auto_increment,
  `reply_id` int(11) NOT NULL,
  `name` varchar(200) NOT NULL,
  `mime_type` varchar(100) NOT NULL,
  `enced_content` text NOT NULL,
  `register_datetime` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `reply_id` (`reply_id`),
  KEY `name` (`name`),
  KEY `register_datetime` (`register_datetime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- テーブルのデータをダンプしています `t_reply_attach`
--


-- --------------------------------------------------------

--
-- テーブルの構造 `t_service_event`
--

DROP TABLE IF EXISTS `t_service_event`;
CREATE TABLE IF NOT EXISTS `t_service_event` (
  `id` int(11) NOT NULL auto_increment,
  `service_id` int(11) NOT NULL default '0',
  `event_action_id` int(11) NOT NULL,
  `authority_id` int(11) NOT NULL default '0',
  `mailtemplate_id` int(11) NOT NULL default '0',
  `enable` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `service_id` (`service_id`,`event_action_id`,`authority_id`,`mailtemplate_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- テーブルのデータをダンプしています `t_service_event`
--


-- --------------------------------------------------------

--
-- テーブルの構造 `t_service_setting`
--

DROP TABLE IF EXISTS `t_service_setting`;
CREATE TABLE IF NOT EXISTS `t_service_setting` (
  `id` int(11) NOT NULL auto_increment,
  `service_id` int(11) NOT NULL,
  `type` tinyint(4) NOT NULL default '0',
  `pop3_host` varchar(16) NOT NULL,
  `pop3_port` int(8) NOT NULL default '110',
  `pop3_user` varchar(50) NOT NULL,
  `pop3_pass` varchar(50) default NULL,
  PRIMARY KEY  (`id`),
  KEY `service_id` (`service_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- テーブルのデータをダンプしています `t_service_setting`
--

