<?php
/*
 * This file is part of INQMAN
 *
 * Copyright(c) 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 *
 * http://www.bullhead.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation;
 * either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Enter description here...
 *
 */
class Inqman_MaildumpModel extends Inqman_AbstractDao
{
    protected $_name = 't_maildump';

    const ID              = 'id';
    const UNIQUE_ID       = 'unique_id';
    const HEADER          = 'header';
    const CONTENT         = 'content';
    const CREATE_DATETIME = 'create_datetime';
    
    /**
     * 
     * 
     */
    public function create($values)
    {
        $values[self::CREATE_DATETIME] = date("Y-m-d H:i:s", time());
        parent::create($values);
    }
    
    /**
     * 受信済みメールのユニークIDを取得する
     * 
     */
    public function getReceivedUniqueId()
    {
        $db = $this->getAdapter();
        $select = $db->select()
                ->from('t_maildump', 'unique_id')
                ->order('id ASC')
        ;
        return $result = $db->fetchCol($select);
    }
    
}

?>
