<?php
/*
 * This file is part of INQMAN
 *
 * Copyright(c) 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 *
 * http://www.bullhead.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation;
 * either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * イベント操作・管理クラス
 *
 * @author 
 * @copyright COPYRIGHT &copy 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 * @version 
 * @package 
 * @see EventActionModel ServiceEventModel
 * 
 */
class Inqman_EventModel extends Inqman_AbstractDao
{
    protected $_name = 'm_event_action';
    
    /**
     * イベントアクション情報を取得する
     * 
     * @return array $result イベントアクション情報を連想配列で返す
     * 
     */
    public function getAllEventActions()
    {
        $db = $this->getAdapter();
        
        $select = $db->select()
                     ->from('m_event_action')
                     ->where('enable<>0')
                     ->order('id asc')
        ;
        
        return $db->fetchAll($select);
    }
    
    /**
     * サービスに設定されたイベントアクション情報を取得する
     * 
     * @access  public
     * @param integer $serviceid サービスID
     * @return array イベントアクション情報を連想配列で返す
     * 
     */
    public function getServiceEventsPerEventAction($service_id)
    {
        $event_actions = $this->getAllEventActions();
        
        $db = $this->getAdapter();
        
        $service_events = array();
        foreach ($event_actions as $event_action) {
            $select = $db->select()
                    ->from('t_service_event')
                    ->where('service_id=?', $service_id)
                    ->where('event_action_id=?', $event_action['id'])
            ;
            $this->_logger->info('Inqman_EventModel->getServiceEventsPerEventAction :' . $select->__toString());
            
            $result = $db->fetchAll($select);
            if (!empty($result)) $service_events[] = $result;
        }
        
        return $service_events;
    }
    
    /**
     * サービスごとのイベント設定を保存する
     * 
     */
    public function saveServiceEvent($service_id, $values)
    {
        try {
        
            $db = $this->getAdapter();
            $db->beginTransaction();
            
            $select = $db->select()
                    ->from('t_service_event', 'id')
                    ->where('service_id=?', $service_id)
            ;
            $this->_logger->info('Inqman_EventModel->saveServiceEvent : ' . $select->__toString());
            $old_ids = $db->fetchCol($select);
            
            $where = $db->quoteInto('service_id=?', $service_id);
            $db->delete('t_service_event', $where);
            
            $count = 0;
            foreach ($values as $value) {
                $data = array(
                        'service_id'      => $service_id,
                        'event_action_id' => $value['event_action_id'],
                        'authority_id'    => $value['authority_id'],
                        'mailtemplate_id' => $value['mailtemplate_id'],
                        'enable'          => 1,
                );
                if (!empty($old_ids[$count])) {
                    $data['id'] = $old_ids[$count];
                }
                $db->insert('t_service_event', $data);
                $count++;
            }
            $db->commit();
        
        } catch (Exception $e) {
            $db->rollBack();
            throw $e;
        }
    }
    
    /**
     * 指定したサービスのイベントに対して対象とメールテンプレートを取得する
     * 
     * @param integer $serviceId 対象のサービスID
     * @param integer $eventActionId 対象のイベントアクションID
     * @return array $groups グループIDを配列で返す
     * 
     */
    public function getEvanetActionTarget($service_id, $event_action_id)
    {
        $db = $this->getAdapter();
        
        $select = $db->select()
                     ->from(array('se' => 't_service_event'))
                     ->joinInner(array('mt'=>'t_mailtemplate'), 'se.mailtemplate_id=mt.id')
                     ->joinInner(array('ea'=>'m_event_action'), 'se.event_action_id=ea.id')
                     ->where('se.service_id=?', $service_id)
                     ->where('se.event_action_id=?', $event_action_id)
                     ->order('se.authority_id asc')
        ;
        $this->_logger->info('Inqman_EventModel->getEventActionTarget : ' . $select->__toString());
    
        return $db->fetchAll($select);
    }
    
}