<?php
/*
 * This file is part of INQMAN
 *
 * Copyright(c) 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 *
 * http://www.bullhead.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation;
 * either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * サービス登録フォームクラス
 * 
 *
 */
class Inqman_ServiceForm extends AbstractForm 
{
    const ID       = 'service_id';
    const NAME     = 'name';
    const CODE     = 'code';
    const INQ_MAIL = 'inquiry_mailaddress';
    const CMT_MAIL = 'comment_mailaddress';
    const STATUS   = 'status';
    const ENABLE   = 'enable';
    
    /**
     * バリデータを設定する
     * 
     * @access protected
     * @return array バリデータチェイン
     */
    protected function _prepareValidators()
    {
        $validators = array();
        $validate_config = $this->_config->validate->service;
        
        //IDフィールドの検証ルールを設定（制限は無し）
        $validId = new Zend_Validate();
        $validators[self::ID] = $validId;
        
        //サービス名フィールドの検証ルールを設定
        $validName = new Zend_Validate();
        $validName
            ->addValidator(new Zend_Validate_NotEmpty(), true)
            ->addValidator(new Zend_Validate_StringLength(0, $validate_config->name->get('max_length', 100)))
        ;
        $validators[self::NAME] = $validName;
        
        //サービスコードフィールドの検証ルールを設定
        $validCode = new Zend_Validate();
        $validCode
            ->addValidator(new Zend_Validate_NotEmpty(), true)
            ->addValidator(new Zend_Validate_StringLength(0, $validate_config->code->get('max_length', 20)))
            ->addValidator(new Zend_Validate_Alnum())
        ;
        $validators[self::CODE] = $validCode;
        
        //受付用メールアドレスフィールドの検証ルールを設定
        $validInqMailaddr = new Zend_Validate();
        $validInqMailaddr->addValidator(new Zend_Validate_NotEmpty(), true)
            ->addValidator(new Zend_Validate_StringLength(0, $validate_config->inquiry_mailaddress->get('max_length', 80)))
            ->addValidator(new Inqman_Validate_EmailAddress())
        ;
        $validators[self::INQ_MAIL] = $validInqMailaddr;
        
        //コメント用メールアドレスフィールドの検証ルールを設定
        $validCmtMailaddr = new Zend_Validate();
        $validCmtMailaddr->addValidator(new Zend_Validate_NotEmpty(), true)
            ->addValidator(new Zend_Validate_StringLength(0, $validate_config->comment_mailaddress->get('max_length', 80)))
            ->addValidator(new Inqman_Validate_EmailAddress())
        ;
        $validators[self::CMT_MAIL] = $validCmtMailaddr;
        
        //有効・無効選択フィールドの検証ルールを設定
        $validStatus = new Zend_Validate();
        $validStatus->addValidator(new Zend_Validate_NotEmpty(), true);
        
        return $validators;
    }
    
    /**
     * フィルタを設定する
     * 
     * @access protected
     * @return array フィルタチェイン
     */
    protected function _prepareFilters()
    {
        $filters = array();
        
        //サービス名フィールドのフィルタ設定
        $filterName = new Zend_Filter();
        $filterName->addFilter(new Zend_Filter_StringTrim());
        $filters[self::NAME] = $filterName;
        
        //サービスコードフィールドのフィルタ設定
        $filterCode = new Zend_Filter();
        $filterCode
                ->addFilter(new Bullhead_Filter_ZenToHan())
                ->addFilter(new Zend_Filter_StringTrim())
                ->addFilter(new Zend_Filter_StringToUpper())
        ;
        $filters[self::CODE] = $filterCode;
        
        //問い合わせメールアドレスフィールドのフィルタ設定
        $filterInqMailaddr = new Zend_Filter();
        $filterInqMailaddr
                ->addFilter(new Bullhead_Filter_ZenToHan())
                ->addFilter(new Zend_Filter_StringTrim())
                ->addFilter(new Zend_Filter_StringToLower())
        ;
        $filters[self::INQ_MAIL] = $filterInqMailaddr;
        
        //コメント用メールアドレスフィールドのフィルタ設定
        $filterCmtMailaddr = new Zend_Filter();
        $filterCmtMailaddr
                ->addFilter(new Bullhead_Filter_ZenToHan())
                ->addFilter(new Zend_Filter_StringTrim())
                ->addFilter(new Zend_Filter_StringToLower())
        ;
        $filters[self::CMT_MAIL] = $filterCmtMailaddr;
        
        return $filters;
    }
    
}
?>
