<?php
// $Id: formdhtmltextarea.php,v 1.1 2004/09/09 05:14:50 onokazu Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
// Author: Kazumi Ono (AKA onokazu)                                          //
// URL: http://www.myweb.ne.jp/, http://www.xoops.org/, http://jp.xoops.org/ //
// Project: The XOOPS Project                                                //
// ------------------------------------------------------------------------- //
/**
 *
 *
 * @package     kernel
 * @subpackage  form
 *
 * @author	    Kazumi Ono	<onokazu@xoops.org>
 * @copyright	copyright (c) 2000-2003 XOOPS.org
 */
/**
 * base class
 */
include_once XOOPS_ROOT_PATH."/class/xoopsform/formtextarea.php";

// Make sure you have included /include/xoopscodes.php, otherwise DHTML will not work properly!

/**
 * A textarea with xoopsish formatting and smilie buttons
 *
 * @author	ITOH Takashi
 * @copyright	copyright (c) 2000-2003 ITT-WEB
 *
 * @package     xanhte
 * @subpackage  form
 */
class XoopsFormPhpBBTextArea extends XoopsFormTextArea
{
	/**
     * Hidden text
	 * @var	string
	 * @access	private
	 */
	var $_hiddenText;

	/**
	 * Constructor
	 *
     * @param	string  $caption    Caption
     * @param	string  $name       "name" attribute
     * @param	string  $value      Initial text
     * @param	int     $rows       Number of rows
     * @param	int     $cols       Number of columns
     * @param	string  $hiddentext Hidden Text
	 */
	function XoopsFormPhpBBTextArea($caption, $name, $value, $rows=5, $cols=50, $hiddentext="xoopsHiddenText")
	{
		$this->XoopsFormTextArea($caption, $name, $value, $rows, $cols);
		$this->_hiddenText = $hiddentext;
		global $xoopsTpl ;
		if(is_object($xoopsTpl)){
			
		}
	}

	/**
	 * Prepare HTML for output
	 *
     * @return	string  HTML
	 */
	function render()
	{
	$smile_icons = $this->_renderSmileys() ;
	$textarea_value = $this->getValue() ;
	
	$phpbb_textarea=<<<EOF
	<div>
	<span class="fname-msg hidetext"></span>
	<span class="value icons">
		<ul class="posteditor">
		<li>
			<input type="button" class="button" accesskey="b" name="addbbcode0" value="  " style="font-weight:bold; width: 30px" onclick="bbstyle(0)" onmouseover="helpline('b')" onkeypress="void(0)" />
			<input type="button" class="button" accesskey="i" name="addbbcode2" value="  " style="font-style:italic; width: 30px" onclick="bbstyle(2)" onmouseover="helpline('i')" onkeypress="void(0)" />
			<input type="button" class="button" accesskey="u" name="addbbcode4" value="  " style="text-decoration: underline; width: 30px" onclick="bbstyle(4)" onmouseover="helpline('u')" onkeypress="void(0)" />
			<input type="button" class="button" accesskey="q" name="addbbcode6" value="" style="width: 50px" onclick="bbstyle(6)" onmouseover="helpline('q')" onkeypress="void(0)" />
			<input type="button" class="button" accesskey="c" name="addbbcode8" value="" style="width: 40px" onclick="bbstyle(8)" onmouseover="helpline('c')" onkeypress="void(0)" />
			<input type="button" class="button" accesskey="l" name="addbbcode10" value="ꥹ" style="width: 40px" onclick="bbstyle(10)" onmouseover="helpline('l')" onkeypress="void(0)" />
			<input type="button" class="button" accesskey="p" name="addbbcode14" value="" style="width: 40px"  onclick="bbstyle(14)" onmouseover="helpline('p')" onkeypress="void(0)" />
			<input type="button" class="button" accesskey="w" name="addbbcode16" value="" style="width: 40px" onclick="bbstyle(16)" onmouseover="helpline('w')" onkeypress="void(0)" />
		</li>
		<li>
			&nbsp;եȿ:
			<select name="addbbcode18" onchange="bbfontstyle('[color=' + this.form.addbbcode18.options[this.form.addbbcode18.selectedIndex].value + ']', '[/color]');this.selectedIndex=0;" onmouseover="helpline('s')">
			<option value="#">ư</option>
			<option style="color:#cc0000; background-color:transparent" value="cc0000">()</option>
			<option style="color:#ff0000; background-color:transparent" value="ff0000"></option>
			<option style="color:#ff9900; background-color:transparent" value="ff9900"></option>
			<option style="color:#cc9900; background-color:transparent" value="cc9900"></option>
			<option style="color:#ffcc00; background-color:transparent" value="ffcc00"></option>
			<option style="color:#33cc00; background-color:transparent" value="33cc00"></option>
			<option style="color:#66cc00; background-color:transparent" value="66cc00">꡼</option>
			<option style="color:#00ccff; background-color:transparent" value="00ccff">忧</option>
			<option style="color:#0000ff; background-color:transparent" value="0000ff"></option>
			<option style="color:#0033cc; background-color:transparent" value="0033cc">()</option>
			<option style="color:#000066; background-color:transparent" value="000066"></option>
			<option style="color:#cc0099; background-color:transparent" value="cc0099"></option>
			<option style="color:#ffffff; background-color:transparent" value="ffffff"></option>
			<option style="color:#000000; background-color:transparent" value="000000"></option>
			</select>
			&nbsp;եȥ:
			<select name="addbbcode20" onchange="bbfontstyle('[size=' + this.form.addbbcode20.options[this.form.addbbcode20.selectedIndex].value + ']', '[/size]')" onmouseover="helpline('f')">
			<option value="xx-small">Ǿ</option><option value="x-small"></option><option value="medium" selected="selected"></option><option value="x-large"></option><option  value="xx-large"></option>
			</select>
		</li>
		<li>
			<div class="hideanchor closetag"><a href="javascript:void(javascript:bbstyle(-1))" onmouseover="helpline('a')">Ĥ</a></div>
			<input type="text" name="helpbox" size="45" maxlength="100" class="helpline" value="Tip: 򤷤ƤƥȤ˥᤯ŬѤ뤳ȤǤޤ" />
			<br class="both" />
		</li>
		</ul>
	</span>
	</div>

	<div>
	<span>
		<div class="smiles">
		<p>ޥ꡼</p>
		<div>
		{$smile_icons}
		</div>
		<br class="both" />
		</div>
	</span>
	<span class="value">
	<textarea name="message" cols="70" rows="15" class="blocktext" id='message' onselect="storeCaret(this);" onclick="storeCaret(this);" onkeyup="storeCaret(this);" onmouseup="void(0)" onkeypress="void(0)">{$textarea_value}</textarea>
	</span>
	</div>
EOF;


		return $phpbb_textarea;
	}

	/**
	 * prepare HTML for output of the smiley list.
     *
	 * @return	string HTML
	 */
	function _renderSmileys()
	{
		$myts =& MyTextSanitizer::getInstance();
		$smiles =& $myts->getSmileys();
		$ret = '';
		if (empty($smiles)) {
			$db =& Database::getInstance();
			if ($result = $db->query('SELECT * FROM '.$db->prefix('smiles').' WHERE display=1')) {
				while ($smiles = $db->fetchArray($result)) {
//					$ret .= "<img onclick='xoopsCodeSmilie(\"".$this->getName()."\", \" ".$smiles['code']." \");' onmouseover='style.cursor=\"hand\"' src='".XOOPS_UPLOAD_URL."/".htmlspecialchars($smiles['smile_url'], ENT_QUOTES)."' alt='' />";
					$ret .= '<span><a href="javascript:emoticon(\''.$smiles['code'].'\')"><img src="'.XOOPS_UPLOAD_URL."/".htmlspecialchars($smiles['smile_url'], ENT_QUOTES).'" alt="'.$smiles['code'].'" title="'.$smiles['code'].'" /></a></span>'."\n";
				}
			}
		} else {
			$count = count($smiles);
			for ($i = 0; $i < $count; $i++) {
				if ($smiles[$i]['display'] == 1) {
//					$ret .= "<img onclick='xoopsCodeSmilie(\"".$this->getName()."\", \" ".$smiles[$i]['code']." \");' onmouseover='style.cursor=\"hand\"' src='".XOOPS_UPLOAD_URL."/".$myts->oopsHtmlSpecialChars($smiles['smile_url'])."' border='0' alt='' />";
					$ret .= '<span><a href="javascript:emoticon(\''.$smiles[$i]['code'].'\')"><img src="'.XOOPS_UPLOAD_URL."/".htmlspecialchars($smiles[$i]['smile_url'], ENT_QUOTES).'" alt="'.$smiles[$i]['code'].'" title="'.$smiles[$i]['code'].'" /></a></span>'."\n";
				}
			}
		}
//		$ret .= "&nbsp;[<a href='#moresmiley' onclick='javascript:openWithSelfMain(\"".XOOPS_URL."/misc.php?action=showpopups&amp;type=smilies&amp;target=".$this->getName()."\",\"smilies\",300,475);'>"._MORE."</a>]";
		return $ret;
	}
}
?>
