<?php
// vim: foldmethod=marker
/**
 *	
 *
 *	@author		ITOH Takashi
 *	@package	Sample
 *	@version	$Id: Sample_Rss.php,v 1.1 2005/01/23 13:46:58 masaki-f Exp $
 */

// {{{ Xanhte_XeblogCategory
/**
 *	XanhteץꥱΥ桼饹
 *
 *	@author		ITOH Takashi
 *	@access		public
 *	@package	Sample
 */

class Xanhte_XeblogCategoryManager extends Xanhte_AppManager
{
	function Xanhte_XeblogCategoryManager(&$backend){
		$this->Xanhte_AppManager(&$backend);
	}
	
	// ƥɲ
	function addCategory($cat_pid, $cat_title, $cat_description=null, $cat_imgurl=null){
		is_null($cat_description) and $cat_description = '';
		is_null($cat_imgurl) and $cat_imgurl = '';
		$prop = array(
			'cat_id' => '',
			'cat_pid'=> $cat_pid, 
			'cat_title'=> $cat_title,
			'cat_description' => $cat_description,
			'cat_imgurl' => $cat_imgurl,
			'cat_created' => time(),
			) ;
		$category = new Xanhte_XeblogCategory(&$this->backend, null, null, $prop);
		if( $category->add() === 0 ){
			$ret = intval($category->get('cat_id'));
		}else{
			$ret = false ;
		}
		return $ret ;
	}
	
	/***
	 * ƥ꡼array('1'=>'misc', '2'=>'asc')Ȥ֤
	 * @access public
	 * @return array
	 */
	function getCategoryArray(){
		$filter = array();
		$order = array('cat_id'=>'ASC');
		$cats =& $this->getObjectPropList('XeblogCategory', array('cat_id','cat_title'), $filter, $order);
		$ret = array();
		foreach($cats[1] as $key=>$value){
			$ret[$value['cat_id']] = $value['cat_title'];
		}
		return $ret ;
	}

	/***
	 * ƥ꡼롼Ȥޤ̤äArray֤
	 * @access public
	 * @return array
	 */
	function getCategoryNicePath(){
		$filter = array();
		$order = array('cat_id'=>'ASC');
		$cats =& $this->getObjectPropList('XeblogCategory', array('cat_id','cat_title'), $filter, $order);
		$ret = array();
		foreach($cats[1] as $key=>$value){
			$ret[$value['cat_id']] = $value['cat_title'];
		}
		return $ret ;
	}

	
	/***
	 * /Ʋǽʥƥĥ꡼Array֤
	 * array( array('prefix'=>'0', 'title'=>'cate1'), array('prefix'=>'1', 'title'=>'cate2'.....),
	 * @access public
	 * @param boolean(trueʤ falseʤ)
	 * @param boolean(trueʤXML)
	 * @param int 
	 * @param array
	 * @param string
	 * @return object or array
	 */
	function getCategoryTreeArray($is_read=true, $for_xml=false, $cat_pid=0, $tree=array(), $prefix=''){
		global $xoopsModuleConfig ;
		
		$filter = array('cat_pid' => $cat_pid );
		if($xoopsModuleConfig['use_permissionsystem']){
			if(!isset($GLOBALS['get_allowed_category_so'])){
				$GLOBALS['get_allowed_category_so'] = $this->getAllowedCategorySO($is_read);
			}
			$filter['cat_id'] = $GLOBALS['get_allowed_category_so'];

		}

		$cat = $this->getObjectPropList('XeblogCategory', null, $filter, array('cat_created'=>OBJECT_SORT_ASC));
		if($for_xml==false){
			if($cat[0] == 0){
				return $tree ;
			}else{
				foreach($cat[1] as $key=>$category){
					$category['prefix'] = $prefix.'.' ;
					$tree[] = $category ;
					$tree = $this->getCategoryTreeArray($is_read, $for_xml, $category['cat_id'], $tree, $category['prefix']);
				}
			}
		}else{
			if($cat[0] == 0){
				return array() ;
			}else{
				$ca = array();
				foreach($cat[1] as $key=>$category){
					$ul = $this->getCategoryTreeArray($is_read, $for_xml, $category['cat_id'], array(), '') ;
					if(count($ul)==0){
						$tree[] = array('li' => $category['cat_title']);
					}else{
						$tree[] = array('li' => $category['cat_title'], 'ul'=>$ul) ;
					}
				}
			}
		}
		return $tree ;
	}
	
	
	/***
	 * /ƲǽʥƥξAppSearchObjectˤ֤֤
	 * ($ret_is_objecttrueʤ顢cat_idΤ)
	 * @access public
	 * @param boolean(trueʤ falseʤ)
	 * @return object or array
	 */
	function getAllowedCategorySO($is_read=true, $ret_is_object=true){
		global $xoopsUser, $xoopsModule, $xoopsDB ;
		
		$gperm_name =  $is_read ? 'xeblog_cat_visiblegroup' : 'xeblog_cat_postgroup' ;

		// ޤĤƤcat_id
		$filter_gperm = array();
		$groups = is_object($xoopsUser) ? $xoopsUser->getGroups() : array(XOOPS_GROUP_ANONYMOUS) ;
		$so =& new Ethna_AppSearchObject($groups[0], OBJECT_CONDITION_EQ);
		for($i=1; $i<count($groups); $i++){
			$so->addObject('gperm_groupid', new Ethna_AppSearchObject($groups[$i], OBJECT_CONDITION_EQ) , OBJECT_CONDITION_OR);
		}
		$filter_gperm['gperm_groupid'] = $so ;
		$filter_gperm['gperm_modid'] =& new Ethna_AppSearchObject($xoopsModule->mid(), OBJECT_CONDITION_EQ);
		$filter_gperm['gperm_name'] =& new Ethna_AppSearchObject($gperm_name, OBJECT_CONDITION_EQ);
		
		$gperms = $this->getObjectPropList('Gperm', array('gperm_itemid'), $filter_gperm);
		
		// Short cut
		if($ret_is_object===false){
			$ret_cid = array();
			foreach($gperms[1] as $gperm){
				$ret_cid[] = $gperm['gperm_itemid'];
			}
			return $ret_cid ;
		}
		
		if($gperms[0] == 0){
			$ret_so =&  new Ethna_AppSearchObject(0, OBJECT_CONDITION_EQ); // ƥ꡼0Τ(ĤޤäƤ)
			return $ret_so ;
		}
		$so_catid =& new Ethna_AppSearchObject($gperms[1][0]['gperm_itemid'], OBJECT_CONDITION_EQ);
		for($i=1; $i<$gperms[0]; $i++){
			$so_catid->addObject($xoopsDB->prefix('xeblog.cat_id'), new Ethna_AppSearchObject($gperms[1][$i]['gperm_itemid'], OBJECT_CONDITION_EQ) , OBJECT_CONDITION_OR);
		}
		return $so_catid ;
		
	}

	/***
	 * Ʋǽʥƥ꤫ɤ
	 * @access public
	 * @param int ƥID 
	 * @return boolean
	 */
	function isPostableCategory($cat_id){
		if(!$cat_id) return true ;
		$postable_cid = $this->getAllowedCategorySO(false, false) ;
		$ret = in_array($cat_id, $postable_cid);
		return $ret ;
	}

	/***
	 * ǽʥƥ꤫ɤ
	 * @access public
	 * @param int ƥID 
	 * @return boolean
	 */
	function isReadableCategory($cat_id){
		$readable_cid = $this->getAllowedCategorySO(true, false) ;
		$ret = in_array($cat_id, $readable_cid);
		return $ret ;
	}

}
// }}}

// {{{ Xanhte_Category
/**
 *	XanhteץꥱΥ桼饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Sample
 */
class Xanhte_XeblogCategory extends Xanhte_AppObject
{
	/**#@+
	 *	@access	private
	 */

	/**
	 *	@var	array	ơ֥
	 */
        var $table_def = array(
			'xeblog_category' => array(
				'primary' => true 
				)
			);
	
        var $prop_def = array(
			'cat_id'=> array(
				'primary' => true,
				'key' => true,
				'seq' => true,
				'type' => VAR_TYPE_INT,
				'form_name' => 'cat_id',
				'prop_name' => 'ƥID' ,
				),
			'cat_pid'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'cat_pid',
				'prop_name' => 'ƥοƥƥ' ,
				),
			'cat_title'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_STRING,
				'form_name' => 'cat_title',
				'prop_name' => 'ƥ̾' ,
				),
			'cat_description'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_STRING,
				'form_name' => 'cat_description',
				'prop_name' => 'ƥ' ,
				),
			'cat_created'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'cat_created',
				'prop_name' => 'ƥ' ,
				),
			'cat_imgurl'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_STRING,
				'form_name' => 'cat_imgurl',
				'prop_name' => 'ƥβURL' ,
				),
			);
	
	/**#@-*/	    
	
	/**#@-*/
	
	/**
	 *	Xeblog_Entry饹Υ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	object	Ethna_Backend	&$backend	Ethna_Backend֥
	 *	@param	mixed	$key_type					
	 *	@param	mixed	$key						
	 *	@param	array	$prop						ץѥƥ
	 */
	function Xanhte_XeblogCategory(&$backend, $key_type = null, $key = null, $prop = null)
	{
		$this->Xanhte_AppObject(&$backend, $key_type, $key, $prop);
	    // ֥ȼԤϤ˵Ҥޤ
	}
}
// }}}

?>
