/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.util;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.text.SimpleDateFormat;
import java.util.Date;
import jp.sourceforge.freegantt.locale.Resource;

public class StringUtil {
    public static void drawStringLeft(Graphics g, String str, int x, int y, int width, int height) {
        FontMetrics metrics = g.getFontMetrics();
        int adjustedX = x + 1;
        int adjustedY = y + metrics.getAscent() + (height - metrics.getHeight()) / 2;
        g.drawString(str, adjustedX, adjustedY);
    }

    public static void drawStringCenter(Graphics g, String str, int x, int y, int width, int height) {
        FontMetrics metrics = g.getFontMetrics();
        int stringWidth = metrics.stringWidth(str);
        int adjustedX = x + (width - stringWidth) / 2;
        int adjustedY = y + metrics.getAscent() + (height - metrics.getHeight()) / 2;
        g.drawString(str, adjustedX, adjustedY);
    }

    public static void drawScaledDate(Graphics g, String str, int x, int y, int width, int height, double scaleX) {
        if (str.length() == 1) {
            StringUtil.drawStringCenter(g, str, x, y, width, height);
            return;
        }
        FontMetrics metrics = g.getFontMetrics();
        int stringWidth = metrics.stringWidth(str);
        int adjustedX = (int)((double)x / scaleX) + ((int)((double)width / scaleX) - stringWidth) / 2;
        int adjustedY = y + metrics.getAscent() + (height - metrics.getHeight()) / 2;
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform oldTransform = g2d.getTransform();
        AffineTransform newTransform = (AffineTransform)oldTransform.clone();
        newTransform.scale(scaleX, 1.0);
        g2d.setTransform(newTransform);
        g2d.drawString(str, adjustedX, adjustedY);
        g2d.setTransform(oldTransform);
    }

    public static String getWeekCharacter(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("EEE", Resource.getLocale());
        return format.format(date);
    }
}

