/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.Dimension;
import java.util.Calendar;
import javax.swing.JPanel;
import jp.sourceforge.freegantt.swing.Application;
import jp.sourceforge.freegantt.util.CalendarUtil;

public class TaskLinePane
extends JPanel {
    private static final long serialVersionUID = 843023457646014650L;
    Application app;

    public TaskLinePane(Application app) {
        this.app = app;
        Calendar fromDate = app.getProject().getChartFromDate();
        Calendar toDate = app.getProject().getChartToDate();
        int taskSize = app.getProject().getMaxIndex();
        int width = CalendarUtil.subDate(toDate, fromDate) * this.getCellWidth();
        int height = taskSize * this.getCellHeight() + this.getHeaderHeight();
        this.setBounds(0, 0, width, height);
        this.setPreferredSize(new Dimension(width, height));
    }

    public void updateWidth() {
        Calendar fromDate = this.app.getProject().getChartFromDate();
        Calendar toDate = this.app.getProject().getChartToDate();
        this.setSize(CalendarUtil.subDate(toDate, fromDate) * this.getCellWidth(), this.getHeight());
        this.setPreferredSize(this.getSize());
    }

    public int getCellWidth() {
        return this.app.getProject().getCellSize().width;
    }

    public int getCellHeight() {
        return this.app.getProject().getCellSize().height;
    }

    public int getHeaderHeight() {
        return this.getCellHeight() * 2;
    }
}

