/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.sourceforge.freegantt.data.Member;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;
import jp.sourceforge.freegantt.data.serializer.FileFormatException;
import jp.sourceforge.freegantt.util.XmlUtil;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FtgSerializer {
    public static String VERSION = "1";

    public void read(Project project, InputStream in) throws SAXException, IOException, FileFormatException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(in);
            Element element = doc.getDocumentElement();
            this.parseProject(project, element);
        }
        catch (ParserConfigurationException factory) {
        }
        catch (NumberFormatException e) {
            throw new FileFormatException(e);
        }
    }

    public void parseProject(Project project, Element ele) throws FileFormatException {
        Element additionaldHolidays;
        Element fixedHolidays;
        Element tasks;
        project.setName(XmlUtil.getTextByTagName(ele, "name"));
        project.setSummary(XmlUtil.getTextByTagName(ele, "summary"));
        project.setPrintCellSize(XmlUtil.getDimensionByTagName(ele, "printCellSize"));
        Element members = XmlUtil.getFirstElementByTag(ele, "resources");
        if (members != null) {
            NodeList memberNodes = members.getElementsByTagName("resource");
            int i = 0;
            while (i < memberNodes.getLength()) {
                Member member = this.parseMember((Element)memberNodes.item(i));
                if (member != null) {
                    project.getMembers().add(member);
                }
                ++i;
            }
        }
        if ((tasks = XmlUtil.getFirstElementByTag(ele, "tasks")) != null) {
            NodeList taskNodes = tasks.getElementsByTagName("task");
            int i = 0;
            while (i < taskNodes.getLength()) {
                Task task = this.parseTask(project, (Element)taskNodes.item(i));
                if (task != null) {
                    project.getTasks().add(task);
                }
                ++i;
            }
            i = 0;
            while (i < taskNodes.getLength()) {
                this.parseRestrictions(project, (Element)taskNodes.item(i));
                ++i;
            }
        }
        if ((fixedHolidays = XmlUtil.getFirstElementByTag(ele, "fixedHolidays")) != null) {
            List<String> weeks = XmlUtil.getTextsByTagName(fixedHolidays, "week");
            for (String week : weeks) {
                project.getFixedHolidays().add(Integer.parseInt(week));
            }
        }
        if ((additionaldHolidays = XmlUtil.getFirstElementByTag(ele, "additionalHolidays")) != null) {
            List<String> dates = XmlUtil.getTextsByTagName(additionaldHolidays, "date");
            for (String date : dates) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(Long.parseLong(date));
                project.getAdditionalHolidays().add(calendar);
            }
        }
    }

    public Member parseMember(Element ele) throws FileFormatException {
        Member member = new Member();
        member.setName(XmlUtil.getTextByTagName(ele, "name"));
        return member;
    }

    public Task parseTask(Project project, Element ele) throws FileFormatException {
        Task task = new Task();
        task.setIndex(XmlUtil.getIntegerByTagName(ele, "index"));
        task.setName(XmlUtil.getTextByTagName(ele, "name"));
        task.setStartDate(XmlUtil.getCalendarByTagName(ele, "startDate", null));
        task.setPeriod(XmlUtil.getIntegerByTagName(ele, "period", null));
        task.setCompletion(XmlUtil.getIntegerByTagName(ele, "completion"));
        task.setLevel(XmlUtil.getIntegerByTagName(ele, "level"));
        Integer memberIndex = XmlUtil.getIntegerByTagName(ele, "resource", null);
        if (memberIndex != null && memberIndex < project.getMembers().size()) {
            task.setMember(project.getMembers().get(memberIndex));
        }
        return task;
    }

    public void parseRestrictions(Project project, Element ele) throws FileFormatException {
        int index = XmlUtil.getIntegerByTagName(ele, "index");
        Task task = project.findTask(index);
        Element restrictions = XmlUtil.getFirstElementByTag(ele, "restrictions");
        if (restrictions != null) {
            List<String> dests = XmlUtil.getTextsByTagName(restrictions, "dest");
            for (String dest : dests) {
                int destIndex = Integer.parseInt(dest);
                Task destTask = project.findTask(destIndex);
                task.getRestrictions().add(destTask);
            }
        }
    }

    public void write(Project project, OutputStream out) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation dom = builder.getDOMImplementation();
            Document doc = dom.createDocument("", "freeganttProject", null);
            this.addProject(project, doc);
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(out);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    private void addProject(Project project, Document doc) {
        Element root = doc.getDocumentElement();
        root.setAttribute("version", VERSION);
        root.appendChild(XmlUtil.createTextElement(doc, "name", project.getName()));
        root.appendChild(XmlUtil.createTextElement(doc, "summary", project.getSummary()));
        root.appendChild(XmlUtil.createDimensionElement(doc, "printCellSize", project.getPrintCellSize()));
        Element members = doc.createElement("resources");
        for (Member member : project.getMembers()) {
            members.appendChild(this.getMemberElement(member, doc));
        }
        if (members.getChildNodes().getLength() > 0) {
            root.appendChild(members);
        }
        Element tasks = doc.createElement("tasks");
        for (Task task : project.getTasks()) {
            tasks.appendChild(this.getTaskElement(project, task, doc));
        }
        if (tasks.getChildNodes().getLength() > 0) {
            root.appendChild(tasks);
        }
        Element fixedHolidays = doc.createElement("fixedHolidays");
        for (Integer holiday : project.getFixedHolidays()) {
            fixedHolidays.appendChild(XmlUtil.createTextElement(doc, "week", holiday.toString()));
        }
        if (fixedHolidays.getChildNodes().getLength() > 0) {
            root.appendChild(fixedHolidays);
        }
        Element additionalHolidays = doc.createElement("additionalHolidays");
        for (Calendar holiday : project.getAdditionalHolidays()) {
            additionalHolidays.appendChild(XmlUtil.createTextElement(doc, "date", String.valueOf(holiday.getTimeInMillis())));
        }
        if (additionalHolidays.getChildNodes().getLength() > 0) {
            root.appendChild(additionalHolidays);
        }
    }

    private Element getMemberElement(Member member, Document doc) {
        Element element = doc.createElement("resource");
        element.appendChild(XmlUtil.createTextElement(doc, "name", member.getName()));
        return element;
    }

    private Element getTaskElement(Project project, Task task, Document doc) {
        Element element = doc.createElement("task");
        element.appendChild(XmlUtil.createTextElement(doc, "index", String.valueOf(task.getIndex())));
        element.appendChild(XmlUtil.createTextElement(doc, "name", task.getName()));
        if (task.getStartDate() != null) {
            element.appendChild(XmlUtil.createTextElement(doc, "startDate", String.valueOf(task.getStartDate().getTimeInMillis())));
        }
        if (task.getPeriod() != null) {
            element.appendChild(XmlUtil.createTextElement(doc, "period", String.valueOf(task.getPeriod())));
        }
        element.appendChild(XmlUtil.createTextElement(doc, "completion", String.valueOf(task.getCompletion())));
        if (task.getMember() != null) {
            int memberIndex = project.getMembers().indexOf(task.getMember());
            element.appendChild(XmlUtil.createTextElement(doc, "resource", String.valueOf(memberIndex)));
        }
        element.appendChild(XmlUtil.createTextElement(doc, "level", String.valueOf(task.getLevel())));
        if (!task.getRestrictions().isEmpty()) {
            Element restrictions = doc.createElement("restrictions");
            for (Task restriction : task.getRestrictions()) {
                restrictions.appendChild(XmlUtil.createTextElement(doc, "dest", restriction.getIndex().toString()));
            }
            element.appendChild(restrictions);
        }
        return element;
    }
}

