/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data;

import java.awt.Dimension;
import java.awt.print.PageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jp.sourceforge.freegantt.data.Member;
import jp.sourceforge.freegantt.data.Task;
import jp.sourceforge.freegantt.print.GanttChartPrintable;
import jp.sourceforge.freegantt.swing.HolidayTableModel;
import jp.sourceforge.freegantt.swing.MemberTableModel;
import jp.sourceforge.freegantt.swing.TaskListTableModel;
import jp.sourceforge.freegantt.swing.TaskMemberComboBoxModel;
import jp.sourceforge.freegantt.util.CalendarUtil;

public class Project {
    String filename;
    String name = "";
    String summary = "";
    List<Member> members = new ArrayList<Member>();
    List<Task> tasks = new ArrayList<Task>();
    List<Integer> fixedHolidays = new ArrayList<Integer>();
    List<Calendar> additionalHolidays = new ArrayList<Calendar>();
    Dimension printCellSize = new Dimension(30, 20);
    Dimension cellSize = new Dimension(14, 16);
    PageFormat pageFormat = GanttChartPrintable.getDefaultPageFormat();
    int maxLevel;
    Calendar chartFromDate;
    Calendar chartToDate;
    private TaskListTableModel taskTableModel;
    private MemberTableModel memberTableModel;
    private HolidayTableModel holidayTableModel;
    private TaskMemberComboBoxModel taskMemberComboBoxModel;

    public Dimension getCellSize() {
        return this.cellSize;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public Dimension getPrintCellSize() {
        return this.printCellSize;
    }

    public void setPrintCellSize(Dimension printCellSize) {
        this.printCellSize = printCellSize;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public List<Member> getMembers() {
        return this.members;
    }

    public void setMembers(List<Member> members) {
        this.members = members;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    public List<Integer> getFixedHolidays() {
        return this.fixedHolidays;
    }

    public void setFixedHolidays(List<Integer> fixedHolidays) {
        this.fixedHolidays = fixedHolidays;
    }

    public List<Calendar> getAdditionalHolidays() {
        return this.additionalHolidays;
    }

    public void setAdditionalHolidays(List<Calendar> additionalHolidays) {
        this.additionalHolidays = additionalHolidays;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public TaskListTableModel getTaskTableModel() {
        return this.taskTableModel;
    }

    public MemberTableModel getMemberTableModel() {
        return this.memberTableModel;
    }

    public HolidayTableModel getHolidayTableModel() {
        return this.holidayTableModel;
    }

    public TaskMemberComboBoxModel getTaskMemberComboBoxModel() {
        return this.taskMemberComboBoxModel;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    public Calendar getChartFromDate() {
        return this.chartFromDate;
    }

    public Calendar getChartToDate() {
        return this.chartToDate;
    }

    public Project() {
        this.updateTableModel();
    }

    public void updateTableModel() {
        this.taskTableModel = new TaskListTableModel(this);
        this.memberTableModel = new MemberTableModel(this);
        this.holidayTableModel = new HolidayTableModel(this);
        this.taskMemberComboBoxModel = new TaskMemberComboBoxModel(this);
    }

    public boolean isHoliday(Calendar calendar) {
        int week = calendar.get(7);
        if (this.fixedHolidays.contains(week)) {
            return true;
        }
        return this.additionalHolidays.contains(calendar);
    }

    public boolean isAdditionalHoliday(Calendar calendar) {
        return this.additionalHolidays.contains(calendar);
    }

    public void update() {
        ArrayList<Task> sortedTasks = new ArrayList<Task>(this.tasks);
        Collections.sort(sortedTasks, new Comparator<Task>(){

            @Override
            public int compare(Task lhs, Task rhs) {
                if (lhs.getLevel() == rhs.getLevel()) {
                    return 0;
                }
                return lhs.getLevel() > rhs.getLevel() ? 1 : -1;
            }
        });
        for (Task task : sortedTasks) {
            this.updateChildrenPeriod(task);
            this.updateParentPeriod(task);
        }
        this.maxLevel = 0;
        if (!sortedTasks.isEmpty()) {
            this.maxLevel = ((Task)sortedTasks.get(sortedTasks.size() - 1)).getLevel();
        }
    }

    public void updateChildrenPeriod(Task task) {
        if (task.isParent()) {
            return;
        }
        if (task.getStartDate() == null) {
            return;
        }
        if (task.getPeriod() == null) {
            task.setPeriod(0);
        }
        int leftPeriod = task.getPeriod();
        int realPeriod = 0;
        Calendar now = (Calendar)task.getStartDate().clone();
        int i = 0;
        while (i < 365 && (double)leftPeriod > 0.0) {
            if (!this.isHoliday(now)) {
                leftPeriod = (int)((double)leftPeriod - 1.0);
            }
            realPeriod = (int)((double)realPeriod + 1.0);
            now.add(5, 1);
            ++i;
        }
        task.setRealPeriod(realPeriod);
    }

    private List<Task> getChildTasks(Task targetTask) {
        ArrayList<Task> childTasks = new ArrayList<Task>();
        if (targetTask.getLevel() == 0) {
            return childTasks;
        }
        int rangeIndex = Integer.MAX_VALUE;
        for (Task task : this.tasks) {
            if (task.getIndex() <= targetTask.getIndex() || task.getLevel() < targetTask.getLevel()) continue;
            rangeIndex = Math.min(rangeIndex, task.getIndex());
        }
        for (Task task : this.tasks) {
            if (task.getLevel() >= targetTask.getLevel() || task.getIndex() <= targetTask.getIndex() || task.getIndex() >= rangeIndex) continue;
            childTasks.add(task);
        }
        return childTasks;
    }

    public void updateParentPeriod(Task task) {
        if (!task.isParent()) {
            return;
        }
        task.setStartDate(null);
        task.setPeriod(null);
        task.setRealPeriod(null);
        long from = Long.MAX_VALUE;
        long to = Long.MIN_VALUE;
        List<Task> children = this.getChildTasks(task);
        for (Task child : children) {
            if (child.getStartDate() == null) continue;
            long childFrom = child.getStartDate().getTimeInMillis();
            if (childFrom < from) {
                from = childFrom;
            }
            if (childFrom > to) {
                to = childFrom;
            }
            if (child.getRealPeriod() == null) continue;
            long childTo = childFrom + child.getRealPeriod().longValue() * 86400000L;
            if (childTo < from) {
                from = childTo;
            }
            if (childTo <= to) continue;
            to = childTo;
        }
        if (to < from) {
            return;
        }
        Calendar startDate = Calendar.getInstance();
        startDate.setTimeInMillis(from);
        task.setStartDate(startDate);
        task.setPeriod((int)((to - from) / 86400000L));
        task.setRealPeriod((int)((to - from) / 86400000L));
    }

    public Task findTask(int index) {
        for (Task task : this.tasks) {
            if (index != task.getIndex()) continue;
            return task;
        }
        return null;
    }

    public void removeRow(int index) {
        Task targetTask = this.findTask(index);
        for (Task task : this.tasks) {
            if (targetTask != null) {
                task.getRestrictions().remove(targetTask);
            }
            if (task.getIndex() <= index) continue;
            task.setIndex(task.getIndex() - 1);
        }
        if (targetTask != null) {
            this.tasks.remove(targetTask);
        }
        this.update();
        this.taskTableModel.fireTableChanged();
    }

    public void insertRow(int index) {
        for (Task task : this.tasks) {
            if (task.getIndex() < index) continue;
            task.setIndex(task.getIndex() + 1);
        }
        this.taskTableModel.fireTableChanged();
    }

    public Calendar getFirstDate() {
        Calendar firstDate = Calendar.getInstance();
        boolean found = false;
        firstDate.setTimeInMillis(Long.MAX_VALUE);
        for (Task task : this.tasks) {
            if (task.getStartDate() == null || firstDate.getTimeInMillis() <= task.getStartDate().getTimeInMillis()) continue;
            found = true;
            firstDate = (Calendar)task.getStartDate().clone();
        }
        if (!found) {
            return null;
        }
        return firstDate;
    }

    public int getWholePeriod() {
        Calendar firstDate = this.getFirstDate();
        Calendar lastDate = Calendar.getInstance();
        boolean found = false;
        lastDate.setTimeInMillis(Long.MIN_VALUE);
        if (firstDate == null) {
            return 0;
        }
        for (Task task : this.tasks) {
            Calendar endDate = task.getEndDate();
            if (endDate == null || lastDate.getTimeInMillis() >= endDate.getTimeInMillis()) continue;
            found = true;
            lastDate = endDate;
        }
        if (!found) {
            return 0;
        }
        return CalendarUtil.subDate(lastDate, firstDate);
    }

    public int getMaxIndex() {
        int index = 0;
        for (Task task : this.tasks) {
            if (task.getIndex() <= index) continue;
            index = task.getIndex();
        }
        return index;
    }

    public void removeMember(int index) {
        if (index >= this.members.size()) {
            return;
        }
        Member member = this.members.get(index);
        for (Task task : this.tasks) {
            if (task.getMember() != member) continue;
            task.setMember(null);
        }
        this.members.remove(index);
        this.getMemberTableModel().fireTableChanged();
        this.getTaskTableModel().fireTableChanged();
    }

    public void removeAdditionalHoliday(int index) {
        if (index >= this.additionalHolidays.size()) {
            return;
        }
        this.additionalHolidays.remove(index);
        this.update();
        this.getHolidayTableModel().fireTableChanged();
        this.getTaskTableModel().fireTableChanged();
    }

    public void updateChartRange() {
        this.chartFromDate = this.getFirstDate();
        if (this.chartFromDate == null) {
            this.chartFromDate = CalendarUtil.toDateCalendar(Calendar.getInstance());
        }
        this.chartToDate = this.getFirstDate();
        int period = this.getWholePeriod();
        if (this.chartToDate != null) {
            this.chartToDate.add(5, period);
        }
        if (this.chartToDate == null) {
            this.chartToDate = CalendarUtil.toDateCalendar(Calendar.getInstance());
        }
        this.chartFromDate.add(2, -1);
        this.chartToDate.add(2, 2);
    }
}

