package org.j69.eewiki.wiki.transformer;

import org.j69.eewiki.util.StringUtil;

/**
 * キーワード「,」を処理する
 *
 * , : <table><tr><td>[通常文字列]</td></tr></table>
 *
 * @see DataLineCreator
 */
public class TableDataLine implements DataLine {
    private  String keyword_ = ",",             //キーワード（置き換え対象）
                    lineData_,                  //データ
                    dataHoldTag_ = "tr",        //データ自体をはさむタグ
                    outerHoldTag_ = "table";    //データの外側をはさむタグ

    /**
     * 初期化
     *
     * @param lineData 行データ（キーワード分解前）
     **/
    public void init(String lineData) {
        String[] cells = StringUtil.split(lineData.substring(1), ",");
        StringBuffer buf = new StringBuffer();
        for (int i = 0 ; i < cells.length ; i++) {
//          buf.append("<td>" + cells[i] + "</td>");
            buf.append("<td class=\"style_td\">" + makeCellContent(cells[i]) + "</td>");
        }

        lineData_ = buf.toString();
    }

    private String makeCellContent(String cell) {
        if(cell.length() < 2) { return cell; }

        if(cell.indexOf("&gt;&gt;") == 0) {
            return "<div align=right>" + cell.substring(8) + "</div>";
        }
        if(cell.indexOf("&gt;") == 0) {
            return "<div align=center>" + cell.substring(4) + "</div>";
        }
        return cell;
    }

    /**
     * 行頭キーワード取得
     *
     * @return 行頭キーワード
     **/
    public String getKeyword() {
        return keyword_;
    }

    /**
     * データの外側を挟む開始タグ（<table>）取得
     *
     * @param oldLine 前の行データ
     * @return <table>
     **/
    public String openTag(DataLine oldLine) {
        if(oldLine != null && oldLine instanceof TableDataLine) {
            //前の行もテーブルデータの場合は<table>はいらない
            return "";
        } else {
            return "<" + outerHoldTag_ + " class=\"style_table\">\n";
        }
    }

    /**
     * データの外側を挟む終了タグ（</table>）取得
     *
     * @param newLine 次の行データ
     * @return </table>
     **/
    public String closeTag(DataLine newLine) {
        if(newLine != null && !(newLine instanceof TableDataLine)) {
            return "</" + outerHoldTag_ + ">\n";
        } else {
            //次の行もテーブルデータの場合は</table>はいらない
            return "";
        }
    }

    /**
     * 行データ取得
     *
     * @return 行データ
     **/
    public String get(int row) {
        return "<" + dataHoldTag_ + ">" + lineData_ + "</" + dataHoldTag_ + ">\n";
    }
}

