package org.j69.eewiki.wiki;

import org.apache.velocity.runtime.RuntimeSingleton;

/**
 * @author J.r0ck
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public final class WikiConstants {


    /**
     * Wikiデータファイル拡張子
     *
     */
    public final static String WIKI_DATA_EXTANSION = "dat";

    /**
     * Wiki設定ファイル名
     *
     */
    public final static String WIKI_CONFIG_FILE = "wiki-config-file";

    // ELEMENTのKEY名称
    /**
     * Wiki設定識別子
     *
     */
    public final static String WIKI_ELKEY_CONFIG = "config";

    /**
     * WikiDir識別子
     *
     */
    public final static String WIKI_ELKEY_BASE = "basedir";

    /**
     * Wikiコンテンツ識別子
     *
     */
    public final static String WIKI_ELKEY_CONTENTS = "contents";

    /**
     * EDIT入力コンテンツ識別子
     *
     */
    public final static String WIKI_ELKEY_EDITCONTENTS = "editcontents";

    /**
     * PREVIEWコンテンツ識別子
     *
     */
    public final static String WIKI_ELKEY_PREVIEW = "preview";

    /**
     * Recentコンテンツ識別子
     *
     */
    public final static String WIKI_ELKEY_RECENT = "recent";

    /**
     * Listコンテンツ識別子
     *
     */
    public final static String WIKI_ELKEY_LIST = "list";

    /**
     * ページID識別子
     *
     */
    public final static String WIKI_ELKEY_PID = "pid";

    /**
     * エンコードされたページID識別子
     *
     */
    public final static String WIKI_ELKEY_ENCPID = "encpid";

    /**
     * アクション識別子
     *
     */
    public final static String WIKI_ELKEY_ACTION = "action";

    /**
     * アクション内容定義
     *
     */
    public final static String WIKI_ACTION_NEW = "new";
    public final static String WIKI_ACTION_EDIT = "edit";
    public final static String WIKI_ACTION_CREATE = "create";
    public final static String WIKI_ACTION_PREVIEW = "preview";
    public final static String WIKI_ACTION_SAVE = "save";

    /**
     * ソート定義
     *
     */
    public final static String WIKI_LIST_ASC = "ASC";
    public final static String WIKI_LIST_DESC = "DESC";

    /**
     * デフォルトファイルエンコーディング
     * Velocityのinput.encodingの設定値、無ければSystemのFileEncoding
     */
    public final static String DEFAULT_FILE_ENCODING =
                        RuntimeSingleton.getString("input.encoding",  System.getProperty("file.encoding"));

    /**
     * デフォルトOUTエンコーディング
     * Velocityのoutput.encodingの設定値、無ければSystemのFileEncoding
     */
    public final static String DEFAULT_OUT_ENCODING =
                        RuntimeSingleton.getString("output.encoding",  System.getProperty("file.encoding"));

    /**
     * log4j Categories
     */
    public final static String LOG_CAT_INIT = "Init";
    public final static String LOG_CAT_CONFIG = "Config";
    public final static String LOG_CAT_ACTIONS = "Actions";
    public final static String LOG_CAT_REPOSITORY = "Repository";
    public final static String LOG_CAT_PERSISTER = "Persister";
    public final static String LOG_CAT_TRANSLATOR = "Translator";
    public final static String LOG_CAT_VALIDATOR = "Validator";
    public final static String LOG_CAT_CACHE = "Cache";
    public final static String LOG_CAT_REGISTRY = "Registry";
    public final static String LOG_CAT_EVENT = "Event";

}
