package org.j69.eewiki.wiki;

import java.io.IOException;
import org.j69.eewiki.util.UtilComparator;

/**
 * File の順序付け（ファイル名）
 */
public class SubTitleComparator extends UtilComparator {
    public SubTitleComparator(String order) {
        super.init(order);
    }

    protected int asc(Object data0, Object data1) {
        try {
            return String.CASE_INSENSITIVE_ORDER.compare(
                ((WikiFile)data0).getSubtitlename(), ((WikiFile)data1).getSubtitlename());
        } catch(IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
    }

    protected int desc(Object data0, Object data1) {
        try {
            return String.CASE_INSENSITIVE_ORDER.compare(
                ((WikiFile)data1).getSubtitlename(), ((WikiFile)data0).getSubtitlename());
        } catch(IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
    }
}
