package org.j69.eewiki.util;

import java.util.Comparator;

/**
 * リストデータの並び替え
 * from mobwiki(mobstar)
 *
 * @author
 */
public abstract class UtilComparator implements Comparator {

    public static final String ASC = "ASC";
    public static final String DESC = "DESC";

    //昇順かどうか true:昇順 false:降順
    private String order_;

    protected void init(String order) {
        order_ = order;
    }

    public int compare(Object data0, Object data1) {
        if(order_.equals(ASC)) {
            return asc(data0, data1);
        } else {
            return desc(data0, data1);
        }
    }

    protected abstract int asc(Object data0, Object data1);
    protected abstract int desc(Object data0, Object data1);
}
