/*
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Struts", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */

package org.j69.eewiki.action;

import java.io.UnsupportedEncodingException;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

import org.apache.struts.upload.FormFile;

/**
 * UploadForm.java created by EasyStruts - XsltGen.
 * http://easystruts.sf.net
 * created on 06-07-2003
 *
 * XDoclet definition:
 * @struts:form name="UploadForm"
 */
public class UploadForm extends ActionForm {

    /** action property */
    private String action;

    /** fileName property */
    private String fileName;

    /** pid property */
    private String pid;

    /** uploadFile property */
    private FormFile uploadFile;

    /**
     * Method validate
     * @param ActionMapping mapping
     * @param HttpServletRequest request
     * @return ActionErrors
     */
    public ActionErrors validate(
        ActionMapping mapping,
        HttpServletRequest request) {

        throw new UnsupportedOperationException("Generated method 'validate(...)' not implemented.");
    }

    /**
     * Returns the action.
     * @return String
     */
    public String getAction() {
        return action;
    }

    /**
     * Set the action.
     * @param action The action to set
     */
    public void setAction(String action) {
        this.action = action;
    }

    /**
     * Returns the fileName.
     * @return String
     */
    public String getFileName() throws UnsupportedEncodingException {
    	//うーん（涙）日本語ファイル名で化ける文字がある...
		String fname =  new String(uploadFile.getFileName().getBytes(), "UTF-8");
		////String fname =  uploadFile.getFileName();
        return fname;
    }

    /**
     * Set the fileName.
     * @param fileName The fileName to set
     */
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    /**
     * Returns the pid.
     * @return String
     */
    public String getPid() {
        return pid;
    }

    /**
     * Set the pid.
     * @param pid The pid to set
     */
    public void setPid(String pid) {
        this.pid = pid;
    }

    /**
     * Set the uploadFile.
     * @param file
     */
    public void setUploadFile(FormFile uploadFile) {
        this.uploadFile = uploadFile;
    }

    /**
     * Returns the uploadFile.
     * @return
     */
    public FormFile getUploadFile() {
        return uploadFile;
    }

}
