/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.jdbc2pool;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp.jdbc2pool.PooledConnectionAndInfo;
import org.apache.commons.dbcp.jdbc2pool.UserPassKey;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;

class KeyedCPDSConnectionFactory
implements KeyedPoolableObjectFactory,
ConnectionEventListener {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    protected ConnectionPoolDataSource _cpds = null;
    protected String _validationQuery = null;
    protected KeyedObjectPool _pool = null;
    private Map validatingMap = new HashMap();
    private WeakHashMap pcMap = new WeakHashMap();

    public KeyedCPDSConnectionFactory(ConnectionPoolDataSource cpds, KeyedObjectPool pool, String validationQuery) {
        this._cpds = cpds;
        this._pool = pool;
        this._pool.setFactory((KeyedPoolableObjectFactory)this);
        this._validationQuery = validationQuery;
    }

    public synchronized void setCPDS(ConnectionPoolDataSource cpds) {
        this._cpds = cpds;
    }

    public synchronized void setValidationQuery(String validationQuery) {
        this._validationQuery = validationQuery;
    }

    public synchronized void setPool(KeyedObjectPool pool) throws SQLException {
        if (null != this._pool && pool != this._pool) {
            try {
                this._pool.close();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new SQLException(e.getMessage());
            }
        }
        this._pool = pool;
    }

    public KeyedObjectPool getPool() {
        return this._pool;
    }

    public synchronized Object makeObject(Object key) {
        PooledConnectionAndInfo obj = null;
        UserPassKey upkey = (UserPassKey)key;
        try {
            PooledConnection pc = null;
            String username = upkey.getUsername();
            String password = upkey.getPassword();
            pc = username == null ? this._cpds.getPooledConnection() : this._cpds.getPooledConnection(username, password);
            pc.addConnectionEventListener(this);
            obj = new PooledConnectionAndInfo(pc, username, password);
            this.pcMap.put(pc, obj);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage());
        }
        return obj;
    }

    public void destroyObject(Object key, Object obj) {
        if (obj instanceof PooledConnectionAndInfo) {
            try {
                ((PooledConnectionAndInfo)obj).getPooledConnection().close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (SQLException e) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateObject(Object key, Object obj) {
        boolean valid = false;
        if (obj instanceof PooledConnectionAndInfo) {
            PooledConnection pconn = ((PooledConnectionAndInfo)obj).getPooledConnection();
            String query = this._validationQuery;
            if (null != query) {
                Connection conn = null;
                Statement stmt = null;
                ResultSet rset = null;
                this.validatingMap.put(pconn, null);
                try {
                    conn = pconn.getConnection();
                    stmt = conn.createStatement();
                    rset = stmt.executeQuery(query);
                    if (rset.next()) {
                        valid = true;
                    }
                    valid = false;
                }
                catch (Exception e) {
                    valid = false;
                }
                finally {
                    try {
                        rset.close();
                    }
                    catch (Throwable t) {}
                    try {
                        stmt.close();
                    }
                    catch (Throwable t) {}
                    try {
                        conn.close();
                    }
                    catch (Throwable t) {}
                    this.validatingMap.remove(pconn);
                }
            } else {
                valid = true;
            }
        } else {
            valid = false;
        }
        return valid;
    }

    public void passivateObject(Object key, Object obj) {
    }

    public void activateObject(Object key, Object obj) {
    }

    public void connectionClosed(ConnectionEvent event) {
        block3: {
            PooledConnection pc = (PooledConnection)event.getSource();
            if (this.validatingMap.containsKey(pc)) break block3;
            PooledConnectionAndInfo info = (PooledConnectionAndInfo)this.pcMap.get(pc);
            if (info == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this._pool.returnObject((Object)info.getUserPassKey(), (Object)info);
            }
            catch (Exception e) {
                this.destroyObject(info.getUserPassKey(), info);
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
            }
        }
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        try {
            if (null != event.getSQLException()) {
                System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR (" + event.getSQLException() + ")");
            }
            pc.removeConnectionEventListener(this);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        PooledConnectionAndInfo info = (PooledConnectionAndInfo)this.pcMap.get(pc);
        if (info == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        this.destroyObject(info.getUserPassKey(), info);
    }
}

